/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class CompatThaumcraft
implements IBlockTransformer {
    private static Class<?> classBlockArcaneDoor;
    private static Class<?> classBlockChestHungry;
    private static Class<?> classBlockEssentiaReservoir;
    private static Class<?> classBlockJar;
    private static Class<?> classBlockMetalDevice;
    private static Class<?> classBlockMirror;
    private static Class<?> classBlockTable;
    private static Class<?> classBlockTube;
    private static Class<?> classBlockWoodenDevice;
    private static final int[] mrotArcaneDoor;
    private static final int[] mrotHungryChest;
    private static final int[] mrotMirror;
    private static final int[] mrotTable;
    private static final byte[] rotForgeByte;
    private static final int[] rotForgeInt;
    private static final short[] rotForgeShort;
    private static final byte[] rotBanner;

    public static void register() {
        try {
            classBlockArcaneDoor = Class.forName("thaumcraft.common.blocks.BlockArcaneDoor");
            classBlockChestHungry = Class.forName("thaumcraft.common.blocks.BlockChestHungry");
            classBlockEssentiaReservoir = Class.forName("thaumcraft.common.blocks.BlockEssentiaReservoir");
            classBlockJar = Class.forName("thaumcraft.common.blocks.BlockJar");
            classBlockMetalDevice = Class.forName("thaumcraft.common.blocks.BlockMetalDevice");
            classBlockMirror = Class.forName("thaumcraft.common.blocks.BlockMirror");
            classBlockTable = Class.forName("thaumcraft.common.blocks.BlockTable");
            classBlockTube = Class.forName("thaumcraft.common.blocks.BlockTube");
            classBlockWoodenDevice = Class.forName("thaumcraft.common.blocks.BlockWoodenDevice");
            WarpDriveConfig.registerBlockTransformer("Thaumcraft", new CompatThaumcraft());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockArcaneDoor.isInstance(block) || classBlockChestHungry.isInstance(block) || classBlockEssentiaReservoir.isInstance(block) || classBlockJar.isInstance(block) || classBlockMetalDevice.isInstance(block) || classBlockMirror.isInstance(block) || classBlockTable.isInstance(block) || classBlockTube.isInstance(block) || classBlockWoodenDevice.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (classBlockArcaneDoor.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotArcaneDoor[metadata];
                }
                case 2: {
                    return mrotArcaneDoor[mrotArcaneDoor[metadata]];
                }
                case 3: {
                    return mrotArcaneDoor[mrotArcaneDoor[mrotArcaneDoor[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockChestHungry.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotHungryChest[metadata];
                }
                case 2: {
                    return mrotHungryChest[mrotHungryChest[metadata]];
                }
                case 3: {
                    return mrotHungryChest[mrotHungryChest[mrotHungryChest[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockEssentiaReservoir.isInstance(block) && nbtTileEntity.func_74764_b("face")) {
            short direction = nbtTileEntity.func_74771_c("face");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("face", rotForgeByte[direction]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("face", rotForgeByte[rotForgeByte[direction]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("face", rotForgeByte[rotForgeByte[rotForgeByte[direction]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (classBlockJar.isInstance(block) && nbtTileEntity.func_74764_b("facing")) {
            short direction = nbtTileEntity.func_74771_c("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("facing", rotForgeByte[direction]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("facing", rotForgeByte[rotForgeByte[direction]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("facing", rotForgeByte[rotForgeByte[rotForgeByte[direction]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (classBlockMetalDevice.isInstance(block)) {
            if (nbtTileEntity.func_74764_b("orientation") && nbtTileEntity.func_150297_b("orientation", 2)) {
                short orientation = nbtTileEntity.func_74765_d("orientation");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74777_a("orientation", rotForgeShort[orientation]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74777_a("orientation", rotForgeShort[rotForgeShort[orientation]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74777_a("orientation", rotForgeShort[rotForgeShort[rotForgeShort[orientation]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
            if (nbtTileEntity.func_74764_b("orientation") && nbtTileEntity.func_150297_b("orientation", 3)) {
                int orientation = nbtTileEntity.func_74762_e("orientation");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74768_a("orientation", rotForgeInt[orientation]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74768_a("orientation", rotForgeInt[rotForgeInt[orientation]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74768_a("orientation", rotForgeInt[rotForgeInt[rotForgeInt[orientation]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
            if (nbtTileEntity.func_74764_b("facing") && nbtTileEntity.func_150297_b("facing", 1)) {
                byte facing = nbtTileEntity.func_74771_c("facing");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("facing", rotForgeByte[facing]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("facing", rotForgeByte[rotForgeByte[facing]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("facing", rotForgeByte[rotForgeByte[rotForgeByte[facing]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
        }
        if (classBlockMirror.isInstance(block)) {
            if (nbtTileEntity.func_74764_b("linkX") && nbtTileEntity.func_74764_b("linkY") && nbtTileEntity.func_74764_b("linkZ")) {
                ChunkCoordinates targetLink = transformation.apply(nbtTileEntity.func_74762_e("linkX"), nbtTileEntity.func_74762_e("linkY"), nbtTileEntity.func_74762_e("linkZ"));
                nbtTileEntity.func_74768_a("linkX", targetLink.field_71574_a);
                nbtTileEntity.func_74768_a("linkY", targetLink.field_71572_b);
                nbtTileEntity.func_74768_a("linkZ", targetLink.field_71573_c);
            }
            switch (rotationSteps) {
                case 1: {
                    return mrotMirror[metadata];
                }
                case 2: {
                    return mrotMirror[mrotMirror[metadata]];
                }
                case 3: {
                    return mrotMirror[mrotMirror[mrotMirror[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockTable.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotTable[metadata];
                }
                case 2: {
                    return mrotTable[mrotTable[metadata]];
                }
                case 3: {
                    return mrotTable[mrotTable[mrotTable[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockTube.isInstance(block)) {
            if (nbtTileEntity.func_74764_b("side") && nbtTileEntity.func_150297_b("side", 3)) {
                byte side = nbtTileEntity.func_74771_c("side");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74768_a("side", rotForgeInt[side]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74768_a("side", rotForgeInt[rotForgeInt[side]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74768_a("side", rotForgeInt[rotForgeInt[rotForgeInt[side]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
            if (nbtTileEntity.func_74764_b("face") && nbtTileEntity.func_150297_b("face", 1)) {
                byte face = nbtTileEntity.func_74771_c("face");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("face", rotForgeByte[face]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("face", rotForgeByte[rotForgeByte[face]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("face", rotForgeByte[rotForgeByte[rotForgeByte[face]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
        }
        if (classBlockWoodenDevice.isInstance(block)) {
            if (nbtTileEntity.func_74764_b("orientation") && nbtTileEntity.func_150297_b("orientation", 1)) {
                byte orientation = nbtTileEntity.func_74771_c("orientation");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("orientation", rotForgeByte[orientation]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("orientation", rotForgeByte[rotForgeByte[orientation]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("orientation", rotForgeByte[rotForgeByte[rotForgeByte[orientation]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
            if (nbtTileEntity.func_74764_b("orientation") && nbtTileEntity.func_150297_b("orientation", 3)) {
                byte orientation = nbtTileEntity.func_74771_c("orientation");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74768_a("orientation", rotForgeInt[orientation]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74768_a("orientation", rotForgeInt[rotForgeInt[orientation]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74768_a("orientation", rotForgeInt[rotForgeInt[rotForgeInt[orientation]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
            if (nbtTileEntity.func_74764_b("facing") && nbtTileEntity.func_150297_b("facing", 1)) {
                byte facing = nbtTileEntity.func_74771_c("facing");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("facing", rotBanner[facing]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("facing", rotBanner[rotBanner[facing]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("facing", rotBanner[rotBanner[rotBanner[facing]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotArcaneDoor = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotHungryChest = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotMirror = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 14, 15};
        mrotTable = new int[]{1, 0, 5, 4, 2, 3, 9, 8, 6, 7, 10, 11, 12, 13, 14, 15};
        rotForgeByte = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotForgeInt = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotForgeShort = new short[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotBanner = new byte[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3};
    }
}

