/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.hull.BlockHullGlass;
import cr0s.warpdrive.block.hull.BlockHullPlain;
import cr0s.warpdrive.block.hull.BlockHullStairs;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class Dictionary {
    private static final boolean adjustResistance = false;
    private static HashMap<String, String> taggedBlocks = null;
    private static HashMap<String, String> taggedEntities = null;
    private static HashMap<String, String> taggedItems = null;
    public static HashSet<Block> BLOCKS_ORES = null;
    public static HashSet<Block> BLOCKS_SOILS = null;
    public static HashSet<Block> BLOCKS_LOGS = null;
    public static HashSet<Block> BLOCKS_LEAVES = null;
    public static HashSet<Block> BLOCKS_ANCHOR = null;
    public static HashSet<Block> BLOCKS_NOMASS = null;
    public static HashSet<Block> BLOCKS_LEFTBEHIND = null;
    public static HashSet<Block> BLOCKS_EXPANDABLE = null;
    public static HashSet<Block> BLOCKS_MINING = null;
    public static HashSet<Block> BLOCKS_SKIPMINING = null;
    public static HashSet<Block> BLOCKS_STOPMINING = null;
    public static HashMap<Block, Integer> BLOCKS_PLACE = null;
    public static HashSet<Block> BLOCKS_NOCAMOUFLAGE = null;
    public static HashSet<String> ENTITIES_ANCHOR = null;
    public static HashSet<String> ENTITIES_NOMASS = null;
    public static HashSet<String> ENTITIES_LEFTBEHIND = null;
    public static HashSet<String> ENTITIES_NONLIVINGTARGET = null;
    public static HashSet<Item> ITEMS_FLYINSPACE = null;
    public static HashSet<Item> ITEMS_NOFALLDAMAGE = null;
    public static HashSet<Item> ITEMS_BREATHINGIC2 = null;

    public static void loadConfig(Configuration config) {
        String tags;
        config.addCustomCategoryComment("block_tags", "Use this section to enable special behavior on blocks using tags.\nMost blocks are already supported automatically. Only modify this section when something doesn't work!\n\nTags shall be separated by at least one space, comma or tabulation.\nInvalid tags will be ignored silently. Tags and block names are case sensitive.\nIn case of conflicts, the latest tag overwrite the previous ones.\n- Soil: this block is a soil for plants (default: dirt, farmland, grass, sand & soul sand).\n- Log: this block is harvestable as a wood log (default: all 'log*', '*log' & '*logs' blocks from the ore dictionary).\n- Leaf: this block is harvestable as a leaf (default: all 'leave*', '*leave' & '*leaves' blocks from the ore dictionary).\n- Anchor: ship can't move with this block aboard (default: bedrock and assimilated).\n- NoMass: this block doesn't count when calculating ship volume/mass (default: leaves, all 'air' blocks).\n- LeftBehind: this block won't move with your ship (default: RailCraft heat, WarpDrive gases).\n- Expandable: this block will be squished/ignored in case of collision.\n- Mining: this block is mineable (default: all 'ore' blocks from the ore dictionary).\n- SkipMining: this block is ignored from mining (default: bedrock).\n- StopMining: this block will prevent mining through it (default: forcefields).\n- PlaceEarliest: this block will be removed last and placed first (default: ship hull and projectors).\n- PlaceEarlier: this block will be placed fairly soon (default: forcefield blocks).\n- PlaceNormal: this block will be removed and placed with non-tile entities.\n- PlaceLater: this block will be placed fairly late (default: IC2 Reactor core).\n- PlaceLatest: this block will be removed first and placed last (default: IC2 Reactor chamber).\n- NoCamouflage: this block isn't valid for camouflage.");
        ConfigCategory categoryBlockTags = config.getCategory("block_tags");
        String[] taggedBlocksName = categoryBlockTags.getValues().keySet().toArray(new String[0]);
        if (taggedBlocksName.length == 0) {
            config.get("block_tags", "minecraft:dirt", "Soil").getString();
            config.get("block_tags", "minecraft:farmland", "Soil").getString();
            config.get("block_tags", "minecraft:grass", "Soil").getString();
            config.get("block_tags", "minecraft:mycelium", "Soil").getString();
            config.get("block_tags", "minecraft:sand", "Soil").getString();
            config.get("block_tags", "minecraft:soul_sand", "Soil").getString();
            config.get("block_tags", "IC2:blockRubWood", "Log").getString();
            config.get("block_tags", "TConstruct:slime.gel", "Log").getString();
            config.get("block_tags", "TConstruct:slime.leaves", "Leaf").getString();
            config.get("block_tags", "minecraft:bedrock", "Anchor SkipMining").getString();
            config.get("block_tags", "minecraft:command_block", "Anchor StopMining").getString();
            config.get("block_tags", "minecraft:end_portal_frame", "Anchor StopMining").getString();
            config.get("block_tags", "minecraft:end_portal", "Anchor StopMining").getString();
            config.get("block_tags", "IC2:blockPersonal", "Anchor SkipMining").getString();
            config.get("block_tags", "Artifacts:invisible_bedrock", "Anchor StopMining").getString();
            config.get("block_tags", "Artifacts:anti_anti_builder_stone", "Anchor StopMining").getString();
            config.get("block_tags", "Artifacts:anti_builder", "Anchor StopMining").getString();
            config.get("block_tags", "malisisdoors:rustyHatch", "Anchor").getString();
            config.get("block_tags", "minecraft:lever", "PlaceLatest").getString();
            config.get("block_tags", "WarpDrive:blockHull1_plain", "PlaceEarliest StopMining").getString();
            config.get("block_tags", "WarpDrive:blockHull2_plain", "PlaceEarliest StopMining").getString();
            config.get("block_tags", "WarpDrive:blockHull3_plain", "PlaceEarliest StopMining").getString();
            config.get("block_tags", "WarpDrive:blockHull1_glass", "PlaceEarliest StopMining").getString();
            config.get("block_tags", "WarpDrive:blockHull2_glass", "PlaceEarliest StopMining").getString();
            config.get("block_tags", "WarpDrive:blockHull3_glass", "PlaceEarliest StopMining").getString();
            config.get("block_tags", "WarpDrive:blockForceField1", "PlaceLatest StopMining NoMass").getString();
            config.get("block_tags", "WarpDrive:blockForceField2", "PlaceLatest StopMining NoMass").getString();
            config.get("block_tags", "WarpDrive:blockForceField3", "PlaceLatest StopMining NoMass").getString();
            config.get("block_tags", "IC2:blockReinforcedFoam", "PlaceEarliest StopMining").getString();
            config.get("block_tags", "IC2:blockAlloy", "PlaceEarliest StopMining").getString();
            config.get("block_tags", "IC2:blockAlloyGlass", "PlaceEarliest StopMining").getString();
            config.get("block_tags", "minecraft:obsidian", "PlaceEarliest Mining").getString();
            config.get("block_tags", "AdvancedRepulsionSystems:field", "PlaceEarlier StopMining").getString();
            config.get("block_tags", "IC2:blockGenerator", "PlaceLater").getString();
            config.get("block_tags", "IC2:blockReactorChamber", "PlaceLatest").getString();
            config.get("block_tags", "ImmersiveEngineering:metalDevice", "PlaceLatest").getString();
            config.get("block_tags", "CarpentersBlocks:blockCarpentersDaylightSensor", "PlaceLatest").getString();
            config.get("block_tags", "CarpentersBlocks:blockCarpentersDoor", "PlaceLatest").getString();
            config.get("block_tags", "CarpentersBlocks:blockCarpentersGarageDoor", "PlaceLatest").getString();
            config.get("block_tags", "CarpentersBlocks:blockCarpentersHatch", "PlaceLatest").getString();
            config.get("block_tags", "CarpentersBlocks:blockCarpentersLadder", "PlaceLatest").getString();
            config.get("block_tags", "CarpentersBlocks:blockCarpentersLever", "PlaceLatest").getString();
            config.get("block_tags", "CarpentersBlocks:blockCarpentersPressurePlate", "PlaceLatest").getString();
            config.get("block_tags", "CarpentersBlocks:blockCarpentersTorch", "PlaceLatest").getString();
            config.get("block_tags", "OpenComputers:case1", "PlaceLatest").getString();
            config.get("block_tags", "OpenComputers:case2", "PlaceLatest").getString();
            config.get("block_tags", "OpenComputers:case3", "PlaceLatest").getString();
            config.get("block_tags", "OpenComputers:caseCreative", "PlaceLatest").getString();
            config.get("block_tags", "OpenComputers:keyboard", "PlaceLatest").getString();
            config.get("block_tags", "StargateTech2:block.shieldEmitter", "PlaceLater StopMining").getString();
            config.get("block_tags", "StargateTech2:block.shieldController", "PlaceNormal StopMining").getString();
            config.get("block_tags", "StargateTech2:block.shield", "PlaceNormal StopMining").getString();
            config.get("block_tags", "StargateTech2:block.busAdapter", "PlaceLatest StopMining").getString();
            config.get("block_tags", "StargateTech2:block.busCable", "PlaceNormal StopMining").getString();
            config.get("block_tags", "chisel:cloud", "LeftBehind Expandable").getString();
            config.get("block_tags", "Railcraft:residual.heat", "LeftBehind Expandable").getString();
            config.get("block_tags", "WarpDrive:blockGas", "LeftBehind Expandable").getString();
            config.get("block_tags", "InvisibLights:blockLightSource", "NoMass Expandable").getString();
            config.get("block_tags", "WarpDrive:blockAir", "NoMass Expandable PlaceLatest").getString();
            config.get("block_tags", "minecraft:web", "Mining").getString();
            config.get("block_tags", "minecraft:fence", "Mining").getString();
            config.get("block_tags", "minecraft:torch", "Mining").getString();
            config.get("block_tags", "minecraft:glowstone", "Mining").getString();
            config.get("block_tags", "minecraft:redstone_block", "Mining").getString();
            config.get("block_tags", "WarpDrive:blockIridium", "Mining").getString();
            config.get("block_tags", "deepresonance:energyCollectorBlock", "NoCamouflage").getString();
            config.get("block_tags", "deepresonance:resonatingCrystalBlock", "NoCamouflage").getString();
            config.get("block_tags", "evilcraft:bloodInfuser", "NoCamouflage").getString();
            config.get("block_tags", "evilcraft:darkOre", "NoCamouflage").getString();
            config.get("block_tags", "evilcraft:sanguinaryEnvironmentalAccumulator", "NoCamouflage").getString();
            config.get("block_tags", "evilcraft:spiritReanimator", "NoCamouflage").getString();
            config.get("block_tags", "openmodularturrets:baseTierWood", "NoCamouflage").getString();
            config.get("block_tags", "openmodularturrets:baseTierOneBlock", "NoCamouflage").getString();
            config.get("block_tags", "openmodularturrets:baseTierTwoBlock", "NoCamouflage").getString();
            config.get("block_tags", "openmodularturrets:baseTierThreeBlock", "NoCamouflage").getString();
            config.get("block_tags", "openmodularturrets:baseTierFourBlock", "NoCamouflage").getString();
            config.get("block_tags", "Thaumcraft:blockCustomPlant", "NoCamouflage").getString();
            config.get("block_tags", "ThermalExpansion:Cache", "NoCamouflage").getString();
            config.get("block_tags", "ThermalExpansion:Device", "NoCamouflage").getString();
            config.get("block_tags", "ThermalExpansion:Machine", "NoCamouflage").getString();
            config.get("block_tags", "ThermalExpansion:Sponge", "NoCamouflage").getString();
            config.get("block_tags", "witchery:leechchest", "NoCamouflage").getString();
            taggedBlocksName = categoryBlockTags.getValues().keySet().toArray(new String[0]);
        }
        taggedBlocks = new HashMap(taggedBlocksName.length);
        for (String name : taggedBlocksName) {
            tags = config.get("block_tags", name, "").getString();
            taggedBlocks.put(name, tags);
        }
        config.addCustomCategoryComment("entity_tags", "Use this section to enable special behavior on entities using tags.\nMost entities are already supported automatically. Only modify this section when something doesn't work!\n\nTags shall be separated by at least one space, comma or tabulation.\nInvalid tags will be ignored silently. Tags and block names are case sensitive.\nIn case of conflicts, the latest tag overwrite the previous ones.\n- Anchor: ship can't move with this entity aboard (default: none).\n- NoMass: this entity doesn't count when calculating ship volume/mass (default: Galacticraft air bubble).\n- LeftBehind: this entity won't move with your ship (default: Galacticraft air bubble).\n- NonLivingTarget: this non-living entity can be targeted/removed by weapons (default: ItemFrame, Painting).");
        ConfigCategory categoryEntityTags = config.getCategory("entity_tags");
        String[] taggedEntitiesName = categoryEntityTags.getValues().keySet().toArray(new String[0]);
        if (taggedEntitiesName.length == 0) {
            config.get("entity_tags", "GalacticraftCore.OxygenBubble", "NoMass LeftBehind").getString();
            config.get("entity_tags", "ItemFrame", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "Painting", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "LeashKnot", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "Boat", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "MinecartRideable", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "MinecartChest", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "MinecartFurnace", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "MinecartTNT", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "MinecartHopper", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "MinecartSpawner", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "EnderCrystal", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "IC2.BoatCarbon", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "IC2.BoatRubber", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "IC2.BoatElectric", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "IC2.Nuke", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "IC2.Itnt", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "IC2.StickyDynamite", "NoMass NonLivingTarget").getString();
            config.get("entity_tags", "IC2.Dynamite", "NoMass NonLivingTarget").getString();
            taggedEntitiesName = categoryEntityTags.getValues().keySet().toArray(new String[0]);
        }
        taggedEntities = new HashMap(taggedEntitiesName.length);
        for (String name : taggedEntitiesName) {
            tags = config.get("entity_tags", name, "").getString();
            taggedEntities.put(name, tags);
        }
        config.addCustomCategoryComment("item_tags", "Use this section to enable special behavior on items using tags.\nMost items are already supported automatically. Only modify this section when something doesn't work!\n\nTags shall be separated by at least one space, comma or tabulation.\nInvalid tags will be ignored silently. Tags and block names are case sensitive.\nIn case of conflicts, the latest tag overwrite the previous ones.\n- FlyInSpace: player can move without gravity effect while wearing this item (default: jetpacks).\n- NoFallDamage: player doesn't take fall damage while wearing this armor item (default: IC2 rubber boots).\n- BreathingIC2: player can breath IC2 compressed air while wearing this armor item (default: IC2 nano helmet and Cie).\n");
        ConfigCategory categoryItemTags = config.getCategory("item_tags");
        String[] taggedItemsName = categoryItemTags.getValues().keySet().toArray(new String[0]);
        if (taggedItemsName.length == 0) {
            config.get("item_tags", "AWWayofTime:boundHelmet", "BreathingIC2").getString();
            config.get("item_tags", "AWWayofTime:boundHelmetEarth", "BreathingIC2").getString();
            config.get("item_tags", "AWWayofTime:boundHelmetFire", "BreathingIC2").getString();
            config.get("item_tags", "AWWayofTime:boundHelmetWater", "BreathingIC2").getString();
            config.get("item_tags", "AWWayofTime:boundHelmetWind", "BreathingIC2").getString();
            config.get("item_tags", "AdvancedSolarPanel:advanced_solar_helmet", "BreathingIC2").getString();
            config.get("item_tags", "AdvancedSolarPanel:hybrid_solar_helmet", "BreathingIC2").getString();
            config.get("item_tags", "AdvancedSolarPanel:ultimate_solar_helmet", "BreathingIC2").getString();
            config.get("item_tags", "Botania:elementiumHelm", "BreathingIC2").getString();
            config.get("item_tags", "Botania:elementiumHelmReveal", "BreathingIC2").getString();
            config.get("item_tags", "Botania:terrasteelHelm", "BreathingIC2").getString();
            config.get("item_tags", "Botania:terrasteelHelmReveal", "BreathingIC2").getString();
            config.get("item_tags", "EnderIO:item.darkSteel_helmet", "BreathingIC2").getString();
            config.get("item_tags", "IC2:itemArmorHazmatHelmet", "BreathingIC2").getString();
            config.get("item_tags", "IC2:itemSolarHelmet", "BreathingIC2").getString();
            config.get("item_tags", "IC2:itemArmorNanoHelmet", "BreathingIC2").getString();
            config.get("item_tags", "IC2:itemArmorQuantumHelmet", "BreathingIC2").getString();
            config.get("item_tags", "RedstoneArsenal:armor.helmetFlux", "BreathingIC2").getString();
            config.get("item_tags", "IC2:itemArmorJetpack", "FlyInSpace NoFallDamage").getString();
            config.get("item_tags", "IC2:itemArmorJetpackElectric", "FlyInSpace NoFallDamage").getString();
            config.get("item_tags", "GraviSuite:advJetpack", "FlyInSpace NoFallDamage").getString();
            config.get("item_tags", "GraviSuite:advNanoChestPlate", "FlyInSpace NoFallDamage").getString();
            config.get("item_tags", "GraviSuite:graviChestPlate", "FlyInSpace NoFallDamage").getString();
            config.get("item_tags", "IC2:itemArmorRubBoots", "NoFallDamage").getString();
            config.get("item_tags", "IC2:itemArmorQuantumBoots", "NoFallDamage").getString();
            taggedItemsName = categoryItemTags.getValues().keySet().toArray(new String[0]);
        }
        taggedItems = new HashMap(taggedItemsName.length);
        for (String name : taggedItemsName) {
            tags = config.get("item_tags", name, "").getString();
            taggedItems.put(name, tags);
        }
    }

    public static void apply() {
        BLOCKS_ORES = new HashSet();
        BLOCKS_LOGS = new HashSet();
        BLOCKS_LEAVES = new HashSet();
        String[] oreNames = OreDictionary.getOreNames();
        for (String string : oreNames) {
            ArrayList itemStacks;
            String lowerOreName = string.toLowerCase();
            if (string.length() > 4 && string.substring(0, 3).equals("ore")) {
                itemStacks = OreDictionary.getOres((String)string);
                for (Object itemStack : itemStacks) {
                    BLOCKS_ORES.add(Block.func_149634_a((Item)itemStack.func_77973_b()));
                }
            }
            if (lowerOreName.startsWith("log") || lowerOreName.endsWith("log") || lowerOreName.endsWith("logs")) {
                itemStacks = OreDictionary.getOres((String)string);
                for (Object itemStack : itemStacks) {
                    BLOCKS_LOGS.add(Block.func_149634_a((Item)itemStack.func_77973_b()));
                }
            }
            if (!lowerOreName.startsWith("leave") && !lowerOreName.endsWith("leave") && !lowerOreName.endsWith("leaves")) continue;
            itemStacks = OreDictionary.getOres((String)string);
            for (Object itemStack : itemStacks) {
                BLOCKS_LEAVES.add(Block.func_149634_a((Item)itemStack.func_77973_b()));
            }
        }
        BLOCKS_SOILS = new HashSet(taggedBlocks.size());
        BLOCKS_ANCHOR = new HashSet(taggedBlocks.size());
        BLOCKS_NOMASS = new HashSet(taggedBlocks.size() + BLOCKS_LEAVES.size());
        BLOCKS_NOMASS.addAll(BLOCKS_LEAVES);
        BLOCKS_LEFTBEHIND = new HashSet(taggedBlocks.size());
        BLOCKS_EXPANDABLE = new HashSet(taggedBlocks.size() + BLOCKS_LEAVES.size());
        BLOCKS_EXPANDABLE.addAll(BLOCKS_LEAVES);
        BLOCKS_MINING = new HashSet(taggedBlocks.size());
        BLOCKS_SKIPMINING = new HashSet(taggedBlocks.size());
        BLOCKS_STOPMINING = new HashSet(taggedBlocks.size());
        BLOCKS_PLACE = new HashMap(taggedBlocks.size());
        BLOCKS_NOCAMOUFLAGE = new HashSet(taggedBlocks.size());
        for (Map.Entry entry : taggedBlocks.entrySet()) {
            Block block = Block.func_149684_b((String)((String)entry.getKey()));
            if (block == null) {
                WarpDrive.logger.info("Ignoring missing block " + (String)entry.getKey());
                continue;
            }
            block63: for (String tag : ((String)entry.getValue()).replace("\t", " ").replace(",", " ").replace("  ", " ").split(" ")) {
                switch (tag) {
                    case "Soil": {
                        BLOCKS_SOILS.add(block);
                        continue block63;
                    }
                    case "Log": {
                        BLOCKS_LOGS.add(block);
                        continue block63;
                    }
                    case "Leaf": {
                        BLOCKS_LEAVES.add(block);
                        continue block63;
                    }
                    case "Anchor": {
                        BLOCKS_ANCHOR.add(block);
                        continue block63;
                    }
                    case "NoMass": {
                        BLOCKS_NOMASS.add(block);
                        continue block63;
                    }
                    case "LeftBehind": {
                        BLOCKS_LEFTBEHIND.add(block);
                        continue block63;
                    }
                    case "Expandable": {
                        BLOCKS_EXPANDABLE.add(block);
                        continue block63;
                    }
                    case "Mining": {
                        BLOCKS_MINING.add(block);
                        continue block63;
                    }
                    case "SkipMining": {
                        BLOCKS_SKIPMINING.add(block);
                        continue block63;
                    }
                    case "StopMining": {
                        BLOCKS_STOPMINING.add(block);
                        continue block63;
                    }
                    case "PlaceEarliest": {
                        BLOCKS_PLACE.put(block, 0);
                        continue block63;
                    }
                    case "PlaceEarlier": {
                        BLOCKS_PLACE.put(block, 1);
                        continue block63;
                    }
                    case "PlaceNormal": {
                        BLOCKS_PLACE.put(block, 2);
                        continue block63;
                    }
                    case "PlaceLater": {
                        BLOCKS_PLACE.put(block, 3);
                        continue block63;
                    }
                    case "PlaceLatest": {
                        BLOCKS_PLACE.put(block, 4);
                        continue block63;
                    }
                    case "NoCamouflage": {
                        BLOCKS_NOCAMOUFLAGE.add(block);
                        continue block63;
                    }
                    default: {
                        WarpDrive.logger.error("Unsupported tag '" + tag + "' for block " + block);
                    }
                }
            }
        }
        ENTITIES_ANCHOR = new HashSet(taggedEntities.size());
        ENTITIES_NOMASS = new HashSet(taggedEntities.size());
        ENTITIES_LEFTBEHIND = new HashSet(taggedEntities.size());
        ENTITIES_NONLIVINGTARGET = new HashSet(taggedEntities.size());
        for (Map.Entry entry : taggedEntities.entrySet()) {
            String entityId = (String)entry.getKey();
            block65: for (String tag : ((String)entry.getValue()).replace("\t", " ").replace(",", " ").replace("  ", " ").split(" ")) {
                switch (tag) {
                    case "Anchor": {
                        ENTITIES_ANCHOR.add(entityId);
                        continue block65;
                    }
                    case "NoMass": {
                        ENTITIES_NOMASS.add(entityId);
                        continue block65;
                    }
                    case "LeftBehind": {
                        ENTITIES_LEFTBEHIND.add(entityId);
                        continue block65;
                    }
                    case "NonLivingTarget": {
                        ENTITIES_NONLIVINGTARGET.add(entityId);
                        continue block65;
                    }
                    default: {
                        WarpDrive.logger.error("Unsupported tag '" + tag + "' for entity " + entityId);
                    }
                }
            }
        }
        ITEMS_FLYINSPACE = new HashSet(taggedItems.size());
        ITEMS_NOFALLDAMAGE = new HashSet(taggedItems.size());
        ITEMS_BREATHINGIC2 = new HashSet(taggedItems.size());
        for (Map.Entry entry : taggedItems.entrySet()) {
            String itemId = (String)entry.getKey();
            Item item = (Item)GameData.getItemRegistry().func_82594_a(itemId);
            if (item == null) {
                WarpDrive.logger.info("Ignoring missing item " + itemId);
                continue;
            }
            String[] stringArray = ((String)entry.getValue()).replace("\t", " ").replace(",", " ").replace("  ", " ").split(" ");
            int n = stringArray.length;
            block67: for (int i = 0; i < n; ++i) {
                String tag;
                switch (tag = stringArray[i]) {
                    case "FlyInSpace": {
                        ITEMS_FLYINSPACE.add(item);
                        continue block67;
                    }
                    case "NoFallDamage": {
                        ITEMS_NOFALLDAMAGE.add(item);
                        continue block67;
                    }
                    case "BreathingIC2": {
                        ITEMS_BREATHINGIC2.add(item);
                        continue block67;
                    }
                    default: {
                        WarpDrive.logger.error("Unsupported tag '" + tag + "' for item " + item);
                    }
                }
            }
        }
        Dictionary.adjustHardnessAndResistance();
        Dictionary.print();
    }

    private static void print() {
        WarpDrive.logger.info("Active blocks dictionary:");
        WarpDrive.logger.info("- " + BLOCKS_ORES.size() + " ores: " + Dictionary.getHashMessage(BLOCKS_ORES));
        WarpDrive.logger.info("- " + BLOCKS_SOILS.size() + " soils: " + Dictionary.getHashMessage(BLOCKS_SOILS));
        WarpDrive.logger.info("- " + BLOCKS_LOGS.size() + " logs: " + Dictionary.getHashMessage(BLOCKS_LOGS));
        WarpDrive.logger.info("- " + BLOCKS_LEAVES.size() + " leaves: " + Dictionary.getHashMessage(BLOCKS_LEAVES));
        WarpDrive.logger.info("- " + BLOCKS_ANCHOR.size() + " anchors: " + Dictionary.getHashMessage(BLOCKS_ANCHOR));
        WarpDrive.logger.info("- " + BLOCKS_NOMASS.size() + " with NoMass tag: " + Dictionary.getHashMessage(BLOCKS_NOMASS));
        WarpDrive.logger.info("- " + BLOCKS_LEFTBEHIND.size() + " with LeftBehind tag: " + Dictionary.getHashMessage(BLOCKS_LEFTBEHIND));
        WarpDrive.logger.info("- " + BLOCKS_EXPANDABLE.size() + " expandable: " + Dictionary.getHashMessage(BLOCKS_EXPANDABLE));
        WarpDrive.logger.info("- " + BLOCKS_MINING.size() + " with Mining tag: " + Dictionary.getHashMessage(BLOCKS_MINING));
        WarpDrive.logger.info("- " + BLOCKS_SKIPMINING.size() + " with SkipMining tag: " + Dictionary.getHashMessage(BLOCKS_SKIPMINING));
        WarpDrive.logger.info("- " + BLOCKS_STOPMINING.size() + " with StopMining tag: " + Dictionary.getHashMessage(BLOCKS_STOPMINING));
        WarpDrive.logger.info("- " + BLOCKS_PLACE.size() + " with Placement priority: " + Dictionary.getHashMessage(BLOCKS_PLACE));
        WarpDrive.logger.info("Active entities dictionary:");
        WarpDrive.logger.info("- " + ENTITIES_ANCHOR.size() + " anchors: " + Dictionary.getHashMessage(ENTITIES_ANCHOR));
        WarpDrive.logger.info("- " + ENTITIES_NOMASS.size() + " with NoMass tag: " + Dictionary.getHashMessage(ENTITIES_NOMASS));
        WarpDrive.logger.info("- " + ENTITIES_LEFTBEHIND.size() + " with LeftBehind tag: " + Dictionary.getHashMessage(ENTITIES_LEFTBEHIND));
        WarpDrive.logger.info("- " + ENTITIES_NONLIVINGTARGET.size() + " with NonLivingTarget tag: " + Dictionary.getHashMessage(ENTITIES_NONLIVINGTARGET));
        WarpDrive.logger.info("Active items dictionary:");
        WarpDrive.logger.info("- " + ITEMS_FLYINSPACE.size() + " allowing fly in space: " + Dictionary.getHashMessage(ITEMS_FLYINSPACE));
        WarpDrive.logger.info("- " + ITEMS_NOFALLDAMAGE.size() + " absorbing fall damages: " + Dictionary.getHashMessage(ITEMS_NOFALLDAMAGE));
        WarpDrive.logger.info("- " + ITEMS_BREATHINGIC2.size() + " allowing breathing compressed air: " + Dictionary.getHashMessage(ITEMS_BREATHINGIC2));
    }

    private static void adjustHardnessAndResistance() {
        Blocks.field_150343_Z.func_149752_b(60.0f);
        Blocks.field_150381_bn.func_149752_b(60.0f);
        Blocks.field_150477_bB.func_149752_b(60.0f);
        Blocks.field_150467_bQ.func_149752_b(60.0f);
        Blocks.field_150355_j.func_149752_b(30.0f);
        Blocks.field_150358_i.func_149752_b(30.0f);
        Blocks.field_150353_l.func_149752_b(30.0f);
        Blocks.field_150356_k.func_149752_b(30.0f);
        for (Object blockKey : Block.field_149771_c.func_148742_b()) {
            Object object = Block.field_149771_c.func_82594_a(blockKey);
            WarpDrive.logger.debug("Checking block registry for '" + blockKey + "': " + object);
            if (!(object instanceof Block)) {
                WarpDrive.logger.error("Block registry for '" + blockKey + "': this is not a block? " + object);
                continue;
            }
            Block block = (Block)object;
            float hardness = -2.0f;
            if (WarpDrive.fieldBlockHardness != null) {
                try {
                    hardness = ((Float)WarpDrive.fieldBlockHardness.get(block)).floatValue();
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    exception.printStackTrace();
                    WarpDrive.logger.error("Unable to access block hardness value '" + blockKey + "' " + block);
                }
            }
            float blastResistance = block.func_149638_a(null);
            if (hardness != -2.0f) {
                if (hardness < 0.0f && !BLOCKS_ANCHOR.contains(block)) {
                    WarpDrive.logger.warn("Warning: non-anchor block with unbreakable hardness '" + blockKey + "' " + block + " (" + hardness + ")");
                } else if (!(!(hardness > WarpDriveConfig.HULL_HARDNESS[0]) || block instanceof BlockHullPlain || block instanceof BlockHullGlass || block instanceof BlockHullStairs || BLOCKS_ANCHOR.contains(block))) {
                    WarpDrive.logger.warn("Warning: non-hull block with high hardness '" + blockKey + "' " + block + " (" + hardness + ")");
                }
            }
            if (blastResistance > WarpDriveConfig.HULL_BLAST_RESISTANCE[0] && !(block instanceof BlockHullPlain) && !(block instanceof BlockHullGlass) && !BLOCKS_ANCHOR.contains(block)) {
                block.func_149752_b(WarpDriveConfig.HULL_BLAST_RESISTANCE[0]);
                WarpDrive.logger.warn("Warning: non-anchor block with high blast resistance '" + blockKey + "' " + block + " (" + hardness + ")");
            }
            if (!WarpDriveConfig.LOGGING_DICTIONARY) continue;
            WarpDrive.logger.info("Block registry for '" + blockKey + "': Block " + block + " with hardness " + (WarpDrive.fieldBlockHardness != null ? Float.valueOf(hardness) : "-") + " resistance " + block.func_149638_a(null));
        }
    }

    private static String getHashMessage(HashSet hashSet) {
        String message = "";
        for (Object object : hashSet) {
            if (!message.isEmpty()) {
                message = message + ", ";
            }
            if (object instanceof Block) {
                message = message + GameRegistry.findUniqueIdentifierFor((Block)((Block)object));
                continue;
            }
            if (object instanceof String) {
                message = message + (String)object;
                continue;
            }
            message = message + object;
        }
        return message;
    }

    private static String getHashMessage(HashMap<Block, Integer> hashMap) {
        String message = "";
        for (Map.Entry<Block, Integer> entry : hashMap.entrySet()) {
            if (!message.isEmpty()) {
                message = message + ", ";
            }
            message = message + GameRegistry.findUniqueIdentifierFor((Block)entry.getKey()) + "=" + entry.getValue();
        }
        return message;
    }
}

