/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.IXmlRepresentable;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class RandomCollection<E extends IXmlRepresentable> {
    private final NavigableMap<Integer, E> weightMap = new TreeMap<Integer, E>();
    private int totalWeight = 0;
    private final NavigableMap<Double, E> ratioMap = new TreeMap<Double, E>();
    private double totalRatio = 0.0;
    private final ArrayList<E> list = new ArrayList();

    public void addWeight(int weight, E object) {
        if (weight <= 0) {
            WarpDrive.logger.warn("Weight is negative or zero, skipping " + object + " with weight " + weight);
            return;
        }
        if (this.weightMap.containsValue(object)) {
            WarpDrive.logger.warn("Object already has a weight defined, skipping " + object + " with weight " + weight);
            return;
        }
        this.totalWeight += weight;
        this.weightMap.put(this.totalWeight, object);
        this.list.add(object);
    }

    public void addRatio(double ratio, E object) {
        if (ratio <= 0.0 || ratio >= 1.0) {
            WarpDrive.logger.warn("Ratio isn't in ]0, 1.0] bounds, skipping " + object + " with ratio " + ratio);
            return;
        }
        if (this.ratioMap.containsValue(object)) {
            WarpDrive.logger.warn("Object already has a ratio defined, skipping " + object + " with ratio " + ratio);
            return;
        }
        if (this.totalRatio + ratio > 1.0) {
            WarpDrive.logger.warn("Total ratio is greater than 1.0, skipping " + object + " with ratio " + ratio);
            return;
        }
        this.totalRatio += ratio;
        this.ratioMap.put(this.totalRatio, object);
        this.list.add(object);
    }

    public E getRandomEntry(Random random) {
        double value = random.nextDouble();
        if ((double)this.totalWeight == 0.0) {
            value *= this.totalRatio;
        }
        if (value < this.totalRatio) {
            return (E)((IXmlRepresentable)this.ratioMap.ceilingEntry(value).getValue());
        }
        int weight = (int)Math.round((value - this.totalRatio) * (double)this.totalWeight);
        Map.Entry<Integer, E> entry = this.weightMap.ceilingEntry(weight);
        if (entry != null) {
            return (E)((IXmlRepresentable)entry.getValue());
        }
        return null;
    }

    public E getNamedEntry(String name) {
        for (IXmlRepresentable object : this.list) {
            if (!object.getName().equals(name)) continue;
            return (E)object;
        }
        return null;
    }

    public String getNames() {
        String names = "";
        if (this.list.isEmpty()) {
            return "-none defined-";
        }
        for (IXmlRepresentable object : this.list) {
            if (!names.isEmpty()) {
                names = names + ", ";
            }
            names = names + object.getName();
        }
        return names;
    }

    public ArrayList<E> elements() {
        return this.list;
    }

    public void loadFromXML(E object, Element element) throws InvalidXmlException {
        if (!object.loadFromXmlElement(element)) {
            return;
        }
        E existing = this.getNamedEntry(object.getName());
        if (existing != null) {
            if (existing.equals(object)) {
                if (WarpDriveConfig.LOGGING_WORLDGEN) {
                    WarpDrive.logger.info("Object already exists in collection, skipping " + object.getName());
                }
                return;
            }
            throw new InvalidXmlException("Invalid merge of different objects with the same name " + object.getName() + "\nnew entry is " + object + "\nwhile existing entry is " + existing + "");
        }
        String stringRatio = element.getAttribute("ratio");
        if (!stringRatio.isEmpty()) {
            double ratio;
            try {
                ratio = Double.parseDouble(stringRatio);
            }
            catch (NumberFormatException exceptionRatio) {
                throw new InvalidXmlException("Ratio must be double!");
            }
            this.addRatio(ratio, object);
        } else {
            int weight = 1;
            String stringWeight = element.getAttribute("weight");
            if (!stringWeight.isEmpty()) {
                try {
                    weight = Integer.parseInt(stringWeight);
                }
                catch (NumberFormatException exceptionWeight) {
                    throw new InvalidXmlException("Weight must be an integer!");
                }
                weight = Math.max(1, weight);
            }
            this.addWeight(weight, object);
        }
    }

    public void loadFrom(RandomCollection<E> objects) {
        int previousWeight = 0;
        for (Map.Entry entry : objects.weightMap.entrySet()) {
            this.addWeight((Integer)entry.getKey() - previousWeight, (IXmlRepresentable)entry.getValue());
            previousWeight = (Integer)entry.getKey();
        }
        double previousRatio = 0.0;
        for (Map.Entry entry : objects.ratioMap.entrySet()) {
            this.addRatio((Double)entry.getKey() - previousRatio, (IXmlRepresentable)entry.getValue());
            previousRatio = (Double)entry.getKey();
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

