/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cpw.mods.fml.common.Loader;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlPreprocessor {
    static final boolean enableOutput = false;
    static int outputCount = 1;

    public static String checkModRequirements(Element element) {
        ModCheckResults modCheckResults = new ModCheckResults();
        for (String mod : element.getAttribute("mods").split(",")) {
            if (mod.isEmpty()) continue;
            if (mod.startsWith("!")) {
                if (!Loader.isModLoaded((String)mod.substring(1))) continue;
                modCheckResults.addMod(mod, "loaded");
                continue;
            }
            if (Loader.isModLoaded((String)mod)) continue;
            modCheckResults.addMod(mod, "not loaded");
        }
        return modCheckResults.toString();
    }

    public static void doModReqSanitation(Node base) {
        NodeList children = base.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element elementChild = (Element)child;
            String result = XmlPreprocessor.checkModRequirements(elementChild);
            if (!result.isEmpty()) {
                WarpDrive.logger.info("Skipping " + base.getNodeName() + "/" + elementChild.getNodeName() + " " + elementChild.getAttribute("group") + elementChild.getAttribute("name") + elementChild.getAttribute("block") + " due to " + result);
                base.removeChild(child);
                continue;
            }
            XmlPreprocessor.doModReqSanitation(child);
        }
    }

    public static void doLogicPreprocessing(Node root) throws InvalidXmlException {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XmlPreprocessor.doLogicPreprocessing(children.item(i));
        }
        if (root.getNodeType() != 1 || !((Element)root).getTagName().equalsIgnoreCase("for")) {
            return;
        }
        Element elementFor = (Element)root;
        String variableName = elementFor.getAttribute("variable");
        if (variableName.isEmpty()) {
            throw new InvalidXmlException("A for tag must include a variable attribute!");
        }
        if (elementFor.hasAttribute("in")) {
            String[] inOptions;
            for (String variableValue : inOptions = elementFor.getAttribute("in").split(",")) {
                if (WarpDriveConfig.LOGGING_WORLDGEN) {
                    WarpDrive.logger.info("Resolving for-loop with variable " + variableName + " = " + variableValue);
                }
                NodeList allChildren = root.getChildNodes();
                for (int childIndex = 0; childIndex < allChildren.getLength(); ++childIndex) {
                    Node copy = XmlPreprocessor.copyNodeAndReplaceVariable(allChildren.item(childIndex), variableName, variableValue);
                    root.getParentNode().appendChild(copy);
                }
            }
        } else {
            int intTo;
            String stringFrom = elementFor.getAttribute("from");
            String stringTo = elementFor.getAttribute("to");
            if (stringTo.isEmpty() || stringFrom.isEmpty()) {
                throw new InvalidXmlException("For element with no 'in' attribute requires both 'from' and 'to' attributes! " + variableName);
            }
            try {
                int intFrom = Integer.parseInt(stringFrom);
                intTo = Integer.parseInt(stringTo);
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException(exception);
            }
            for (int variableValue = intFrom; variableValue <= intTo; ++variableValue) {
                if (WarpDriveConfig.LOGGING_WORLDGEN) {
                    WarpDrive.logger.info("Resolving for-loop with variable " + variableName + " = " + variableValue);
                }
                NodeList allChildren = root.getChildNodes();
                for (int childIndex = 0; childIndex < allChildren.getLength(); ++childIndex) {
                    Node copy = XmlPreprocessor.copyNodeAndReplaceVariable(allChildren.item(childIndex), variableName, "" + variableValue);
                    root.getParentNode().appendChild(copy);
                }
            }
        }
        root.getParentNode().removeChild(root);
    }

    private static Node copyNodeAndReplaceVariable(Node nodeOriginal, String variableName, String variableValue) {
        Node nodeCopy = nodeOriginal.cloneNode(true);
        XmlPreprocessor.replaceVariable(nodeCopy, "%" + variableName + "%", variableValue);
        return nodeCopy;
    }

    private static void replaceVariable(Node node, String keyword, String value) {
        ArrayList<String> nameToRemove = new ArrayList<String>();
        ArrayList<Attr> attrToAdd = new ArrayList<Attr>();
        if (node.getNodeType() == 1) {
            NamedNodeMap attributes = node.getAttributes();
            for (int indexAttr = 0; indexAttr < attributes.getLength(); ++indexAttr) {
                String newName;
                Attr attr = (Attr)attributes.item(indexAttr);
                String oldName = attr.getName();
                if (oldName.equals(newName = oldName.replace(keyword, value))) {
                    attr.setValue(attr.getValue().replace(keyword, value));
                    continue;
                }
                nameToRemove.add(oldName);
                Attr newAttr = attr.getOwnerDocument().createAttribute(newName);
                newAttr.setValue(attr.getValue().replace(keyword, value));
                attrToAdd.add(newAttr);
            }
            for (String string : nameToRemove) {
                attributes.removeNamedItem(string);
            }
            for (Attr attr : attrToAdd) {
                attributes.setNamedItem(attr);
            }
        }
        NodeList children = node.getChildNodes();
        block7: for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
            Node node2 = children.item(childIndex);
            switch (node2.getNodeType()) {
                case 1: {
                    XmlPreprocessor.replaceVariable(node2, keyword, value);
                    continue block7;
                }
                case 3: {
                    node2.setTextContent(node2.getTextContent().replace(keyword, value));
                    continue block7;
                }
            }
        }
    }

    public static class ModCheckResults {
        private final TreeMap<String, String> modResults = new TreeMap();

        public void addMod(String name, String error) {
            this.modResults.put(name, error);
        }

        public boolean isEmpty() {
            return this.modResults.isEmpty();
        }

        public String toString() {
            String string = this.modResults.size() > 1 ? "{" : "";
            boolean isFirst = true;
            for (Map.Entry<String, String> entry : this.modResults.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    string = string + ", ";
                }
                string = string + entry.getKey() + ": " + entry.getValue();
            }
            return string + (this.modResults.size() > 1 ? "}" : "");
        }
    }
}

