/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.filler;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.IXmlRepresentable;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.data.JumpBlock;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Filler
implements IXmlRepresentable {
    private String name;
    public Block block;
    public int metadata;
    public NBTTagCompound tag = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        if (!element.hasAttribute("block")) {
            throw new InvalidXmlException("Filler " + element + " is missing a block tag!");
        }
        String blockName = element.getAttribute("block");
        this.block = Block.func_149684_b((String)blockName);
        if (this.block == null) {
            WarpDrive.logger.warn("Skipping missing block " + blockName);
            return false;
        }
        this.metadata = 0;
        String stringMetadata = element.getAttribute("metadata");
        if (!stringMetadata.isEmpty()) {
            try {
                this.metadata = Integer.parseInt(stringMetadata);
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Invalid metadata for block " + blockName);
            }
        }
        this.name = blockName + "@" + this.metadata + "{" + this.tag + "}";
        return true;
    }

    @Override
    @Deprecated
    public void saveToXmlElement(Element element, Document document) throws InvalidXmlException {
        throw new InvalidXmlException("Not implemented");
    }

    public void setBlock(World world, int x, int y, int z) {
        JumpBlock.setBlockNoLight(world, x, y, z, this.block, this.metadata, 2);
    }

    public boolean equals(Object object) {
        return !(!(object instanceof Filler) || this.block != null && !this.block.equals(((Filler)object).block) || this.metadata != ((Filler)object).metadata || this.tag != null && !this.tag.equals((Object)((Filler)object).tag));
    }

    public String toString() {
        return "Filler(" + this.block.func_149739_a() + "@" + this.metadata + ")";
    }

    public int hashCode() {
        return Block.func_149682_b((Block)this.block) * 16 + this.metadata + (this.tag == null ? 0 : this.tag.hashCode() * 4096 * 16);
    }
}

