/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.filler;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.RandomCollection;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlPreprocessor;
import cr0s.warpdrive.config.filler.FillerSet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FillerManager {
    private static HashMap<String, RandomCollection<FillerSet>> fillerSetsByGroup;
    private static final String[] REQUIRED_GROUPS;

    public static void load(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File path " + dir.getName() + " must be a directory!");
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file_notUsed, String name) {
                return name.startsWith("filler") && name.endsWith(".xml");
            }
        });
        fillerSetsByGroup = new HashMap();
        for (File file : files) {
            try {
                FillerManager.loadXmlFillerFile(file);
            }
            catch (Exception exception) {
                WarpDrive.logger.error("Error loading filler data file " + file.getName() + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        for (String group : REQUIRED_GROUPS) {
            if (fillerSetsByGroup.containsKey(group)) continue;
            WarpDrive.logger.error("Error: no fillerSet defined for mandatory group " + (String)group);
        }
        FillerManager.propagateFillerSets();
        WarpDrive.logger.info("Loading filler data files done");
    }

    private static void loadXmlFillerFile(File file) throws InvalidXmlException, SAXException, IOException {
        WarpDrive.logger.info("Loading filler data file " + file.getName());
        Document document = WarpDriveConfig.getXmlDocumentBuilder().parse(file);
        String result = XmlPreprocessor.checkModRequirements(document.getDocumentElement());
        if (!result.isEmpty()) {
            WarpDrive.logger.info("Skipping filler data file " + file.getName() + " due to " + result);
            return;
        }
        XmlPreprocessor.doModReqSanitation(document);
        XmlPreprocessor.doLogicPreprocessing(document);
        NodeList nodeListFillerSet = document.getElementsByTagName("fillerSet");
        for (int fillerSetIndex = 0; fillerSetIndex < nodeListFillerSet.getLength(); ++fillerSetIndex) {
            FillerSet fillerSet;
            RandomCollection<FillerSet> randomCollection;
            Element elementFillerSet = (Element)nodeListFillerSet.item(fillerSetIndex);
            String group = elementFillerSet.getAttribute("group");
            if (group.isEmpty()) {
                throw new InvalidXmlException("FillerSet " + (fillerSetIndex + 1) + "/" + nodeListFillerSet.getLength() + " is missing a group attribute!");
            }
            String name = elementFillerSet.getAttribute("name");
            if (name.isEmpty()) {
                throw new InvalidXmlException("FillerSet " + (fillerSetIndex + 1) + "/" + nodeListFillerSet.getLength() + " is missing a name attribute!");
            }
            if (WarpDriveConfig.LOGGING_WORLDGEN) {
                WarpDrive.logger.info("- found FillerSet " + group + ":" + name);
            }
            if ((randomCollection = fillerSetsByGroup.get(group)) == null) {
                randomCollection = new RandomCollection();
                fillerSetsByGroup.put(group, randomCollection);
            }
            if ((fillerSet = randomCollection.getNamedEntry(name)) == null) {
                fillerSet = new FillerSet(group, name);
            }
            randomCollection.loadFromXML(fillerSet, elementFillerSet);
        }
    }

    private static void propagateFillerSets() {
        HashMap<FillerSet, ArrayList<String>> fillerSetsDependencies = new HashMap<FillerSet, ArrayList<String>>();
        for (RandomCollection<FillerSet> fillerSets : fillerSetsByGroup.values()) {
            for (FillerSet fillerSet : fillerSets.elements()) {
                ArrayList<String> dependencies = (ArrayList<String>)fillerSetsDependencies.get(fillerSet);
                if (dependencies == null) {
                    dependencies = new ArrayList<String>();
                    fillerSetsDependencies.put(fillerSet, dependencies);
                }
                dependencies.addAll(fillerSet.getImportGroupNames());
            }
        }
        int iterationCount = 0;
        while (!fillerSetsDependencies.isEmpty() && iterationCount++ < 10) {
            HashMap fillerSetsLeftToImport = new HashMap();
            for (Map.Entry entry : fillerSetsDependencies.entrySet()) {
                ArrayList<String> newDependencies = new ArrayList<String>();
                for (String dependency : (ArrayList)entry.getValue()) {
                    FillerSet fillerSet = FillerManager.getFillerSet(dependency);
                    if (fillerSet == null) {
                        WarpDrive.logger.error("Ignoring missing FillerSet " + dependency + " dependency in FillerSet " + entry.getKey());
                        continue;
                    }
                    if (fillerSetsDependencies.containsKey(fillerSet)) {
                        newDependencies.add(dependency);
                        continue;
                    }
                    try {
                        if (WarpDriveConfig.LOGGING_WORLDGEN) {
                            WarpDrive.logger.info("Importing FillerSet " + fillerSet.getFullName() + " in " + ((FillerSet)entry.getKey()).getFullName());
                        }
                        ((FillerSet)entry.getKey()).loadFrom(fillerSet);
                    }
                    catch (InvalidXmlException exception) {
                        exception.printStackTrace();
                        WarpDrive.logger.error("While importing " + dependency + " into FillerSet " + ((FillerSet)entry.getKey()).getFullName());
                    }
                }
                if (newDependencies.isEmpty()) continue;
                fillerSetsLeftToImport.put(entry.getKey(), newDependencies);
            }
            fillerSetsDependencies = fillerSetsLeftToImport;
        }
        if (!fillerSetsDependencies.isEmpty()) {
            WarpDrive.logger.error("Too many import recursions, ignoring the remaining ones:");
            for (Map.Entry entry : fillerSetsDependencies.entrySet()) {
                WarpDrive.logger.warn("- FillerSet " + entry.getKey() + " is pending:");
                for (String dependency : (ArrayList)entry.getValue()) {
                    WarpDrive.logger.warn(" + " + dependency);
                }
            }
        }
    }

    public static boolean doesGroupExist(String groupName) {
        return fillerSetsByGroup.get(groupName) != null;
    }

    public static FillerSet getRandomFillerSetFromGroup(Random random, String groupName) {
        RandomCollection<FillerSet> group = fillerSetsByGroup.get(groupName);
        if (group == null) {
            return null;
        }
        return group.getRandomEntry(random);
    }

    public static FillerSet getFillerSet(String groupAndName) {
        String[] parts = groupAndName.split(":");
        if (parts.length != 2) {
            WarpDrive.logger.error("Invalid FillerSet '" + groupAndName + "'. Expecting '{group}:{name}'");
            return null;
        }
        RandomCollection<FillerSet> group = fillerSetsByGroup.get(parts[0]);
        if (group == null) {
            return null;
        }
        return group.getNamedEntry(parts[1]);
    }

    static {
        REQUIRED_GROUPS = new String[0];
    }
}

