/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.filler;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.IXmlRepresentable;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.RandomCollection;
import cr0s.warpdrive.config.filler.Filler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.init.Blocks;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FillerSet
implements IXmlRepresentable,
Comparable {
    protected String group;
    protected String name;
    private RandomCollection<Filler> fillers;
    private ArrayList<String> importGroupNames;
    private ArrayList<String> importGroups;

    public String getFullName() {
        return this.group + ":" + this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public FillerSet(String group, String name) {
        this.group = group;
        this.name = name;
        this.fillers = new RandomCollection();
        this.importGroupNames = new ArrayList();
        this.importGroups = new ArrayList();
    }

    public boolean isEmpty() {
        return this.fillers.isEmpty();
    }

    public Filler getRandomBlock(Random random) {
        Filler filler = this.fillers.getRandomEntry(random);
        if (filler == null) {
            WarpDrive.logger.error("null filler encountered in FillerSet " + this.getFullName());
            filler = new Filler();
            filler.block = Blocks.field_150359_w;
        }
        return filler;
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        NodeList nodeListFillers = element.getElementsByTagName("filler");
        for (int i = 0; i < nodeListFillers.getLength(); ++i) {
            Element elementFiller = (Element)nodeListFillers.item(i);
            Filler filler = new Filler();
            this.fillers.loadFromXML(filler, elementFiller);
        }
        NodeList nodeListImports = element.getElementsByTagName("import");
        if (nodeListImports.getLength() > 0) {
            for (int importIndex = 0; importIndex < nodeListImports.getLength(); ++importIndex) {
                Element elementImport = (Element)nodeListImports.item(importIndex);
                String importGroup = elementImport.getAttribute("group");
                String importName = elementImport.getAttribute("name");
                if (!importGroup.isEmpty()) {
                    if (!importName.isEmpty()) {
                        this.importGroupNames.add(importGroup + ":" + importName);
                        continue;
                    }
                    this.importGroups.add(importGroup);
                    continue;
                }
                WarpDrive.logger.warn("Ignoring import with no group definition in import element from " + this.getFullName());
            }
        }
        return true;
    }

    @Override
    @Deprecated
    public void saveToXmlElement(Element element, Document document) throws InvalidXmlException {
        throw new InvalidXmlException("Not implemented");
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((FillerSet)object).name);
    }

    public String toString() {
        return this.getFullName() + "(" + (this.fillers == null ? "-empty-" : Integer.valueOf(this.fillers.elements().size())) + ")";
    }

    public void loadFrom(FillerSet fillerSet) throws InvalidXmlException {
        this.fillers.loadFrom(fillerSet.fillers);
    }

    public Collection<String> getImportGroupNames() {
        return this.importGroupNames;
    }

    public Collection<String> getImportGroups() {
        return this.importGroups;
    }
}

