/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CloakedArea;
import cr0s.warpdrive.network.PacketHandler;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class CloakManager {
    private static LinkedList<CloakedArea> cloaks;

    public CloakManager() {
        cloaks = new LinkedList();
    }

    public boolean isCloaked(int dimensionID, int x, int y, int z) {
        for (CloakedArea area : cloaks) {
            if (area.dimensionId != dimensionID || area.minX > x || area.maxX < x || area.minY > y || area.maxY < y || area.minZ > z || area.maxZ < z) continue;
            return true;
        }
        return false;
    }

    public void onChunkLoaded(EntityPlayerMP player, int chunkPosX, int chunkPosZ) {
        for (CloakedArea area : cloaks) {
            if (area.dimensionId != player.field_70170_p.field_73011_w.field_76574_g || area.minX > chunkPosX << 19 || area.maxX < chunkPosX << 4 || area.minZ > chunkPosZ << 19 || area.maxZ < chunkPosZ << 4) continue;
            PacketHandler.sendCloakPacket((EntityPlayer)player, area, false);
        }
    }

    public void onPlayerEnteringDimension(EntityPlayer player) {
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info("onEntityJoinWorld " + player);
        }
        for (CloakedArea area : cloaks) {
            if (area.dimensionId != player.field_70170_p.field_73011_w.field_76574_g || !((double)area.minX > player.field_70165_t || (double)area.maxX < player.field_70165_t || (double)area.minY > player.field_70163_u || (double)area.maxY < player.field_70163_u || (double)area.minZ > player.field_70161_v) && !((double)area.maxZ < player.field_70161_v)) continue;
            PacketHandler.sendCloakPacket(player, area, false);
        }
    }

    public boolean isAreaExists(World world, int x, int y, int z) {
        return this.getCloakedArea(world, x, y, z) != null;
    }

    public void updateCloakedArea(World world, int dimensionId, int coreX, int coreY, int coreZ, byte tier, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        CloakedArea newArea = new CloakedArea(world, dimensionId, coreX, coreY, coreZ, tier, minX, minY, minZ, maxX, maxY, maxZ);
        int index = -1;
        for (int i = 0; i < cloaks.size(); ++i) {
            CloakedArea area = cloaks.get(i);
            if (area.dimensionId != world.field_73011_w.field_76574_g || area.coreX != coreX || area.coreY != coreY || area.coreZ != coreZ) continue;
            index = i;
            break;
        }
        if (index != -1) {
            cloaks.set(index, newArea);
        } else {
            cloaks.add(newArea);
        }
        if (world.field_72995_K) {
            newArea.clientCloak();
        }
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info("Cloak count is " + cloaks.size());
        }
    }

    public void removeCloakedArea(int dimensionId, int coreX, int coreY, int coreZ) {
        int index = -1;
        for (int i = 0; i < cloaks.size(); ++i) {
            CloakedArea area = cloaks.get(i);
            if (area.dimensionId != dimensionId || area.coreX != coreX || area.coreY != coreY || area.coreZ != coreZ) continue;
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                area.clientDecloak();
            } else {
                area.sendCloakPacketToPlayersEx(true);
            }
            index = i;
            break;
        }
        if (index != -1) {
            cloaks.remove(index);
        }
    }

    public CloakedArea getCloakedArea(World world, int x, int y, int z) {
        for (CloakedArea area : cloaks) {
            if (area.dimensionId != world.field_73011_w.field_76574_g || area.coreX != x || area.coreY != y || area.coreZ != z) continue;
            return area;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public CloakedArea getCloakedArea(int x, int y, int z) {
        for (CloakedArea area : cloaks) {
            if (area.coreX != x || area.coreY != y || area.coreZ != z) continue;
            return area;
        }
        return null;
    }

    public void updatePlayer(EntityPlayer player) {
        for (CloakedArea area : cloaks) {
            area.updatePlayer(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean onBlockChange(int x, int y, int z, Block block, int metadata, int flag) {
        if (block != Blocks.field_150350_a && cloaks != null) {
            for (CloakedArea area : cloaks) {
                if (!area.isBlockWithinArea(x, y, z) || area.isEntityWithinArea((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) continue;
                return Minecraft.func_71410_x().field_71441_e.func_147465_d(x, y, z, area.fogBlock, area.fogMetadata, flag);
            }
        }
        return Minecraft.func_71410_x().field_71441_e.func_147465_d(x, y, z, block, metadata, flag);
    }

    @SideOnly(value=Side.CLIENT)
    public static void onFillChunk(Chunk chunk) {
        if (cloaks == null) {
            return;
        }
        int chunkX_min = chunk.field_76635_g * 16;
        int chunkX_max = chunk.field_76635_g * 16 + 15;
        int chunkZ_min = chunk.field_76647_h * 16;
        int chunkZ_max = chunk.field_76647_h * 16 + 15;
        for (CloakedArea area : cloaks) {
            if (area.minX > chunkX_max || area.maxX < chunkX_min || area.minZ > chunkZ_max || area.maxZ < chunkZ_min || area.isEntityWithinArea((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) continue;
            int areaX_min = Math.max(chunkX_min, area.minX) & 0xF;
            int areaX_max = Math.min(chunkX_max, area.maxX) & 0xF;
            int areaZ_min = Math.max(chunkZ_min, area.minZ) & 0xF;
            int areaZ_max = Math.min(chunkZ_max, area.maxZ) & 0xF;
            for (int x = areaX_min; x <= areaX_max; ++x) {
                for (int z = areaZ_min; z <= areaZ_max; ++z) {
                    for (int y = area.maxY; y >= area.minY; --y) {
                        if (chunk.func_150810_a(x, y, z) == Blocks.field_150350_a) continue;
                        chunk.func_150807_a(x, y, z, area.fogBlock, area.fogMetadata);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientChangingDimension() {
        cloaks.clear();
    }
}

