/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.api.IForceFieldShape;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.VectorI;
import java.util.HashMap;
import java.util.Map;

public enum EnumForceFieldShape implements IForceFieldShape
{
    NONE("none"),
    SPHERE("sphere"),
    CYLINDER_H("cylinder_h"),
    CYLINDER_V("cylinder_v"),
    CUBE("cube"),
    PLANE("plane"),
    TUBE("tube"),
    TUNNEL("tunnel");

    public final String unlocalizedName;
    public static final int length;
    private static final HashMap<Integer, EnumForceFieldShape> ID_MAP;

    private EnumForceFieldShape(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    public static EnumForceFieldShape get(int damage) {
        return ID_MAP.get(damage);
    }

    @Override
    public Map<VectorI, Boolean> getVertexes(ForceFieldSetup forceFieldSetup) {
        VectorI vScale = forceFieldSetup.vMax.clone().translateBack(forceFieldSetup.vMin);
        HashMap<VectorI, Boolean> mapVertexes = new HashMap<VectorI, Boolean>(vScale.x * vScale.y * vScale.z);
        float halfThickness = forceFieldSetup.thickness / 2.0f;
        switch (this) {
            case SPHERE: {
                float radius = forceFieldSetup.vMax.y;
                float radiusInterior2 = (radius - halfThickness) * (radius - halfThickness);
                float radiusPerimeter2 = (radius + halfThickness) * (radius + halfThickness);
                VectorI vCenter = new VectorI(0, 0, 0);
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    int y2 = (y - vCenter.y) * (y - vCenter.y);
                    for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                        int x2 = (x - vCenter.x) * (x - vCenter.x);
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            int z2 = (z - vCenter.z) * (z - vCenter.z);
                            if (!((float)(x2 + y2 + z2) <= radiusPerimeter2)) continue;
                            mapVertexes.put(new VectorI(x, y, z), (float)(x2 + y2 + z2) >= radiusInterior2);
                        }
                    }
                }
                break;
            }
            case CYLINDER_H: {
                float radius = (float)(forceFieldSetup.vMax.y + forceFieldSetup.vMax.z) / 2.0f;
                float radiusInterior2 = (radius - halfThickness) * (radius - halfThickness);
                float radiusPerimeter2 = (radius + halfThickness) * (radius + halfThickness);
                VectorI vCenter = new VectorI(0, 0, 0);
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    int y2 = (y - vCenter.y) * (y - vCenter.y);
                    for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                        int z2 = (z - vCenter.z) * (z - vCenter.z);
                        if (!((float)(y2 + z2) <= radiusPerimeter2)) continue;
                        boolean isPerimeter = (float)(y2 + z2) >= radiusInterior2;
                        for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
            case CYLINDER_V: {
                float radius = (float)(forceFieldSetup.vMax.x + forceFieldSetup.vMax.y) / 2.0f;
                float radiusInterior2 = (radius - halfThickness) * (radius - halfThickness);
                float radiusPerimeter2 = (radius + halfThickness) * (radius + halfThickness);
                VectorI vCenter = new VectorI(0, 0, 0);
                for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                    int x2 = (x - vCenter.x) * (x - vCenter.x);
                    for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                        int y2 = (y - vCenter.y) * (y - vCenter.y);
                        if (!((float)(x2 + y2) <= radiusPerimeter2)) continue;
                        boolean isPerimeter = (float)(x2 + y2) >= radiusInterior2;
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
            case TUBE: {
                float radius = (float)(forceFieldSetup.vMax.x + forceFieldSetup.vMax.z) / 2.0f;
                float radiusInterior2 = (radius - halfThickness) * (radius - halfThickness);
                float radiusPerimeter2 = (radius + halfThickness) * (radius + halfThickness);
                VectorI vCenter = new VectorI(0, 0, 0);
                for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                    int x2 = (x - vCenter.x) * (x - vCenter.x);
                    for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                        int z2 = (z - vCenter.z) * (z - vCenter.z);
                        if (!((float)(x2 + z2) <= radiusPerimeter2)) continue;
                        boolean isPerimeter = (float)(x2 + z2) >= radiusInterior2;
                        for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
            case CUBE: {
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    boolean yFace = (float)Math.abs(y - forceFieldSetup.vMin.y) <= halfThickness || (float)Math.abs(y - forceFieldSetup.vMax.y) <= halfThickness;
                    for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                        boolean xFace = (float)Math.abs(x - forceFieldSetup.vMin.x) <= halfThickness || (float)Math.abs(x - forceFieldSetup.vMax.x) <= halfThickness;
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            boolean zFace = (float)Math.abs(z - forceFieldSetup.vMin.z) <= halfThickness || (float)Math.abs(z - forceFieldSetup.vMax.z) <= halfThickness;
                            mapVertexes.put(new VectorI(x, y, z), xFace || yFace || zFace);
                        }
                    }
                }
                break;
            }
            case PLANE: {
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    boolean yFace = (float)Math.abs(y - forceFieldSetup.vMin.y) <= halfThickness || (float)Math.abs(y - forceFieldSetup.vMax.y) <= halfThickness;
                    for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            mapVertexes.put(new VectorI(x, y, z), yFace);
                        }
                    }
                }
                break;
            }
            case TUNNEL: {
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                        boolean xFace = (float)Math.abs(x - forceFieldSetup.vMin.x) <= halfThickness || (float)Math.abs(x - forceFieldSetup.vMax.x) <= halfThickness;
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            boolean isPerimeter = xFace || (float)Math.abs(z - forceFieldSetup.vMin.z) <= halfThickness || (float)Math.abs(z - forceFieldSetup.vMax.z) <= halfThickness;
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
        }
        return mapVertexes;
    }

    static {
        ID_MAP = new HashMap();
        length = EnumForceFieldShape.values().length;
        for (EnumForceFieldShape enumForceFieldShape : EnumForceFieldShape.values()) {
            ID_MAP.put(enumForceFieldShape.ordinal(), enumForceFieldShape);
        }
    }
}

