/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Planet;
import cr0s.warpdrive.data.VectorI;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class GlobalPosition {
    public final int dimensionId;
    public final int x;
    public final int y;
    public final int z;

    public GlobalPosition(int dimensionId, int x, int y, int z) {
        this.dimensionId = dimensionId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public GlobalPosition(TileEntity tileEntity) {
        this(tileEntity.func_145831_w().field_73011_w.field_76574_g, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public WorldServer getWorldServerIfLoaded() {
        boolean isLoaded;
        WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
        if (world == null) {
            return null;
        }
        if (world.func_72863_F() instanceof ChunkProviderServer) {
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)world.func_72863_F();
            try {
                isLoaded = chunkProviderServer.field_73244_f.func_76161_b(ChunkCoordIntPair.func_77272_a((int)(this.x >> 4), (int)(this.z >> 4)));
            }
            catch (NoSuchFieldError exception) {
                isLoaded = chunkProviderServer.func_73149_a(this.x >> 4, this.z >> 4);
            }
        } else {
            isLoaded = world.func_72863_F().func_73149_a(this.x >> 4, this.z >> 4);
        }
        if (!isLoaded) {
            return null;
        }
        return world;
    }

    public boolean isLoaded() {
        return this.getWorldServerIfLoaded() != null;
    }

    public VectorI getSpaceCoordinates() {
        if (this.dimensionId == WarpDriveConfig.G_SPACE_DIMENSION_ID) {
            return new VectorI(this.x, this.y + 256, this.z);
        }
        if (this.dimensionId == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID) {
            return new VectorI(this.x, this.y + 512, this.z);
        }
        for (Planet planet : WarpDriveConfig.PLANETS) {
            if (planet.dimensionId != this.dimensionId || Math.abs(this.x - planet.dimensionCenterX) > planet.borderSizeX || Math.abs(this.z - planet.dimensionCenterZ) > planet.borderSizeZ) continue;
            return new VectorI(this.x - planet.dimensionCenterX + planet.spaceCenterX, this.y, this.z - planet.dimensionCenterZ + planet.spaceCenterZ);
        }
        return null;
    }

    public boolean equals(TileEntity tileEntity) {
        return this.dimensionId == tileEntity.func_145831_w().field_73011_w.field_76574_g && this.x == tileEntity.field_145851_c && this.y == tileEntity.field_145848_d && this.z == tileEntity.field_145849_e;
    }

    public int hashCode() {
        return this.dimensionId << 24 + (this.x >> 10) << 12 + this.y << 10 + (this.z >> 10);
    }
}

