/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.data.Jumpgate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JumpgatesRegistry {
    private File file;
    private ArrayList<Jumpgate> gates = new ArrayList();

    public JumpgatesRegistry() {
        this.file = new File("gates.txt");
        WarpDrive.logger.info("Opening gates file '" + this.file + "'");
        if (this.file != null && !this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.loadGates();
        }
        catch (IOException exception) {
            Logger.getLogger(JumpgatesRegistry.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void saveGates() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(this.file));
        for (Jumpgate jg : this.gates) {
            out.println(jg);
        }
        out.close();
    }

    public void loadGates() throws IOException {
        String s1;
        WarpDrive.logger.info("Loading jump gates from gates.txt...");
        BufferedReader bufferedreader = new BufferedReader(new FileReader(this.file));
        while ((s1 = bufferedreader.readLine()) != null) {
            this.gates.add(new Jumpgate(s1));
        }
        bufferedreader.close();
        WarpDrive.logger.info("Loaded " + this.gates.size() + " jump gates.");
    }

    public void addGate(Jumpgate jg) {
        this.gates.add(jg);
    }

    public boolean addGate(String name, int x, int y, int z) {
        if (this.findGateByName(name) != null) {
            return false;
        }
        this.addGate(new Jumpgate(name, x, y, z));
        try {
            this.saveGates();
        }
        catch (IOException ex) {
            Logger.getLogger(JumpgatesRegistry.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public void removeGate(String name) {
        for (int i = 0; i < this.gates.size(); ++i) {
            Jumpgate jg = this.gates.get(i);
            if (!jg.name.equalsIgnoreCase(name)) continue;
            this.gates.remove(i);
            return;
        }
        try {
            this.saveGates();
        }
        catch (IOException ex) {
            Logger.getLogger(JumpgatesRegistry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Jumpgate findGateByName(String name) {
        for (Jumpgate jg : this.gates) {
            if (!jg.name.equalsIgnoreCase(name)) continue;
            return jg;
        }
        return null;
    }

    public String JumpgatesList() {
        String result = "";
        for (Jumpgate jg : this.gates) {
            result = result + jg.toNiceString() + "\n";
        }
        return result;
    }

    public String commaList() {
        String result = "";
        if (this.gates.isEmpty()) {
            result = result + "<none> (check /generate to create one)";
        } else {
            for (Jumpgate jg : this.gates) {
                result = result + jg.toNiceString() + ",";
            }
        }
        return result;
    }

    public Jumpgate findNearestGate(int x, int y, int z) {
        double minDistance2 = -1.0;
        Jumpgate res = null;
        for (Jumpgate jg : this.gates) {
            double dX = jg.xCoord - x;
            double dY = jg.yCoord - y;
            double dZ = jg.zCoord - z;
            double distance2 = dX * dX + dY * dY + dZ * dZ;
            if (minDistance2 != -1.0 && !(distance2 < minDistance2)) continue;
            minDistance2 = distance2;
            res = jg;
        }
        return res;
    }
}

