/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Vector3
implements Cloneable {
    public double x;
    public double y;
    public double z;

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(Entity par1) {
        this.x = par1.field_70165_t;
        this.y = par1.field_70163_u;
        this.z = par1.field_70161_v;
    }

    public Vector3(TileEntity par1) {
        this.x = par1.field_145851_c;
        this.y = par1.field_145848_d;
        this.z = par1.field_145849_e;
    }

    public Vector3(Vec3 par1) {
        this.x = par1.field_72450_a;
        this.y = par1.field_72448_b;
        this.z = par1.field_72449_c;
    }

    public Vector3(MovingObjectPosition par1) {
        this.x = par1.field_72311_b;
        this.y = par1.field_72312_c;
        this.z = par1.field_72309_d;
    }

    public Vector3(ChunkCoordinates par1) {
        this.x = par1.field_71574_a;
        this.y = par1.field_71572_b;
        this.z = par1.field_71573_c;
    }

    public Vector3(ForgeDirection direction) {
        this.x = direction.offsetX;
        this.y = direction.offsetY;
        this.z = direction.offsetZ;
    }

    public Vector3(NBTTagCompound nbt) {
        this.x = nbt.func_74769_h("x");
        this.y = nbt.func_74769_h("y");
        this.z = nbt.func_74769_h("z");
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Block getBlockID(IBlockAccess world) {
        return world.func_147439_a(this.intX(), this.intY(), this.intZ());
    }

    public int getBlockMetadata(IBlockAccess world) {
        return world.func_72805_g(this.intX(), this.intY(), this.intZ());
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_147438_o(this.intX(), this.intY(), this.intZ());
    }

    public boolean setBlock(World world, Block id, int metadata, int notify) {
        return world.func_147465_d(this.intX(), this.intY(), this.intZ(), id, metadata, notify);
    }

    public boolean setBlock(World world, Block id, int metadata) {
        return this.setBlock(world, id, metadata, 3);
    }

    public boolean setBlock(World world, Block id) {
        return this.setBlock(world, id, 0);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        double d = this.getMagnitude();
        if (d != 0.0) {
            this.scale(1.0 / d);
        }
        return this;
    }

    public static double distance(Vector3 par1, Vector3 par2) {
        double var2 = par1.x - par2.x;
        double var4 = par1.y - par2.y;
        double var6 = par1.z - par2.z;
        return Math.sqrt(var2 * var2 + var4 * var4 + var6 * var6);
    }

    public double distanceTo(Vector3 vector3) {
        double var2 = vector3.x - this.x;
        double var4 = vector3.y - this.y;
        double var6 = vector3.z - this.z;
        return Math.sqrt(var2 * var2 + var4 * var4 + var6 * var6);
    }

    public double distanceTo_square(Vector3 vector3) {
        double var2 = vector3.x - this.x;
        double var4 = vector3.y - this.y;
        double var6 = vector3.z - this.z;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public double distanceTo_square(Entity entity) {
        double var2 = entity.field_70165_t - this.x;
        double var4 = entity.field_70163_u - this.y;
        double var6 = entity.field_70161_v - this.z;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public Vector3 invert() {
        this.scale(-1.0);
        return this;
    }

    public Vector3 translate(Vector3 par1) {
        this.x += par1.x;
        this.y += par1.y;
        this.z += par1.z;
        return this;
    }

    public Vector3 translate(double par1) {
        this.x += par1;
        this.y += par1;
        this.z += par1;
        return this;
    }

    public Vector3 translate(ForgeDirection side, double amount) {
        switch (side) {
            case DOWN: {
                this.y -= amount;
                break;
            }
            case UP: {
                this.y += amount;
                break;
            }
            case NORTH: {
                this.z -= amount;
                break;
            }
            case SOUTH: {
                this.z += amount;
                break;
            }
            case WEST: {
                this.x -= amount;
                break;
            }
            case EAST: {
                this.x += amount;
                break;
            }
        }
        return this;
    }

    public Vector3 translate(ForgeDirection side) {
        this.x += (double)side.offsetX;
        this.y += (double)side.offsetY;
        this.z += (double)side.offsetZ;
        return this;
    }

    public static Vector3 translate(Vector3 translate, Vector3 par1) {
        translate.x += par1.x;
        translate.y += par1.y;
        translate.z += par1.z;
        return translate;
    }

    public Vector3 translateFactor(Vector3 direction, double factor) {
        this.x += direction.x * factor;
        this.y += direction.y * factor;
        this.z += direction.z * factor;
        return this;
    }

    public Vector3 subtract(Vector3 amount) {
        return this.translate(amount.clone().invert());
    }

    public Vector3 subtract(double amount) {
        return this.translate(-amount);
    }

    public Vector3 scale(double amount) {
        this.x *= amount;
        this.y *= amount;
        this.z *= amount;
        return this;
    }

    public Vector3 scale(Vector3 amount) {
        this.x *= amount.x;
        this.y *= amount.y;
        this.z *= amount.z;
        return this;
    }

    public static Vector3 scale(Vector3 vec, double amount) {
        return vec.scale(amount);
    }

    public static Vector3 scale(Vector3 vec, Vector3 amount) {
        return vec.scale(amount);
    }

    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3 ceil() {
        return new Vector3(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector3 toRound() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        return this;
    }

    public Vector3 toCeil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        return this;
    }

    public Vector3 toFloor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }

    public List<Entity> getEntitiesWithin(World worldObj, Class<? extends Entity> par1Class) {
        return worldObj.func_72872_a(par1Class, AxisAlignedBB.func_72330_a((double)this.intX(), (double)this.intY(), (double)this.intZ(), (double)(this.intX() + 1), (double)(this.intY() + 1), (double)(this.intZ() + 1)));
    }

    public Vector3 modifyPositionFromSide(ForgeDirection side, double amount) {
        switch (side.ordinal()) {
            case 0: {
                this.y -= amount;
                break;
            }
            case 1: {
                this.y += amount;
                break;
            }
            case 2: {
                this.z -= amount;
                break;
            }
            case 3: {
                this.z += amount;
                break;
            }
            case 4: {
                this.x -= amount;
                break;
            }
            case 5: {
                this.x += amount;
                break;
            }
        }
        return this;
    }

    public Vector3 modifyPositionFromSide(ForgeDirection side) {
        this.modifyPositionFromSide(side, 1.0);
        return this;
    }

    public Vector3 crossProduct(Vector3 vec2) {
        return new Vector3(this.y * vec2.z - this.z * vec2.y, this.z * vec2.x - this.x * vec2.z, this.x * vec2.y - this.y * vec2.x);
    }

    public Vector3 xCrossProduct() {
        return new Vector3(0.0, this.z, -this.y);
    }

    public Vector3 zCrossProduct() {
        return new Vector3(-this.y, this.x, 0.0);
    }

    public double dotProduct(Vector3 vec2) {
        return this.x * vec2.x + this.y * vec2.y + this.z * vec2.z;
    }

    public Vector3 getPerpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Vector3 rotate(float angle, Vector3 axis) {
        return Vector3.translateMatrix(Vector3.getRotationMatrix(angle, axis), this.clone());
    }

    public double[] getRotationMatrix(float angle_deg) {
        double[] matrix = new double[16];
        Vector3 axis = this.clone().normalize();
        double xn = axis.x;
        double yn = axis.y;
        double zn = axis.z;
        float angle_rad = angle_deg * ((float)Math.PI / 180);
        float cos = (float)Math.cos(angle_rad);
        float oCos = 1.0f - cos;
        float sin = (float)Math.sin(angle_rad);
        matrix[0] = xn * xn * (double)oCos + (double)cos;
        matrix[1] = yn * xn * (double)oCos + zn * (double)sin;
        matrix[2] = xn * zn * (double)oCos - yn * (double)sin;
        matrix[4] = xn * yn * (double)oCos - zn * (double)sin;
        matrix[5] = yn * yn * (double)oCos + (double)cos;
        matrix[6] = yn * zn * (double)oCos + xn * (double)sin;
        matrix[8] = xn * zn * (double)oCos + yn * (double)sin;
        matrix[9] = yn * zn * (double)oCos - xn * (double)sin;
        matrix[10] = zn * zn * (double)oCos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public static Vector3 translateMatrix(double[] matrix, Vector3 translation) {
        double x = translation.x * matrix[0] + translation.y * matrix[1] + translation.z * matrix[2] + matrix[3];
        double y = translation.x * matrix[4] + translation.y * matrix[5] + translation.z * matrix[6] + matrix[7];
        double z = translation.x * matrix[8] + translation.y * matrix[9] + translation.z * matrix[10] + matrix[11];
        translation.x = x;
        translation.y = y;
        translation.z = z;
        return translation;
    }

    public static double[] getRotationMatrix(float angle, Vector3 axis) {
        return axis.getRotationMatrix(angle);
    }

    public void rotate(double yaw, double pitch, double roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double oldX = this.x;
        double oldY = this.y;
        double oldZ = this.z;
        this.x = oldX * Math.cos(yawRadians) * Math.cos(pitchRadians) + oldZ * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + oldY * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        this.z = oldX * Math.sin(yawRadians) * Math.cos(pitchRadians) + oldZ * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + oldY * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        this.y = -oldX * Math.sin(pitchRadians) + oldZ * Math.cos(pitchRadians) * Math.sin(rollRadians) + oldY * Math.cos(pitchRadians) * Math.cos(rollRadians);
    }

    public void rotate(double yaw, double pitch) {
        this.rotate(yaw, pitch, 0.0);
    }

    public void rotate(double yaw) {
        double yawRadians = Math.toRadians(yaw);
        double oldX = this.x;
        double oldZ = this.z;
        if (yaw != 0.0) {
            this.x = oldX * Math.cos(yawRadians) - oldZ * Math.sin(yawRadians);
            this.z = oldX * Math.sin(yawRadians) + oldZ * Math.cos(yawRadians);
        }
    }

    public static Vector3 getDeltaPositionFromRotation(float rotationYaw1, float rotationPitch1) {
        float rotationYaw2 = rotationYaw1 + 90.0f;
        float rotationPitch2 = -rotationPitch1;
        return new Vector3(Math.cos(Math.toRadians(rotationYaw2)), Math.sin(Math.toRadians(rotationPitch2)), Math.sin(Math.toRadians(rotationYaw2)));
    }

    public double getAngle(Vector3 vec2) {
        return Vector3.anglePreNorm(this.clone().normalize(), vec2.clone().normalize());
    }

    public static double getAngle(Vector3 vec1, Vector3 vec2) {
        return vec1.getAngle(vec2);
    }

    public double anglePreNorm(Vector3 vec2) {
        return Math.acos(this.dotProduct(vec2));
    }

    public static double anglePreNorm(Vector3 vec1, Vector3 vec2) {
        return Math.acos(vec1.clone().dotProduct(vec2));
    }

    @Deprecated
    public static Vector3 readFromNBT(NBTTagCompound nbt) {
        return new Vector3(nbt);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        nbt.func_74780_a("z", this.z);
        return nbt;
    }

    public static Vector3 UP() {
        return new Vector3(0.0, 1.0, 0.0);
    }

    public static Vector3 DOWN() {
        return new Vector3(0.0, -1.0, 0.0);
    }

    public static Vector3 NORTH() {
        return new Vector3(0.0, 0.0, -1.0);
    }

    public static Vector3 SOUTH() {
        return new Vector3(0.0, 0.0, 1.0);
    }

    public static Vector3 WEST() {
        return new Vector3(-1.0, 0.0, 0.0);
    }

    public static Vector3 EAST() {
        return new Vector3(1.0, 0.0, 0.0);
    }

    public MovingObjectPosition rayTrace(World world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        MovingObjectPosition pickedBlock = this.rayTraceBlocks(world, rotationYaw, rotationPitch, reachDistance);
        MovingObjectPosition pickedEntity = this.rayTraceEntities(world, rotationYaw, rotationPitch, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        double dBlock = this.distanceTo(new Vector3(pickedBlock.field_72307_f));
        double dEntity = this.distanceTo(new Vector3(pickedEntity.field_72307_f));
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public MovingObjectPosition rayTraceBlocks(World world, float rotationYaw, float rotationPitch, double reachDistance) {
        Vector3 lookVector = Vector3.getDeltaPositionFromRotation(rotationYaw, rotationPitch);
        Vector3 reachPoint = this.clone().translateFactor(lookVector, reachDistance);
        return world.func_72933_a(this.toVec3(), reachPoint.toVec3());
    }

    public MovingObjectPosition rayTraceEntities(World world, float rotationYaw, float rotationPitch, double reachDistance) {
        MovingObjectPosition pickedEntity = null;
        Vec3 startingPosition = this.toVec3();
        Vec3 look = Vector3.getDeltaPositionFromRotation(rotationYaw, rotationPitch).toVec3();
        Vec3 reachPoint = Vec3.func_72443_a((double)(startingPosition.field_72450_a + look.field_72450_a * reachDistance), (double)(startingPosition.field_72448_b + look.field_72448_b * reachDistance), (double)(startingPosition.field_72449_c + look.field_72449_c * reachDistance));
        double playerBorder = 1.1 * reachDistance;
        AxisAlignedBB boxToScan = AxisAlignedBB.func_72330_a((double)(-playerBorder), (double)(-playerBorder), (double)(-playerBorder), (double)playerBorder, (double)playerBorder, (double)playerBorder);
        List entitiesHit = world.func_72839_b(null, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            float border;
            AxisAlignedBB aabb;
            MovingObjectPosition hitMOP;
            if (entityHit == null || !entityHit.func_70067_L() || entityHit.field_70121_D == null || (hitMOP = (aabb = entityHit.field_70121_D.func_72314_b((double)(border = entityHit.func_70111_Y()), (double)border, (double)border)).func_72327_a(startingPosition, reachPoint)) == null) continue;
            if (aabb.func_72318_a(startingPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0) continue;
                pickedEntity = new MovingObjectPosition(entityHit);
                pickedEntity.field_72307_f = hitMOP.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = startingPosition.func_72438_d(hitMOP.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new MovingObjectPosition(entityHit);
            pickedEntity.field_72307_f = hitMOP.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public int hashCode() {
        return ("X:" + this.x + "Y:" + this.y + "Z:" + this.z).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3) {
            Vector3 vector3 = (Vector3)o;
            return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
        }
        return false;
    }

    public String toString() {
        return String.format("Vector3 [%.3f %.3f %.3f]", this.x, this.y, this.z);
    }
}

