/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbstractSequencer {
    private static AtomicBoolean isUpdating = new AtomicBoolean(false);
    private static ConcurrentHashMap<AbstractSequencer, Boolean> sequencers = new ConcurrentHashMap(10);

    public static void updateTick() {
        if (sequencers.isEmpty()) {
            return;
        }
        while (!isUpdating.compareAndSet(false, true)) {
            Thread.yield();
        }
        Iterator<Map.Entry<AbstractSequencer, Boolean>> iterator = sequencers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AbstractSequencer, Boolean> entry = iterator.next();
            boolean doContinue = entry.getKey().onUpdate();
            if (doContinue) continue;
            iterator.remove();
        }
        isUpdating.set(false);
    }

    protected void register() {
        while (!isUpdating.compareAndSet(false, true)) {
            Thread.yield();
        }
        sequencers.put(this, true);
        isUpdating.set(false);
    }

    protected void unregister() {
        sequencers.put(this, false);
    }

    public abstract boolean onUpdate();

    protected abstract void readFromNBT(NBTTagCompound var1);

    protected abstract void writeToNBT(NBTTagCompound var1);
}

