/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CloakedArea;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;

public class MessageCloak
implements IMessage,
IMessageHandler<MessageCloak, IMessage> {
    private int coreX;
    private int coreY;
    private int coreZ;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private byte tier;
    private boolean decloak;

    public MessageCloak() {
    }

    public MessageCloak(CloakedArea area, boolean decloak) {
        this.coreX = area.coreX;
        this.coreY = area.coreY;
        this.coreZ = area.coreZ;
        this.minX = area.minX;
        this.minY = area.minY;
        this.minZ = area.minZ;
        this.maxX = area.maxX;
        this.maxY = area.maxY;
        this.maxZ = area.maxZ;
        this.tier = area.tier;
        this.decloak = decloak;
    }

    public void fromBytes(ByteBuf buffer) {
        this.coreX = buffer.readInt();
        this.coreY = buffer.readInt();
        this.coreZ = buffer.readInt();
        this.minX = buffer.readInt();
        this.minY = buffer.readInt();
        this.minZ = buffer.readInt();
        this.maxX = buffer.readInt();
        this.maxY = buffer.readInt();
        this.maxZ = buffer.readInt();
        this.decloak = buffer.readBoolean();
        this.tier = buffer.readByte();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.coreX);
        buffer.writeInt(this.coreY);
        buffer.writeInt(this.coreZ);
        buffer.writeInt(this.minX);
        buffer.writeInt(this.minY);
        buffer.writeInt(this.minZ);
        buffer.writeInt(this.maxX);
        buffer.writeInt(this.maxY);
        buffer.writeInt(this.maxZ);
        buffer.writeBoolean(this.decloak);
        buffer.writeByte((int)this.tier);
    }

    @SideOnly(value=Side.CLIENT)
    private void handle(EntityClientPlayerMP player) {
        if (this.decloak) {
            WarpDrive.cloaks.removeCloakedArea(player.field_70170_p.field_73011_w.field_76574_g, this.coreX, this.coreY, this.coreZ);
        } else {
            WarpDrive.cloaks.updateCloakedArea(player.field_70170_p, player.field_70170_p.field_73011_w.field_76574_g, this.coreX, this.coreY, this.coreZ, this.tier, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageCloak cloakMessage, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring cloak packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info("Received cloak packet: " + (cloakMessage.decloak ? "DEcloaked" : "cloaked") + "area: (" + cloakMessage.minX + " " + cloakMessage.minY + " " + cloakMessage.minZ + ") -> (" + cloakMessage.maxX + " " + cloakMessage.maxY + " " + cloakMessage.maxZ + ") tier " + cloakMessage.tier);
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if ((double)cloakMessage.minX <= player.field_70165_t && (double)(cloakMessage.maxX + 1) > player.field_70165_t && (double)cloakMessage.minY <= player.field_70163_u && (double)(cloakMessage.maxY + 1) > player.field_70163_u && (double)cloakMessage.minZ <= player.field_70161_v && (double)(cloakMessage.maxZ + 1) > player.field_70161_v) {
            return null;
        }
        cloakMessage.handle(player);
        return null;
    }
}

