/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MessageTargeting
implements IMessage,
IMessageHandler<MessageTargeting, IMessage> {
    private int x;
    private int y;
    private int z;
    private float yaw;
    private float pitch;

    public MessageTargeting() {
    }

    public MessageTargeting(int x, int y, int z, float yaw, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void fromBytes(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.yaw = buffer.readFloat();
        this.pitch = buffer.readFloat();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
    }

    private void handle(World worldObj) {
        TileEntity te = worldObj.func_147438_o(this.x, this.y, this.z);
        if (te != null && te instanceof TileEntityLaser) {
            TileEntityLaser laser = (TileEntityLaser)te;
            laser.initiateBeamEmission(this.yaw, this.pitch);
        }
    }

    public IMessage onMessage(MessageTargeting targetingMessage, MessageContext context) {
        if (WarpDriveConfig.LOGGING_TARGETING) {
            WarpDrive.logger.info("Received target packet: (" + targetingMessage.x + " " + targetingMessage.y + " " + targetingMessage.z + ") yaw: " + targetingMessage.yaw + " pitch: " + targetingMessage.pitch);
        }
        targetingMessage.handle(context.getServerHandler().field_147369_b.field_70170_p);
        return null;
    }
}

