/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.building;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.Transformation;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemCrystalToken;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityShipScanner
extends TileEntityAbstractEnergy {
    private boolean isActive = false;
    private TileEntityShipCore shipCore = null;
    private int laserTicks = 0;
    private int scanTicks = 0;
    private int deployDelayTicks = 0;
    private int searchTicks = 0;
    private String schematicFileName = "";
    private String playerName = "";
    private JumpShip jumpShip;
    private int currentDeployIndex;
    private int blocksToDeployCount;
    private boolean isDeploying = false;
    private int targetX;
    private int targetY;
    private int targetZ;
    private byte rotationSteps;
    private static final int SS_SEARCH_INTERVAL_TICKS = 20;
    private int cooldownPlayerDetection = 5;
    private static final int SS_SEARCH_WARMUP_INTERVALS = 5;
    private UUID warmupPlayerId = null;
    private int warmupPlayer = 5;
    private String warmupSchematicName = "";

    public TileEntityShipScanner() {
        this.peripheralName = "warpdriveShipScanner";
        this.addMethods(new String[]{"scan", "fileName", "deploy", "state"});
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.searchTicks;
        if (this.searchTicks > WarpDriveConfig.SS_SEARCH_INTERVAL_TICKS) {
            this.searchTicks = 0;
            this.shipCore = this.searchShipCore();
        }
        if (!this.isActive) {
            this.checkPlayerToken();
        }
        if (!this.isDeploying && this.shipCore == null) {
            this.setActive(false);
            ++this.laserTicks;
            if (this.laserTicks > 20) {
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e).translate(0.5), 1.0f, 0.2f, 0.0f, 40, 0, 100);
                this.laserTicks = 0;
            }
            return;
        }
        if (!this.isActive) {
            ++this.laserTicks;
            if (this.laserTicks > 20) {
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(this.shipCore.field_145851_c, this.shipCore.field_145848_d, this.shipCore.field_145849_e).translate(0.5), 0.0f, 1.0f, 0.2f, 40, 0, 100);
                this.laserTicks = 0;
            }
        } else if (!this.isDeploying) {
            ++this.laserTicks;
            if (this.laserTicks > 5) {
                this.laserTicks = 0;
                for (int index = 0; index < 10; ++index) {
                    int randomX = this.shipCore.minX + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxX - this.shipCore.minX + 1);
                    int randomY = this.shipCore.minY + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxY - this.shipCore.minY + 1);
                    int randomZ = this.shipCore.minZ + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxZ - this.shipCore.minZ + 1);
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                    float r = this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat();
                    float g = this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat();
                    float b = this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat();
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(randomX, randomY, randomZ).translate(0.5), r, g, b, 15, 0, 100);
                }
            }
            ++this.scanTicks;
            if (this.scanTicks > 20 * (1 + this.shipCore.shipMass / WarpDriveConfig.SS_SCAN_BLOCKS_PER_SECOND)) {
                this.setActive(false);
                this.scanTicks = 0;
            }
        } else {
            ++this.deployDelayTicks;
            if (this.deployDelayTicks > WarpDriveConfig.SS_DEPLOY_INTERVAL_TICKS) {
                this.deployDelayTicks = 0;
                EntityPlayerMP entityPlayerMP = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.playerName);
                int optimumSpeed = Math.round((float)(this.blocksToDeployCount * WarpDriveConfig.SS_DEPLOY_INTERVAL_TICKS) / 200.0f);
                int blockToDeployPerTick = Math.max(WarpDriveConfig.SS_DEPLOY_BLOCKS_PER_INTERVAL, Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK / 4, optimumSpeed));
                int blocksToDeployCurrentTick = Math.min(blockToDeployPerTick, this.blocksToDeployCount - this.currentDeployIndex);
                int periodLaserEffect = Math.max(1, blocksToDeployCurrentTick / 10);
                if (WarpDrive.isDev && WarpDriveConfig.LOGGING_BUILDING) {
                    WarpDrive.logger.info("optimumSpeed " + optimumSpeed + " blockToDeployPerTick " + blockToDeployPerTick + " blocksToDeployCurrentTick " + blocksToDeployCurrentTick + " currentDeployIndex " + this.currentDeployIndex);
                }
                if (blocksToDeployCurrentTick == 0) {
                    TileEntity tileEntity = this.field_145850_b.func_147438_o(this.targetX, this.targetY, this.targetZ);
                    if (tileEntity instanceof TileEntityShipCore) {
                        ((TileEntityShipCore)tileEntity).summonOwnerOnDeploy(this.playerName);
                        if (entityPlayerMP != null) {
                            WarpDrive.addChatMessage((ICommandSender)entityPlayerMP, "\u00c2\u00a76Welcome aboard captain. Use the computer to get moving...");
                        }
                    }
                    this.isDeploying = false;
                    this.setActive(false);
                    if (WarpDriveConfig.LOGGING_BUILDING) {
                        WarpDrive.logger.info(this + " Deployment done");
                    }
                    this.cooldownPlayerDetection = 60;
                    return;
                }
                if (WarpDriveConfig.LOGGING_BUILDING) {
                    WarpDrive.logger.info(this + " Deploying " + blocksToDeployCurrentTick + " more blocks");
                }
                Transformation transformation = new Transformation(this.jumpShip, this.field_145850_b, this.targetX - this.jumpShip.coreX, this.targetY - this.jumpShip.coreY, this.targetZ - this.jumpShip.coreZ, this.rotationSteps);
                int index = 0;
                while (index < blocksToDeployCurrentTick && this.currentDeployIndex < this.blocksToDeployCount) {
                    JumpBlock jumpBlock = this.jumpShip.jumpBlocks[this.currentDeployIndex];
                    if (jumpBlock == null) {
                        if (WarpDriveConfig.LOGGING_BUILDING) {
                            WarpDrive.logger.info("At index " + this.currentDeployIndex + ", skipping undefined block");
                        }
                    } else if (jumpBlock.block == Blocks.field_150350_a) {
                        if (WarpDriveConfig.LOGGING_BUILDING) {
                            WarpDrive.logger.info("At index " + this.currentDeployIndex + ", skipping air block");
                        }
                    } else if (Dictionary.BLOCKS_ANCHOR.contains(jumpBlock.block)) {
                        if (WarpDriveConfig.LOGGING_BUILDING) {
                            WarpDrive.logger.info("At index " + this.currentDeployIndex + ", skipping anchor block " + jumpBlock.block);
                        }
                    } else {
                        ++index;
                        if (WarpDriveConfig.LOGGING_BUILDING) {
                            WarpDrive.logger.info("At index " + this.currentDeployIndex + ", deploying block " + Block.field_149771_c.func_148750_c((Object)jumpBlock.block) + ":" + jumpBlock.blockMeta + " tileEntity " + jumpBlock.blockTileEntity + " NBT " + jumpBlock.blockNBT);
                        }
                        ChunkCoordinates targetLocation = transformation.apply(jumpBlock.x, jumpBlock.y, jumpBlock.z);
                        Block blockAtTarget = this.field_145850_b.func_147439_a(targetLocation.field_71574_a, targetLocation.field_71572_b, targetLocation.field_71573_c);
                        if (blockAtTarget == Blocks.field_150350_a || Dictionary.BLOCKS_EXPANDABLE.contains(blockAtTarget)) {
                            jumpBlock.deploy(this.field_145850_b, transformation);
                            if (index % periodLaserEffect == 0) {
                                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 0.5f, 1.0f);
                                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(targetLocation.field_71574_a, targetLocation.field_71572_b, targetLocation.field_71573_c).translate(0.5), 0.0f, 1.0f, 0.0f, 15, 0, 100);
                            }
                            this.field_145850_b.func_72908_a((double)((float)targetLocation.field_71574_a + 0.5f), (double)((float)targetLocation.field_71572_b + 0.5f), (double)((float)targetLocation.field_71573_c + 0.5f), jumpBlock.block.field_149762_H.func_150496_b(), (jumpBlock.block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, jumpBlock.block.field_149762_H.func_150494_d() * 0.8f);
                        } else {
                            if (WarpDriveConfig.LOGGING_BUILDING) {
                                WarpDrive.logger.info("Target position is occupied, skipping");
                            }
                            this.field_145850_b.func_72885_a(null, (double)(this.targetX + jumpBlock.x), (double)(this.targetY + jumpBlock.y), (double)(this.targetZ + jumpBlock.z), 3.0f, false, false);
                            WarpDrive.logger.info("Deployment collision detected at " + (this.targetX + jumpBlock.x) + " " + (this.targetY + jumpBlock.y) + " " + (this.targetZ + jumpBlock.z));
                        }
                    }
                    ++this.currentDeployIndex;
                    if (this.currentDeployIndex < this.blocksToDeployCount || entityPlayerMP == null) continue;
                    WarpDrive.addChatMessage((ICommandSender)entityPlayerMP, "Ship complete. Teleporting captain to the main deck");
                }
            }
        }
    }

    private void setActive(boolean newState) {
        this.isActive = newState;
        if (this.func_145832_p() == 1 == newState) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isActive ? 1 : 0, 2);
        }
    }

    private TileEntityShipCore searchShipCore() {
        StringBuilder reason = new StringBuilder();
        TileEntityShipCore result = null;
        for (int newY = this.field_145848_d + 1; newY <= 255; ++newY) {
            if (!this.field_145850_b.func_147439_a(this.field_145851_c, newY, this.field_145849_e).func_149667_c(WarpDrive.blockShipCore)) continue;
            result = (TileEntityShipCore)this.field_145850_b.func_147438_o(this.field_145851_c, newY, this.field_145849_e);
            if (result == null || result.validateShipSpatialParameters(reason)) break;
            result = null;
            break;
        }
        return result;
    }

    private int getScanningEnergyCost(int size) {
        if (WarpDriveConfig.SS_ENERGY_PER_BLOCK_SCAN >= 0) {
            return size * WarpDriveConfig.SS_ENERGY_PER_BLOCK_SCAN;
        }
        return WarpDriveConfig.SS_MAX_ENERGY_STORED;
    }

    private int getDeploymentEnergyCost(int size) {
        if (WarpDriveConfig.SS_ENERGY_PER_BLOCK_DEPLOY >= 0) {
            return size * WarpDriveConfig.SS_ENERGY_PER_BLOCK_DEPLOY;
        }
        return WarpDriveConfig.SS_MAX_ENERGY_STORED;
    }

    private boolean saveShipToSchematic(String fileName, StringBuilder reason) {
        if (!this.shipCore.validateShipSpatialParameters(reason)) {
            return false;
        }
        int width = this.shipCore.maxX - this.shipCore.minX + 1;
        int length = this.shipCore.maxZ - this.shipCore.minZ + 1;
        int height = this.shipCore.maxY - this.shipCore.minY + 1;
        int size = width * length * height;
        if (width <= 0 || length <= 0 || height <= 0) {
            reason.append("Invalid ship dimensions, nothing to scan");
            return false;
        }
        int energyCost = this.getScanningEnergyCost(this.shipCore.shipMass);
        if (!this.energy_consume(energyCost, false)) {
            reason.append(String.format("Insufficient energy (%d required)", energyCost));
            return false;
        }
        NBTTagCompound schematic = new NBTTagCompound();
        schematic.func_74777_a("Width", (short)width);
        schematic.func_74777_a("Length", (short)length);
        schematic.func_74777_a("Height", (short)height);
        schematic.func_74768_a("shipMass", this.shipCore.shipMass);
        schematic.func_74778_a("shipName", this.shipCore.shipName);
        schematic.func_74768_a("shipVolume", this.shipCore.shipVolume);
        JumpShip ship = new JumpShip();
        ship.worldObj = this.shipCore.func_145831_w();
        ship.coreX = this.shipCore.field_145851_c;
        ship.coreY = this.shipCore.field_145848_d;
        ship.coreZ = this.shipCore.field_145849_e;
        ship.dx = this.shipCore.dx;
        ship.dz = this.shipCore.dz;
        ship.minX = this.shipCore.minX;
        ship.maxX = this.shipCore.maxX;
        ship.minY = this.shipCore.minY;
        ship.maxY = this.shipCore.maxY;
        ship.minZ = this.shipCore.minZ;
        ship.maxZ = this.shipCore.maxZ;
        ship.shipCore = this.shipCore;
        if (!ship.save(reason)) {
            return false;
        }
        NBTTagCompound tagCompoundShip = new NBTTagCompound();
        ship.writeToNBT(tagCompoundShip);
        schematic.func_74782_a("ship", (NBTBase)tagCompoundShip);
        String[] stringBlockRegistryNames = new String[size];
        byte[] byteMetadatas = new byte[size];
        NBTTagList tileEntitiesList = new NBTTagList();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    TileEntity tileEntity;
                    Block block = this.field_145850_b.func_147439_a(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z);
                    if (Dictionary.BLOCKS_LEFTBEHIND.contains(block) || Dictionary.BLOCKS_ANCHOR.contains(block)) {
                        block = Blocks.field_150350_a;
                    }
                    int index = x + (y * length + z) * width;
                    stringBlockRegistryNames[index] = Block.field_149771_c.func_148750_c((Object)block);
                    byteMetadatas[index] = (byte)this.field_145850_b.func_72805_g(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z);
                    if (block.func_149667_c(Blocks.field_150350_a) || (tileEntity = this.field_145850_b.func_147438_o(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z)) == null) continue;
                    try {
                        NBTTagCompound tagTileEntity = new NBTTagCompound();
                        tileEntity.func_145841_b(tagTileEntity);
                        if (tagTileEntity.func_74764_b("computerID")) {
                            tagTileEntity.func_82580_o("computerID");
                        }
                        if (tagTileEntity.func_74764_b("oc:computer")) {
                            NBTTagCompound tagComputer = tagTileEntity.func_74775_l("oc:computer");
                            tagComputer.func_82580_o("components");
                            tagComputer.func_82580_o("node");
                            tagTileEntity.func_74782_a("oc:computer", (NBTBase)tagComputer);
                        }
                        tagTileEntity.func_74768_a("x", tileEntity.field_145851_c - this.shipCore.minX);
                        tagTileEntity.func_74768_a("y", tileEntity.field_145848_d - this.shipCore.minY);
                        tagTileEntity.func_74768_a("z", tileEntity.field_145849_e - this.shipCore.minZ);
                        tileEntitiesList.func_74742_a((NBTBase)tagTileEntity);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        schematic.func_74778_a("Materials", "Alpha");
        NBTTagList tagListBlocks = new NBTTagList();
        for (String stringRegistryName : stringBlockRegistryNames) {
            tagListBlocks.func_74742_a((NBTBase)new NBTTagString(stringRegistryName));
        }
        schematic.func_74782_a("Blocks", (NBTBase)tagListBlocks);
        schematic.func_74773_a("Data", byteMetadatas);
        schematic.func_74782_a("Entities", (NBTBase)new NBTTagList());
        schematic.func_74782_a("TileEntities", (NBTBase)tileEntitiesList);
        this.writeNBTToFile(fileName, schematic);
        return true;
    }

    private void writeNBTToFile(String fileName, NBTTagCompound nbttagcompound) {
        WarpDrive.logger.info(this + " writeNBTToFile " + fileName);
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)fileoutputstream);
            fileoutputstream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean scanShip(StringBuilder reason) {
        this.setActive(true);
        File file = new File(WarpDriveConfig.G_SCHEMALOCATION);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            return false;
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'ss's'SSS");
        String shipName = this.shipCore.shipName.replaceAll("[^ -~]", "").replaceAll("[:/\\\\]", "");
        do {
            Date now = new Date();
            this.schematicFileName = shipName + "_" + sdfDate.format(now);
        } while (new File(WarpDriveConfig.G_SCHEMALOCATION + "/" + this.schematicFileName + ".schematic").exists());
        if (!this.saveShipToSchematic(WarpDriveConfig.G_SCHEMALOCATION + "/" + this.schematicFileName + ".schematic", reason)) {
            return false;
        }
        reason.append(this.schematicFileName);
        return true;
    }

    private static NBTTagCompound readNBTFromFile(String fileName) {
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileinputstream = new FileInputStream(file);
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
            fileinputstream.close();
            return nbttagcompound;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private int deployShip(String fileName, int offsetX, int offsetY, int offsetZ, byte rotationSteps, boolean isForced, StringBuilder reason) {
        double dZ;
        double dY;
        double dX;
        double distance;
        NBTTagCompound schematic = TileEntityShipScanner.readNBTFromFile(WarpDriveConfig.G_SCHEMALOCATION + "/" + fileName + ".schematic");
        if (schematic == null) {
            reason.append(String.format("Schematic not found or unknown error reading it: '%s'.", fileName));
            return -1;
        }
        this.jumpShip = new JumpShip();
        this.targetX = this.field_145851_c + offsetX;
        this.targetY = this.field_145848_d + offsetY;
        this.targetZ = this.field_145849_e + offsetZ;
        this.rotationSteps = rotationSteps;
        if (schematic.func_74764_b("ship")) {
            this.jumpShip.readFromNBT(schematic.func_74775_l("ship"));
            this.blocksToDeployCount = this.jumpShip.jumpBlocks.length;
            if (WarpDriveConfig.LOGGING_BUILDING) {
                WarpDrive.logger.info(String.format("[ShipScanner] Loaded %d blocks to deploy", this.blocksToDeployCount));
            }
        } else {
            int width = schematic.func_74765_d("Width");
            int height = schematic.func_74765_d("Height");
            int length = schematic.func_74765_d("Length");
            this.jumpShip.minX = 0;
            this.jumpShip.maxX = width - 1;
            this.jumpShip.minY = 0;
            this.jumpShip.maxY = height - 1;
            this.jumpShip.minZ = 0;
            this.jumpShip.maxZ = length - 1;
            this.jumpShip.coreX = 0;
            this.jumpShip.coreY = 0;
            this.jumpShip.coreZ = 0;
            this.blocksToDeployCount = width * height * length;
            this.jumpShip.jumpBlocks = new JumpBlock[this.blocksToDeployCount];
            NBTTagList localBlocks = (NBTTagList)schematic.func_74781_a("Blocks");
            byte[] localMetadata = schematic.func_74770_j("Data");
            NBTTagCompound[] tileEntities = new NBTTagCompound[this.blocksToDeployCount];
            NBTTagList tagListTileEntities = schematic.func_150295_c("TileEntities", 10);
            for (int i = 0; i < tagListTileEntities.func_74745_c(); ++i) {
                NBTTagCompound tagTileEntity = tagListTileEntities.func_150305_b(i);
                int teX = tagTileEntity.func_74762_e("x");
                int teY = tagTileEntity.func_74762_e("y");
                int teZ = tagTileEntity.func_74762_e("z");
                tileEntities[teX + (teY * length + teZ) * width] = tagTileEntity;
            }
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < length; ++z) {
                        int index = x + (y * length + z) * width;
                        JumpBlock jumpBlock = new JumpBlock();
                        jumpBlock.x = x;
                        jumpBlock.y = y;
                        jumpBlock.z = z;
                        jumpBlock.block = Block.func_149684_b((String)localBlocks.func_150307_f(index));
                        jumpBlock.blockMeta = localMetadata[index] & 0xFF;
                        jumpBlock.blockNBT = tileEntities[index];
                        if (jumpBlock.block != null) {
                            if (WarpDriveConfig.LOGGING_BUILDING) {
                                if (tileEntities[index] == null) {
                                    WarpDrive.logger.info("[ShipScanner] Adding block to deploy: " + jumpBlock.block.func_149739_a() + ":" + jumpBlock.blockMeta + " (no tile entity)");
                                } else {
                                    WarpDrive.logger.info("[ShipScanner] Adding block to deploy: " + jumpBlock.block.func_149739_a() + ":" + jumpBlock.blockMeta + " with tile entity " + tileEntities[index].func_74779_i("id"));
                                }
                            }
                        } else {
                            jumpBlock = null;
                        }
                        this.jumpShip.jumpBlocks[index] = jumpBlock;
                    }
                }
            }
        }
        if ((distance = (double)MathHelper.func_76133_a((double)((dX = (double)(this.field_145851_c - this.targetX)) * dX + (dY = (double)(this.field_145848_d - this.targetY)) * dY + (dZ = (double)(this.field_145849_e - this.targetZ)) * dZ))) > (double)WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS) {
            reason.append(String.format("Cannot deploy ship more than %d blocks away from scanner.", WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS));
            return 5;
        }
        int energyCost = this.getDeploymentEnergyCost(this.blocksToDeployCount);
        if (!this.energy_consume(energyCost, false)) {
            reason.append(String.format("Insufficient energy (%d required)", energyCost));
            return 1;
        }
        Transformation transformation = new Transformation(this.jumpShip, this.field_145850_b, this.targetX - this.jumpShip.coreX, this.targetY - this.jumpShip.coreY, this.targetZ - this.jumpShip.coreZ, rotationSteps);
        ChunkCoordinates targetLocation1 = transformation.apply(this.jumpShip.minX, this.jumpShip.minY, this.jumpShip.minZ);
        ChunkCoordinates targetLocation2 = transformation.apply(this.jumpShip.maxX, this.jumpShip.maxY, this.jumpShip.maxZ);
        ChunkCoordinates targetLocationMin = new ChunkCoordinates(Math.min(targetLocation1.field_71574_a, targetLocation2.field_71574_a) - 1, Math.max(0, Math.min(targetLocation1.field_71572_b, targetLocation2.field_71572_b) - 1), Math.min(targetLocation1.field_71573_c, targetLocation2.field_71573_c) - 1);
        ChunkCoordinates targetLocationMax = new ChunkCoordinates(Math.max(targetLocation1.field_71574_a, targetLocation2.field_71574_a) + 1, Math.min(255, Math.max(targetLocation1.field_71572_b, targetLocation2.field_71572_b) + 1), Math.max(targetLocation1.field_71573_c, targetLocation2.field_71573_c) + 1);
        if (isForced) {
            if (!this.field_145850_b.func_147437_c(this.targetX, this.targetY, this.targetZ)) {
                this.field_145850_b.func_72885_a(null, (double)this.targetX, (double)this.targetY, (double)this.targetZ, 1.0f, false, false);
                if (WarpDriveConfig.LOGGING_BUILDING) {
                    WarpDrive.logger.info("Deployment collision detected at " + this.targetX + " " + this.targetY + " " + this.targetZ);
                }
                reason.append(String.format("Deployment area occupied with existing ship. Can't deploy new ship at " + this.targetX + " " + this.targetY + " " + this.targetZ, new Object[0]));
                return 2;
            }
            for (int x = targetLocationMin.field_71574_a; x <= targetLocationMax.field_71574_a; ++x) {
                for (int y = targetLocationMin.field_71572_b; y <= targetLocationMax.field_71572_b; ++y) {
                    for (int z = targetLocationMin.field_71573_c; z <= targetLocationMax.field_71573_c; ++z) {
                        this.field_145850_b.func_147468_f(x, y, z);
                    }
                }
            }
        } else {
            int occupiedBlockCount = 0;
            for (int x = targetLocationMin.field_71574_a; x <= targetLocationMax.field_71574_a; ++x) {
                for (int y = targetLocationMin.field_71572_b; y <= targetLocationMax.field_71572_b; ++y) {
                    for (int z = targetLocationMin.field_71573_c; z <= targetLocationMax.field_71573_c; ++z) {
                        if (this.field_145850_b.func_147437_c(x, y, z)) continue;
                        if (++occupiedBlockCount == 1 || occupiedBlockCount <= 100 && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                            this.field_145850_b.func_72885_a(null, (double)x, (double)y, (double)z, 1.0f, false, false);
                        }
                        if (!WarpDriveConfig.LOGGING_BUILDING) continue;
                        WarpDrive.logger.info("Deployment collision detected at " + x + " " + y + " " + z);
                    }
                }
            }
            if (occupiedBlockCount > 0) {
                reason.append(String.format("Deployment area occupied with %d blocks. Can't deploy ship.", occupiedBlockCount));
                return 2;
            }
        }
        this.isDeploying = true;
        this.currentDeployIndex = 0;
        this.setActive(true);
        reason.append(String.format("Deploying ship '%s'...", fileName));
        return 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.schematicFileName = tag.func_74779_i("schematic");
        this.targetX = tag.func_74762_e("targetX");
        this.targetY = tag.func_74762_e("targetY");
        this.targetZ = tag.func_74762_e("targetZ");
        this.rotationSteps = tag.func_74771_c("rotationSteps");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74778_a("schematic", this.schematicFileName);
        tag.func_74768_a("targetX", this.targetX);
        tag.func_74768_a("targetY", this.targetY);
        tag.func_74768_a("targetZ", this.targetZ);
        tag.func_74774_a("rotationSteps", this.rotationSteps);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] scan(Context context, Arguments arguments) {
        return this.scan();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] filename(Context context, Arguments arguments) {
        return this.filename();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] deploy(Context context, Arguments arguments) {
        return this.deploy(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state();
    }

    private Object[] scan() {
        if (this.isActive) {
            return new Object[]{false, 0, "Already active"};
        }
        if (this.shipCore == null) {
            return new Object[]{false, 1, "Ship-Core not found"};
        }
        int energyCost = this.getScanningEnergyCost(this.shipCore.shipMass);
        if (!this.energy_consume(energyCost, true)) {
            return new Object[]{false, 2, "Not enough energy! " + energyCost + " required."};
        }
        StringBuilder reason = new StringBuilder();
        boolean success = this.scanShip(reason);
        return new Object[]{success, 3, reason.toString()};
    }

    private Object[] filename() {
        if (this.isActive && !this.schematicFileName.isEmpty()) {
            if (this.isDeploying) {
                return new Object[]{false, "Deployment in progress. Please wait..."};
            }
            return new Object[]{false, "Scan in progress. Please wait..."};
        }
        return new Object[]{true, this.schematicFileName};
    }

    private Object[] deploy(Object[] arguments) {
        if (arguments.length == 5) {
            String fileName = (String)arguments[0];
            int x = TileEntityShipScanner.toInt(arguments[1]);
            int y = TileEntityShipScanner.toInt(arguments[2]);
            int z = TileEntityShipScanner.toInt(arguments[3]);
            byte rotationSteps = (byte)TileEntityShipScanner.toInt(arguments[4]);
            if (!new File(WarpDriveConfig.G_SCHEMALOCATION + "/" + fileName + ".schematic").exists()) {
                return new Object[]{0, "Specified schematic file was not found!"};
            }
            StringBuilder reason = new StringBuilder();
            int result = this.deployShip(fileName, x, y, z, rotationSteps, false, reason);
            return new Object[]{result, reason.toString()};
        }
        return new Object[]{4, "Invalid arguments count, you need .schematic file name, offsetX, offsetY, offsetZ, rotationSteps!"};
    }

    private Object[] state() {
        if (!this.isActive) {
            return new Object[]{false, "IDLE", 0, 0};
        }
        if (!this.isDeploying) {
            return new Object[]{true, "Scanning", 0, 0};
        }
        return new Object[]{true, "Deploying", this.currentDeployIndex, this.blocksToDeployCount};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "scan": {
                return this.scan();
            }
            case "fileName": {
                return this.filename();
            }
            case "deploy": {
                return this.deploy(arguments);
            }
            case "state": {
                return this.state();
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    private void checkPlayerToken() {
        int slotIndex;
        --this.cooldownPlayerDetection;
        if (this.cooldownPlayerDetection > 0) {
            return;
        }
        this.cooldownPlayerDetection = 20;
        if (this.targetX == 0 && this.targetY == 0 && this.targetZ == 0) {
            return;
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 1.0), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e - 1.0), (double)((double)this.field_145851_c + 1.99), (double)((double)this.field_145848_d + 5.0), (double)((double)this.field_145849_e + 1.99));
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        ArrayList<EntityPlayer> entityPlayers = new ArrayList<EntityPlayer>(10);
        for (Object object : list) {
            if (!(object instanceof EntityPlayer)) continue;
            entityPlayers.add((EntityPlayer)object);
        }
        if (entityPlayers.isEmpty()) {
            this.warmupPlayerId = null;
            return;
        }
        if (entityPlayers.size() > 1) {
            for (EntityPlayer entityPlayer : entityPlayers) {
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a7cToo many players detected: please stand in the beam one at a time.");
                this.cooldownPlayerDetection = 60;
            }
            this.warmupPlayerId = null;
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entityPlayers.get(0);
        ItemStack itemStack = null;
        for (slotIndex = 0; slotIndex < entityPlayer.field_71071_by.func_70302_i_() && ((itemStack = entityPlayer.field_71071_by.func_70301_a(slotIndex)) == null || itemStack.func_77973_b() != WarpDrive.itemCrystalToken || itemStack.field_77994_a < 1); ++slotIndex) {
        }
        if (itemStack == null || slotIndex >= entityPlayer.field_71071_by.func_70302_i_()) {
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, "Please come back once you've a Crystal token.");
            this.cooldownPlayerDetection = 60;
            return;
        }
        if (entityPlayer.func_110124_au() != this.warmupPlayerId || !this.warmupSchematicName.equals(ItemCrystalToken.getSchematicName(itemStack))) {
            this.warmupPlayerId = entityPlayer.func_110124_au();
            this.warmupPlayer = 6;
            this.warmupSchematicName = ItemCrystalToken.getSchematicName(itemStack);
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a76" + String.format("Token '%1$s' detected!", this.warmupSchematicName, 5));
        }
        --this.warmupPlayer;
        if (this.warmupPlayer > 0) {
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, String.format("Stand by for ship materialization in %2$d...", this.warmupSchematicName, this.warmupPlayer));
            return;
        }
        this.warmupPlayerId = null;
        this.playerName = entityPlayer.func_70005_c_();
        StringBuilder reason = new StringBuilder();
        this.deployShip(ItemCrystalToken.getSchematicName(itemStack), this.targetX - this.field_145851_c, this.targetY - this.field_145848_d, this.targetZ - this.field_145849_e, this.rotationSteps, true, reason);
        if (!this.isActive) {
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a7c" + reason.toString());
            this.cooldownPlayerDetection = 100;
            return;
        }
        WarpDrive.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a76" + reason.toString());
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            --itemStack.field_77994_a;
            if (itemStack.field_77994_a > 0) {
                entityPlayer.field_71071_by.func_70299_a(slotIndex, itemStack);
            } else {
                entityPlayer.field_71071_by.func_70299_a(slotIndex, null);
            }
            entityPlayer.field_71071_by.func_70296_d();
        }
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.SS_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }

    public String toString() {
        return String.format("%s @ '%s' (%d %d %d)", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

