/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.forcefield.BlockAbstractForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldProjector;
import cr0s.warpdrive.block.hull.BlockHullGlass;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumPermissionNode;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.render.RenderBlockForceField;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockForceField
extends BlockAbstractForceField
implements IDamageReceiver {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private static final float BOUNDING_TOLERANCE = 0.05f;
    private double log_explosionX;
    private double log_explosionY = -1.0;
    private double log_explosionZ;

    public BlockForceField(byte tier) {
        super(tier, Material.field_151592_s);
        this.func_149672_a(Block.field_149775_l);
        this.func_149663_c("warpdrive.forcefield.block" + tier);
        this.func_149658_d("warpdrive:forcefield/forcefield");
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityForceField();
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer entityPlayer) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[metadata % 16];
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.func_149641_N() + "_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderBlockForceField.renderId;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_147437_c(x, y, z)) {
            return true;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)side).getOpposite();
        Block sideBlock = world.func_147439_a(x, y, z);
        if (sideBlock instanceof BlockGlass || sideBlock instanceof BlockHullGlass || sideBlock instanceof BlockForceField) {
            return world.func_72805_g(x, y, z) != world.func_72805_g(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
        }
        return !world.isSideSolid(x, y, z, direction, false);
    }

    protected TileEntityForceFieldProjector getProjector(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityForceField) {
            return ((TileEntityForceField)tileEntity).getProjector();
        }
        return null;
    }

    private ForceFieldSetup getForceFieldSetup(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityForceField) {
            return ((TileEntityForceField)tileEntity).getForceFieldSetup();
        }
        return null;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup(world, x, y, z);
        if (forceFieldSetup != null) {
            forceFieldSetup.onEntityEffect(world, x, y, z, (Entity)entityPlayer);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup(world, x, y, z);
        if (forceFieldSetup != null) {
            List entities = world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((double)y + 0.9), (double)(z + 1)));
            for (EntityPlayer entityPlayer : entities) {
                if (entityPlayer == null || !entityPlayer.func_70093_af() || !entityPlayer.field_71075_bZ.field_75098_d && !forceFieldSetup.isAccessGranted(entityPlayer, EnumPermissionNode.SNEAK_THROUGH)) continue;
                return null;
            }
        }
        return AxisAlignedBB.func_72330_a((double)((float)x + 0.05f), (double)((float)y + 0.05f), (double)((float)z + 0.05f), (double)((float)(x + 1) - 0.05f), (double)((float)(y + 1) - 0.05f), (double)((float)(z + 1) - 0.05f));
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup(world, x, y, z);
        if (forceFieldSetup != null) {
            forceFieldSetup.onEntityEffect(world, x, y, z, entity);
            double distance2 = new Vector3(x, y, z).translate(0.5).distanceTo_square(entity);
            if (entity instanceof EntityLiving && distance2 < 0.26) {
                boolean hasPermission = false;
                List entities = world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((double)y + 0.9), (double)(z + 1)));
                for (EntityPlayer entityPlayer : entities) {
                    if (entityPlayer == null || !entityPlayer.func_70093_af() || !entityPlayer.field_71075_bZ.field_75098_d && !forceFieldSetup.isAccessGranted(entityPlayer, EnumPermissionNode.SNEAK_THROUGH)) continue;
                    hasPermission = true;
                    break;
                }
                ((EntityLiving)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 20, 1));
                if (!hasPermission) {
                    ((EntityLiving)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 80, 3));
                    if (distance2 < 0.24) {
                        entity.func_70097_a((DamageSource)WarpDrive.damageShock, 5.0f);
                    }
                }
            }
        }
    }

    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityForceField && ((TileEntityForceField)tileEntity).cache_blockCamouflage != null) {
            return ((TileEntityForceField)tileEntity).cache_colorMultiplierCamouflage;
        }
        return super.func_149720_d(blockAccess, x, y, z);
    }

    public int getLightValue(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityForceField) {
            return ((TileEntityForceField)tileEntity).cache_lightCamouflage;
        }
        return 0;
    }

    private void downgrade(World world, int x, int y, int z) {
        if (this.tier > 1) {
            TileEntity tileEntity;
            TileEntityForceFieldProjector tileEntityForceFieldProjector = this.getProjector(world, x, y, z);
            world.func_147465_d(x, y, z, WarpDrive.blockForceFields[this.tier - 2], (world.func_72805_g(x, y, z) + 1) % 16, 2);
            if (tileEntityForceFieldProjector != null && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityForceField) {
                ((TileEntityForceField)tileEntity).setProjector(new VectorI(tileEntityForceFieldProjector));
            }
        } else {
            world.func_147468_f(x, y, z);
        }
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        boolean enableFirstHit;
        boolean bl = enableFirstHit = this.log_explosionX != explosionX || this.log_explosionY != explosionY || this.log_explosionZ != explosionZ;
        if (enableFirstHit) {
            this.log_explosionX = explosionX;
            this.log_explosionY = explosionY;
            this.log_explosionZ = explosionZ;
        }
        double strength = 0.0;
        if (entity == null && explosionX == Math.rint(explosionX) && explosionY == Math.rint(explosionY) && explosionZ == Math.rint(explosionZ)) {
            Block block = world.func_147439_a((int)explosionX, (int)explosionY, (int)explosionZ);
            TileEntity tileEntity = world.func_147438_o((int)explosionX, (int)explosionY, (int)explosionZ);
            if (enableFirstHit && WarpDriveConfig.LOGGING_FORCEFIELD) {
                WarpDrive.logger.info("Block at location is " + block + " " + block.func_149739_a() + " with tileEntity " + tileEntity);
            }
            return 2.0f * super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
        }
        if (entity != null) {
            switch (entity.getClass().toString()) {
                case "class net.minecraft.entity.item.EntityEnderCrystal": {
                    strength = 6.0;
                    break;
                }
                case "class net.minecraft.entity.item.EntityMinecartTNT": {
                    strength = 4.0;
                    break;
                }
                case "class net.minecraft.entity.item.EntityTNTPrimed": {
                    strength = 5.0;
                    break;
                }
                case "class net.minecraft.entity.monster.EntityCreeper": {
                    strength = 3.0;
                    break;
                }
                case "class appeng.entity.EntityTinyTNTPrimed": {
                    strength = 0.2;
                    break;
                }
                case "class com.arc.bloodarsenal.common.entity.EntityBloodTNT": {
                    strength = 1.0;
                    break;
                }
                case "class ic2.core.block.EntityItnt": {
                    strength = 5.5;
                    break;
                }
                case "class ic2.core.block.EntityNuke": {
                    strength = 0.02;
                    break;
                }
                case "class ic2.core.block.EntityDynamite": {
                    strength = 1.0;
                    break;
                }
                case "class ic2.core.block.EntityStickyDynamite": {
                    strength = 1.0;
                    break;
                }
                case "class defense.common.entity.EntityExplosion": {
                    strength = 1.0;
                    break;
                }
                case "class defense.common.entity.EntityExplosive": {
                    strength = 15.0;
                    break;
                }
                case "class defense.common.entity.EntityFragments": {
                    strength = 0.02;
                    break;
                }
                default: {
                    if (!enableFirstHit) break;
                    WarpDrive.logger.error("Unknown explosion source " + entity.getClass().toString() + " " + entity);
                }
            }
        }
        Explosion explosion = new Explosion(world, entity, explosionX, explosionY, explosionZ, 4.0f);
        Vector3 vDirection = new Vector3((double)x + 0.5 - explosionX, (double)y + 0.5 - explosionY, (double)z + 0.5 - explosionZ);
        double magnitude = Math.max(1.0, vDirection.getMagnitude());
        if (magnitude != 0.0) {
            vDirection.scale(1.0 / magnitude);
        }
        double damageLevel = strength / (magnitude * magnitude) * 1.0;
        double damageLeft = 0.0;
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup(world, x, y, z);
        if (forceFieldSetup != null) {
            damageLeft = forceFieldSetup.applyDamage(world, DamageSource.func_94539_a((Explosion)explosion), damageLevel);
        }
        assert (damageLeft >= 0.0);
        if (enableFirstHit && WarpDriveConfig.LOGGING_FORCEFIELD) {
            WarpDrive.logger.info("BlockForceField(" + this.tier + " at " + x + " " + y + " " + z + ") involved in explosion " + (entity != null ? " from " + entity : " at " + explosionX + " " + explosionY + " " + explosionZ) + (WarpDrive.isDev ? " damageLevel " + damageLevel + " damageLeft " + damageLeft : ""));
        }
        return super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public boolean func_149659_a(Explosion p_149659_1_) {
        return false;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        this.downgrade(world, x, y, z);
        super.onBlockExploded(world, x, y, z, explosion);
    }

    @Override
    public void onEMP(World world, int x, int y, int z, float efficiency) {
        if (efficiency > 0.0f) {
            this.downgrade(world, x, y, z);
        }
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        this.downgrade(world, x, y, z);
        super.func_149723_a(world, x, y, z, explosion);
    }

    @Override
    public float getBlockHardness(World world, int x, int y, int z, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        return WarpDriveConfig.HULL_HARDNESS[this.tier - 1];
    }

    @Override
    public int applyDamage(World world, int x, int y, int z, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup(world, x, y, z);
        if (forceFieldSetup != null) {
            return (int)Math.round(forceFieldSetup.applyDamage(world, damageSource, damageLevel));
        }
        return damageLevel;
    }
}

