/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IForceFieldShape;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.block.forcefield.TileEntityAbstractForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceField;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumForceFieldShape;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityForceFieldProjector
extends TileEntityAbstractForceField {
    private static final int PROJECTOR_MAX_ENERGY_STORED = 30000;
    private static final int PROJECTOR_COOLDOWN_TICKS = 300;
    public static final int PROJECTOR_PROJECTION_UPDATE_TICKS = 8;
    private static final int PROJECTOR_SETUP_TICKS = 20;
    private static final int PROJECTOR_SOUND_UPDATE_TICKS = 60;
    private static final int PROJECTOR_GUIDE_UPDATE_TICKS = 300;
    private int maxEnergyStored;
    public boolean isDoubleSided;
    private EnumForceFieldShape shape;
    private float rotationYaw;
    private float rotationPitch;
    private float rotationRoll;
    private Vector3 v3Min = new Vector3(-1.0, -1.0, -1.0);
    private Vector3 v3Max = new Vector3(1.0, 1.0, 1.0);
    private Vector3 v3Translation = new Vector3(0.0, 0.0, 0.0);
    private int cooldownTicks;
    private int setupTicks;
    private int updateTicks;
    private int soundTicks;
    private int guideTicks;
    private double damagesEnergyCost = 0.0;
    private final HashSet<UUID> setInteractedEntities = new HashSet();
    protected boolean isPowered = true;
    private ForceFieldSetup cache_forceFieldSetup;
    private ForceFieldSetup legacy_forceFieldSetup;
    private boolean legacy_isOn = true;
    private double consumptionLeftOver = 0.0;
    private float carryScanSpeed;
    private float carryPlaceSpeed;
    private static final AtomicBoolean isGlobalThreadRunning = new AtomicBoolean(false);
    private final AtomicBoolean isThreadRunning = new AtomicBoolean(false);
    private final AtomicBoolean isDirty = new AtomicBoolean(true);
    private Set<VectorI> calculated_interiorField = null;
    private Set<VectorI> calculated_forceField = null;
    private Iterator<VectorI> iteratorForcefield = null;
    private final Set<VectorI> vForceFields = new HashSet<VectorI>();

    public TileEntityForceFieldProjector() {
        this.peripheralName = "warpdriveForceFieldProjector";
        this.addMethods(new String[]{"rotation", "state"});
        for (EnumForceFieldUpgrade enumForceFieldUpgrade : EnumForceFieldUpgrade.values()) {
            if (enumForceFieldUpgrade.maxCountOnProjector <= 0) continue;
            this.setUpgradeMaxCount(enumForceFieldUpgrade, enumForceFieldUpgrade.maxCountOnProjector);
        }
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.maxEnergyStored = 30000 * (1 + 2 * this.tier);
        this.cooldownTicks = 0;
        this.setupTicks = this.field_145850_b.field_73012_v.nextInt(20);
        this.updateTicks = this.field_145850_b.field_73012_v.nextInt(8);
        this.guideTicks = 300;
    }

    @Override
    public void func_145845_h() {
        block20: {
            boolean isEnabledAndValid;
            block19: {
                boolean isOn;
                super.func_145845_h();
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                if (!this.isConnected) {
                    return;
                }
                --this.setupTicks;
                if (this.setupTicks <= 0) {
                    this.setupTicks = 20;
                    if (this.cache_forceFieldSetup != null) {
                        this.legacy_forceFieldSetup = this.cache_forceFieldSetup;
                        this.cache_forceFieldSetup = null;
                    }
                }
                if (this.cooldownTicks > 0) {
                    --this.cooldownTicks;
                }
                if (this.guideTicks > 0) {
                    --this.guideTicks;
                }
                ForceFieldSetup forceFieldSetup = this.getForceFieldSetup();
                int energyRequired = !this.legacy_isOn ? (int)Math.round(forceFieldSetup.startupEnergyCost + forceFieldSetup.placeEnergyCost * (double)forceFieldSetup.placeSpeed * 8.0 / 20.0) : (int)Math.round(forceFieldSetup.scanEnergyCost * (double)forceFieldSetup.scanSpeed * 8.0 / 20.0);
                if (energyRequired > this.energy_getMaxStorage()) {
                    WarpDrive.logger.error("Force field projector requires " + energyRequired + " to get started but can only store " + this.energy_getMaxStorage());
                }
                this.isPowered = this.energy_getEnergyStored() >= energyRequired;
                isEnabledAndValid = this.isEnabled && this.isValid();
                boolean bl = isOn = isEnabledAndValid && this.cooldownTicks <= 0 && this.isPowered;
                if (!isOn) break block19;
                if (!this.legacy_isOn) {
                    this.consumeEnergy(forceFieldSetup.startupEnergyCost, false);
                    if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                        WarpDrive.logger.info(this + " starting up...");
                    }
                    this.legacy_isOn = true;
                }
                this.cooldownTicks = 0;
                int countEntityInteractions = this.setInteractedEntities.size();
                if (countEntityInteractions > 0) {
                    this.setInteractedEntities.clear();
                    this.consumeEnergy(forceFieldSetup.getEntityEnergyCost(countEntityInteractions), false);
                }
                if (this.damagesEnergyCost > 0.0) {
                    if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                        WarpDrive.logger.info(String.format("%s damages received, energy lost: %.6f", this.toString(), this.damagesEnergyCost));
                    }
                    this.consumeEnergy(this.damagesEnergyCost, false);
                    this.damagesEnergyCost = 0.0;
                }
                --this.updateTicks;
                if (this.updateTicks <= 0) {
                    this.updateTicks = 8;
                    if (!this.isCalculated()) {
                        this.calculateForceField();
                    } else {
                        this.projectForceField();
                    }
                }
                --this.soundTicks;
                if (this.soundTicks > 0) break block20;
                this.soundTicks = 60;
                if (this.hasUpgrade(EnumForceFieldUpgrade.SILENCER)) break block20;
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "warpdrive:projecting", 1.0f, 0.85f + 0.15f * this.field_145850_b.field_73012_v.nextFloat());
                break block20;
            }
            if (this.legacy_isOn) {
                if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                    WarpDrive.logger.info(this + " shutting down...");
                }
                this.legacy_isOn = false;
                this.cooldownTicks = 300;
                this.guideTicks = 0;
            }
            this.destroyForceField(false);
            if (isEnabledAndValid && this.guideTicks <= 0) {
                this.guideTicks = 300;
                String msg = StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{this.func_145838_q().func_149732_F()}) + StatCollector.func_74837_a((String)"warpdrive.forcefield.guide.lowPower", (Object[])new Object[0]);
                AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 10), (double)(this.field_145848_d - 10), (double)(this.field_145849_e - 10), (double)(this.field_145851_c + 10), (double)(this.field_145848_d + 10), (double)(this.field_145849_e + 10));
                List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
                for (Entity entity : list) {
                    if (entity == null || !(entity instanceof EntityPlayer) || entity instanceof FakePlayer) continue;
                    WarpDrive.addChatMessage((ICommandSender)((EntityPlayer)entity), msg);
                }
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroyForceField(true);
    }

    public boolean isValid() {
        return this.getShape() != EnumForceFieldShape.NONE;
    }

    public boolean isCalculated() {
        return !this.isDirty.get() && !this.isThreadRunning.get();
    }

    private void calculateForceField() {
        if (!this.field_145850_b.field_72995_K && this.isValid() && !isGlobalThreadRunning.getAndSet(true)) {
            if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                WarpDrive.logger.info("Calculation initiated for " + this);
            }
            this.isThreadRunning.set(true);
            this.isDirty.set(false);
            this.iteratorForcefield = null;
            this.calculated_interiorField = null;
            this.calculated_forceField = null;
            this.vForceFields.clear();
            new ThreadCalculation(this).start();
        }
    }

    private void calculation_done(Set<VectorI> interiorField, Set<VectorI> forceField) {
        if (WarpDriveConfig.LOGGING_FORCEFIELD) {
            WarpDrive.logger.info("Calculation done for " + this);
        }
        if (interiorField == null || forceField == null) {
            this.calculated_interiorField = new HashSet<VectorI>(0);
            this.calculated_forceField = new HashSet<VectorI>(0);
        } else {
            this.calculated_interiorField = interiorField;
            this.calculated_forceField = forceField;
        }
        this.isThreadRunning.set(false);
        isGlobalThreadRunning.set(false);
    }

    boolean isOn() {
        return this.legacy_isOn;
    }

    boolean isPartOfForceField(VectorI vector) {
        if (!this.isEnabled || !this.isValid()) {
            return false;
        }
        if (!this.isCalculated()) {
            return true;
        }
        return this.calculated_forceField.contains(vector);
    }

    private boolean isPartOfInterior(VectorI vector) {
        if (!this.isEnabled || !this.isValid()) {
            return false;
        }
        if (!this.isCalculated()) {
            return false;
        }
        return this.calculated_interiorField.contains(vector);
    }

    public boolean onEntityInteracted(UUID uniqueID) {
        return this.setInteractedEntities.add(uniqueID);
    }

    public void onEnergyDamage(double energyCost) {
        this.damagesEnergyCost += energyCost;
    }

    private void projectForceField() {
        assert (!this.field_145850_b.field_72995_K && this.isCalculated());
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup();
        int countScanned = 0;
        float floatScanSpeed = Math.min(forceFieldSetup.scanSpeed * 8.0f / 20.0f + this.carryScanSpeed, (float)this.calculated_forceField.size());
        int countMaxScanned = (int)Math.floor(floatScanSpeed);
        this.carryScanSpeed = floatScanSpeed - (float)countMaxScanned;
        int countPlaced = 0;
        float floatPlaceSpeed = Math.min(forceFieldSetup.placeSpeed * 8.0f / 20.0f + this.carryPlaceSpeed, (float)this.calculated_forceField.size());
        int countMaxPlaced = (int)Math.floor(floatPlaceSpeed);
        this.carryPlaceSpeed = floatPlaceSpeed - (float)countMaxPlaced;
        int metadataForceField = Math.min(15, this.beamFrequency * 16 / 65000);
        if (forceFieldSetup.getCamouflageBlock() != null) {
            metadataForceField = forceFieldSetup.getCamouflageMetadata();
        }
        while (countScanned < countMaxScanned && countPlaced < countMaxPlaced && this.consumeEnergy(Math.max(forceFieldSetup.scanEnergyCost, forceFieldSetup.placeEnergyCost), true)) {
            if (this.iteratorForcefield == null || !this.iteratorForcefield.hasNext()) {
                this.iteratorForcefield = this.calculated_forceField.iterator();
            }
            ++countScanned;
            VectorI vector = this.iteratorForcefield.next();
            if (!this.field_145850_b.func_72899_e(vector.x, vector.y, vector.z) || !this.field_145850_b.func_72938_d((int)vector.x, (int)vector.z).field_76636_d) continue;
            Block block = vector.getBlock((IBlockAccess)this.field_145850_b);
            boolean doProjectThisBlock = true;
            if (forceFieldSetup.hasFusion) {
                for (TileEntityForceFieldProjector projector : forceFieldSetup.projectors) {
                    if (!projector.isPartOfInterior(vector)) continue;
                    doProjectThisBlock = false;
                    break;
                }
            }
            if (doProjectThisBlock && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !Dictionary.BLOCKS_EXPANDABLE.contains(block)) {
                if (block instanceof BlockLiquid) {
                    Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                    doProjectThisBlock = fluid == null || forceFieldSetup.pumping_maxViscosity >= (float)fluid.getViscosity();
                } else if (forceFieldSetup.breaking_maxHardness > 0.0f) {
                    float blockHardness = block.func_149712_f(this.field_145850_b, vector.x, vector.y, vector.z);
                    if (blockHardness == -1.0f || blockHardness > forceFieldSetup.breaking_maxHardness || this.field_145850_b.func_147437_c(vector.x, vector.y, vector.z)) {
                        doProjectThisBlock = false;
                    }
                } else {
                    if (block instanceof BlockForceField) {
                        TileEntity tileEntity = vector.getTileEntity((IBlockAccess)this.field_145850_b);
                        if (!(tileEntity instanceof TileEntityForceField)) {
                            this.field_145850_b.func_147468_f(vector.x, vector.y, vector.z);
                            block = Blocks.field_150350_a;
                        } else {
                            TileEntityForceField tileEntityForceField = (TileEntityForceField)tileEntity;
                            TileEntityForceFieldProjector tileEntityForceFieldProjector = tileEntityForceField.getProjector();
                            if (tileEntityForceFieldProjector == null) {
                                tileEntityForceField.setProjector(new VectorI(this));
                                tileEntityForceField.cache_blockCamouflage = forceFieldSetup.getCamouflageBlock();
                                tileEntityForceField.cache_metadataCamouflage = forceFieldSetup.getCamouflageMetadata();
                                this.field_145850_b.func_72921_c(vector.x, vector.y, vector.z, tileEntityForceField.cache_metadataCamouflage, 2);
                            } else if (tileEntityForceFieldProjector == this && (tileEntityForceField.cache_blockCamouflage != forceFieldSetup.getCamouflageBlock() || tileEntityForceField.cache_metadataCamouflage != forceFieldSetup.getCamouflageMetadata() || block != WarpDrive.blockForceFields[this.tier - 1] || vector.getBlockMetadata((IBlockAccess)this.field_145850_b) != metadataForceField)) {
                                this.field_145850_b.func_147468_f(vector.x, vector.y, vector.z);
                                block = Blocks.field_150350_a;
                            }
                        }
                    }
                    boolean bl = doProjectThisBlock = block.isReplaceable((IBlockAccess)this.field_145850_b, vector.x, vector.y, vector.z) || block == WarpDrive.blockForceFields[this.tier - 1];
                }
            }
            if (doProjectThisBlock) {
                if (forceFieldSetup.breaking_maxHardness > 0.0f) {
                    doProjectThisBlock = !this.isBlockBreakCanceled(null, this.field_145850_b, vector.x, vector.y, vector.z);
                } else if (!(block instanceof BlockForceField)) {
                    boolean bl = doProjectThisBlock = !this.isBlockPlaceCanceled(null, this.field_145850_b, vector.x, vector.y, vector.z, WarpDrive.blockForceFields[this.tier - 1], metadataForceField);
                }
            }
            if (doProjectThisBlock) {
                TileEntity tileEntity;
                if (block != WarpDrive.blockForceFields[this.tier - 1] && !vector.equals(this)) {
                    boolean hasPlaced = false;
                    if (block instanceof BlockLiquid) {
                        hasPlaced = true;
                        this.doPumping(forceFieldSetup, metadataForceField, vector, block);
                    } else if (forceFieldSetup.breaking_maxHardness > 0.0f) {
                        hasPlaced = true;
                        if (this.doBreaking(forceFieldSetup, vector, block)) {
                            return;
                        }
                    } else if (forceFieldSetup.hasStabilize) {
                        hasPlaced = true;
                        if (this.doStabilize(forceFieldSetup, vector)) {
                            return;
                        }
                    } else if (forceFieldSetup.isInverted && (forceFieldSetup.temperatureLevel < 295.0f || forceFieldSetup.temperatureLevel > 305.0f)) {
                        this.doTerraforming(forceFieldSetup, vector, block);
                    } else if (!forceFieldSetup.isInverted) {
                        hasPlaced = true;
                        this.field_145850_b.func_147465_d(vector.x, vector.y, vector.z, WarpDrive.blockForceFields[this.tier - 1], metadataForceField, 2);
                        TileEntity tileEntity2 = this.field_145850_b.func_147438_o(vector.x, vector.y, vector.z);
                        if (tileEntity2 instanceof TileEntityForceField) {
                            ((TileEntityForceField)tileEntity2).setProjector(new VectorI(this));
                        }
                        this.vForceFields.add(vector);
                    }
                    if (hasPlaced) {
                        ++countPlaced;
                        this.consumeEnergy(forceFieldSetup.placeEnergyCost, false);
                        continue;
                    }
                    this.consumeEnergy(forceFieldSetup.scanEnergyCost, false);
                    continue;
                }
                this.consumeEnergy(forceFieldSetup.scanEnergyCost, false);
                if (block != WarpDrive.blockForceFields[this.tier - 1] || this.vForceFields.contains(vector) || !((tileEntity = this.field_145850_b.func_147438_o(vector.x, vector.y, vector.z)) instanceof TileEntityForceField) || ((TileEntityForceField)tileEntity).getProjector() != this) continue;
                this.vForceFields.add(vector);
                continue;
            }
            this.consumeEnergy(forceFieldSetup.scanEnergyCost, false);
            if (block != WarpDrive.blockForceFields[this.tier - 1]) continue;
            assert (block instanceof BlockForceField);
            if (((BlockForceField)block).getProjector(this.field_145850_b, vector.x, vector.y, vector.z) != this) continue;
            this.field_145850_b.func_147468_f(vector.x, vector.y, vector.z);
            this.vForceFields.remove(vector);
        }
    }

    private void doPumping(ForceFieldSetup forceFieldSetup, int metadataForceField, VectorI vector, Block block) {
        if (block instanceof BlockStaticLiquid) {
            // empty if block
        }
        if (forceFieldSetup.isInverted || forceFieldSetup.breaking_maxHardness > 0.0f) {
            this.field_145850_b.func_147465_d(vector.x, vector.y, vector.z, Blocks.field_150350_a, 0, 2);
        } else {
            this.field_145850_b.func_147465_d(vector.x, vector.y, vector.z, WarpDrive.blockForceFields[this.tier - 1], metadataForceField, 2);
            TileEntity tileEntity = this.field_145850_b.func_147438_o(vector.x, vector.y, vector.z);
            if (tileEntity instanceof TileEntityForceField) {
                ((TileEntityForceField)tileEntity).setProjector(new VectorI(this));
            }
            this.vForceFields.add(vector);
        }
    }

    private boolean doStabilize(ForceFieldSetup forceFieldSetup, VectorI vector) {
        int slotIndex = 0;
        boolean found = false;
        int countItemBlocks = 0;
        ItemStack itemStack = null;
        Block blockToPlace = null;
        int metadataToPlace = -1;
        IInventory inventory = null;
        for (IInventory inventoryLoop : forceFieldSetup.inventories) {
            if (!found) {
                slotIndex = 0;
            }
            while (slotIndex < inventoryLoop.func_70302_i_() && !found) {
                itemStack = inventoryLoop.func_70301_a(slotIndex);
                if (itemStack == null || itemStack.field_77994_a <= 0) {
                    ++slotIndex;
                    continue;
                }
                blockToPlace = Block.func_149634_a((Item)itemStack.func_77973_b());
                if (blockToPlace == Blocks.field_150350_a) {
                    ++slotIndex;
                    continue;
                }
                ++countItemBlocks;
                metadataToPlace = itemStack.func_77973_b().func_77647_b(itemStack.func_77960_j());
                if (metadataToPlace == 0 && itemStack.func_77960_j() != 0) {
                    metadataToPlace = itemStack.func_77960_j();
                }
                if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                    WarpDrive.logger.info("Slot " + slotIndex + " as " + itemStack + " known as block " + blockToPlace + ":" + metadataToPlace);
                }
                if (!blockToPlace.func_149742_c(this.field_145850_b, vector.x, vector.y, vector.z)) {
                    ++slotIndex;
                    continue;
                }
                found = true;
                inventory = inventoryLoop;
            }
        }
        if (countItemBlocks <= 0) {
            return true;
        }
        if (inventory == null) {
            if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                WarpDrive.logger.debug("No item to place found");
            }
            return true;
        }
        assert (found);
        if (this.isBlockPlaceCanceled(null, this.field_145850_b, vector.x, vector.y, vector.z, blockToPlace, metadataToPlace)) {
            if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                WarpDrive.logger.info(this + " Placing cancelled at (" + vector.x + " " + vector.y + " " + vector.z + ")");
            }
            return true;
        }
        --itemStack.field_77994_a;
        if (itemStack.field_77994_a <= 0) {
            itemStack = null;
        }
        inventory.func_70299_a(slotIndex, itemStack);
        int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(vector.x, vector.y, vector.z).translate(0.5), 0.2f, 0.7f, 0.4f, age, 0, 50);
        this.field_145850_b.func_72908_a((double)((float)vector.x + 0.5f), (double)((float)vector.y + 0.5f), (double)((float)vector.z + 0.5f), blockToPlace.field_149762_H.func_150496_b(), (blockToPlace.field_149762_H.func_150497_c() + 1.0f) / 2.0f, blockToPlace.field_149762_H.func_150494_d() * 0.8f);
        this.field_145850_b.func_147465_d(vector.x, vector.y, vector.z, blockToPlace, metadataToPlace, 3);
        return false;
    }

    private void doTerraforming(ForceFieldSetup forceFieldSetup, VectorI vector, Block block) {
        assert (vector != null);
        assert (block != null);
        if (forceFieldSetup.temperatureLevel > 300.0f) {
            // empty if block
        }
    }

    private boolean doBreaking(ForceFieldSetup forceFieldSetup, VectorI vector, Block block) {
        List itemStacks;
        int metadata = 0;
        try {
            metadata = this.field_145850_b.func_72805_g(vector.x, vector.y, vector.z);
            itemStacks = block.getDrops(this.field_145850_b, vector.x, vector.y, vector.z, metadata, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            itemStacks = null;
        }
        if (itemStacks != null) {
            if (forceFieldSetup.hasCollection) {
                if (this.addToInventories(itemStacks, forceFieldSetup.inventories)) {
                    return true;
                }
            } else {
                for (ItemStack itemStackDrop : itemStacks) {
                    ItemStack drop = itemStackDrop.func_77946_l();
                    EntityItem entityItem = new EntityItem(this.field_145850_b, (double)vector.x + 0.5, (double)vector.y + 1.0, (double)vector.z + 0.5, drop);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                }
            }
        }
        int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(vector.x, vector.y, vector.z).translate(0.5), new Vector3(this).translate(0.5), 0.7f, 0.4f, 0.2f, age, 0, 50);
        this.field_145850_b.func_72889_a(null, 2001, vector.x, vector.y, vector.z, Block.func_149682_b((Block)block) + (metadata << 12));
        this.field_145850_b.func_147468_f(vector.x, vector.y, vector.z);
        return false;
    }

    private void destroyForceField(boolean isChunkLoading) {
        Block block;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.legacy_isOn = false;
        if (!this.vForceFields.isEmpty()) {
            Iterator<VectorI> iterator = this.vForceFields.iterator();
            while (iterator.hasNext()) {
                VectorI vector = iterator.next();
                if (!isChunkLoading && (!this.field_145850_b.func_72899_e(vector.x, vector.y, vector.z) || !this.field_145850_b.func_72938_d((int)vector.x, (int)vector.z).field_76636_d)) continue;
                block = vector.getBlock((IBlockAccess)this.field_145850_b);
                if (block == WarpDrive.blockForceFields[this.tier - 1]) {
                    this.field_145850_b.func_147468_f(vector.x, vector.y, vector.z);
                }
                iterator.remove();
            }
        }
        if (this.isCalculated() && isChunkLoading) {
            for (VectorI vector : this.calculated_forceField) {
                TileEntity tileEntity;
                block = vector.getBlock((IBlockAccess)this.field_145850_b);
                if (block != WarpDrive.blockForceFields[this.tier - 1] || !((tileEntity = this.field_145850_b.func_147438_o(vector.x, vector.y, vector.z)) instanceof TileEntityForceField) || ((TileEntityForceField)tileEntity).getProjector() != this) continue;
                this.field_145850_b.func_147468_f(vector.x, vector.y, vector.z);
            }
        }
    }

    public IForceFieldShape getShapeProvider() {
        return this.getShape();
    }

    @Override
    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    @Override
    public void setBeamFrequency(int parBeamFrequency) {
        super.setBeamFrequency(parBeamFrequency);
        this.cache_forceFieldSetup = null;
        this.isDirty.set(true);
        this.destroyForceField(false);
    }

    public Vector3 getMin() {
        return this.v3Min;
    }

    private void setMin(float x, float y, float z) {
        this.v3Min = new Vector3(TileEntityForceFieldProjector.clamp(-1.0, 0.0, (double)x), TileEntityForceFieldProjector.clamp(-1.0, 0.0, (double)y), TileEntityForceFieldProjector.clamp(-1.0, 0.0, (double)z));
    }

    public Vector3 getMax() {
        return this.v3Max;
    }

    private void setMax(float x, float y, float z) {
        this.v3Max = new Vector3(TileEntityForceFieldProjector.clamp(0.0, 1.0, (double)x), TileEntityForceFieldProjector.clamp(0.0, 1.0, (double)y), TileEntityForceFieldProjector.clamp(0.0, 1.0, (double)z));
    }

    public float getRotationYaw() {
        float totalYaw;
        int metadata = this.func_145832_p();
        switch (ForgeDirection.getOrientation((int)(metadata & 7))) {
            case DOWN: {
                totalYaw = 0.0f;
                break;
            }
            case UP: {
                totalYaw = 0.0f;
                break;
            }
            case NORTH: {
                totalYaw = 90.0f;
                break;
            }
            case SOUTH: {
                totalYaw = 270.0f;
                break;
            }
            case WEST: {
                totalYaw = 0.0f;
                break;
            }
            case EAST: {
                totalYaw = 180.0f;
                break;
            }
            default: {
                totalYaw = 0.0f;
            }
        }
        if (this.hasUpgrade(EnumForceFieldUpgrade.ROTATION)) {
            totalYaw += this.rotationYaw;
        }
        return (totalYaw + 540.0f) % 360.0f - 180.0f;
    }

    public float getRotationPitch() {
        float totalPitch;
        int metadata = this.func_145832_p();
        switch (ForgeDirection.getOrientation((int)(metadata & 7))) {
            case DOWN: {
                totalPitch = 180.0f;
                break;
            }
            case UP: {
                totalPitch = 0.0f;
                break;
            }
            case NORTH: {
                totalPitch = -90.0f;
                break;
            }
            case SOUTH: {
                totalPitch = -90.0f;
                break;
            }
            case WEST: {
                totalPitch = -90.0f;
                break;
            }
            case EAST: {
                totalPitch = -90.0f;
                break;
            }
            default: {
                totalPitch = 0.0f;
            }
        }
        if (this.hasUpgrade(EnumForceFieldUpgrade.ROTATION)) {
            totalPitch += this.rotationPitch;
        }
        return (totalPitch + 540.0f) % 360.0f - 180.0f;
    }

    public float getRotationRoll() {
        if (this.hasUpgrade(EnumForceFieldUpgrade.ROTATION)) {
            return (this.rotationRoll + 540.0f) % 360.0f - 180.0f;
        }
        return 0.0f;
    }

    private void setRotation(float rotationYaw, float rotationPitch, float rotationRoll) {
        float oldYaw = this.rotationYaw;
        float oldPitch = this.rotationPitch;
        float oldRoll = this.rotationRoll;
        this.rotationYaw = TileEntityForceFieldProjector.clamp(-45.0f, 45.0f, rotationYaw);
        this.rotationPitch = TileEntityForceFieldProjector.clamp(-45.0f, 45.0f, rotationPitch);
        this.rotationRoll = (rotationRoll + 720.0f) % 360.0f - 180.0f;
        if (oldYaw != this.rotationYaw || oldPitch != this.rotationPitch || oldRoll != this.rotationRoll) {
            this.isDirty.set(true);
            this.destroyForceField(false);
            this.func_70296_d();
        }
    }

    public EnumForceFieldShape getShape() {
        if (this.shape == null) {
            return EnumForceFieldShape.NONE;
        }
        return this.shape;
    }

    void setShape(EnumForceFieldShape shape) {
        this.shape = shape;
        this.cache_forceFieldSetup = null;
        this.isDirty.set(true);
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.destroyForceField(false);
        }
    }

    public Vector3 getTranslation() {
        if (this.hasUpgrade(EnumForceFieldUpgrade.TRANSLATION)) {
            return this.v3Translation;
        }
        return new Vector3(0.0, 0.0, 0.0);
    }

    private void setTranslation(float x, float y, float z) {
        this.v3Translation = new Vector3(TileEntityForceFieldProjector.clamp(-1.0, 1.0, (double)x), TileEntityForceFieldProjector.clamp(-1.0, 1.0, (double)y), TileEntityForceFieldProjector.clamp(-1.0, 1.0, (double)z));
    }

    @Override
    public boolean mountUpgrade(Object upgrade) {
        if (super.mountUpgrade(upgrade)) {
            this.cache_forceFieldSetup = null;
            this.isDirty.set(true);
            this.destroyForceField(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean dismountUpgrade(Object upgrade) {
        if (super.dismountUpgrade(upgrade)) {
            this.cache_forceFieldSetup = null;
            this.isDirty.set(true);
            this.destroyForceField(false);
            return true;
        }
        return false;
    }

    private String getShapeStatus() {
        EnumForceFieldShape enumForceFieldShape = this.getShape();
        String strDisplayName = StatCollector.func_74837_a((String)("warpdrive.forcefield.shape.statusLine." + enumForceFieldShape.unlocalizedName), (Object[])new Object[0]);
        if (enumForceFieldShape == EnumForceFieldShape.NONE) {
            return StatCollector.func_74837_a((String)"warpdrive.forcefield.shape.statusLine.none", (Object[])new Object[]{strDisplayName});
        }
        if (this.isDoubleSided) {
            return StatCollector.func_74837_a((String)"warpdrive.forcefield.shape.statusLine.double", (Object[])new Object[]{strDisplayName});
        }
        return StatCollector.func_74837_a((String)"warpdrive.forcefield.shape.statusLine.single", (Object[])new Object[]{strDisplayName});
    }

    @Override
    public String getStatus() {
        return super.getStatus() + "\n" + this.getShapeStatus() + "\n" + this.getUpgradeStatus();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isDoubleSided = tag.func_74767_n("isDoubleSided");
        if (tag.func_74764_b("minX")) {
            this.setMin(tag.func_74760_g("minX"), tag.func_74760_g("minY"), tag.func_74760_g("minZ"));
        } else {
            this.setMin(-1.0f, -1.0f, -1.0f);
        }
        if (tag.func_74764_b("maxX")) {
            this.setMax(tag.func_74760_g("maxX"), tag.func_74760_g("maxY"), tag.func_74760_g("maxZ"));
        } else {
            this.setMax(1.0f, 1.0f, 1.0f);
        }
        this.setRotation(tag.func_74760_g("rotationYaw"), tag.func_74760_g("rotationPitch"), tag.func_74760_g("rotationRoll"));
        this.setShape(EnumForceFieldShape.get(tag.func_74771_c("shape")));
        this.setTranslation(tag.func_74760_g("translationX"), tag.func_74760_g("translationY"), tag.func_74760_g("translationZ"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("isDoubleSided", this.isDoubleSided);
        if (this.v3Min.x != -1.0 || this.v3Min.y != -1.0 || this.v3Min.z != -1.0) {
            tag.func_74776_a("minX", (float)this.v3Min.x);
            tag.func_74776_a("minY", (float)this.v3Min.y);
            tag.func_74776_a("minZ", (float)this.v3Min.z);
        }
        if (this.v3Max.x != 1.0 || this.v3Max.y != 1.0 || this.v3Max.z != 1.0) {
            tag.func_74776_a("maxX", (float)this.v3Max.x);
            tag.func_74776_a("maxY", (float)this.v3Max.y);
            tag.func_74776_a("maxZ", (float)this.v3Max.z);
        }
        if (this.rotationYaw != 0.0f) {
            tag.func_74776_a("rotationYaw", this.rotationYaw);
        }
        if (this.rotationPitch != 0.0f) {
            tag.func_74776_a("rotationPitch", this.rotationPitch);
        }
        if (this.rotationRoll != 0.0f) {
            tag.func_74776_a("rotationRoll", this.rotationRoll);
        }
        tag.func_74774_a("shape", (byte)this.getShape().ordinal());
        if (this.v3Translation.x != 0.0 || this.v3Translation.y != 0.0 || this.v3Translation.z != 0.0) {
            tag.func_74776_a("translationX", (float)this.v3Translation.x);
            tag.func_74776_a("translationY", (float)this.v3Translation.y);
            tag.func_74776_a("translationZ", (float)this.v3Translation.z);
        }
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        tagCompound.func_74757_a("isPowered", this.isPowered);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    @Override
    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
        this.isPowered = tagCompound.func_74767_n("isPowered");
    }

    public ForceFieldSetup getForceFieldSetup() {
        if (this.cache_forceFieldSetup == null) {
            this.cache_forceFieldSetup = new ForceFieldSetup(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tier, this.beamFrequency);
            this.setupTicks = Math.max(this.setupTicks, 10);
            if (this.legacy_forceFieldSetup != null) {
                int energyRequired = (int)Math.max(0L, Math.round(this.cache_forceFieldSetup.startupEnergyCost - this.legacy_forceFieldSetup.startupEnergyCost));
                if (this.legacy_forceFieldSetup.getCamouflageBlock() != this.cache_forceFieldSetup.getCamouflageBlock() || this.legacy_forceFieldSetup.getCamouflageMetadata() != this.cache_forceFieldSetup.getCamouflageMetadata() || this.legacy_forceFieldSetup.beamFrequency != this.cache_forceFieldSetup.beamFrequency || !this.energy_consume(energyRequired, false)) {
                    if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                        WarpDrive.logger.info(this + " rebooting with new rendering...");
                    }
                    this.destroyForceField(true);
                } else if (this.legacy_forceFieldSetup.isInverted != this.cache_forceFieldSetup.isInverted || this.legacy_forceFieldSetup.shapeProvider != this.cache_forceFieldSetup.shapeProvider || this.legacy_forceFieldSetup.thickness != this.cache_forceFieldSetup.thickness || !this.legacy_forceFieldSetup.vMin.equals(this.cache_forceFieldSetup.vMin) || !this.legacy_forceFieldSetup.vMax.equals(this.cache_forceFieldSetup.vMax) || !this.legacy_forceFieldSetup.vTranslation.equals(this.cache_forceFieldSetup.vTranslation) || this.legacy_forceFieldSetup.breaking_maxHardness <= 0.0f && this.cache_forceFieldSetup.breaking_maxHardness > 0.0f) {
                    if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                        WarpDrive.logger.info(this + " rebooting with new shape...");
                    }
                    this.destroyForceField(true);
                    this.isDirty.set(true);
                }
            }
        }
        return this.cache_forceFieldSetup;
    }

    @Override
    public int energy_getMaxStorage() {
        return this.maxEnergyStored;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }

    public boolean consumeEnergy(double amount_internal, boolean simulate) {
        int intAmount = (int)Math.floor(amount_internal + this.consumptionLeftOver);
        boolean bResult = super.energy_consume(intAmount, simulate);
        if (!simulate) {
            this.consumptionLeftOver = amount_internal + this.consumptionLeftOver - (double)intAmount;
        }
        return bResult;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] min(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setMin((float)arguments.checkDouble(0), (float)arguments.checkDouble(0), (float)arguments.checkDouble(0));
        } else if (arguments.count() == 2) {
            this.setMin((float)arguments.checkDouble(0), (float)arguments.checkDouble(1), (float)arguments.checkDouble(0));
        } else if (arguments.count() == 3) {
            this.setMin((float)arguments.checkDouble(0), (float)arguments.checkDouble(1), (float)arguments.checkDouble(2));
        }
        return new Double[]{this.v3Min.x, this.v3Min.y, this.v3Min.z};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] max(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setMax((float)arguments.checkDouble(0), (float)arguments.checkDouble(0), (float)arguments.checkDouble(0));
        } else if (arguments.count() == 2) {
            this.setMax((float)arguments.checkDouble(0), (float)arguments.checkDouble(1), (float)arguments.checkDouble(0));
        } else if (arguments.count() == 3) {
            this.setMax((float)arguments.checkDouble(0), (float)arguments.checkDouble(1), (float)arguments.checkDouble(2));
        }
        return new Double[]{this.v3Max.x, this.v3Max.y, this.v3Max.z};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] rotation(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setRotation((float)arguments.checkDouble(0), this.rotationPitch, this.rotationRoll);
        } else if (arguments.count() == 2) {
            this.setRotation((float)arguments.checkDouble(0), (float)arguments.checkDouble(1), this.rotationRoll);
        } else if (arguments.count() == 3) {
            this.setRotation((float)arguments.checkDouble(0), (float)arguments.checkDouble(1), (float)arguments.checkDouble(2));
        }
        return new Float[]{Float.valueOf(this.rotationYaw), Float.valueOf(this.rotationPitch), Float.valueOf(this.rotationRoll)};
    }

    private Object[] state() {
        int energy = this.energy_getEnergyStored();
        String status = this.getStatus();
        return new Object[]{status, this.isEnabled, this.isConnected, this.isPowered, this.getShape().name(), energy};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] translation(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setTranslation((float)arguments.checkDouble(0), (float)arguments.checkDouble(0), (float)arguments.checkDouble(0));
        } else if (arguments.count() == 2) {
            this.setTranslation((float)arguments.checkDouble(0), (float)arguments.checkDouble(1), (float)arguments.checkDouble(0));
        } else if (arguments.count() == 3) {
            this.setTranslation((float)arguments.checkDouble(0), (float)arguments.checkDouble(1), (float)arguments.checkDouble(2));
        }
        return new Double[]{this.v3Translation.x, this.v3Translation.y, this.v3Translation.z};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "min": {
                if (arguments.length == 1) {
                    this.setMin(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[0]));
                } else if (arguments.length == 2) {
                    this.setMin(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[1]), TileEntityForceFieldProjector.toFloat(arguments[0]));
                } else if (arguments.length == 3) {
                    this.setMin(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[1]), TileEntityForceFieldProjector.toFloat(arguments[2]));
                }
                return new Double[]{this.v3Min.x, this.v3Min.y, this.v3Min.z};
            }
            case "max": {
                if (arguments.length == 1) {
                    this.setMax(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[0]));
                } else if (arguments.length == 2) {
                    this.setMax(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[1]), TileEntityForceFieldProjector.toFloat(arguments[0]));
                } else if (arguments.length == 3) {
                    this.setMax(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[1]), TileEntityForceFieldProjector.toFloat(arguments[2]));
                }
                return new Double[]{this.v3Max.x, this.v3Max.y, this.v3Max.z};
            }
            case "rotation": {
                if (arguments.length == 1) {
                    this.setRotation(TileEntityForceFieldProjector.toFloat(arguments[0]), this.rotationPitch, this.rotationRoll);
                } else if (arguments.length == 2) {
                    this.setRotation(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[1]), this.rotationRoll);
                } else if (arguments.length == 3) {
                    this.setRotation(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[1]), TileEntityForceFieldProjector.toFloat(arguments[2]));
                }
                return new Float[]{Float.valueOf(this.rotationYaw), Float.valueOf(this.rotationPitch), Float.valueOf(this.rotationRoll)};
            }
            case "state": {
                return this.state();
            }
            case "translation": {
                if (arguments.length == 1) {
                    this.setTranslation(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[0]));
                } else if (arguments.length == 2) {
                    this.setTranslation(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[1]), TileEntityForceFieldProjector.toFloat(arguments[0]));
                } else if (arguments.length == 3) {
                    this.setTranslation(TileEntityForceFieldProjector.toFloat(arguments[0]), TileEntityForceFieldProjector.toFloat(arguments[1]), TileEntityForceFieldProjector.toFloat(arguments[2]));
                }
                return new Double[]{this.v3Translation.x, this.v3Translation.y, this.v3Translation.z};
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    private class ThreadCalculation
    extends Thread {
        private final TileEntityForceFieldProjector projector;

        ThreadCalculation(TileEntityForceFieldProjector projector) {
            this.projector = projector;
        }

        @Override
        public void run() {
            HashSet<VectorI> vPerimeterBlocks = null;
            HashSet<VectorI> vInteriorBlocks = null;
            try {
                if (this.projector.isValid()) {
                    ForceFieldSetup forceFieldSetup = this.projector.getForceFieldSetup();
                    if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                        WarpDrive.logger.debug(this + " Calculation started for " + this.projector);
                    }
                    VectorI vScale = forceFieldSetup.vMax.clone().subtract(forceFieldSetup.vMin);
                    vInteriorBlocks = new HashSet<VectorI>(vScale.x * vScale.y * vScale.z);
                    vPerimeterBlocks = new HashSet<VectorI>(2 * vScale.x * vScale.y + 2 * vScale.x * vScale.z + 2 * vScale.y * vScale.z);
                    for (Map.Entry<VectorI, Boolean> entry : forceFieldSetup.shapeProvider.getVertexes(forceFieldSetup).entrySet()) {
                        VectorI vPosition = entry.getKey();
                        if (!forceFieldSetup.isDoubleSided && vPosition.y < 0) continue;
                        if (forceFieldSetup.rotationYaw != 0.0f || forceFieldSetup.rotationPitch != 0.0f || forceFieldSetup.rotationRoll != 0.0f) {
                            vPosition.rotateByAngle(forceFieldSetup.rotationYaw, forceFieldSetup.rotationPitch, forceFieldSetup.rotationRoll);
                        }
                        vPosition.translate(forceFieldSetup.vTranslation);
                        if (vPosition.y <= 0 || vPosition.y > this.projector.field_145850_b.func_72800_K()) continue;
                        if (entry.getValue().booleanValue()) {
                            vPerimeterBlocks.add(vPosition);
                            continue;
                        }
                        vInteriorBlocks.add(vPosition);
                    }
                    if (forceFieldSetup.isInverted) {
                        vPerimeterBlocks = new HashSet(vInteriorBlocks);
                    }
                    if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                        WarpDrive.logger.debug(this + " Calculation done: " + vInteriorBlocks.size() + " blocks inside, including " + vPerimeterBlocks.size() + " blocks to place");
                    }
                } else if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                    WarpDrive.logger.error(this + " Calculation aborted");
                }
            }
            catch (Exception exception) {
                vInteriorBlocks = null;
                vPerimeterBlocks = null;
                exception.printStackTrace();
                WarpDrive.logger.error(this + " Calculation failed");
            }
            this.projector.calculation_done(vInteriorBlocks, vPerimeterBlocks);
        }
    }
}

