/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.movement.TileEntityShipController;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Jumpgate;
import cr0s.warpdrive.data.StarMapRegistryItem;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.event.JumpSequencer;
import cr0s.warpdrive.world.SpaceTeleporter;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityShipCore
extends TileEntityAbstractEnergy {
    public int dx;
    public int dz;
    private int direction;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int minX;
    public int minY;
    public int minZ;
    public int shipMass;
    public int shipVolume;
    private EnumShipCoreMode currentMode = EnumShipCoreMode.IDLE;
    private int warmupTime = 0;
    private int cooldownTime = 0;
    private boolean isCooldownReported = false;
    protected int randomWarmupAddition = 0;
    private int chestTeleportUpdateTicks = 0;
    private final int registryUpdateInterval_ticks = 20 * WarpDriveConfig.SHIP_CORE_REGISTRY_UPDATE_INTERVAL_SECONDS;
    private int registryUpdateTicks = 0;
    private int bootTicks = 20;
    private static final int logInterval_ticks = 1200;
    private int logTicks = 120;
    public UUID uuid = null;
    public String shipName = "default";
    private int isolationBlocksCount = 0;
    public double isolationRate = 0.0;
    private int isolationUpdateTicks = 0;
    public int jumpCount = 0;
    public TileEntityShipController controller;
    private boolean soundPlayed = false;
    private static final VectorI[] vSummonOffsets = new VectorI[]{new VectorI(2, 0, 0), new VectorI(-1, 0, 0), new VectorI(2, 0, 1), new VectorI(2, 0, -1), new VectorI(-1, 0, 1), new VectorI(-1, 0, -1), new VectorI(1, 0, 1), new VectorI(1, 0, -1), new VectorI(0, 0, 1), new VectorI(0, 0, -1)};

    public TileEntityShipCore() {
        this.peripheralName = "warpdriveShipCore";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cooldownTime > 0) {
            --this.cooldownTime;
            this.warmupTime = 0;
            if (this.cooldownTime == 0 && this.controller != null) {
                this.controller.cooldownDone();
            }
        }
        if (this.cooldownTime > 0) {
            if (this.func_145832_p() != 2) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 3);
            }
        } else if (this.controller == null) {
            if (this.func_145832_p() != 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            }
        } else if (this.controller.isJumpFlag() || this.controller.isSummonAllFlag() || !this.controller.getToSummon().isEmpty()) {
            if (this.func_145832_p() != 1) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
            }
        } else if (this.func_145832_p() != 0) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        }
        if (this.bootTicks > 0) {
            --this.bootTicks;
            if (this.controller == null) {
                this.registryUpdateTicks = 1;
            }
        }
        --this.registryUpdateTicks;
        if (this.registryUpdateTicks <= 0) {
            this.registryUpdateTicks = this.registryUpdateInterval_ticks;
            if (this.uuid == null || this.uuid.getMostSignificantBits() == 0L && this.uuid.getLeastSignificantBits() == 0L) {
                this.uuid = UUID.randomUUID();
            }
            WarpDrive.starMap.updateInRegistry(new StarMapRegistryItem(this));
            TileEntity controllerFound = this.findControllerBlock();
            if (controllerFound == null) {
                this.controller = null;
                this.warmupTime = 0;
                this.soundPlayed = false;
                return;
            }
            this.controller = (TileEntityShipController)controllerFound;
        }
        --this.logTicks;
        if (this.logTicks <= 0) {
            this.logTicks = 1200;
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " controller is " + this.controller + ", warmupTime " + this.warmupTime + ", currentMode " + (Object)((Object)this.currentMode) + ", jumpFlag " + (this.controller == null ? "NA" : Boolean.valueOf(this.controller.isJumpFlag())) + ", cooldownTime " + this.cooldownTime);
            }
        }
        ++this.isolationUpdateTicks;
        if (this.isolationUpdateTicks > WarpDriveConfig.SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS * 20) {
            this.isolationUpdateTicks = 0;
            this.updateIsolationState();
        }
        if (this.controller == null) {
            return;
        }
        this.currentMode = this.controller.getMode();
        StringBuilder reason = new StringBuilder();
        if (this.controller.isJumpFlag() && this.isolationUpdateTicks == 1 || this.controller.isSummonAllFlag() || !this.controller.getToSummon().isEmpty()) {
            if (!this.validateShipSpatialParameters(reason)) {
                if (this.controller.isJumpFlag()) {
                    this.controller.setJumpFlag(false);
                    this.messageToAllPlayersOnShip(reason.toString());
                }
                this.warmupTime = 0;
                this.soundPlayed = false;
                return;
            }
            if (this.controller.isSummonAllFlag()) {
                this.summonPlayers();
                this.controller.setSummonAllFlag(false);
            } else if (!this.controller.getToSummon().isEmpty()) {
                this.summonSinglePlayer(this.controller.getToSummon());
                this.controller.setToSummon("");
            }
        }
        switch (this.currentMode) {
            case TELEPORT: {
                if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    if (this.isChestSummonMode().booleanValue()) {
                        ++this.chestTeleportUpdateTicks;
                        if (this.chestTeleportUpdateTicks < 20) break;
                        this.summonPlayersByChestCode();
                        this.chestTeleportUpdateTicks = 0;
                        break;
                    }
                    this.teleportPlayersToSpace();
                    break;
                }
                this.chestTeleportUpdateTicks = 0;
                break;
            }
            case BASIC_JUMP: 
            case LONG_JUMP: 
            case BEACON_JUMP: 
            case HYPERSPACE: 
            case GATE_JUMP: {
                if (this.controller.isJumpFlag()) {
                    String soundFile;
                    int soundThreshold;
                    int targetWarmup;
                    switch (this.currentMode) {
                        case BASIC_JUMP: 
                        case LONG_JUMP: {
                            if (this.controller.getDistance() < 50) {
                                targetWarmup = WarpDriveConfig.SHIP_SHORTJUMP_WARMUP_SECONDS * 20;
                                break;
                            }
                            targetWarmup = WarpDriveConfig.SHIP_LONGJUMP_WARMUP_SECONDS * 20;
                            break;
                        }
                        default: {
                            targetWarmup = WarpDriveConfig.SHIP_LONGJUMP_WARMUP_SECONDS * 20;
                        }
                    }
                    if (targetWarmup < 200) {
                        soundThreshold = targetWarmup - 80;
                        soundFile = "warpdrive:warp_4s";
                    } else if (targetWarmup > 580) {
                        soundThreshold = targetWarmup - 600;
                        soundFile = "warpdrive:warp_30s";
                    } else {
                        soundThreshold = targetWarmup - 200;
                        soundFile = "warpdrive:warp_10s";
                    }
                    soundThreshold += this.randomWarmupAddition;
                    if (this.cooldownTime > 0) {
                        if (this.cooldownTime % 20 == 0) {
                            int seconds = this.cooldownTime / 20;
                            if (!this.isCooldownReported || seconds < 5 || seconds < 30 && seconds % 5 == 0 || seconds % 10 == 0) {
                                this.isCooldownReported = true;
                                this.messageToAllPlayersOnShip("Warp core is cooling down... " + seconds + "s to go...");
                            }
                        }
                        return;
                    }
                    if (this.warmupTime == 0) {
                        this.messageToAllPlayersOnShip("Running pre-jump checklist...");
                        if (!this.validateShipSpatialParameters(reason)) {
                            this.controller.setJumpFlag(false);
                            this.messageToAllPlayersOnShip(reason.toString());
                            return;
                        }
                        if (WarpDriveConfig.SHIP_WARMUP_SICKNESS) {
                            if (WarpDriveConfig.LOGGING_JUMP) {
                                WarpDrive.logger.info(this + " Giving warp sickness targetWarmup " + targetWarmup + " distance " + this.controller.getDistance());
                            }
                            this.makePlayersOnShipDrunk(targetWarmup + WarpDriveConfig.SHIP_WARMUP_RANDOM_TICKS);
                        }
                    }
                    if (!this.soundPlayed && soundThreshold > this.warmupTime) {
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info(this + " Playing sound effect '" + soundFile + "' soundThreshold " + soundThreshold + " warmupTime " + this.warmupTime);
                        }
                        this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), soundFile, 4.0f, 1.0f);
                        this.soundPlayed = true;
                    }
                    if (this.warmupTime < targetWarmup + this.randomWarmupAddition) {
                        ++this.warmupTime;
                        return;
                    }
                    this.warmupTime = 0;
                    this.soundPlayed = false;
                    if (!this.validateShipSpatialParameters(reason)) {
                        this.controller.setJumpFlag(false);
                        this.messageToAllPlayersOnShip(reason.toString());
                        return;
                    }
                    if (WarpDrive.starMap.isWarpCoreIntersectsWithOthers(this)) {
                        this.controller.setJumpFlag(false);
                        this.messageToAllPlayersOnShip("Warp field intersects with other ship's field. Cannot jump.");
                        return;
                    }
                    if (WarpDrive.cloaks.isCloaked(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                        this.controller.setJumpFlag(false);
                        this.messageToAllPlayersOnShip("Core is inside a cloaking field. Aborting. Disable cloaking field to jump!");
                        return;
                    }
                    this.doJump();
                    this.cooldownTime = Math.max(1, WarpDriveConfig.SHIP_COOLDOWN_INTERVAL_SECONDS * 20);
                    this.isCooldownReported = false;
                    this.controller.setJumpFlag(false);
                    ++this.jumpCount;
                    break;
                }
                this.warmupTime = 0;
                break;
            }
        }
    }

    public void messageToAllPlayersOnShip(String msg) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)((double)this.maxX + 0.99), (double)((double)this.maxY + 0.99), (double)((double)this.maxZ + 0.99));
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        WarpDrive.logger.info(this + " messageToAllPlayersOnShip: " + msg);
        for (Object object : list) {
            if (!(object instanceof EntityPlayer)) continue;
            WarpDrive.addChatMessage((ICommandSender)((EntityPlayer)object), "[" + (!this.shipName.isEmpty() ? this.shipName : "ShipCore") + "] " + msg);
        }
    }

    private void updateIsolationState() {
        int xMin = this.field_145851_c - WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int xMax = this.field_145851_c + WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int zMin = this.field_145849_e - WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int zMax = this.field_145849_e + WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int yMin = Math.max(0, this.field_145848_d - WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE + 1);
        int yMax = Math.min(255, this.field_145848_d + WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE + 1);
        int newCount = 0;
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!this.field_145850_b.func_147439_a(x, y, z).func_149667_c(WarpDrive.blockWarpIsolation)) continue;
                    ++newCount;
                }
            }
        }
        this.isolationBlocksCount = newCount;
        this.isolationRate = this.isolationBlocksCount >= WarpDriveConfig.RADAR_MIN_ISOLATION_BLOCKS ? Math.min(1.0, WarpDriveConfig.RADAR_MIN_ISOLATION_EFFECT + (double)(this.isolationBlocksCount - WarpDriveConfig.RADAR_MIN_ISOLATION_BLOCKS) * (WarpDriveConfig.RADAR_MAX_ISOLATION_EFFECT - WarpDriveConfig.RADAR_MIN_ISOLATION_EFFECT) / (double)(WarpDriveConfig.RADAR_MAX_ISOLATION_BLOCKS - WarpDriveConfig.RADAR_MIN_ISOLATION_BLOCKS)) : 0.0;
        if (WarpDriveConfig.LOGGING_RADAR) {
            WarpDrive.logger.info(this + " Isolation updated to " + this.isolationBlocksCount + " (" + String.format("%.1f", this.isolationRate * 100.0) + "%)");
        }
    }

    private void makePlayersOnShipDrunk(int tickDuration) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        for (Object object : list) {
            if (object == null || !(object instanceof EntityPlayer)) continue;
            ((EntityPlayer)object).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, tickDuration, 0, true));
        }
    }

    private void summonPlayers() {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        for (int i = 0; i < this.controller.players.size(); ++i) {
            String nick = this.controller.players.get(i);
            EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(nick);
            if (player == null || !TileEntityShipCore.isOutsideBB(aabb, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v))) continue;
            this.summonPlayer(player);
        }
    }

    private void summonSinglePlayer(String nickname) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        for (int i = 0; i < this.controller.players.size(); ++i) {
            String nick = this.controller.players.get(i);
            EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(nick);
            if (player == null || !nick.equals(nickname) || !TileEntityShipCore.isOutsideBB(aabb, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v))) continue;
            this.summonPlayer(player);
            return;
        }
    }

    public void summonOwnerOnDeploy(String playerName) {
        EntityPlayerMP entityPlayerMP = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playerName);
        StringBuilder reason = new StringBuilder();
        if (!this.validateShipSpatialParameters(reason)) {
            WarpDrive.addChatMessage((ICommandSender)entityPlayerMP, "[" + (!this.shipName.isEmpty() ? this.shipName : "ShipCore") + "] \u00c2\u00a7c" + reason.toString());
            return;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        TileEntity controllerFound = this.findControllerBlock();
        if (controllerFound != null) {
            this.controller = (TileEntityShipController)controllerFound;
            this.controller.players.clear();
            this.controller.players.add(playerName);
        }
        if (entityPlayerMP != null && TileEntityShipCore.isOutsideBB(aabb, MathHelper.func_76128_c((double)entityPlayerMP.field_70165_t), MathHelper.func_76128_c((double)entityPlayerMP.field_70163_u), MathHelper.func_76128_c((double)entityPlayerMP.field_70161_v))) {
            this.summonPlayer(entityPlayerMP);
        }
    }

    private void summonPlayer(EntityPlayerMP entityPlayer) {
        double distance = Math.sqrt(new VectorI((Entity)entityPlayer).distance2To(this));
        if (entityPlayer.field_70170_p != this.field_145850_b) {
            distance += 256.0;
            if (!WarpDriveConfig.SHIP_SUMMON_ACROSS_DIMENSIONS) {
                this.messageToAllPlayersOnShip("\u00c2\u00a7c" + String.format("%1$s is in a different dimension, too far away to be summoned", entityPlayer.getDisplayName()));
                return;
            }
        }
        if (WarpDriveConfig.SHIP_SUMMON_MAX_RANGE >= 0 && distance > (double)WarpDriveConfig.SHIP_SUMMON_MAX_RANGE) {
            this.messageToAllPlayersOnShip("\u00c2\u00a7c" + String.format("%1$s is too far away to be summoned (max. is %2$d m)", entityPlayer.getDisplayName(), WarpDriveConfig.SHIP_SUMMON_MAX_RANGE));
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a7c" + String.format("You are to far away to be summoned aboard '%1$s' (max. is %2$d m)", this.shipName, WarpDriveConfig.SHIP_SUMMON_MAX_RANGE));
            return;
        }
        for (VectorI vOffset : vSummonOffsets) {
            VectorI vPosition = new VectorI(this.field_145851_c + this.dx * vOffset.x + this.dz * vOffset.z, this.field_145848_d, this.field_145849_e + this.dz * vOffset.x + this.dx * vOffset.z);
            if (!this.field_145850_b.func_147437_c(vPosition.x, vPosition.y, vPosition.z) || !this.field_145850_b.func_147437_c(vPosition.x, vPosition.y + 1, vPosition.z)) continue;
            this.summonPlayer(entityPlayer, vPosition.x, vPosition.y, vPosition.z);
            return;
        }
        this.messageToAllPlayersOnShip("\u00c2\u00a7c" + String.format("No safe spot found to summon player %1$s", entityPlayer.getDisplayName()));
    }

    private void summonPlayer(EntityPlayerMP player, int x, int y, int z) {
        if (this.energy_consume(WarpDriveConfig.SHIP_TELEPORT_ENERGY_PER_ENTITY, false)) {
            if (player.field_71093_bK != this.field_145850_b.field_73011_w.field_76574_g) {
                player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, this.field_145850_b.field_73011_w.field_76574_g, (Teleporter)new SpaceTeleporter(DimensionManager.getWorld((int)this.field_145850_b.field_73011_w.field_76574_g), 0, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v)));
                player.func_70634_a((double)x + 0.5, (double)y, (double)z + 0.5);
                player.func_71016_p();
            } else {
                player.func_70634_a((double)x + 0.5, (double)y, (double)z + 0.5);
            }
        }
    }

    public boolean validateShipSpatialParameters(StringBuilder reason) {
        if (this.controller == null) {
            reason.append("TileEntityReactor.validateShipSpatialParameters: no controller detected!");
            return false;
        }
        this.direction = this.controller.getDirection();
        int shipFront = this.controller.getFront();
        int shipRight = this.controller.getRight();
        int shipUp = this.controller.getUp();
        int shipBack = this.controller.getBack();
        int shipLeft = this.controller.getLeft();
        int shipDown = this.controller.getDown();
        int x1 = 0;
        int x2 = 0;
        int z1 = 0;
        int z2 = 0;
        if (Math.abs(this.dx) > 0) {
            if (this.dx == 1) {
                x1 = this.field_145851_c - shipBack;
                x2 = this.field_145851_c + shipFront;
                z1 = this.field_145849_e - shipLeft;
                z2 = this.field_145849_e + shipRight;
            } else {
                x1 = this.field_145851_c - shipFront;
                x2 = this.field_145851_c + shipBack;
                z1 = this.field_145849_e - shipRight;
                z2 = this.field_145849_e + shipLeft;
            }
        } else if (Math.abs(this.dz) > 0) {
            if (this.dz == 1) {
                z1 = this.field_145849_e - shipBack;
                z2 = this.field_145849_e + shipFront;
                x1 = this.field_145851_c - shipRight;
                x2 = this.field_145851_c + shipLeft;
            } else {
                z1 = this.field_145849_e - shipFront;
                z2 = this.field_145849_e + shipBack;
                x1 = this.field_145851_c - shipLeft;
                x2 = this.field_145851_c + shipRight;
            }
        }
        if (x1 < x2) {
            this.minX = x1;
            this.maxX = x2;
        } else {
            this.minX = x2;
            this.maxX = x1;
        }
        if (z1 < z2) {
            this.minZ = z1;
            this.maxZ = z2;
        } else {
            this.minZ = z2;
            this.maxZ = z1;
        }
        this.minY = this.field_145848_d - shipDown;
        this.maxY = this.field_145848_d + shipUp;
        if (shipBack + shipFront > WarpDriveConfig.SHIP_MAX_SIDE_SIZE || shipLeft + shipRight > WarpDriveConfig.SHIP_MAX_SIDE_SIZE || shipDown + shipUp > WarpDriveConfig.SHIP_MAX_SIDE_SIZE) {
            reason.append("Ship is too big (max is " + WarpDriveConfig.SHIP_MAX_SIDE_SIZE + " per side)");
            return false;
        }
        boolean isUnlimited = false;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)((double)this.maxX + 0.99), (double)((double)this.maxY + 0.99), (double)((double)this.maxZ + 0.99));
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        for (Object object : list) {
            if (object == null || !(object instanceof EntityPlayer)) continue;
            String playerName = ((EntityPlayer)object).getDisplayName();
            for (String unlimitedName : WarpDriveConfig.SHIP_VOLUME_UNLIMITED_PLAYERNAMES) {
                isUnlimited = isUnlimited || unlimitedName.equals(playerName);
            }
        }
        this.updateShipMassAndVolume();
        if (!isUnlimited && this.shipMass > WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE && this.isOnPlanet()) {
            reason.append("Ship is too big for a planet (max is " + WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE + " blocks)");
            return false;
        }
        return true;
    }

    private void doBeaconJump() {
        String freq = this.controller.getBeaconFrequency();
        int beaconX = 0;
        int beaconZ = 0;
        boolean isBeaconFound = false;
        for (int i = 0; i < MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.size(); ++i) {
            TileEntity tileEntity;
            EntityPlayerMP player = (EntityPlayerMP)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.get(i);
            if (player.field_71093_bK != this.field_145850_b.field_73011_w.field_76574_g || (tileEntity = this.field_145850_b.func_147438_o(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u) - 1, MathHelper.func_76128_c((double)player.field_70161_v))) == null || !(tileEntity instanceof TileEntityShipController) || !((TileEntityShipController)tileEntity).getBeaconFrequency().equals(freq)) continue;
            beaconX = tileEntity.field_145851_c;
            beaconZ = tileEntity.field_145849_e;
            isBeaconFound = true;
            break;
        }
        if (isBeaconFound) {
            if (this.energy_consume(TileEntityShipCore.calculateRequiredEnergy(this.currentMode, this.shipMass, this.controller.getDistance()), false)) {
                WarpDrive.logger.info(this + " Moving ship to beacon (" + beaconX + "; " + this.field_145848_d + "; " + beaconZ + ")");
                JumpSequencer jump = new JumpSequencer(this, false, 0, 0, 0, 0, true, beaconX, this.field_145848_d, beaconZ);
                jump.enable();
            } else {
                this.messageToAllPlayersOnShip("Insufficient energy level");
            }
        } else {
            WarpDrive.logger.info(this + " Beacon '" + freq + "' is unknown.");
        }
    }

    private boolean isShipInJumpgate(Jumpgate jumpgate, StringBuilder reason) {
        AxisAlignedBB aabb = jumpgate.getGateAABB();
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Jumpgate " + jumpgate.name + " AABB is " + aabb);
        }
        int countBlocksInside = 0;
        int countBlocksTotal = 0;
        if (aabb.func_72318_a(Vec3.func_72443_a((double)this.minX, (double)this.minY, (double)this.minZ)) && aabb.func_72318_a(Vec3.func_72443_a((double)this.maxX, (double)this.maxY, (double)this.maxZ))) {
            return true;
        }
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    if (block == Blocks.field_150350_a || Dictionary.BLOCKS_LEFTBEHIND.contains(block) || Dictionary.BLOCKS_NOMASS.contains(block)) continue;
                    if (aabb.field_72340_a <= (double)x && aabb.field_72336_d >= (double)x && aabb.field_72338_b <= (double)y && aabb.field_72337_e >= (double)y && aabb.field_72339_c <= (double)z && aabb.field_72334_f >= (double)z) {
                        ++countBlocksInside;
                    }
                    ++countBlocksTotal;
                }
            }
        }
        float percent = 0.0f;
        if (this.shipMass != 0) {
            percent = (float)Math.round((float)countBlocksInside * 1.0f / (float)this.shipMass * 100.0f * 10.0f) / 10.0f;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            if (this.shipMass != countBlocksTotal) {
                WarpDrive.logger.info(this + " Ship mass has changed from " + this.shipMass + " to " + countBlocksTotal + " blocks");
            }
            WarpDrive.logger.info(this + "Ship has " + countBlocksInside + " / " + this.shipMass + " blocks (" + percent + "%) in jumpgate '" + jumpgate.name + "'");
        }
        if (percent > 80.0f) {
            return true;
        }
        if ((double)percent <= 0.001) {
            reason.append("Ship is not inside a jumpgate. Jump rejected. Nearest jumpgate is " + jumpgate.toNiceString());
            return false;
        }
        reason.append("Ship is only " + percent + "% inside a jumpgate. Sorry, we'll loose too much crew as is, jump rejected.");
        return false;
    }

    private boolean isFreePlaceForShip(int destX, int destY, int destZ) {
        if (this.controller == null || destY + this.controller.getUp() > 255 || destY - this.controller.getDown() < 5) {
            return false;
        }
        int moveX = destX - this.field_145851_c;
        int moveY = destY - this.field_145848_d;
        int moveZ = destZ - this.field_145849_e;
        for (int x = this.minX; x <= this.maxX; ++x) {
            int newX = moveX + x;
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                int newZ = moveZ + z;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    Block blockSource = this.field_145850_b.func_147439_a(x, y, z);
                    Block blockTarget = this.field_145850_b.func_147439_a(newX, moveY + y, newZ);
                    if (blockSource == Blocks.field_150350_a || Dictionary.BLOCKS_EXPANDABLE.contains(blockSource) || blockTarget == Blocks.field_150350_a || Dictionary.BLOCKS_EXPANDABLE.contains(blockTarget)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void doGateJump() {
        StringBuilder reason;
        String gateName = this.controller.getTargetJumpgateName();
        Jumpgate targetGate = WarpDrive.jumpgates.findGateByName(gateName);
        if (targetGate == null) {
            this.messageToAllPlayersOnShip("Destination jumpgate '" + gateName + "' is unknown. Check jumpgate name.");
            this.controller.setJumpFlag(false);
            return;
        }
        int gateX = targetGate.xCoord;
        int gateY = targetGate.yCoord;
        int gateZ = targetGate.zCoord;
        int destX = gateX;
        int destY = gateY;
        int destZ = gateZ;
        Jumpgate nearestGate = WarpDrive.jumpgates.findNearestGate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.isShipInJumpgate(nearestGate, reason = new StringBuilder())) {
            this.messageToAllPlayersOnShip(reason.toString());
            this.controller.setJumpFlag(false);
            return;
        }
        if (!this.isFreePlaceForShip(gateX, gateY, gateZ)) {
            int numTries;
            boolean placeFound = false;
            for (numTries = 10; numTries > 0; --numTries) {
                destX = gateX + (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1) * (20 + this.field_145850_b.field_73012_v.nextInt(100));
                destZ = gateZ + (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1) * (20 + this.field_145850_b.field_73012_v.nextInt(100));
                destY = gateY + (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1) * (20 + this.field_145850_b.field_73012_v.nextInt(50));
                if (!this.isFreePlaceForShip(destX, destY, destZ)) continue;
                placeFound = true;
                break;
            }
            if (!placeFound) {
                this.messageToAllPlayersOnShip("Destination gate is blocked by obstacles. Aborting...");
                this.controller.setJumpFlag(false);
                return;
            }
            WarpDrive.logger.info("[GATE] Place found over " + (10 - numTries) + " tries.");
        }
        if (this.energy_consume(TileEntityShipCore.calculateRequiredEnergy(this.currentMode, this.shipMass, this.controller.getDistance()), false)) {
            WarpDrive.logger.info(this + " Moving ship to a place around gate '" + targetGate.name + "' (" + destX + "; " + destY + "; " + destZ + ")");
            JumpSequencer jump = new JumpSequencer(this, false, 0, 0, 0, 0, true, destX, destY, destZ);
            jump.enable();
        } else {
            this.messageToAllPlayersOnShip("Insufficient energy level");
        }
    }

    private void doJump() {
        int distance = this.controller.getDistance();
        int requiredEnergy = TileEntityShipCore.calculateRequiredEnergy(this.currentMode, this.shipMass, distance);
        if (!this.energy_consume(requiredEnergy, true)) {
            this.messageToAllPlayersOnShip("Insufficient energy to jump! Core is currently charged with " + this.energy_getEnergyStored() + " EU while jump requires " + requiredEnergy + " EU");
            this.controller.setJumpFlag(false);
            return;
        }
        String shipInfo = "" + this.shipVolume + " blocks inside (" + this.minX + ", " + this.minY + ", " + this.minZ + ") to (" + this.maxX + ", " + this.maxY + ", " + this.maxZ + ") with an actual mass of " + this.shipMass + " blocks";
        if (this.currentMode == EnumShipCoreMode.GATE_JUMP) {
            WarpDrive.logger.info(this + " Performing gate jump of " + shipInfo);
            this.doGateJump();
            return;
        }
        if (this.currentMode == EnumShipCoreMode.BEACON_JUMP) {
            WarpDrive.logger.info(this + " Performing beacon jump of " + shipInfo);
            this.doBeaconJump();
            return;
        }
        if (this.currentMode == EnumShipCoreMode.HYPERSPACE) {
            WarpDrive.logger.info(this + " Performing hyperspace jump of " + shipInfo);
            if (this.shipMass < WarpDriveConfig.SHIP_VOLUME_MIN_FOR_HYPERSPACE) {
                Jumpgate nearestGate = null;
                if (WarpDrive.jumpgates == null) {
                    WarpDrive.logger.warn(this + " WarpDrive.instance.jumpGates is NULL!");
                } else {
                    nearestGate = WarpDrive.jumpgates.findNearestGate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                StringBuilder reason = new StringBuilder();
                if (nearestGate == null || !this.isShipInJumpgate(nearestGate, reason)) {
                    this.messageToAllPlayersOnShip("Ship is too small (" + this.shipMass + "/" + WarpDriveConfig.SHIP_VOLUME_MIN_FOR_HYPERSPACE + ").\nInsufficient ship mass to open hyperspace portal.\nUse a jumpgate to reach or exit hyperspace.");
                    this.controller.setJumpFlag(false);
                    return;
                }
            }
        } else if (this.currentMode == EnumShipCoreMode.BASIC_JUMP) {
            WarpDrive.logger.info(this + " Performing basic jump of " + shipInfo + " toward direction " + this.direction + " over " + distance + " blocks.");
        } else if (this.currentMode == EnumShipCoreMode.LONG_JUMP) {
            WarpDrive.logger.info(this + " Performing long jump of " + shipInfo + " toward direction " + this.direction + " over " + distance + " blocks.");
        } else {
            WarpDrive.logger.info(this + " Performing some jump #" + (Object)((Object)this.currentMode) + " of " + shipInfo);
        }
        if (this.currentMode == EnumShipCoreMode.BASIC_JUMP || this.currentMode == EnumShipCoreMode.LONG_JUMP || this.currentMode == EnumShipCoreMode.HYPERSPACE) {
            if (!this.energy_consume(requiredEnergy, false)) {
                this.messageToAllPlayersOnShip("Insufficient energy level");
                return;
            }
            int moveX = 0;
            int moveY = 0;
            int moveZ = 0;
            if (this.currentMode != EnumShipCoreMode.HYPERSPACE) {
                VectorI movement = this.controller.getMovement();
                moveX = this.dx * movement.x - this.dz * movement.z;
                moveY = movement.y;
                moveZ = this.dz * movement.x + this.dx * movement.z;
                if (this.currentMode != EnumShipCoreMode.BASIC_JUMP && this.currentMode == EnumShipCoreMode.LONG_JUMP) {
                    moveX *= 100;
                    moveZ *= 100;
                }
            }
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " Movement adjusted to (" + moveX + " " + moveY + " " + moveZ + ") blocks.");
            }
            JumpSequencer jump = new JumpSequencer(this, this.currentMode == EnumShipCoreMode.HYPERSPACE, moveX, moveY, moveZ, this.controller.getRotationSteps(), false, 0, 0, 0);
            jump.enable();
        }
    }

    private void teleportPlayersToSpace() {
        if (this.field_145850_b.field_73011_w.field_76574_g != WarpDriveConfig.G_SPACE_DIMENSION_ID) {
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 2));
            List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
            WorldServer spaceWorld = MinecraftServer.func_71276_C().func_71218_a(WarpDriveConfig.G_SPACE_DIMENSION_ID);
            if (spaceWorld == null) {
                String msg = "Unable to load Space dimension " + WarpDriveConfig.G_SPACE_DIMENSION_ID + ", aborting teleportation.";
                this.messageToAllPlayersOnShip(msg);
                return;
            }
            for (Object o : list) {
                int newY;
                if (!this.energy_consume(WarpDriveConfig.SHIP_TELEPORT_ENERGY_PER_ENTITY, false)) {
                    return;
                }
                Entity entity = (Entity)o;
                int x = MathHelper.func_76128_c((double)entity.field_70165_t);
                int z = MathHelper.func_76128_c((double)entity.field_70161_v);
                for (newY = 254; newY > 0 && !spaceWorld.func_147439_a(x, newY, z).func_149667_c(Blocks.field_150325_L); --newY) {
                }
                if (newY <= 0) {
                    newY = 254;
                }
                if (!(entity instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)entity).field_71133_b.func_71203_ab().transferPlayerToDimension((EntityPlayerMP)entity, WarpDriveConfig.G_SPACE_DIMENSION_ID, (Teleporter)new SpaceTeleporter(DimensionManager.getWorld((int)WarpDriveConfig.G_SPACE_DIMENSION_ID), 0, x, 256, z));
                if (spaceWorld.func_147437_c(x, newY, z)) {
                    spaceWorld.func_147465_d(x, newY, z, Blocks.field_150348_b, 0, 2);
                    spaceWorld.func_147465_d(x + 1, newY, z, Blocks.field_150348_b, 0, 2);
                    spaceWorld.func_147465_d(x - 1, newY, z, Blocks.field_150348_b, 0, 2);
                    spaceWorld.func_147465_d(x, newY, z + 1, Blocks.field_150348_b, 0, 2);
                    spaceWorld.func_147465_d(x, newY, z - 1, Blocks.field_150348_b, 0, 2);
                    spaceWorld.func_147465_d(x + 1, newY, z + 1, Blocks.field_150348_b, 0, 2);
                    spaceWorld.func_147465_d(x - 1, newY, z - 1, Blocks.field_150348_b, 0, 2);
                    spaceWorld.func_147465_d(x + 1, newY, z - 1, Blocks.field_150348_b, 0, 2);
                    spaceWorld.func_147465_d(x - 1, newY, z + 1, Blocks.field_150348_b, 0, 2);
                }
                ((EntityPlayerMP)entity).func_70634_a((double)x + 0.5, (double)newY + 2.0, (double)z + 0.5);
                ((EntityPlayerMP)entity).func_71016_p();
            }
        }
    }

    private void summonPlayersByChestCode() {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == null) {
            return;
        }
        TileEntityChest chest = (TileEntityChest)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        for (int i = 0; i < MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.size(); ++i) {
            EntityPlayerMP player = (EntityPlayerMP)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.get(i);
            if (!TileEntityShipCore.checkPlayerInventory(chest, player)) continue;
            WarpDrive.logger.info(this + " Summoning " + player.getDisplayName());
            this.summonPlayer(player, this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        }
    }

    private static boolean checkPlayerInventory(TileEntityChest chest, EntityPlayerMP player) {
        Boolean result = false;
        int MIN_KEY_LENGTH = 5;
        int keyLength = 0;
        for (int index = 0; index < chest.func_70302_i_(); ++index) {
            ItemStack chestItem = chest.func_70301_a(index);
            ItemStack playerItem = player.field_71071_by.func_70301_a(9 + index);
            if (chestItem == null) continue;
            if (playerItem == null || chestItem != playerItem || chestItem.func_77960_j() != playerItem.func_77960_j() || chestItem.field_77994_a != playerItem.field_77994_a) {
                return false;
            }
            result = true;
            ++keyLength;
        }
        if (keyLength < 5) {
            WarpDrive.logger.info("[ChestCode] Key is too short: " + keyLength + " < " + 5);
            return false;
        }
        return result;
    }

    private Boolean isChestSummonMode() {
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (tileEntity != null) {
            return tileEntity instanceof TileEntityChest;
        }
        return false;
    }

    private static boolean isOutsideBB(AxisAlignedBB axisalignedbb, int x, int y, int z) {
        return axisalignedbb.field_72340_a > (double)x || axisalignedbb.field_72336_d < (double)x || axisalignedbb.field_72338_b > (double)y || axisalignedbb.field_72337_e < (double)y || axisalignedbb.field_72339_c > (double)z || axisalignedbb.field_72334_f < (double)z;
    }

    @Override
    public String getStatus() {
        return super.getStatus() + (this.cooldownTime > 0 ? "\n" + StatCollector.func_74837_a((String)"warpdrive.ship.statusLine.cooling", (Object[])new Object[]{this.cooldownTime / 20}) : "") + (this.isolationBlocksCount > 0 ? "\n" + StatCollector.func_74837_a((String)"warpdrive.ship.statusLine.isolation", (Object[])new Object[]{this.isolationBlocksCount, this.isolationRate * 100.0}) : "");
    }

    public static int calculateRequiredEnergy(EnumShipCoreMode enumShipCoreMode, int shipVolume, int jumpDistance) {
        switch (enumShipCoreMode) {
            case TELEPORT: {
                return WarpDriveConfig.SHIP_TELEPORT_ENERGY_PER_ENTITY;
            }
            case BASIC_JUMP: {
                return WarpDriveConfig.SHIP_NORMALJUMP_ENERGY_PER_BLOCK * shipVolume + WarpDriveConfig.SHIP_NORMALJUMP_ENERGY_PER_DISTANCE * jumpDistance;
            }
            case LONG_JUMP: {
                return WarpDriveConfig.SHIP_HYPERJUMP_ENERGY_PER_BLOCK * shipVolume + WarpDriveConfig.SHIP_HYPERJUMP_ENERGY_PER_DISTANCE * jumpDistance;
            }
            case HYPERSPACE: {
                return WarpDriveConfig.SHIP_MAX_ENERGY_STORED / 10;
            }
            case BEACON_JUMP: {
                return WarpDriveConfig.SHIP_MAX_ENERGY_STORED / 2;
            }
            case GATE_JUMP: {
                return 2 * shipVolume;
            }
        }
        return WarpDriveConfig.SHIP_MAX_ENERGY_STORED;
    }

    private void updateShipMassAndVolume() {
        int newMass = 0;
        int newVolume = 0;
        try {
            for (int x = this.minX; x <= this.maxX; ++x) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    for (int y = this.minY; y <= this.maxY; ++y) {
                        Block block = this.field_145850_b.func_147439_a(x, y, z);
                        if (block == Blocks.field_150350_a || Dictionary.BLOCKS_LEFTBEHIND.contains(block)) continue;
                        ++newVolume;
                        if (Dictionary.BLOCKS_NOMASS.contains(block)) continue;
                        ++newMass;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.shipMass = newMass;
        this.shipVolume = newVolume;
    }

    private TileEntity findControllerBlock() {
        TileEntity result = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        if (result != null && result instanceof TileEntityShipController) {
            this.dx = 1;
            this.dz = 0;
            return result;
        }
        result = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        if (result != null && result instanceof TileEntityShipController) {
            this.dx = -1;
            this.dz = 0;
            return result;
        }
        result = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        if (result != null && result instanceof TileEntityShipController) {
            this.dx = 0;
            this.dz = 1;
            return result;
        }
        result = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        if (result != null && result instanceof TileEntityShipController) {
            this.dx = 0;
            this.dz = -1;
            return result;
        }
        return null;
    }

    public int getCooldown() {
        return this.cooldownTime;
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.SHIP_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.uuid = new UUID(tag.func_74763_f("uuidMost"), tag.func_74763_f("uuidLeast"));
        if (this.uuid.getMostSignificantBits() == 0L && this.uuid.getLeastSignificantBits() == 0L) {
            this.uuid = UUID.randomUUID();
        }
        this.shipName = tag.func_74779_i("corefrequency") + tag.func_74779_i("shipName");
        this.isolationBlocksCount = tag.func_74762_e("isolation");
        this.cooldownTime = tag.func_74762_e("cooldownTime");
        this.jumpCount = tag.func_74762_e("jumpCount");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.uuid != null) {
            tag.func_74772_a("uuidMost", this.uuid.getMostSignificantBits());
            tag.func_74772_a("uuidLeast", this.uuid.getLeastSignificantBits());
        }
        tag.func_74778_a("shipName", this.shipName);
        tag.func_74768_a("isolation", this.isolationBlocksCount);
        tag.func_74768_a("cooldownTime", this.cooldownTime);
        tag.func_74768_a("jumpCount", this.jumpCount);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        WarpDrive.starMap.updateInRegistry(new StarMapRegistryItem(this));
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            WarpDrive.starMap.removeFromRegistry(new StarMapRegistryItem(this));
        }
        super.func_145843_s();
    }

    public String toString() {
        return String.format("%s '%s' @ '%s' (%d %d %d)", this.getClass().getSimpleName(), this.shipName, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static enum EnumShipCoreMode {
        IDLE(0),
        BASIC_JUMP(1),
        LONG_JUMP(2),
        TELEPORT(3),
        BEACON_JUMP(4),
        HYPERSPACE(5),
        GATE_JUMP(6);

        private final int code;

        private EnumShipCoreMode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

