/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.weapon;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.block.TileEntityLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CameraRegistryItem;
import cr0s.warpdrive.data.EnumCameraType;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;

public class TileEntityLaserCamera
extends TileEntityLaser
implements IVideoChannel {
    private int videoChannel = -1;
    private static final int REGISTRY_UPDATE_INTERVAL_TICKS = 300;
    private static final int PACKET_SEND_INTERVAL_TICKS = 1200;
    private int packetSendTicks = 10;
    private int registryUpdateTicks = 20;

    public TileEntityLaserCamera() {
        this.peripheralName = "warpdriveLaserCamera";
        this.addMethods(new String[]{"videoChannel"});
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            --this.packetSendTicks;
            if (this.packetSendTicks <= 0) {
                this.packetSendTicks = 1200;
                PacketHandler.sendVideoChannelPacket(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.videoChannel);
            }
        } else {
            --this.registryUpdateTicks;
            if (this.registryUpdateTicks <= 0) {
                this.registryUpdateTicks = 300;
                if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                    WarpDrive.logger.info(this + " Updating registry (" + this.videoChannel + ")");
                }
                WarpDrive.cameras.updateInRegistry(this.field_145850_b, new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.videoChannel, EnumCameraType.LASER_CAMERA);
            }
        }
    }

    @Override
    public int getVideoChannel() {
        return this.videoChannel;
    }

    @Override
    public void setVideoChannel(int parVideoChannel) {
        if (this.videoChannel != parVideoChannel) {
            this.videoChannel = parVideoChannel;
            this.func_70296_d();
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Video channel updated from " + this.videoChannel + " to " + parVideoChannel);
            }
            this.packetSendTicks = 0;
            this.registryUpdateTicks = 0;
        }
    }

    private String getVideoChannelStatus() {
        if (this.videoChannel == -1) {
            return StatCollector.func_74837_a((String)"warpdrive.videoChannel.statusLine.undefined", (Object[])new Object[0]);
        }
        if (this.videoChannel < 0) {
            return StatCollector.func_74837_a((String)"warpdrive.videoChannel.statusLine.invalid", (Object[])new Object[]{this.videoChannel});
        }
        CameraRegistryItem camera = WarpDrive.cameras.getCameraByVideoChannel(this.field_145850_b, this.videoChannel);
        if (camera == null) {
            WarpDrive.cameras.printRegistry(this.field_145850_b);
            return StatCollector.func_74837_a((String)"warpdrive.videoChannel.statusLine.invalid", (Object[])new Object[]{this.videoChannel});
        }
        if (camera.isTileEntity(this)) {
            return StatCollector.func_74837_a((String)"warpdrive.videoChannel.statusLine.valid", (Object[])new Object[]{this.videoChannel});
        }
        return StatCollector.func_74837_a((String)"warpdrive.videoChannel.statusLine.validCamera", (Object[])new Object[]{this.videoChannel, camera.position.field_151329_a, camera.position.field_151327_b, camera.position.field_151328_c});
    }

    @Override
    public String getStatus() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return super.getStatus() + "\n" + this.getVideoChannelStatus();
        }
        return super.getStatus();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setVideoChannel(tag.func_74762_e("cameraFrequency") + tag.func_74762_e("videoChannel"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("videoChannel", this.videoChannel);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("videoChannel", this.videoChannel);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.setVideoChannel(tagCompound.func_74762_e("videoChannel"));
    }

    @Override
    public void func_145843_s() {
        WarpDrive.cameras.removeFromRegistry(this.field_145850_b, new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        WarpDrive.cameras.removeFromRegistry(this.field_145850_b, new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        super.onChunkUnload();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] videoChannel(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setVideoChannel(arguments.checkInteger(0));
        }
        return new Integer[]{this.videoChannel};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("videoChannel")) {
            if (arguments.length == 1) {
                this.setVideoChannel(TileEntityLaserCamera.toInt(arguments[0]));
            }
            return new Integer[]{this.videoChannel};
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s Beam '%d' Camera '%d' @ '%s' (%d %d %d)", this.getClass().getSimpleName(), this.beamFrequency, this.videoChannel, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

