/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cpw.mods.fml.common.FMLCommonHandler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.StructureManager;
import cr0s.warpdrive.world.JumpgateGenerator;
import cr0s.warpdrive.world.SpaceWorldGenerator;
import cr0s.warpdrive.world.WorldGenSmallShip;
import cr0s.warpdrive.world.WorldGenStation;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CommandGenerate
extends CommandBase {
    public String func_71517_b() {
        return "generate";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "/" + this.func_71517_b() + " <structure>\nPossible structures: moon, ship, asteroid, astfield, gascloud, star <class>, jumpgate <name>";
    }

    public void func_71515_b(ICommandSender commandSender, String[] params) {
        World world = commandSender.func_130014_f_();
        ChunkCoordinates coordinates = commandSender.func_82114_b();
        if (world == null || coordinates == null) {
            WarpDrive.addChatMessage(commandSender, "* generate: unknown world or coordinates, probably an invalid command sender in action here.");
            return;
        }
        int x = coordinates.field_71574_a;
        int y = coordinates.field_71572_b;
        int z = coordinates.field_71573_c;
        if (params.length <= 0 || params.length == 3 || params.length > 5) {
            WarpDrive.addChatMessage(commandSender, this.func_71518_a(commandSender));
            return;
        }
        if (params.length > 3) {
            x = this.AdjustAxis(x, params[params.length - 3]);
            y = this.AdjustAxis(y, params[params.length - 2]);
            z = this.AdjustAxis(z, params[params.length - 1]);
        }
        String structure = params[0];
        if (world.field_73011_w.field_76574_g != WarpDriveConfig.G_SPACE_DIMENSION_ID && !"ship".equals(structure)) {
            WarpDrive.addChatMessage(commandSender, "* generate: this structure is only allowed in space!");
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            String name = params.length > 1 ? params[1] : null;
            switch (structure) {
                case "ship": {
                    WarpDrive.logger.info("/generate: generating NPC ship at " + x + ", " + y + ", " + z);
                    new WorldGenSmallShip(false).func_76484_a(world, world.field_73012_v, x, y, z);
                    break;
                }
                case "station": {
                    WarpDrive.logger.info("/generate: generating station at " + x + ", " + y + ", " + z);
                    new WorldGenStation(false).func_76484_a(world, world.field_73012_v, x, y, z);
                    break;
                }
                case "asteroid": {
                    this.generateStructure(commandSender, "asteroid", name, world, x, y - 10, z);
                    break;
                }
                case "astfield": {
                    WarpDrive.logger.info("/generate: generating asteroid field at " + x + ", " + y + ", " + z);
                    SpaceWorldGenerator.generateAsteroidField(world, x, y, z);
                    break;
                }
                case "gascloud": {
                    this.generateStructure(commandSender, "gascloud", name, world, x, y, z);
                    break;
                }
                case "moon": {
                    this.generateStructure(commandSender, "moon", name, world, x, y - 16, z);
                    break;
                }
                case "star": {
                    this.generateStructure(commandSender, "star", name, world, x, y, z);
                    break;
                }
                case "jumpgate": {
                    if (params.length != 2) {
                        WarpDrive.addChatMessage(commandSender, "Missing jumpgate name");
                        break;
                    }
                    WarpDrive.logger.info("/generate: creating jumpgate at " + x + ", " + y + ", " + z);
                    if (WarpDrive.jumpgates.addGate(params[1], x, y, z)) {
                        JumpgateGenerator.generate(world, x, Math.min(y, 228), z);
                        break;
                    }
                    WarpDrive.logger.info("/generate: jumpgate '" + params[1] + "' already exists.");
                    break;
                }
                default: {
                    WarpDrive.addChatMessage(commandSender, this.func_71518_a(commandSender));
                }
            }
        }
    }

    private int AdjustAxis(int axis, String param) {
        if (param.isEmpty() || param.equals("~")) {
            return axis;
        }
        if (param.charAt(0) == '~') {
            return axis + Integer.parseInt(param.substring(1));
        }
        return Integer.parseInt(param);
    }

    private void generateStructure(ICommandSender commandSender, String group, String name, World world, int x, int y, int z) {
        AbstractStructure structure = StructureManager.getStructure(world.field_73012_v, group, name);
        if (structure == null) {
            WarpDrive.addChatMessage(commandSender, "Invalid " + group + " '" + name + "', try one of the followings:\n" + StructureManager.getStructureNames(group));
        } else {
            WarpDrive.logger.info("/generate: Generating " + group + ":" + structure.getName() + " at " + x + " " + y + " " + z);
            structure.func_76484_a(world, world.field_73012_v, x, y, z);
            if (commandSender instanceof EntityPlayerMP) {
                int newY;
                for (newY = y + 1; newY < 256 && !world.func_147437_c(x, newY, z); ++newY) {
                }
                EntityPlayerMP player = (EntityPlayerMP)commandSender;
                player.func_70107_b(player.field_70165_t, (double)newY, player.field_70161_v);
            }
        }
    }
}

