/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class CompatAppliedEnergistics2
implements IBlockTransformer {
    private static Class<?> classAEBaseBlock;
    private static Class<?> classBlockQuartzTorch;
    private static Class<?> classBlockCableBus;
    private static Class<?> classBlockQuantumLinkChamber;
    private static Class<?> classTileQuantumBridge;
    private static Method methodTileQuantumBridge_getQEFrequency;
    private static final byte[] mrotQuartzTorch;
    private static final Map<String, String> rotSideNames;
    private static final Map<String, String> rotTagSuffix;

    public static void register() {
        try {
            classAEBaseBlock = Class.forName("appeng.block.AEBaseBlock");
            classBlockQuartzTorch = Class.forName("appeng.block.misc.BlockQuartzTorch");
            classBlockCableBus = Class.forName("appeng.block.networking.BlockCableBus");
            classBlockQuantumLinkChamber = Class.forName("appeng.block.qnb.BlockQuantumLinkChamber");
            classTileQuantumBridge = Class.forName("appeng.tile.qnb.TileQuantumBridge");
            methodTileQuantumBridge_getQEFrequency = classTileQuantumBridge.getMethod("getQEFrequency", new Class[0]);
            WarpDriveConfig.registerBlockTransformer("appliedenergistics2", new CompatAppliedEnergistics2());
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classAEBaseBlock.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        if (classBlockQuantumLinkChamber.isInstance(block)) {
            if (classTileQuantumBridge.isInstance(tileEntity)) {
                try {
                    Object object = methodTileQuantumBridge_getQEFrequency.invoke((Object)tileEntity, new Object[0]);
                    if ((Long)object != 0L) {
                        reason.append("Quantum field interference detected!");
                        return false;
                    }
                    return true;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    exception.printStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockQuartzTorch.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotQuartzTorch[metadata];
                }
                case 2: {
                    return mrotQuartzTorch[mrotQuartzTorch[metadata]];
                }
                case 3: {
                    return mrotQuartzTorch[mrotQuartzTorch[mrotQuartzTorch[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("orientation_up") && nbtTileEntity.func_74764_b("orientation_forward")) {
            String orientation_forward = nbtTileEntity.func_74779_i("orientation_forward");
            String orientation_up = nbtTileEntity.func_74779_i("orientation_up");
            if (orientation_forward.equals("UP") || orientation_forward.equals("DOWN")) {
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74778_a("orientation_up", rotSideNames.get(orientation_up));
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74778_a("orientation_up", rotSideNames.get(rotSideNames.get(orientation_up)));
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74778_a("orientation_up", rotSideNames.get(rotSideNames.get(rotSideNames.get(orientation_up))));
                        break;
                    }
                }
            } else {
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74778_a("orientation_forward", rotSideNames.get(orientation_forward));
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74778_a("orientation_forward", rotSideNames.get(rotSideNames.get(orientation_forward)));
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74778_a("orientation_forward", rotSideNames.get(rotSideNames.get(rotSideNames.get(orientation_forward))));
                        break;
                    }
                }
            }
        } else if (classBlockCableBus.isInstance(block)) {
            HashMap<String, NBTTagCompound> tagsRotated = new HashMap<String, NBTTagCompound>(7);
            ArrayList keys = new ArrayList();
            keys.addAll(nbtTileEntity.func_150296_c());
            for (String string : keys) {
                if ((!string.startsWith("def:") || string.equals("def:6")) && (!string.startsWith("extra:") || string.equals("extra:6"))) continue;
                NBTTagCompound compound = (NBTTagCompound)nbtTileEntity.func_74775_l(string).func_74737_b();
                String[] parts = string.split(":");
                if (parts.length != 2 || !rotTagSuffix.containsKey(parts[1])) continue;
                switch (rotationSteps) {
                    case 1: {
                        tagsRotated.put(parts[0] + ":" + rotTagSuffix.get(parts[1]), compound);
                        break;
                    }
                    case 2: {
                        tagsRotated.put(parts[0] + ":" + rotTagSuffix.get(rotTagSuffix.get(parts[1])), compound);
                        break;
                    }
                    case 3: {
                        tagsRotated.put(parts[0] + ":" + rotTagSuffix.get(rotTagSuffix.get(rotTagSuffix.get(parts[1]))), compound);
                        break;
                    }
                    default: {
                        tagsRotated.put(string, compound);
                    }
                }
                nbtTileEntity.func_82580_o(string);
            }
            for (Map.Entry entry : tagsRotated.entrySet()) {
                nbtTileEntity.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotQuartzTorch = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("EAST", "SOUTH");
        map.put("SOUTH", "WEST");
        map.put("WEST", "NORTH");
        map.put("NORTH", "EAST");
        map.put("UNKNOWN", "UNKNOWN");
        rotSideNames = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("2", "5");
        map.put("5", "3");
        map.put("3", "4");
        map.put("4", "2");
        rotTagSuffix = Collections.unmodifiableMap(map);
    }
}

