/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class CompatStargateTech2
implements IBlockTransformer {
    private static Class<?> classBlockMachine;
    private static Class<?> classBlockShield;
    private static Class<?> classBlockTransportRing;
    private static Class<?> classTileTransportRing;
    private static Method methodTileTransportRing_link;
    private static final int[] mrot;
    private static final Map<String, String> rotFacingcolors;

    public static void register() {
        try {
            classBlockMachine = Class.forName("lordfokas.stargatetech2.core.machine.BlockMachine");
            classBlockShield = Class.forName("lordfokas.stargatetech2.enemy.BlockShield");
            classBlockTransportRing = Class.forName("lordfokas.stargatetech2.transport.BlockTransportRing");
            classTileTransportRing = Class.forName("lordfokas.stargatetech2.transport.TileTransportRing");
            methodTileTransportRing_link = classTileTransportRing.getDeclaredMethod("link", new Class[0]);
            WarpDriveConfig.registerBlockTransformer("StargateTech2", new CompatStargateTech2());
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockMachine.isInstance(block) || classBlockShield.isInstance(block) || classBlockTransportRing.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    private static NBTTagCompound rotateVector(ITransformation transformation, NBTTagCompound tag) {
        ChunkCoordinates target = transformation.apply(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        tag.func_74768_a("x", target.field_71574_a);
        tag.func_74768_a("y", target.field_71572_b);
        tag.func_74768_a("z", target.field_71573_c);
        return tag;
    }

    private static NBTTagCompound rotateFacingColors(Byte rotationSteps, NBTTagCompound tag) {
        NBTTagCompound newFacing = new NBTTagCompound();
        Set keys = tag.func_150296_c();
        block5: for (String key : keys) {
            NBTBase base = tag.func_74781_a(key);
            if (base instanceof NBTTagByte && rotFacingcolors.containsKey(key)) {
                switch (rotationSteps) {
                    case 1: {
                        newFacing.func_74782_a(rotFacingcolors.get(key), base);
                        continue block5;
                    }
                    case 2: {
                        newFacing.func_74782_a(rotFacingcolors.get(rotFacingcolors.get(key)), base);
                        continue block5;
                    }
                    case 3: {
                        newFacing.func_74782_a(rotFacingcolors.get(rotFacingcolors.get(rotFacingcolors.get(key))), base);
                        continue block5;
                    }
                }
                newFacing.func_74782_a(key, base);
                continue;
            }
            newFacing.func_74782_a(key, base);
        }
        return newFacing;
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity.func_74764_b("pairDn")) {
            nbtTileEntity.func_74782_a("pairDn", (NBTBase)CompatStargateTech2.rotateVector(transformation, nbtTileEntity.func_74775_l("pairDn")));
        }
        if (nbtTileEntity.func_74764_b("pairUp")) {
            nbtTileEntity.func_74782_a("pairUp", (NBTBase)CompatStargateTech2.rotateVector(transformation, nbtTileEntity.func_74775_l("pairUp")));
        }
        if (nbtTileEntity.func_74764_b("controller")) {
            nbtTileEntity.func_74782_a("controller", (NBTBase)CompatStargateTech2.rotateVector(transformation, nbtTileEntity.func_74775_l("controller")));
        }
        if (nbtTileEntity.func_74764_b("emitter_0")) {
            nbtTileEntity.func_74782_a("emitter_0", (NBTBase)CompatStargateTech2.rotateVector(transformation, nbtTileEntity.func_74775_l("emitter_0")));
        }
        if (nbtTileEntity.func_74764_b("facing")) {
            nbtTileEntity.func_74782_a("facing", (NBTBase)CompatStargateTech2.rotateFacingColors(rotationSteps, nbtTileEntity.func_74775_l("facing")));
        }
        if (nbtTileEntity.func_74764_b("master")) {
            nbtTileEntity.func_74782_a("master", (NBTBase)CompatStargateTech2.rotateVector(transformation, nbtTileEntity.func_74775_l("master")));
        }
        switch (rotationSteps) {
            case 1: {
                return mrot[metadata];
            }
            case 2: {
                return mrot[mrot[metadata]];
            }
            case 3: {
                return mrot[mrot[mrot[metadata]]];
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
        if (classTileTransportRing.isInstance(tileEntity)) {
            try {
                methodTileTransportRing_link.invoke((Object)tileEntity, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        mrot = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("color0", "color0");
        map.put("color1", "color1");
        map.put("color2", "color5");
        map.put("color3", "color4");
        map.put("color4", "color2");
        map.put("color5", "color3");
        rotFacingcolors = Collections.unmodifiableMap(map);
    }
}

