/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.core;

import cr0s.warpdrive.core.FMLLoadingPlugin;
import java.util.HashMap;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    private HashMap<String, String> nodeMap = new HashMap();
    private static final String GRAVITY_MANAGER_CLASS = "cr0s/warpdrive/GravityManager";
    private static final String CLOAK_MANAGER_CLASS = "cr0s/warpdrive/data/CloakManager";
    private boolean debugLog = false;

    public ClassTransformer() {
        this.nodeMap.put("EntityLivingBase.class", "sv");
        this.nodeMap.put("moveEntityWithHeading.name", "func_70612_e");
        this.nodeMap.put("moveEntityWithHeading.desc", "(FF)V");
        this.nodeMap.put("EntityItem.class", "xk");
        this.nodeMap.put("onUpdate.name", "func_70071_h_");
        this.nodeMap.put("onUpdate.desc", "()V");
        this.nodeMap.put("WorldClient.class", "bjf");
        this.nodeMap.put("func_147492_c.name", "func_147492_c");
        this.nodeMap.put("func_147492_c.desc", "(IIILnet/minecraft/block/Block;I)Z");
        this.nodeMap.put("setBlock.name", "func_147465_d");
        this.nodeMap.put("Chunk.class", "apx");
        this.nodeMap.put("fillChunk.name", "func_76607_a");
        this.nodeMap.put("fillChunk.desc", "([BIIZ)V");
        this.nodeMap.put("generateHeightMap.name", "func_76590_a");
        this.nodeMap.put("generateHeightMap.desc", "()V");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (this.nodeMap == null) {
            FMLLoadingPlugin.logger.info("Nodemap is null, transformation cancelled");
            return bytes;
        }
        switch (transformedName) {
            case "net.minecraft.entity.EntityLivingBase": {
                bytes = this.transformMinecraftEntityLivingBase(bytes);
                break;
            }
            case "net.minecraft.entity.item.EntityItem": {
                bytes = this.transformMinecraftEntityItem(bytes);
                break;
            }
            case "com.creativemd.itemphysic.physics.ServerPhysic": {
                bytes = this.transformItemPhysicEntityItem(bytes);
                break;
            }
            case "micdoodle8.mods.galacticraft.core.util.WorldUtil": {
                bytes = this.transformGalacticraftWorldUtil(bytes);
                break;
            }
            case "net.minecraft.client.multiplayer.WorldClient": {
                bytes = this.transformMinecraftWorldClient(bytes);
                break;
            }
            case "net.minecraft.world.chunk.Chunk": {
                bytes = this.transformMinecraftChunk(bytes);
            }
        }
        return bytes;
    }

    private byte[] transformMinecraftEntityLivingBase(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 1;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(this.nodeMap.get("moveEntityWithHeading.name")) && !methodNode.name.equals("moveEntityWithHeading") || !methodNode.desc.equals(this.nodeMap.get("moveEntityWithHeading.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                AbstractInsnNode abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (!nodeAt.cst.equals(0.08)) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getGravityForEntity", "(Lnet/minecraft/entity/Entity;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformMinecraftEntityItem(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 2;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(this.nodeMap.get("onUpdate.name")) && !methodNode.name.equals("onUpdate") || !methodNode.desc.equals(this.nodeMap.get("onUpdate.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                MethodInsnNode overwriteNode;
                VarInsnNode beforeNode;
                AbstractInsnNode abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (nodeAt.cst.equals(0.04f)) {
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    if (this.debugLog) {
                        FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                    }
                    ++injectedCount;
                }
                if (!nodeAt.cst.equals(0.98f)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity2", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformItemPhysicEntityItem(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 2;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals("update") || !methodNode.desc.equals("(Lnet/minecraft/entity/item/EntityItem;)V")) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                MethodInsnNode overwriteNode;
                VarInsnNode beforeNode;
                AbstractInsnNode abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (nodeAt.cst.equals(0.04)) {
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    if (this.debugLog) {
                        FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                    }
                    ++injectedCount;
                }
                if (!nodeAt.cst.equals(0.98)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity2", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformGalacticraftWorldUtil(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 5;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            MethodInsnNode overwriteNode;
            VarInsnNode beforeNode;
            LdcInsnNode nodeAt;
            AbstractInsnNode abstractNode;
            int instructionIndex;
            if (methodNode.name.equals("getGravityForEntity") && methodNode.desc.equals("(Lnet/minecraft/entity/Entity;)D")) {
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Method found!");
                }
                for (instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                    abstractNode = methodNode.instructions.get(instructionIndex);
                    if (!(abstractNode instanceof LdcInsnNode)) continue;
                    nodeAt = (LdcInsnNode)abstractNode;
                    if (!nodeAt.cst.equals(0.08)) continue;
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getGravityForEntity", "(Lnet/minecraft/entity/Entity;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    if (this.debugLog) {
                        FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                    }
                    ++injectedCount;
                }
            }
            if (!methodNode.name.equals("getItemGravity") || !methodNode.desc.equals("(Lnet/minecraft/entity/item/EntityItem;)D")) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                nodeAt = (LdcInsnNode)abstractNode;
                if (!nodeAt.cst.equals(0.04f)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount < operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformMinecraftWorldClient(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 1;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(this.nodeMap.get("func_147492_c.name")) && !methodNode.name.equals("func_147492_c") || !methodNode.desc.equals(this.nodeMap.get("func_147492_c.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                AbstractInsnNode abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)abstractNode;
                if (!nodeAt.name.equals(this.nodeMap.get("setBlock.name")) && !nodeAt.name.equals("setBlock")) continue;
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLOAK_MANAGER_CLASS, "onBlockChange", "(IIILnet/minecraft/block/Block;II)Z", false);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformMinecraftChunk(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 1;
        int injectedCount = 0;
        for (MethodNode methodnode : classNode.methods) {
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("- Method " + methodnode.name + " " + methodnode.desc);
            }
            if (!methodnode.name.equals(this.nodeMap.get("fillChunk.name")) && !methodnode.name.equals("fillChunk") || !methodnode.desc.equals(this.nodeMap.get("fillChunk.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodnode.instructions.size(); ++instructionIndex) {
                AbstractInsnNode abstractNode = methodnode.instructions.get(instructionIndex);
                if (this.debugLog) {
                    ClassTransformer.deasm(abstractNode);
                }
                if (!(abstractNode instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)abstractNode;
                if (!nodeAt.name.equals(this.nodeMap.get("generateHeightMap.name")) && !nodeAt.name.equals("generateHeightMap") || !nodeAt.desc.equals(this.nodeMap.get("generateHeightMap.desc"))) continue;
                MethodInsnNode insertMethodNode = new MethodInsnNode(184, CLOAK_MANAGER_CLASS, "onFillChunk", "(Lnet/minecraft/world/chunk/Chunk;)V", false);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)insertMethodNode);
                ++instructionIndex;
                VarInsnNode insertVarNode = new VarInsnNode(25, 0);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)insertVarNode);
                ++instructionIndex;
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private static void deasm(AbstractInsnNode abstractNode) {
        if (abstractNode instanceof VarInsnNode) {
            VarInsnNode node = (VarInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Var " + node.var);
        } else if (abstractNode instanceof LabelNode) {
            LabelNode node = (LabelNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Label " + node.getLabel());
        } else if (abstractNode instanceof LineNumberNode) {
            LineNumberNode node = (LineNumberNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Line " + node.line);
        } else if (abstractNode instanceof InsnNode) {
            InsnNode node = (InsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Instruction " + node);
        } else if (abstractNode instanceof LdcInsnNode) {
            LdcInsnNode node = (LdcInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Load " + node.cst);
        } else if (abstractNode instanceof FieldInsnNode) {
            FieldInsnNode node = (FieldInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Field " + node.owner + " " + node.name + " " + node.desc);
        } else if (abstractNode instanceof MethodInsnNode) {
            MethodInsnNode node = (MethodInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Method " + node.owner + " " + node.name + " " + node.desc);
        } else {
            FMLLoadingPlugin.logger.info("  + Instruction " + abstractNode.getOpcode() + " " + abstractNode.getType() + " " + abstractNode);
        }
    }
}

