/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldRelay;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.GlobalPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class ForceFieldRegistry {
    private static final int FORCE_FIELD_REGISTRY_DEFAULT_ENTRIES_PER_FREQUENCY = 10;
    private static final HashMap<Integer, HashSet<GlobalPosition>> registry = new HashMap();

    public static Set<TileEntity> getTileEntities(int beamFrequency, WorldServer worldSource, int x, int y, int z) {
        int range2;
        Set setGlobalPositions = registry.get(beamFrequency);
        if (setGlobalPositions == null || worldSource == null) {
            return new HashSet<TileEntity>();
        }
        HashSet<TileEntity> setNonRelays = new HashSet<TileEntity>();
        HashSet<TileEntity> setRelays = new HashSet<TileEntity>();
        HashSet<TileEntity> setToIterate = new HashSet<TileEntity>();
        int maxRange2 = 400;
        Iterator iterator = setGlobalPositions.iterator();
        while (iterator.hasNext()) {
            GlobalPosition globalPosition = (GlobalPosition)iterator.next();
            WorldServer world = globalPosition.getWorldServerIfLoaded();
            if (world != null) {
                if (world != worldSource) continue;
                TileEntity tileEntity = world.func_147438_o(globalPosition.x, globalPosition.y, globalPosition.z);
                if (tileEntity instanceof IBeamFrequency && ((IBeamFrequency)tileEntity).getBeamFrequency() == beamFrequency) {
                    if (tileEntity instanceof TileEntityForceFieldRelay) {
                        range2 = (globalPosition.x - x) * (globalPosition.x - x) + (globalPosition.y - y) * (globalPosition.y - y) + (globalPosition.z - z) * (globalPosition.z - z);
                        if (range2 <= maxRange2) {
                            setToIterate.add(tileEntity);
                            continue;
                        }
                        setRelays.add(tileEntity);
                        continue;
                    }
                    setNonRelays.add(tileEntity);
                    continue;
                }
            }
            iterator.remove();
            if (!WarpDriveConfig.LOGGING_FORCEFIELD_REGISTRY) continue;
            ForceFieldRegistry.printRegistry("removed");
        }
        if (setToIterate.isEmpty()) {
            HashSet<TileEntity> setResult = new HashSet<TileEntity>();
            setResult.add(worldSource.func_147438_o(x, y, z));
            return setResult;
        }
        HashSet<TileEntity> setRelaysInRange = new HashSet<TileEntity>();
        while (!setToIterate.isEmpty()) {
            HashSet<TileEntity> setToIterateNext = new HashSet<TileEntity>();
            for (TileEntity tileEntityCurrent : setToIterate) {
                setRelaysInRange.add(tileEntityCurrent);
                for (TileEntity tileEntityEntry : setRelays) {
                    if (setRelaysInRange.contains(tileEntityEntry) || setToIterate.contains(tileEntityEntry) || setToIterateNext.contains(tileEntityEntry) || (range2 = (tileEntityCurrent.field_145851_c - tileEntityEntry.field_145851_c) * (tileEntityCurrent.field_145851_c - tileEntityEntry.field_145851_c) + (tileEntityCurrent.field_145848_d - tileEntityEntry.field_145848_d) * (tileEntityCurrent.field_145848_d - tileEntityEntry.field_145848_d) + (tileEntityCurrent.field_145849_e - tileEntityEntry.field_145849_e) * (tileEntityCurrent.field_145849_e - tileEntityEntry.field_145849_e)) > maxRange2) continue;
                    setToIterateNext.add(tileEntityEntry);
                }
            }
            setToIterate = setToIterateNext;
        }
        HashSet<TileEntity> setEntries = new HashSet<TileEntity>();
        for (TileEntity tileEntityRelayInRange : setRelaysInRange) {
            for (TileEntity tileEntityEntry : setNonRelays) {
                if (setEntries.contains(tileEntityEntry) || (range2 = (tileEntityRelayInRange.field_145851_c - tileEntityEntry.field_145851_c) * (tileEntityRelayInRange.field_145851_c - tileEntityEntry.field_145851_c) + (tileEntityRelayInRange.field_145848_d - tileEntityEntry.field_145848_d) * (tileEntityRelayInRange.field_145848_d - tileEntityEntry.field_145848_d) + (tileEntityRelayInRange.field_145849_e - tileEntityEntry.field_145849_e) * (tileEntityRelayInRange.field_145849_e - tileEntityEntry.field_145849_e)) > maxRange2) continue;
                setEntries.add(tileEntityEntry);
            }
        }
        setEntries.addAll(setRelaysInRange);
        return setEntries;
    }

    public static void updateInRegistry(IBeamFrequency tileEntity) {
        assert (tileEntity instanceof TileEntity);
        HashSet<GlobalPosition> setGlobalPositions = registry.get(tileEntity.getBeamFrequency());
        if (setGlobalPositions == null) {
            setGlobalPositions = new HashSet(10);
        }
        for (GlobalPosition globalPosition : setGlobalPositions) {
            if (!globalPosition.equals(tileEntity)) continue;
            return;
        }
        setGlobalPositions.add(new GlobalPosition((TileEntity)tileEntity));
        registry.put(tileEntity.getBeamFrequency(), setGlobalPositions);
        if (WarpDriveConfig.LOGGING_FORCEFIELD_REGISTRY) {
            ForceFieldRegistry.printRegistry("added");
        }
    }

    public static void removeFromRegistry(IBeamFrequency tileEntity) {
        assert (tileEntity instanceof TileEntity);
        Set setGlobalPositions = registry.get(tileEntity.getBeamFrequency());
        if (setGlobalPositions == null) {
            return;
        }
        Iterator iterator = setGlobalPositions.iterator();
        while (iterator.hasNext()) {
            GlobalPosition globalPosition = (GlobalPosition)iterator.next();
            if (!globalPosition.equals(tileEntity)) continue;
            iterator.remove();
            return;
        }
    }

    public static void printRegistry(String trigger) {
        WarpDrive.logger.info("Forcefield registry (" + registry.size() + " entries after " + trigger + "):");
        for (Map.Entry<Integer, HashSet<GlobalPosition>> entry : registry.entrySet()) {
            String message = "";
            for (GlobalPosition globalPosition : entry.getValue()) {
                if (!message.isEmpty()) {
                    message = message + ", ";
                }
                message = message + globalPosition.dimensionId + ": " + globalPosition.x + " " + globalPosition.y + " " + globalPosition.z;
            }
            WarpDrive.logger.info("- " + entry.getValue().size() + " entries at frequency " + entry.getKey() + ": " + message);
        }
    }
}

