/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.block.detection.BlockMonitor;
import cr0s.warpdrive.compat.CompatForgeMultipart;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.filler.Filler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class JumpBlock {
    public Block block;
    public int blockMeta;
    public TileEntity blockTileEntity;
    public NBTTagCompound blockNBT;
    public int x;
    public int y;
    public int z;
    public HashMap<String, NBTBase> externals;
    private static final byte[] mrotNone = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotRail = new byte[]{1, 0, 5, 4, 2, 3, 7, 8, 9, 6, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotAnvil = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 12, 13, 14, 15};
    private static final byte[] mrotFenceGate = new byte[]{1, 0, 2, 3, 5, 6, 7, 4, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotPumpkin = new byte[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotEndPortalFrame = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotCocoa = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 12, 13, 14, 15};
    private static final byte[] mrotRepeater = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 13, 14, 15, 12};
    private static final byte[] mrotBed = new byte[]{1, 2, 3, 0, 4, 5, 6, 7, 9, 10, 11, 8, 12, 13, 14, 15};
    private static final byte[] mrotStair = new byte[]{2, 3, 1, 0, 6, 7, 5, 4, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotSign = new byte[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3};
    private static final byte[] mrotTrapDoor = new byte[]{3, 2, 0, 1, 7, 6, 4, 5, 11, 10, 8, 9, 15, 14, 12, 13};
    private static final byte[] mrotLever = new byte[]{7, 2, 3, 4, 1, 6, 5, 0, 15, 11, 12, 10, 9, 14, 13, 8};
    private static final byte[] mrotNetherPortal = new byte[]{0, 2, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotVine = new byte[]{0, 2, 4, 6, 8, 10, 12, 14, 1, 3, 5, 7, 9, 11, 13, 15};
    private static final byte[] mrotButton = new byte[]{0, 3, 4, 2, 1, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotMushroom = new byte[]{0, 3, 6, 9, 2, 5, 8, 1, 4, 7, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotForgeDirection = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] mrotPiston = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 13, 12, 10, 11, 14, 15};
    private static final byte[] mrotWoodLog = new byte[]{0, 1, 2, 3, 8, 9, 10, 11, 4, 5, 6, 7, 12, 13, 14, 15};
    private static Object NetworkManager_instance;
    private static Method NetworkManager_updateTileEntityField;

    public JumpBlock() {
    }

    public JumpBlock(Block block, int blockMeta, TileEntity tileEntity, int x, int y, int z) {
        this.block = block;
        this.blockMeta = blockMeta;
        this.blockTileEntity = tileEntity;
        this.x = x;
        this.y = y;
        this.z = z;
        for (Map.Entry<String, IBlockTransformer> entryBlockTransformer : WarpDriveConfig.blockTransformers.entrySet()) {
            if (!entryBlockTransformer.getValue().isApplicable(block, blockMeta, tileEntity)) continue;
            NBTBase nbtBase = entryBlockTransformer.getValue().saveExternals(tileEntity);
            this.setExternal(entryBlockTransformer.getKey(), nbtBase);
        }
    }

    public JumpBlock(Filler filler, int x, int y, int z) {
        if (filler.block == null) {
            WarpDrive.logger.info("Forcing glass for invalid filler with null block at " + x + " " + y + " " + z);
            filler.block = Blocks.field_150359_w;
        }
        this.block = filler.block;
        this.blockMeta = filler.metadata;
        this.blockNBT = filler.tag != null ? (NBTTagCompound)filler.tag.func_74737_b() : null;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public NBTBase getExternal(String modId) {
        if (this.externals == null) {
            return null;
        }
        NBTBase nbtExternal = this.externals.get(modId);
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info("Restoring " + modId + " externals at " + this.x + " " + this.y + " " + this.z + " " + nbtExternal);
        }
        if (nbtExternal == null) {
            return null;
        }
        return nbtExternal.func_74737_b();
    }

    private void setExternal(String modId, NBTBase nbtExternal) {
        if (this.externals == null) {
            this.externals = new HashMap();
        }
        this.externals.put(modId, nbtExternal);
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info("Saved " + modId + " externals at " + this.x + " " + this.y + " " + this.z + " " + nbtExternal);
        }
    }

    private int getMetadataRotation(NBTTagCompound nbtTileEntity, byte rotationSteps) {
        if (rotationSteps == 0) {
            return this.blockMeta;
        }
        byte[] mrot = mrotNone;
        if (this.block instanceof BlockRailBase) {
            mrot = mrotRail;
        } else if (this.block instanceof BlockAnvil) {
            mrot = mrotAnvil;
        } else if (this.block instanceof BlockFenceGate) {
            mrot = mrotFenceGate;
        } else if (this.block instanceof BlockPumpkin || this.block instanceof BlockTripWireHook) {
            mrot = mrotPumpkin;
        } else if (this.block instanceof BlockEndPortalFrame || this.block instanceof BlockDoor) {
            mrot = mrotEndPortalFrame;
        } else if (this.block instanceof BlockCocoa) {
            mrot = mrotCocoa;
        } else if (this.block instanceof BlockRedstoneDiode) {
            mrot = mrotRepeater;
        } else if (this.block instanceof BlockBed) {
            mrot = mrotBed;
        } else if (this.block instanceof BlockStairs) {
            mrot = mrotStair;
        } else if (this.block instanceof BlockSign) {
            mrot = this.block == Blocks.field_150444_as ? mrotForgeDirection : mrotSign;
        } else if (this.block instanceof BlockTrapDoor) {
            mrot = mrotTrapDoor;
        } else if (this.block instanceof BlockLever) {
            mrot = mrotLever;
        } else if (this.block instanceof BlockPortal) {
            mrot = mrotNetherPortal;
        } else if (this.block instanceof BlockVine) {
            mrot = mrotVine;
        } else if (this.block instanceof BlockButton || this.block instanceof BlockTorch) {
            mrot = mrotButton;
        } else if (this.block instanceof BlockHugeMushroom) {
            mrot = mrotMushroom;
        } else if (this.block instanceof BlockFurnace || this.block instanceof BlockDispenser || this.block instanceof BlockHopper || this.block instanceof BlockChest || this.block instanceof BlockEnderChest || this.block instanceof BlockLadder || this.block instanceof BlockMonitor) {
            mrot = mrotForgeDirection;
        } else if (this.block instanceof BlockPistonBase || this.block instanceof BlockPistonExtension || this.block instanceof BlockPistonMoving) {
            mrot = mrotPiston;
        } else if (this.block instanceof BlockLog) {
            mrot = mrotWoodLog;
        } else if (this.block instanceof BlockSkull) {
            mrot = mrotNone;
            short facing = nbtTileEntity.func_74765_d("Rot");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74777_a("Rot", (short)mrotSign[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74777_a("Rot", (short)mrotSign[mrotSign[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74777_a("Rot", (short)mrotSign[mrotSign[mrotSign[facing]]]);
                    break;
                }
            }
        }
        switch (rotationSteps) {
            case 1: {
                return mrot[this.blockMeta];
            }
            case 2: {
                return mrot[mrot[this.blockMeta]];
            }
            case 3: {
                return mrot[mrot[mrot[this.blockMeta]]];
            }
        }
        return this.blockMeta;
    }

    public void deploy(World targetWorld, ITransformation transformation) {
        try {
            NBTTagCompound nbtToDeploy = null;
            if (this.blockTileEntity != null) {
                nbtToDeploy = new NBTTagCompound();
                this.blockTileEntity.func_145841_b(nbtToDeploy);
            } else if (this.blockNBT != null) {
                nbtToDeploy = (NBTTagCompound)this.blockNBT.func_74737_b();
            }
            int newBlockMeta = this.blockMeta;
            if (this.externals != null) {
                for (Map.Entry<String, NBTBase> external : this.externals.entrySet()) {
                    IBlockTransformer blockTransformer = WarpDriveConfig.blockTransformers.get(external.getKey());
                    if (blockTransformer == null) continue;
                    newBlockMeta = blockTransformer.rotate(this.block, this.blockMeta, nbtToDeploy, transformation);
                }
            } else {
                newBlockMeta = this.getMetadataRotation(nbtToDeploy, transformation.getRotationSteps());
            }
            ChunkCoordinates target = transformation.apply(this.x, this.y, this.z);
            JumpBlock.setBlockNoLight(targetWorld, target.field_71574_a, target.field_71572_b, target.field_71573_c, this.block, newBlockMeta, 2);
            if (this.block == WarpDrive.blockAir) {
                targetWorld.func_147471_g(target.field_71574_a, target.field_71572_b, target.field_71573_c);
                targetWorld.func_147464_a(target.field_71574_a, target.field_71572_b, target.field_71573_c, this.block, 40 + targetWorld.field_73012_v.nextInt(20));
            }
            if (nbtToDeploy != null) {
                NBTTagCompound nbtScreenData;
                nbtToDeploy.func_74768_a("x", target.field_71574_a);
                nbtToDeploy.func_74768_a("y", target.field_71572_b);
                nbtToDeploy.func_74768_a("z", target.field_71573_c);
                if (nbtToDeploy.func_74764_b("mainX") && nbtToDeploy.func_74764_b("mainY") && nbtToDeploy.func_74764_b("mainZ")) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info(this + " deploy: TileEntity has mainXYZ");
                    }
                    ChunkCoordinates mainTarget = transformation.apply(nbtToDeploy.func_74762_e("mainX"), nbtToDeploy.func_74762_e("mainY"), nbtToDeploy.func_74762_e("mainZ"));
                    nbtToDeploy.func_74768_a("mainX", mainTarget.field_71574_a);
                    nbtToDeploy.func_74768_a("mainY", mainTarget.field_71572_b);
                    nbtToDeploy.func_74768_a("mainZ", mainTarget.field_71573_c);
                }
                if (nbtToDeploy.func_74764_b("screenData") && (nbtScreenData = nbtToDeploy.func_74775_l("screenData")).func_74764_b("minX") && nbtScreenData.func_74764_b("minY") && nbtScreenData.func_74764_b("minZ") && nbtScreenData.func_74764_b("maxX") && nbtScreenData.func_74764_b("maxY") && nbtScreenData.func_74764_b("maxZ")) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info(this + " deploy: TileEntity has screenData.min/maxXYZ");
                    }
                    ChunkCoordinates minTarget = transformation.apply(nbtScreenData.func_74762_e("minX"), nbtScreenData.func_74762_e("minY"), nbtScreenData.func_74762_e("minZ"));
                    nbtScreenData.func_74768_a("minX", minTarget.field_71574_a);
                    nbtScreenData.func_74768_a("minY", minTarget.field_71572_b);
                    nbtScreenData.func_74768_a("minZ", minTarget.field_71573_c);
                    ChunkCoordinates maxTarget = transformation.apply(nbtScreenData.func_74762_e("maxX"), nbtScreenData.func_74762_e("maxY"), nbtScreenData.func_74762_e("maxZ"));
                    nbtScreenData.func_74768_a("maxX", maxTarget.field_71574_a);
                    nbtScreenData.func_74768_a("maxY", maxTarget.field_71572_b);
                    nbtScreenData.func_74768_a("maxZ", maxTarget.field_71573_c);
                    nbtToDeploy.func_74782_a("screenData", (NBTBase)nbtScreenData);
                }
                if (nbtToDeploy.func_74764_b("hasValidBubble")) {
                    nbtToDeploy.func_74757_a("hasValidBubble", false);
                }
                TileEntity newTileEntity = null;
                boolean isForgeMultipart = false;
                if (WarpDriveConfig.isForgeMultipartLoaded && nbtToDeploy.func_74764_b("id") && nbtToDeploy.func_74779_i("id").equals("savedMultipart")) {
                    isForgeMultipart = true;
                    newTileEntity = (TileEntity)CompatForgeMultipart.methodMultipartHelper_createTileFromNBT.invoke(null, targetWorld, nbtToDeploy);
                } else if (this.block == WarpDriveConfig.CC_Computer || this.block == WarpDriveConfig.CC_peripheral || this.block == WarpDriveConfig.CCT_Turtle || this.block == WarpDriveConfig.CCT_Expanded || this.block == WarpDriveConfig.CCT_Advanced) {
                    newTileEntity = TileEntity.func_145827_c((NBTTagCompound)nbtToDeploy);
                    newTileEntity.func_145843_s();
                }
                if (newTileEntity == null) {
                    newTileEntity = TileEntity.func_145827_c((NBTTagCompound)nbtToDeploy);
                }
                if (newTileEntity != null) {
                    newTileEntity.func_145834_a(targetWorld);
                    newTileEntity.func_145829_t();
                    targetWorld.func_147455_a(target.field_71574_a, target.field_71572_b, target.field_71573_c, newTileEntity);
                    if (isForgeMultipart) {
                        CompatForgeMultipart.methodTileMultipart_onChunkLoad.invoke((Object)newTileEntity, new Object[0]);
                        CompatForgeMultipart.methodMultipartHelper_sendDescPacket.invoke(null, targetWorld, newTileEntity);
                    }
                    newTileEntity.func_70296_d();
                } else {
                    WarpDrive.logger.error(" deploy failed to create new tile entity at " + this.x + " " + this.y + " " + this.z + " blockId " + this.block + ":" + this.blockMeta);
                    WarpDrive.logger.error("NBT data was " + nbtToDeploy);
                }
            }
        }
        catch (Exception exception) {
            String coordinates;
            exception.printStackTrace();
            try {
                coordinates = " at " + this.x + " " + this.y + " " + this.z + " blockId " + this.block + ":" + this.blockMeta;
            }
            catch (Exception dropMe) {
                coordinates = " (unknown coordinates)";
            }
            WarpDrive.logger.error("moveBlockSimple exception at " + coordinates);
        }
    }

    public static void refreshBlockStateOnClient(World world, int x, int y, int z) {
        block18: {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity != null) {
                Class<?> teClass = tileEntity.getClass();
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Tile at " + x + " " + y + " " + z + " is " + teClass + " derived from " + teClass.getSuperclass());
                }
                try {
                    String superClassName = teClass.getSuperclass().getName();
                    boolean isIC2 = superClassName.contains("ic2.core.block");
                    if (isIC2 || superClassName.contains("advsolar.common.tiles")) {
                        Method onUnloaded = teClass.getMethod("onUnloaded", new Class[0]);
                        Method onLoaded = teClass.getMethod("onLoaded", new Class[0]);
                        if (onUnloaded != null && onLoaded != null) {
                            onUnloaded.invoke((Object)tileEntity, new Object[0]);
                            onLoaded.invoke((Object)tileEntity, new Object[0]);
                        } else {
                            WarpDrive.logger.error("Missing IC2 (un)loaded events for TileEntity '" + teClass.getName() + "' at " + x + " " + y + " " + z + ". Please report this issue!");
                        }
                        tileEntity.func_145836_u();
                    }
                    if (isIC2) {
                        if (teClass.getName().equals("ic2.core.block.wiring.TileEntityCable")) {
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "color");
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "foamColor");
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "foamed");
                        } else {
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "active");
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "facing");
                            if (teClass.getName().equals("ic2.core.block.reactor.TileEntityNuclearReactorElectric")) {
                                JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "heat");
                            }
                        }
                        break block18;
                    }
                    try {
                        Method getNetworkedFields = teClass.getMethod("getNetworkedFields", new Class[0]);
                        List fields = (List)getNetworkedFields.invoke((Object)tileEntity, new Object[0]);
                        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                            WarpDrive.logger.info("Tile has " + fields.size() + " networked fields: " + fields);
                        }
                        for (String field : fields) {
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, field);
                        }
                    }
                    catch (NoSuchMethodException getNetworkedFields) {
                    }
                    catch (NoClassDefFoundError exception) {
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info("TileEntity " + teClass.getName() + " at " + x + " " + y + " " + z + " is missing a class definition");
                            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    WarpDrive.logger.info("Exception involving TileEntity " + teClass.getName() + " at " + x + " " + y + " " + z);
                    exception.printStackTrace();
                }
            }
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.block = Block.func_149684_b((String)tag.func_74779_i("block"));
        if (this.block == null) {
            if (WarpDriveConfig.LOGGING_BUILDING) {
                WarpDrive.logger.warn("Ignoring unknown block " + tag.func_74779_i("block") + " from tag " + tag);
            }
            this.block = Blocks.field_150350_a;
            return;
        }
        this.blockMeta = tag.func_74771_c("blockMeta");
        this.blockTileEntity = null;
        if (tag.func_74764_b("blockNBT")) {
            this.blockNBT = tag.func_74775_l("blockNBT");
            if (this.blockNBT.func_74764_b("computerID")) {
                this.blockNBT.func_82580_o("computerID");
            }
            if (this.blockNBT.func_74764_b("oc:computer")) {
                NBTTagCompound tagComputer = this.blockNBT.func_74775_l("oc:computer");
                tagComputer.func_82580_o("components");
                tagComputer.func_82580_o("node");
                this.blockNBT.func_74782_a("oc:computer", (NBTBase)tagComputer);
            }
        } else {
            this.blockNBT = null;
        }
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
        this.z = tag.func_74762_e("z");
        if (tag.func_74764_b("externals")) {
            NBTTagCompound tagCompoundExternals = tag.func_74775_l("externals");
            this.externals = new HashMap();
            for (Object key : tagCompoundExternals.func_150296_c()) {
                assert (key instanceof String);
                this.externals.put((String)key, tagCompoundExternals.func_74781_a((String)key));
            }
        } else {
            this.externals = null;
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.block));
        tag.func_74774_a("blockMeta", (byte)this.blockMeta);
        if (this.blockTileEntity != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.blockTileEntity.func_145841_b(tagCompound);
            tag.func_74782_a("blockNBT", (NBTBase)tagCompound);
        } else if (this.blockNBT != null) {
            tag.func_74782_a("blockNBT", (NBTBase)this.blockNBT);
        }
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        if (this.externals != null && !this.externals.isEmpty()) {
            NBTTagCompound tagCompoundExternals = new NBTTagCompound();
            for (Map.Entry<String, NBTBase> entry : this.externals.entrySet()) {
                if (entry.getValue() == null) {
                    tagCompoundExternals.func_74778_a(entry.getKey(), "");
                    continue;
                }
                tagCompoundExternals.func_74782_a(entry.getKey(), entry.getValue());
            }
            tag.func_74782_a("externals", (NBTBase)tagCompoundExternals);
        }
    }

    private static void NetworkHelper_init() {
        try {
            NetworkManager_updateTileEntityField = Class.forName("ic2.core.network.NetworkManager").getMethod("updateTileEntityField", TileEntity.class, String.class);
            NetworkManager_instance = Class.forName("ic2.core.IC2").getDeclaredField("network").get(null);
            if (!NetworkManager_instance.getClass().getName().contains("NetworkManager")) {
                NetworkManager_instance = Class.forName("ic2.core.util.SideGateway").getMethod("get", new Class[0]).invoke(NetworkManager_instance, new Object[0]);
                WarpDrive.logger.error("Patched IC2 API, new instance is '" + NetworkManager_instance + "'");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void NetworkHelper_updateTileEntityField(TileEntity tileEntity, String field) {
        try {
            if (NetworkManager_instance == null) {
                JumpBlock.NetworkHelper_init();
            }
            NetworkManager_updateTileEntityField.invoke(NetworkManager_instance, tileEntity, field);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean setBlockNoLight(World w, int x, int y, int z, Block block, int blockMeta, int par6) {
        if (x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000) {
            if (y < 0) {
                return false;
            }
            if (y >= 256) {
                return false;
            }
            Chunk chunk = w.func_72964_e(x >> 4, z >> 4);
            Block block1 = null;
            if ((par6 & 1) != 0) {
                block1 = chunk.func_150810_a(x & 0xF, y, z & 0xF);
            }
            boolean flag = JumpBlock.myChunkSBIDWMT(chunk, x & 0xF, y, z & 0xF, block, blockMeta);
            w.markAndNotifyBlock(x, y, z, chunk, block1, block, par6);
            return flag;
        }
        return false;
    }

    private static boolean myChunkSBIDWMT(Chunk c, int x, int y, int z, Block block, int blockMeta) {
        TileEntity tileentity;
        int i1 = z << 4 | x;
        if (y >= c.field_76638_b[i1] - 1) {
            c.field_76638_b[i1] = -999;
        }
        Block block1 = c.func_150810_a(x, y, z);
        int k1 = c.func_76628_c(x, y, z);
        if (block1 == block && k1 == blockMeta) {
            return false;
        }
        ExtendedBlockStorage[] storageArrays = c.func_76587_i();
        ExtendedBlockStorage extendedblockstorage = storageArrays[y >> 4];
        if (extendedblockstorage == null) {
            if (block == Blocks.field_150350_a) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, !c.field_76637_e.field_73011_w.field_76576_e);
            storageArrays[y >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
        }
        int l1 = c.field_76635_g * 16 + x;
        int i2 = c.field_76647_h * 16 + z;
        extendedblockstorage.func_150818_a(x, y & 0xF, z, block);
        extendedblockstorage.func_76654_b(x, y & 0xF, z, blockMeta);
        if (block1 != Blocks.field_150350_a) {
            TileEntity te;
            if (!c.field_76637_e.field_72995_K) {
                block1.func_149749_a(c.field_76637_e, l1, y, i2, block1, k1);
                te = c.getTileEntityUnsafe(x & 0xF, y, z & 0xF);
                if (te != null && te.shouldRefresh(block1, c.func_150810_a(x & 0xF, y, z & 0xF), k1, c.func_76628_c(x & 0xF, y, z & 0xF), c.field_76637_e, l1, y, i2)) {
                    c.func_150805_f(x & 0xF, y, z & 0xF);
                }
            } else if (block1.hasTileEntity(k1) && (te = c.getTileEntityUnsafe(x & 0xF, y, z & 0xF)) != null && te.shouldRefresh(block1, block, k1, blockMeta, c.field_76637_e, l1, y, i2)) {
                c.field_76637_e.func_147475_p(l1, y, i2);
            }
        }
        if (extendedblockstorage.func_150819_a(x, y & 0xF, z) != block) {
            return false;
        }
        extendedblockstorage.func_76654_b(x, y & 0xF, z, blockMeta);
        if (block1 != Blocks.field_150350_a && block.hasTileEntity(blockMeta) && (tileentity = c.func_150806_e(x, y, z)) != null) {
            tileentity.func_145836_u();
            tileentity.field_145847_g = blockMeta;
        }
        c.field_76643_l = true;
        return true;
    }
}

