/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.Planet;
import cr0s.warpdrive.data.Transformation;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.event.AbstractSequencer;
import cr0s.warpdrive.world.SpaceTeleporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class JumpSequencer
extends AbstractSequencer {
    private Transformation transformation;
    private int moveX;
    private int moveY;
    private int moveZ;
    private final byte rotationSteps;
    private final boolean isHyperspaceJump;
    private final World sourceWorld;
    private World targetWorld;
    private ForgeChunkManager.Ticket sourceWorldTicket;
    private ForgeChunkManager.Ticket targetWorldTicket;
    private boolean collisionDetected = false;
    private ArrayList<Vector3> collisionAtSource;
    private ArrayList<Vector3> collisionAtTarget;
    private float collisionStrength = 0.0f;
    private boolean isEnabled = false;
    private static final int STATE_IDLE = 0;
    private static final int STATE_CHUNKLOADING = 1;
    private static final int STATE_SAVING = 2;
    private static final int STATE_BORDERS = 3;
    private static final int STATE_TRANSFORMER = 4;
    private static final int STATE_BLOCKS = 5;
    private static final int STATE_EXTERNALS = 6;
    private static final int STATE_ENTITIES = 7;
    private static final int STATE_REMOVING = 8;
    private static final int STATE_CHUNKUNLOADING = 9;
    private static final int STATE_FINISHING = 10;
    private int state = 0;
    private int actualIndexInShip = 0;
    private final JumpShip ship;
    private boolean betweenWorlds;
    private final int destX;
    private final int destY;
    private final int destZ;
    private final boolean isCoordJump;
    private long msCounter = 0L;
    private int ticks = 0;
    private static final boolean enforceEntitiesPosition = false;

    public JumpSequencer(TileEntityShipCore shipCore, boolean isHyperspaceJump, int moveX, int moveY, int moveZ, byte rotationSteps, boolean isCoordJump, int destX, int destY, int destZ) {
        this.sourceWorld = shipCore.func_145831_w();
        this.ship = new JumpShip();
        this.ship.worldObj = this.sourceWorld;
        this.ship.coreX = shipCore.field_145851_c;
        this.ship.coreY = shipCore.field_145848_d;
        this.ship.coreZ = shipCore.field_145849_e;
        this.ship.dx = shipCore.dx;
        this.ship.dz = shipCore.dz;
        this.ship.minX = shipCore.minX;
        this.ship.maxX = shipCore.maxX;
        this.ship.minY = shipCore.minY;
        this.ship.maxY = shipCore.maxY;
        this.ship.minZ = shipCore.minZ;
        this.ship.maxZ = shipCore.maxZ;
        this.ship.shipCore = shipCore;
        this.isHyperspaceJump = isHyperspaceJump;
        this.moveX = moveX;
        this.moveY = moveY;
        this.moveZ = moveZ;
        this.rotationSteps = rotationSteps;
        this.isCoordJump = isCoordJump;
        this.destX = destX;
        this.destY = destY;
        this.destZ = destZ;
        this.targetWorld = null;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Sequencer created");
        }
    }

    public void enable() {
        this.isEnabled = true;
        this.register();
    }

    public void disable(String reason) {
        if (!this.isEnabled) {
            return;
        }
        this.isEnabled = false;
        if (WarpDriveConfig.LOGGING_JUMP) {
            if (reason == null || reason.isEmpty()) {
                WarpDrive.logger.info(this + " Killing jump sequencer...");
            } else {
                WarpDrive.logger.info(this + " Killing jump sequencer... (" + reason + ")");
            }
        }
        this.unforceChunks();
        this.unregister();
    }

    @Override
    public boolean onUpdate() {
        if (this.sourceWorld.field_72995_K) {
            return false;
        }
        if (!this.isEnabled) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " Removing from onUpdate...");
            }
            return false;
        }
        if (this.ship.minY < 0 || this.ship.maxY > 255) {
            String msg = "Invalid Y coordinate(s), check ship dimensions...";
            this.ship.messageToAllPlayersOnShip(msg);
            this.disable(msg);
            return true;
        }
        ++this.ticks;
        switch (this.state) {
            case 0: {
                this.msCounter = System.currentTimeMillis();
                if (!this.isEnabled) break;
                this.state = 1;
                break;
            }
            case 1: {
                this.state_chunkLoading();
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.state = 2;
                break;
            }
            case 2: {
                this.state_saving();
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.state = 3;
                break;
            }
            case 3: {
                this.state_borders();
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.state = 4;
                break;
            }
            case 4: {
                this.state_transformer();
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.state = 5;
                break;
            }
            case 5: {
                this.state_moveBlocks();
                if (this.actualIndexInShip < this.ship.jumpBlocks.length - 1) break;
                this.actualIndexInShip = 0;
                this.state = 6;
                break;
            }
            case 6: {
                this.state_moveExternals();
                if (this.actualIndexInShip < this.ship.jumpBlocks.length - 1) break;
                this.state = 7;
                break;
            }
            case 7: {
                this.state_moveEntities();
                this.actualIndexInShip = 0;
                this.state = 8;
                break;
            }
            case 8: {
                this.state_removeBlocks();
                if (this.actualIndexInShip < this.ship.jumpBlocks.length - 1) break;
                this.state = 9;
                break;
            }
            case 9: {
                this.state_chunkUnloading();
                this.state = 10;
                break;
            }
            case 10: {
                this.state_finishing();
                this.state = 0;
                break;
            }
            default: {
                String msg = "Invalid state, aborting jump...";
                this.ship.messageToAllPlayersOnShip(msg);
                this.disable(msg);
                return true;
            }
        }
        return true;
    }

    private boolean forceSourceChunks(StringBuilder reason) {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Forcing source chunks in " + this.sourceWorld.field_73011_w.func_80007_l());
        }
        this.sourceWorldTicket = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.sourceWorld, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.sourceWorldTicket == null) {
            reason.append("Chunkloading rejected in source world " + this.sourceWorld.func_72912_H().func_76065_j() + ". Aborting.");
            return false;
        }
        int x1 = this.ship.minX >> 4;
        int x2 = this.ship.maxX >> 4;
        int z1 = this.ship.minZ >> 4;
        int z2 = this.ship.maxZ >> 4;
        int chunkCount = 0;
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                if (++chunkCount > this.sourceWorldTicket.getMaxChunkListDepth()) {
                    reason.append("Ship is extending over too many chunks in source world. Max is currently set to " + this.sourceWorldTicket.getMaxChunkListDepth() + " in forgeChunkLoading.cfg. Aborting.");
                    return false;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.sourceWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
            }
        }
        return true;
    }

    private boolean forceTargetChunks(StringBuilder reason) {
        LocalProfiler.start("Jump.forceTargetChunks");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Forcing target chunks in " + this.targetWorld.field_73011_w.func_80007_l());
        }
        this.targetWorldTicket = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.targetWorld, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.targetWorldTicket == null) {
            reason.append("Chunkloading rejected in target world " + this.sourceWorld.func_72912_H().func_76065_j() + ". Aborting.");
            return false;
        }
        ChunkCoordinates targetMin = this.transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
        ChunkCoordinates targetMax = this.transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
        int x1 = Math.min(targetMin.field_71574_a, targetMax.field_71574_a) >> 4;
        int x2 = Math.max(targetMin.field_71574_a, targetMax.field_71574_a) >> 4;
        int z1 = Math.min(targetMin.field_71573_c, targetMax.field_71573_c) >> 4;
        int z2 = Math.max(targetMin.field_71573_c, targetMax.field_71573_c) >> 4;
        int chunkCount = 0;
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                if (++chunkCount > this.targetWorldTicket.getMaxChunkListDepth()) {
                    reason.append("Ship is extending over too many chunks in target world. Max is currently set to " + this.targetWorldTicket.getMaxChunkListDepth() + " in forgeChunkLoading.cfg. Aborting.");
                    return false;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.targetWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
            }
        }
        LocalProfiler.stop();
        return true;
    }

    private void unforceChunks() {
        int z2;
        int z1;
        int x2;
        int x1;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Unforcing chunks");
        }
        if (this.sourceWorldTicket != null) {
            x1 = this.ship.minX >> 4;
            x2 = this.ship.maxX >> 4;
            z1 = this.ship.minZ >> 4;
            z2 = this.ship.maxZ >> 4;
            for (int x = x1; x <= x2; ++x) {
                for (int z = z1; z <= z2; ++z) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.sourceWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.sourceWorldTicket);
            this.sourceWorldTicket = null;
        }
        if (this.targetWorldTicket != null) {
            ChunkCoordinates targetMin = this.transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
            ChunkCoordinates targetMax = this.transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
            x1 = Math.min(targetMin.field_71574_a, targetMax.field_71574_a) >> 4;
            x2 = Math.max(targetMin.field_71574_a, targetMax.field_71574_a) >> 4;
            z1 = Math.min(targetMin.field_71573_c, targetMax.field_71573_c) >> 4;
            z2 = Math.max(targetMin.field_71573_c, targetMax.field_71573_c) >> 4;
            for (int x = x1; x <= x2; ++x) {
                for (int z = z1; z <= z2; ++z) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.targetWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.targetWorldTicket);
            this.targetWorldTicket = null;
        }
    }

    private void state_chunkLoading() {
        LocalProfiler.start("Jump.chunkLoading");
        StringBuilder reason = new StringBuilder();
        if (!this.forceSourceChunks(reason)) {
            String msg = reason.toString();
            this.disable(msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    private void state_saving() {
        StringBuilder reason;
        LocalProfiler.start("Jump.saving");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Saving ship...");
        }
        if (!this.ship.save(reason = new StringBuilder())) {
            String msg = reason.toString();
            this.disable(msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void state_borders() {
        StringBuilder reason;
        LocalProfiler.start("Jump.borders");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Checking ship borders...");
        }
        if (!this.ship.checkBorders(reason = new StringBuilder())) {
            String msg = reason.toString();
            this.disable(msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        File file = new File(WarpDriveConfig.G_SCHEMALOCATION + "/auto");
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            WarpDrive.logger.warn("Unable to create auto-backup folder, skipping...");
            LocalProfiler.stop();
            return;
        }
        try {
            Date now;
            String schematicFileName;
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'ss's'SSS");
            String shipName = this.ship.shipCore.shipName.replaceAll("[^ -~]", "").replaceAll("[:/\\\\]", "");
            do {
                now = new Date();
            } while (new File(schematicFileName = WarpDriveConfig.G_SCHEMALOCATION + "/auto/" + shipName + "_" + sdfDate.format(now) + ".schematic").exists());
            NBTTagCompound schematic = new NBTTagCompound();
            short width = (short)(this.ship.shipCore.maxX - this.ship.shipCore.minX + 1);
            short length = (short)(this.ship.shipCore.maxZ - this.ship.shipCore.minZ + 1);
            short height = (short)(this.ship.shipCore.maxY - this.ship.shipCore.minY + 1);
            schematic.func_74777_a("Width", width);
            schematic.func_74777_a("Length", length);
            schematic.func_74777_a("Height", height);
            schematic.func_74768_a("shipMass", this.ship.shipCore.shipMass);
            schematic.func_74778_a("shipName", this.ship.shipCore.shipName);
            schematic.func_74768_a("shipVolume", this.ship.shipCore.shipVolume);
            NBTTagCompound tagCompoundShip = new NBTTagCompound();
            this.ship.writeToNBT(tagCompoundShip);
            schematic.func_74782_a("ship", (NBTBase)tagCompoundShip);
            this.writeNBTToFile(schematicFileName, schematic);
            if (!WarpDriveConfig.LOGGING_JUMP) {
                // empty if block
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.msCounter = System.currentTimeMillis();
        LocalProfiler.stop();
    }

    private void writeNBTToFile(String fileName, NBTTagCompound nbttagcompound) {
        WarpDrive.logger.info(this + " Saving ship state prior to jump in " + fileName);
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)fileoutputstream);
            fileoutputstream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void state_transformer() {
        String msg;
        CheckMovementResult checkMovementResult;
        boolean fromSpace;
        boolean toSpace;
        boolean isInHyperSpace;
        boolean isInSpace;
        StringBuilder reason;
        block53: {
            Planet closestTransitionPlane;
            int closestPlaneDistance;
            Boolean planetFound;
            block58: {
                Planet closestPlanet;
                int closestPlanetDistance;
                Boolean planetValid;
                block56: {
                    block57: {
                        block55: {
                            block54: {
                                LocalProfiler.start("Jump.transformer");
                                if (WarpDriveConfig.LOGGING_JUMP) {
                                    WarpDrive.logger.info(this + " Transformer evaluation...");
                                }
                                reason = new StringBuilder();
                                isInSpace = this.sourceWorld.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID;
                                isInHyperSpace = this.sourceWorld.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID;
                                toSpace = this.moveY > 0 && this.ship.maxY + this.moveY > 255 && !isInSpace && !isInHyperSpace;
                                fromSpace = this.moveY < 0 && this.ship.minY + this.moveY < 0 && isInSpace;
                                boolean bl = this.betweenWorlds = fromSpace || toSpace || this.isHyperspaceJump;
                                if (!this.isHyperspaceJump) break block54;
                                if (isInHyperSpace) {
                                    this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(WarpDriveConfig.G_SPACE_DIMENSION_ID);
                                    if (this.targetWorld == null) {
                                        LocalProfiler.stop();
                                        String msg2 = "Unable to load Space dimension " + WarpDriveConfig.G_SPACE_DIMENSION_ID + ", aborting jump.";
                                        this.ship.messageToAllPlayersOnShip(msg2);
                                        this.disable(msg2);
                                        return;
                                    }
                                    break block53;
                                } else {
                                    if (!isInSpace) {
                                        String msg3 = "Unable to reach hyperspace from a planet";
                                        this.disable(msg3);
                                        this.ship.messageToAllPlayersOnShip(msg3);
                                        LocalProfiler.stop();
                                        return;
                                    }
                                    this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID);
                                    if (this.targetWorld == null) {
                                        LocalProfiler.stop();
                                        String msg4 = "Unable to load Hyperspace dimension " + WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID + ", aborting jump.";
                                        this.ship.messageToAllPlayersOnShip(msg4);
                                        this.disable(msg4);
                                        return;
                                    }
                                }
                                break block53;
                            }
                            if (!toSpace) break block55;
                            planetFound = false;
                            planetValid = false;
                            closestPlanetDistance = Integer.MAX_VALUE;
                            closestPlanet = null;
                            break block56;
                        }
                        if (!fromSpace) break block57;
                        planetFound = false;
                        closestPlaneDistance = Integer.MAX_VALUE;
                        closestTransitionPlane = null;
                        break block58;
                    }
                    this.targetWorld = this.sourceWorld;
                    break block53;
                }
                for (int indexPlanet = 0; !planetValid.booleanValue() && indexPlanet < WarpDriveConfig.PLANETS.length; ++indexPlanet) {
                    Planet planet = WarpDriveConfig.PLANETS[indexPlanet];
                    if (this.sourceWorld.field_73011_w.field_76574_g != planet.dimensionId) continue;
                    planetFound = true;
                    int planetDistance = planet.isValidToSpace(new VectorI(this.ship.coreX, this.ship.coreY, this.ship.coreZ));
                    if (planetDistance == 0) {
                        planetValid = true;
                        this.moveX = planet.spaceCenterX - planet.dimensionCenterX;
                        this.moveZ = planet.spaceCenterZ - planet.dimensionCenterZ;
                        this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(WarpDriveConfig.G_SPACE_DIMENSION_ID);
                        if (this.targetWorld != null) continue;
                        LocalProfiler.stop();
                        String msg5 = "Unable to load Space dimension " + WarpDriveConfig.G_SPACE_DIMENSION_ID + ", aborting jump.";
                        this.ship.messageToAllPlayersOnShip(msg5);
                        this.disable(msg5);
                        return;
                    }
                    if (closestPlanetDistance <= planetDistance) continue;
                    closestPlanetDistance = planetDistance;
                    closestPlanet = planet;
                }
                if (!planetFound.booleanValue()) {
                    LocalProfiler.stop();
                    String msg6 = "Unable to reach space!\nThere's no planet defined for current dimension " + this.sourceWorld.field_73011_w.func_80007_l() + " (" + this.sourceWorld.field_73011_w.field_76574_g + ")";
                    this.ship.messageToAllPlayersOnShip(msg6);
                    this.disable(msg6);
                    return;
                }
                if (!planetValid.booleanValue()) {
                    LocalProfiler.stop();
                    assert (closestPlanet != null);
                    String msg7 = "Ship is outside planet border, unable to reach space!\nClosest transition plane is ~" + closestPlanetDistance + " m away (" + (closestPlanet.dimensionCenterX - closestPlanet.borderSizeX) + " 250 " + (closestPlanet.dimensionCenterZ - closestPlanet.borderSizeZ) + ") to (" + (closestPlanet.dimensionCenterX + closestPlanet.borderSizeX) + " 255 " + (closestPlanet.dimensionCenterZ + closestPlanet.borderSizeZ) + ")";
                    this.ship.messageToAllPlayersOnShip(msg7);
                    this.disable(msg7);
                    return;
                }
                break block53;
            }
            for (int indexPlanet = 0; !planetFound.booleanValue() && indexPlanet < WarpDriveConfig.PLANETS.length; ++indexPlanet) {
                Planet planet = WarpDriveConfig.PLANETS[indexPlanet];
                int planeDistance = planet.isValidFromSpace(new VectorI(this.ship.coreX, this.ship.coreY, this.ship.coreZ));
                if (planeDistance == 0) {
                    planetFound = true;
                    this.moveX = planet.dimensionCenterX - planet.spaceCenterX;
                    this.moveZ = planet.dimensionCenterZ - planet.spaceCenterZ;
                    this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(planet.dimensionId);
                    if (this.targetWorld != null) continue;
                    LocalProfiler.stop();
                    String msg8 = "Undefined dimension " + planet.dimensionId + ", aborting jump. Check your server configuration!";
                    this.ship.messageToAllPlayersOnShip(msg8);
                    this.disable(msg8);
                    return;
                }
                if (closestPlaneDistance <= planeDistance) continue;
                closestPlaneDistance = planeDistance;
                closestTransitionPlane = planet;
            }
            if (!planetFound.booleanValue()) {
                LocalProfiler.stop();
                String msg9 = closestTransitionPlane == null ? "No planet defined, unable to enter atmosphere!" : "No planet in range, unable to enter atmosphere!\nClosest planet is " + closestPlaneDistance + " m away (" + (closestTransitionPlane.spaceCenterX - closestTransitionPlane.borderSizeX) + " 250 " + (closestTransitionPlane.spaceCenterZ - closestTransitionPlane.borderSizeZ) + ") to (" + (closestTransitionPlane.spaceCenterX + closestTransitionPlane.borderSizeX) + " 255 " + (closestTransitionPlane.spaceCenterZ + closestTransitionPlane.borderSizeZ) + ")";
                this.ship.messageToAllPlayersOnShip(msg9);
                this.disable(msg9);
                return;
            }
        }
        if ((!isInSpace && !isInHyperSpace || this.targetWorld.field_73011_w.field_76574_g != WarpDriveConfig.G_SPACE_DIMENSION_ID && this.targetWorld.field_73011_w.field_76574_g != WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID) && !this.ship.isUnlimited() && this.ship.actualMass > WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE) {
            String msg10 = "Ship is too big for a planet (max is " + WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE + " blocks)";
            this.ship.messageToAllPlayersOnShip(msg10);
            this.disable(msg10);
            return;
        }
        if (this.betweenWorlds && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " From world " + this.sourceWorld.field_73011_w.func_80007_l() + " to " + this.targetWorld.field_73011_w.func_80007_l());
        }
        Boolean isPluginCheckDone = false;
        String firstAdjustmentReason = "";
        if (this.isCoordJump) {
            this.moveX = this.destX - this.ship.coreX;
            this.moveY = this.destY - this.ship.coreY;
            this.moveZ = this.destZ - this.ship.coreZ;
        } else if (!this.isHyperspaceJump) {
            if (toSpace) {
                this.moveY = 0;
            } else if (fromSpace) {
                this.moveY = 245 - this.ship.maxY;
            } else {
                int rangeZ;
                int rangeX;
                if (this.ship.maxY + this.moveY > 255) {
                    this.moveY = 255 - this.ship.maxY;
                }
                if (this.ship.minY + this.moveY < 5) {
                    this.moveY = 5 - this.ship.minY;
                }
                if (Math.max(rangeX = Math.abs(this.moveX) - (this.ship.maxX - this.ship.minX), rangeZ = Math.abs(this.moveZ) - (this.ship.maxZ - this.ship.minZ)) < 256) {
                    firstAdjustmentReason = this.getPossibleJumpDistance();
                    isPluginCheckDone = true;
                }
            }
        }
        this.transformation = new Transformation(this.ship, this.targetWorld, this.moveX, this.moveY, this.moveZ, this.rotationSteps);
        ChunkCoordinates target1 = this.transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
        ChunkCoordinates target2 = this.transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
        AxisAlignedBB aabbSource = AxisAlignedBB.func_72330_a((double)this.ship.minX, (double)this.ship.minY, (double)this.ship.minZ, (double)this.ship.maxX, (double)this.ship.maxY, (double)this.ship.maxZ);
        aabbSource.func_72314_b(1.0, 1.0, 1.0);
        AxisAlignedBB aabbTarget = AxisAlignedBB.func_72330_a((double)Math.min(target1.field_71574_a, target2.field_71574_a), (double)Math.min(target1.field_71572_b, target2.field_71572_b), (double)Math.min(target1.field_71573_c, target2.field_71573_c), (double)Math.max(target1.field_71574_a, target2.field_71574_a), (double)Math.max(target1.field_71572_b, target2.field_71572_b), (double)Math.max(target1.field_71573_c, target2.field_71573_c));
        if (!this.betweenWorlds && aabbSource.func_72326_a(aabbTarget)) {
            this.doCollisionDamage(false);
            String msg11 = firstAdjustmentReason == null || firstAdjustmentReason.isEmpty() ? "Source and target areas are overlapping, jump aborted! Try increasing jump distance..." : firstAdjustmentReason + "\nNot enough space after adjustment, jump aborted!";
            this.disable(msg11);
            this.ship.messageToAllPlayersOnShip(msg11);
            LocalProfiler.stop();
            return;
        }
        if (this.targetWorld.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID || this.targetWorld.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID) {
            if (WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS > 0 && (Math.abs(aabbTarget.field_72340_a) > (double)WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS || Math.abs(aabbTarget.field_72339_c) > (double)WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS || Math.abs(aabbTarget.field_72336_d) > (double)WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS || Math.abs(aabbTarget.field_72334_f) > (double)WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS)) {
                String msg12 = "Space border reach, max is " + WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS;
                this.disable(msg12);
                this.ship.messageToAllPlayersOnShip(msg12);
                LocalProfiler.stop();
                return;
            }
        } else {
            Boolean planetFound = false;
            Boolean planetValid = false;
            int closestPlanetDistance = Integer.MAX_VALUE;
            Planet closestPlanet = null;
            for (int indexPlanet = 0; !planetValid.booleanValue() && indexPlanet < WarpDriveConfig.PLANETS.length; ++indexPlanet) {
                Planet planet = WarpDriveConfig.PLANETS[indexPlanet];
                if (this.targetWorld.field_73011_w.field_76574_g != planet.dimensionId) continue;
                planetFound = true;
                int planetDistance = planet.isInsideBorder(aabbTarget);
                if (planetDistance == 0) {
                    planetValid = true;
                    continue;
                }
                if (closestPlanetDistance <= planetDistance) continue;
                closestPlanetDistance = planetDistance;
                closestPlanet = planet;
            }
            if (!planetFound.booleanValue()) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.error("There's no world border defined for dimension " + this.targetWorld.field_73011_w.func_80007_l());
                }
            } else if (!planetValid.booleanValue()) {
                LocalProfiler.stop();
                assert (closestPlanet != null);
                String msg13 = "Target ship position is outside planet border, unable to jump!\nPlanet borders are (" + (closestPlanet.dimensionCenterX - closestPlanet.borderSizeX) + " 0 " + (closestPlanet.dimensionCenterZ - closestPlanet.borderSizeZ) + ") to (" + (closestPlanet.dimensionCenterX + closestPlanet.borderSizeX) + " 255 " + (closestPlanet.dimensionCenterZ + closestPlanet.borderSizeZ) + ")";
                this.ship.messageToAllPlayersOnShip(msg13);
                this.disable(msg13);
                return;
            }
        }
        if (!isPluginCheckDone.booleanValue() && (checkMovementResult = this.checkCollisionAndProtection(this.transformation, true, "target")) != null) {
            String msg14 = checkMovementResult.reason + "\nJump aborted!";
            this.disable(msg14);
            this.ship.messageToAllPlayersOnShip(msg14);
            LocalProfiler.stop();
            return;
        }
        if (!this.forceTargetChunks(reason)) {
            msg = reason.toString();
            this.disable(msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        msg = this.ship.saveEntities();
        if (msg != null) {
            this.disable(msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Saved " + this.ship.entitiesOnShip.size() + " entities from ship");
        }
        if (this.isHyperspaceJump && isInSpace) {
            this.ship.messageToAllPlayersOnShip("Entering HYPERSPACE...");
        } else if (this.isHyperspaceJump && isInHyperSpace) {
            this.ship.messageToAllPlayersOnShip("Leaving HYPERSPACE..");
        } else if (this.isCoordJump) {
            this.ship.messageToAllPlayersOnShip("Jumping to coordinates (" + this.destX + " " + this.destY + " " + this.destZ + ")!");
        } else {
            this.ship.messageToAllPlayersOnShip("Jumping of " + Math.round(Math.sqrt(this.moveX * this.moveX + this.moveY * this.moveY + this.moveZ * this.moveZ)) + " blocks (" + this.moveX + " " + this.moveY + " " + this.moveZ + ")");
        }
        switch (this.rotationSteps) {
            case 1: {
                this.ship.messageToAllPlayersOnShip("Turning to the right");
                break;
            }
            case 2: {
                this.ship.messageToAllPlayersOnShip("Turning back");
                break;
            }
            case 3: {
                this.ship.messageToAllPlayersOnShip("Turning to the left");
                break;
            }
        }
        LocalProfiler.stop();
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info("Removing TE duplicates: tileEntities in target world before jump: " + this.targetWorld.field_147482_g.size());
        }
    }

    private void state_moveBlocks() {
        LocalProfiler.start("Jump.moveBlocks");
        int blocksToMove = Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK, this.ship.jumpBlocks.length - this.actualIndexInShip);
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Moving ship blocks " + this.actualIndexInShip + " to " + (this.actualIndexInShip + blocksToMove - 1) + " / " + (this.ship.jumpBlocks.length - 1));
        }
        for (int index = 0; index < blocksToMove && this.actualIndexInShip < this.ship.jumpBlocks.length; ++index) {
            JumpBlock jumpBlock = this.ship.jumpBlocks[this.actualIndexInShip];
            if (jumpBlock != null) {
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Deploying from " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z + " of " + jumpBlock.block + "@" + jumpBlock.blockMeta);
                }
                jumpBlock.deploy(this.targetWorld, this.transformation);
                this.sourceWorld.func_147475_p(jumpBlock.x, jumpBlock.y, jumpBlock.z);
            }
            ++this.actualIndexInShip;
        }
        LocalProfiler.stop();
    }

    private void state_moveExternals() {
        LocalProfiler.start("Jump.moveExternals");
        int blocksToMove = Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK, this.ship.jumpBlocks.length - this.actualIndexInShip);
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Moving ship externals from " + this.actualIndexInShip + " / " + (this.ship.jumpBlocks.length - 1));
        }
        int index = 0;
        while (index < blocksToMove && this.actualIndexInShip < this.ship.jumpBlocks.length) {
            JumpBlock jumpBlock = this.ship.jumpBlocks[this.ship.jumpBlocks.length - this.actualIndexInShip - 1];
            if (jumpBlock == null) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(this + " Moving ship externals: unexpected null found at ship[" + this.actualIndexInShip + "]");
                }
                ++this.actualIndexInShip;
                continue;
            }
            if (jumpBlock.blockTileEntity != null && jumpBlock.externals != null) {
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Moving externals for block " + jumpBlock.block + "@" + jumpBlock.blockMeta + " at " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z);
                }
                for (Map.Entry<String, NBTBase> external : jumpBlock.externals.entrySet()) {
                    IBlockTransformer blockTransformer = WarpDriveConfig.blockTransformers.get(external.getKey());
                    if (blockTransformer == null) continue;
                    blockTransformer.remove(jumpBlock.blockTileEntity);
                    ChunkCoordinates target = this.transformation.apply(jumpBlock.x, jumpBlock.y, jumpBlock.z);
                    TileEntity newTileEntity = this.targetWorld.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
                    blockTransformer.restoreExternals(newTileEntity, this.transformation, external.getValue());
                }
                ++index;
            }
            ++this.actualIndexInShip;
        }
        LocalProfiler.stop();
    }

    private void state_moveEntities() {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Moving entities");
        }
        LocalProfiler.start("Jump.moveEntities");
        if (this.ship.entitiesOnShip != null) {
            for (MovingEntity me : this.ship.entitiesOnShip) {
                Entity entity = me.entity;
                if (entity == null) continue;
                double oldEntityX = me.oldX;
                double oldEntityY = me.oldY;
                double oldEntityZ = me.oldZ;
                Vec3 target = this.transformation.apply(oldEntityX, oldEntityY, oldEntityZ);
                double newEntityX = target.field_72450_a;
                double newEntityY = target.field_72448_b;
                double newEntityZ = target.field_72449_c;
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(String.format("Entity moving: (%.2f %.2f %.2f) -> (%.2f %.2f %.2f) entity %s", oldEntityX, oldEntityY, oldEntityZ, newEntityX, newEntityY, newEntityZ, entity.toString()));
                }
                if (this.betweenWorlds) {
                    MinecraftServer server = MinecraftServer.func_71276_C();
                    WorldServer from = server.func_71218_a(this.sourceWorld.field_73011_w.field_76574_g);
                    WorldServer to = server.func_71218_a(this.targetWorld.field_73011_w.field_76574_g);
                    SpaceTeleporter teleporter = new SpaceTeleporter(to, 0, MathHelper.func_76128_c((double)newEntityX), MathHelper.func_76128_c((double)newEntityY), MathHelper.func_76128_c((double)newEntityZ));
                    if (entity instanceof EntityPlayerMP) {
                        EntityPlayerMP player = (EntityPlayerMP)entity;
                        server.func_71203_ab().transferPlayerToDimension(player, this.targetWorld.field_73011_w.field_76574_g, (Teleporter)teleporter);
                        player.func_71016_p();
                    } else {
                        server.func_71203_ab().transferEntityToWorld(entity, this.sourceWorld.field_73011_w.field_76574_g, from, to, (Teleporter)teleporter);
                    }
                }
                this.transformation.rotate(entity);
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    ChunkCoordinates bedLocation = player.getBedLocation(this.sourceWorld.field_73011_w.field_76574_g);
                    if (bedLocation != null && this.ship.minX <= bedLocation.field_71574_a && this.ship.maxX >= bedLocation.field_71574_a && this.ship.minY <= bedLocation.field_71572_b && this.ship.maxY >= bedLocation.field_71572_b && this.ship.minZ <= bedLocation.field_71573_c && this.ship.maxZ >= bedLocation.field_71573_c) {
                        bedLocation = this.transformation.apply(bedLocation);
                        player.setSpawnChunk(bedLocation, false, this.targetWorld.field_73011_w.field_76574_g);
                    }
                    player.func_70634_a(newEntityX, newEntityY, newEntityZ);
                    continue;
                }
                entity.func_70107_b(newEntityX, newEntityY, newEntityZ);
            }
        }
        LocalProfiler.stop();
    }

    private void state_removeBlocks() {
        LocalProfiler.start("Jump.removeBlocks");
        int blocksToMove = Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK, this.ship.jumpBlocks.length - this.actualIndexInShip);
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Removing ship blocks " + this.actualIndexInShip + " to " + (this.actualIndexInShip + blocksToMove - 1) + " / " + (this.ship.jumpBlocks.length - 1));
        }
        for (int index = 0; index < blocksToMove && this.actualIndexInShip < this.ship.jumpBlocks.length; ++index) {
            JumpBlock jumpBlock;
            block9: {
                jumpBlock = this.ship.jumpBlocks[this.ship.jumpBlocks.length - this.actualIndexInShip - 1];
                if (jumpBlock == null) {
                    if (WarpDriveConfig.LOGGING_JUMP) {
                        WarpDrive.logger.info(this + " Removing ship part: unexpected null found at ship[" + this.actualIndexInShip + "]");
                    }
                    ++this.actualIndexInShip;
                    continue;
                }
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Removing block " + jumpBlock.block + "@" + jumpBlock.blockMeta + " at " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z);
                }
                if (jumpBlock.blockTileEntity != null) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info("Removing tile entity at " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z);
                    }
                    this.sourceWorld.func_147475_p(jumpBlock.x, jumpBlock.y, jumpBlock.z);
                }
                try {
                    JumpBlock.setBlockNoLight(this.sourceWorld, jumpBlock.x, jumpBlock.y, jumpBlock.z, Blocks.field_150350_a, 0, 2);
                }
                catch (Exception exception) {
                    WarpDrive.logger.info("Exception while removing " + jumpBlock.block + "@" + jumpBlock.blockMeta + " at " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z);
                    if (!WarpDriveConfig.LOGGING_JUMPBLOCKS) break block9;
                    exception.printStackTrace();
                }
            }
            ChunkCoordinates target = this.transformation.apply(jumpBlock.x, jumpBlock.y, jumpBlock.z);
            JumpBlock.refreshBlockStateOnClient(this.targetWorld, target.field_71574_a, target.field_71572_b, target.field_71573_c);
            ++this.actualIndexInShip;
        }
        LocalProfiler.stop();
    }

    private void state_chunkUnloading() {
        LocalProfiler.start("Jump.chunkUnloading");
        this.unforceChunks();
        LocalProfiler.stop();
    }

    private void state_finishing() {
        block5: {
            LocalProfiler.start("Jump.finishing()");
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " Jump done in " + (float)(System.currentTimeMillis() - this.msCounter) / 1000.0f + " seconds and " + this.ticks + " ticks");
            }
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("Removing TE duplicates: tileEntities in target world after jump, before cleanup: " + this.targetWorld.field_147482_g.size());
            }
            try {
                this.targetWorld.field_147482_g = JumpSequencer.removeDuplicates(this.targetWorld.field_147482_g);
            }
            catch (Exception exception) {
                if (!WarpDriveConfig.LOGGING_JUMP) break block5;
                WarpDrive.logger.info("TE Duplicates removing exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.doCollisionDamage(true);
        this.disable("Jump done");
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info("Removing TE duplicates: tileEntities in target world after jump, after cleanup: " + this.targetWorld.field_147482_g.size());
        }
        LocalProfiler.stop();
    }

    private String getPossibleJumpDistance() {
        int originalRange;
        CheckMovementResult result;
        int testRange;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Calculating possible jump distance...");
        }
        int blowPoints = 0;
        this.collisionDetected = false;
        String firstAdjustmentReason = "";
        for (testRange = originalRange = Math.max(Math.abs(this.moveX), Math.max(Math.abs(this.moveY), Math.abs(this.moveZ))); testRange >= 0 && (result = this.checkMovement((double)testRange / (double)originalRange, false)) != null; --testRange) {
            if (firstAdjustmentReason.isEmpty()) {
                firstAdjustmentReason = result.reason;
            }
            if (!result.isCollision) continue;
            ++blowPoints;
        }
        VectorI finalMovement = this.getMovementVector((double)testRange / (double)originalRange);
        if (originalRange != testRange && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Jump range adjusted from " + originalRange + " to " + testRange + " after " + blowPoints + " collisions");
        }
        if (blowPoints > WarpDriveConfig.SHIP_COLLISION_TOLERANCE_BLOCKS) {
            result = this.checkMovement(Math.min(1.0, Math.max(0.0, (double)(testRange + 1) / (double)originalRange)), true);
            if (result != null) {
                float massCorrection = 0.5f + (float)Math.sqrt(Math.min(1.0, Math.max(0.0, (double)(this.ship.shipCore.shipMass - WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE)) / (double)WarpDriveConfig.SHIP_VOLUME_MIN_FOR_HYPERSPACE));
                this.collisionDetected = true;
                this.collisionStrength = (4.0f + (float)blowPoints - (float)WarpDriveConfig.SHIP_COLLISION_TOLERANCE_BLOCKS) * massCorrection;
                this.collisionAtSource = result.atSource;
                this.collisionAtTarget = result.atTarget;
                WarpDrive.logger.info(this + " Reporting " + this.collisionAtTarget.size() + " collisions points after " + blowPoints + " blowPoints with " + String.format("%.2f", Float.valueOf(massCorrection)) + " ship mass correction => " + String.format("%.2f", Float.valueOf(this.collisionStrength)) + " explosion strength");
            } else {
                WarpDrive.logger.error("WarpDrive error: unable to compute collision points, ignoring...");
            }
        }
        this.moveX = finalMovement.x;
        this.moveY = finalMovement.y;
        this.moveZ = finalMovement.z;
        return firstAdjustmentReason;
    }

    private void doCollisionDamage(boolean atTarget) {
        if (!this.collisionDetected) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " doCollisionDamage No collision detected...");
            }
            return;
        }
        ArrayList<Vector3> collisionPoints = atTarget ? this.collisionAtTarget : this.collisionAtSource;
        Vector3 min = collisionPoints.get(0).clone();
        Vector3 max = collisionPoints.get(0).clone();
        for (Vector3 v : collisionPoints) {
            if (min.x > v.x) {
                min.x = v.x;
            } else if (max.x < v.x) {
                max.x = v.x;
            }
            if (min.y > v.y) {
                min.y = v.y;
            } else if (max.y < v.y) {
                max.y = v.y;
            }
            if (min.z > v.z) {
                min.z = v.z;
                continue;
            }
            if (!(max.z < v.z)) continue;
            max.z = v.z;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Ship collision from " + min + " to " + max);
        }
        double rx = Math.round(min.x + (double)this.sourceWorld.field_73012_v.nextInt(Math.max(1, (int)(max.x - min.x))));
        double ry = Math.round(min.y + (double)this.sourceWorld.field_73012_v.nextInt(Math.max(1, (int)(max.y - min.y))));
        double rz = Math.round(min.z + (double)this.sourceWorld.field_73012_v.nextInt(Math.max(1, (int)(max.z - min.z))));
        this.ship.messageToAllPlayersOnShip("Ship collision detected around " + (int)rx + ", " + (int)ry + ", " + (int)rz + ". Damage report pending...");
        int nbExplosions = Math.min(5, collisionPoints.size());
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info("doCollisionDamage nbExplosions " + nbExplosions + "/" + collisionPoints.size());
        }
        for (int i = 0; i < nbExplosions; ++i) {
            Vector3 current;
            if (nbExplosions < collisionPoints.size()) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info("doCollisionDamage random #" + i);
                }
                current = collisionPoints.get(this.sourceWorld.field_73012_v.nextInt(collisionPoints.size()));
            } else {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info("doCollisionDamage get " + i);
                }
                current = collisionPoints.get(i);
            }
            float strength = Math.max(4.0f, this.collisionStrength / (float)nbExplosions - 2.0f + 2.0f * this.sourceWorld.field_73012_v.nextFloat());
            (atTarget ? this.targetWorld : this.sourceWorld).func_72885_a(null, current.x, current.y, current.z, strength, atTarget, atTarget);
            WarpDrive.logger.info("Ship collision caused explosion at " + current.x + " " + current.y + " " + current.z + " with strength " + strength);
        }
    }

    private void restoreEntitiesPosition() {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Restoring entities position");
        }
        LocalProfiler.start("Jump.restoreEntitiesPosition");
        if (this.ship.entitiesOnShip != null) {
            for (MovingEntity movingEntity : this.ship.entitiesOnShip) {
                Entity entity = movingEntity.entity;
                if (entity == null) continue;
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info("Entity restoring position at (" + movingEntity.oldX + " " + movingEntity.oldY + " " + movingEntity.oldZ + ")");
                }
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    player.func_70634_a(movingEntity.oldX, movingEntity.oldY, movingEntity.oldZ);
                    continue;
                }
                entity.func_70107_b(movingEntity.oldX, movingEntity.oldY, movingEntity.oldZ);
            }
        }
        LocalProfiler.stop();
    }

    private CheckMovementResult checkCollisionAndProtection(ITransformation transformation, boolean fullCollisionDetails, String context) {
        CheckMovementResult result = new CheckMovementResult();
        VectorI offset = new VectorI((int)Math.signum(this.moveX), (int)Math.signum(this.moveY), (int)Math.signum(this.moveZ));
        ChunkCoordinates coordCoreAtTarget = transformation.apply(this.ship.coreX, this.ship.coreY, this.ship.coreZ);
        for (int y = this.ship.minY; y <= this.ship.maxY; ++y) {
            for (int x = this.ship.minX; x <= this.ship.maxX; ++x) {
                for (int z = this.ship.minZ; z <= this.ship.maxZ; ++z) {
                    ChunkCoordinates coordTarget = transformation.apply(x, y, z);
                    Block blockSource = this.sourceWorld.func_147439_a(x, y, z);
                    Block blockTarget = this.targetWorld.func_147439_a(coordTarget.field_71574_a, coordTarget.field_71572_b, coordTarget.field_71573_c);
                    if (Dictionary.BLOCKS_ANCHOR.contains(blockTarget)) {
                        result.add(x, y, z, (double)coordTarget.field_71574_a + 0.5 - (double)offset.x, (double)coordTarget.field_71572_b + 0.5 - (double)offset.y, (double)coordTarget.field_71573_c + 0.5 - (double)offset.z, true, "Impassable " + blockTarget.func_149732_F() + " detected at destination (" + coordTarget.field_71574_a + " " + coordTarget.field_71572_b + " " + coordTarget.field_71573_c + ")");
                        if (!fullCollisionDetails) {
                            return result;
                        }
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info("Anchor collision at " + context);
                        }
                    }
                    if (blockSource != Blocks.field_150350_a && !Dictionary.BLOCKS_EXPANDABLE.contains(blockSource) && blockTarget != Blocks.field_150350_a && !Dictionary.BLOCKS_EXPANDABLE.contains(blockTarget)) {
                        result.add(x, y, z, (double)coordTarget.field_71574_a + 0.5 + (double)offset.x * 0.1, (double)coordTarget.field_71572_b + 0.5 + (double)offset.y * 0.1, (double)coordTarget.field_71573_c + 0.5 + (double)offset.z * 0.1, true, "Obstacle " + blockTarget.func_149732_F() + " detected at (" + coordTarget.field_71574_a + " " + coordTarget.field_71572_b + " " + coordTarget.field_71573_c + ")");
                        if (!fullCollisionDetails) {
                            return result;
                        }
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info("Hard collision at " + context);
                        }
                    }
                    if (blockSource == Blocks.field_150350_a || !WarpDrive.proxy.isBlockPlaceCanceled(null, coordCoreAtTarget.field_71574_a, coordCoreAtTarget.field_71572_b, coordCoreAtTarget.field_71573_c, this.targetWorld, coordTarget.field_71574_a, coordTarget.field_71572_b, coordTarget.field_71573_c, blockSource, 0)) continue;
                    result.add(x, y, z, coordTarget.field_71574_a, coordTarget.field_71572_b, coordTarget.field_71573_c, false, "Ship is entering a protected area");
                    return result;
                }
            }
        }
        if (fullCollisionDetails && result.isCollision) {
            return result;
        }
        return null;
    }

    private CheckMovementResult checkMovement(double ratio, boolean fullCollisionDetails) {
        CheckMovementResult result = new CheckMovementResult();
        VectorI testMovement = this.getMovementVector(ratio);
        if (this.moveY > 0 && this.ship.maxY + testMovement.y > 255 && !this.betweenWorlds) {
            result.add(this.ship.coreX, this.ship.maxY + testMovement.y, this.ship.coreZ, (double)this.ship.coreX + 0.5, (double)(this.ship.maxY + testMovement.y) + 1.0, (double)this.ship.coreZ + 0.5, false, "Ship core is moving too high");
            return result;
        }
        if (this.moveY < 0 && this.ship.minY + testMovement.y <= 8 && !this.betweenWorlds) {
            result.add(this.ship.coreX, this.ship.minY + testMovement.y, this.ship.coreZ, (double)this.ship.coreX + 0.5, this.ship.maxY + testMovement.y, (double)this.ship.coreZ + 0.5, false, "Ship core is moving too low");
            return result;
        }
        Transformation testTransformation = new Transformation(this.ship, this.targetWorld, testMovement.x, testMovement.y, testMovement.z, this.rotationSteps);
        return this.checkCollisionAndProtection(testTransformation, fullCollisionDetails, "ratio " + ratio + " testMovement " + testMovement);
    }

    private VectorI getMovementVector(double ratio) {
        return new VectorI((int)Math.round((double)this.moveX * ratio), (int)Math.round((double)this.moveY * ratio), (int)Math.round((double)this.moveZ * ratio));
    }

    private static ArrayList<Object> removeDuplicates(List<TileEntity> l) {
        TreeSet<TileEntity> s = new TreeSet<TileEntity>(new Comparator<TileEntity>(){

            @Override
            public int compare(TileEntity o1, TileEntity o2) {
                if (o1.field_145851_c == o2.field_145851_c && o1.field_145848_d == o2.field_145848_d && o1.field_145849_e == o2.field_145849_e) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info("Removed duplicated TE: " + o1 + " vs " + o2);
                    }
                    return 0;
                }
                return 1;
            }
        });
        s.addAll(l);
        return new ArrayList<Object>(Arrays.asList(s.toArray()));
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbttagcompound) {
        WarpDrive.logger.error(this + " readFromNBT()");
    }

    @Override
    protected void writeToNBT(NBTTagCompound nbttagcompound) {
        WarpDrive.logger.error(this + " writeToNBT()");
    }

    public String toString() {
        return String.format("%s/%d '%s' @ '%s' (%d %d %d) #%d", this.getClass().getSimpleName(), this.hashCode(), this.ship == null || this.ship.shipCore == null ? "~NULL~" : this.ship.shipCore.uuid + ":" + this.ship.shipCore.shipName, this.sourceWorld == null ? "~NULL~" : this.sourceWorld.func_72912_H().func_76065_j(), this.ship == null ? -1 : this.ship.coreX, this.ship == null ? -1 : this.ship.coreY, this.ship == null ? -1 : this.ship.coreZ, this.ticks);
    }

    private class CheckMovementResult {
        final ArrayList<Vector3> atSource = new ArrayList(1);
        final ArrayList<Vector3> atTarget = new ArrayList(1);
        boolean isCollision = false;
        public String reason = "Unknown reason";

        CheckMovementResult() {
        }

        public void add(double sx, double sy, double sz, double tx, double ty, double tz, boolean pisCollision, String preason) {
            this.atSource.add(new Vector3(sx, sy, sz));
            this.atTarget.add(new Vector3(tx, ty, tz));
            this.isCollision = this.isCollision || pisCollision;
            this.reason = preason;
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("CheckMovementResult " + sx + ", " + sy + ", " + sz + " -> " + tx + ", " + ty + ", " + tz + " " + this.isCollision + " '" + this.reason + "'");
            }
        }
    }
}

