/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IVideoChannel;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemMultiWarpTuner
extends Item {
    static final int MODE_VIDEO_CHANNEL = 0;
    static final int MODE_BEAM_FREQUENCY = 1;
    static final String TAG_VIDEO_CHANNEL = "videoChannel";
    static final String TAG_BEAM_FREQUENCY = "beamFrequency";
    private IIcon[] icons;

    public ItemMultiWarpTuner() {
        this.func_77656_e(0);
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.tool.MultiWarpTuner");
        this.func_77664_n();
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            this.icons[i] = iconRegister.func_94245_a("warpdrive:toolMultiWarpTuner_" + ItemMultiWarpTuner.getDyeColorName(i));
        }
    }

    public static String getDyeColorName(int metadata) {
        return ItemDye.field_150921_b[metadata];
    }

    public IIcon func_77617_a(int damage) {
        if (damage < this.icons.length) {
            return this.icons[damage];
        }
        return Blocks.field_150480_ab.func_149840_c(0);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int dyeColor = 0; dyeColor < 16; ++dyeColor) {
            list.add(new ItemStack(item, 1, dyeColor));
        }
    }

    public static int getVideoChannel(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemMultiWarpTuner)) {
            return -1;
        }
        if (!itemStack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt.func_74764_b(TAG_VIDEO_CHANNEL)) {
            return nbt.func_74762_e(TAG_VIDEO_CHANNEL);
        }
        return -1;
    }

    public static ItemStack setVideoChannel(ItemStack itemStack, int videoChannel) {
        if (!(itemStack.func_77973_b() instanceof ItemMultiWarpTuner) || videoChannel == -1) {
            return itemStack;
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a(TAG_VIDEO_CHANNEL, videoChannel);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    public static int getBeamFrequency(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemMultiWarpTuner)) {
            return -1;
        }
        if (!itemStack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt.func_74764_b(TAG_BEAM_FREQUENCY)) {
            return nbt.func_74762_e(TAG_BEAM_FREQUENCY);
        }
        return -1;
    }

    public static ItemStack setBeamFrequency(ItemStack itemStack, int beamFrequency) {
        if (!(itemStack.func_77973_b() instanceof ItemMultiWarpTuner) || beamFrequency == -1) {
            return itemStack;
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a(TAG_BEAM_FREQUENCY, beamFrequency);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (world.field_72995_K || !(itemStack.func_77973_b() instanceof ItemMultiWarpTuner)) {
            return itemStack;
        }
        if (entityPlayer.func_70093_af()) {
            switch (itemStack.func_77960_j()) {
                case 0: {
                    ItemMultiWarpTuner.setVideoChannel(itemStack, world.field_73012_v.nextInt(32768));
                    WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"item.warpdrive.tool.MultiWarpTuner.use.getVideoChannel", (Object[])new Object[]{ItemMultiWarpTuner.getVideoChannel(itemStack)}));
                    return itemStack;
                }
                case 1: {
                    ItemMultiWarpTuner.setBeamFrequency(itemStack, world.field_73012_v.nextInt(65000));
                    WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"item.warpdrive.tool.MultiWarpTuner.use.getBeamFrequency", (Object[])new Object[]{ItemMultiWarpTuner.getBeamFrequency(itemStack)}));
                    return itemStack;
                }
            }
            return itemStack;
        }
        switch (itemStack.func_77960_j()) {
            case 0: {
                itemStack.func_77964_b(1);
                entityPlayer.func_70062_b(0, itemStack);
                break;
            }
            case 1: {
                itemStack.func_77964_b(0);
                entityPlayer.func_70062_b(0, itemStack);
                break;
            }
            default: {
                itemStack.func_77964_b(0);
            }
        }
        world.func_72956_a((Entity)entityPlayer, "WarpDrive:ding", 0.1f, 1.0f);
        return itemStack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return false;
        }
        switch (itemStack.func_77960_j()) {
            case 0: {
                if (tileEntity instanceof IVideoChannel) {
                    if (entityPlayer.func_70093_af()) {
                        ItemMultiWarpTuner.setVideoChannel(itemStack, ((IVideoChannel)tileEntity).getVideoChannel());
                        WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"item.warpdrive.tool.MultiWarpTuner.use.getVideoChannel", (Object[])new Object[]{ItemMultiWarpTuner.getVideoChannel(itemStack)}));
                    } else {
                        ((IVideoChannel)tileEntity).setVideoChannel(ItemMultiWarpTuner.getVideoChannel(itemStack));
                        WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"item.warpdrive.tool.MultiWarpTuner.use.setVideoChannel", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemMultiWarpTuner.getVideoChannel(itemStack)}));
                    }
                    return true;
                }
                return false;
            }
            case 1: {
                if (tileEntity instanceof IBeamFrequency) {
                    if (entityPlayer.func_70093_af()) {
                        ItemMultiWarpTuner.setBeamFrequency(itemStack, ((IBeamFrequency)tileEntity).getBeamFrequency());
                        WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"item.warpdrive.tool.MultiWarpTuner.use.getBeamFrequency", (Object[])new Object[]{ItemMultiWarpTuner.getBeamFrequency(itemStack)}));
                    } else {
                        ((IBeamFrequency)tileEntity).setBeamFrequency(ItemMultiWarpTuner.getBeamFrequency(itemStack));
                        WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"item.warpdrive.tool.MultiWarpTuner.use.setBeamFrequency", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemMultiWarpTuner.getBeamFrequency(itemStack)}));
                    }
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean advancedItemTooltips) {
        super.func_77624_a(itemStack, entityPlayer, list, advancedItemTooltips);
        String tooltip = "";
        switch (itemStack.func_77960_j()) {
            case 0: {
                tooltip = tooltip + StatCollector.func_74837_a((String)"item.warpdrive.tool.MultiWarpTuner.tooltip.videoChannel", (Object[])new Object[]{ItemMultiWarpTuner.getVideoChannel(itemStack)});
                break;
            }
            case 1: {
                tooltip = tooltip + StatCollector.func_74837_a((String)"item.warpdrive.tool.MultiWarpTuner.tooltip.beamFrequency", (Object[])new Object[]{ItemMultiWarpTuner.getBeamFrequency(itemStack)});
                break;
            }
            default: {
                tooltip = tooltip + "I'm broken :(";
            }
        }
        tooltip = tooltip + StatCollector.func_74838_a((String)"item.warpdrive.tool.MultiWarpTuner.tooltip.usage");
        WarpDrive.addTooltip(list, tooltip);
    }
}

