/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.data.UpgradeType;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemUpgrade
extends Item {
    private static ItemStack[] isCache = new ItemStack[UpgradeType.values().length];
    private static IIcon[] iconBuffer = new IIcon[UpgradeType.values().length];

    public ItemUpgrade() {
        this.func_77627_a(true);
        this.func_77655_b("warpdrive.upgrade.Malformed");
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
    }

    private static boolean isValidDamage(int damage) {
        return damage >= 0 && damage < UpgradeType.values().length;
    }

    public static ItemStack getItemStack(UpgradeType energy) {
        if (!ItemUpgrade.isValidDamage(energy.ordinal())) {
            return null;
        }
        if (isCache[energy.ordinal()] == null) {
            ItemUpgrade.isCache[energy.ordinal()] = ItemUpgrade.getItemStackNoCache(energy);
        }
        return isCache[energy.ordinal()];
    }

    public static ItemStack getItemStackNoCache(UpgradeType energy) {
        if (!ItemUpgrade.isValidDamage(energy.ordinal())) {
            return null;
        }
        return new ItemStack((Item)WarpDrive.itemUpgrade, 1, energy.ordinal());
    }

    public String func_77667_c(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        int damage = itemStack.func_77960_j();
        if (ItemUpgrade.isValidDamage(damage)) {
            return "item.warpdrive.upgrade." + (Object)((Object)UpgradeType.values()[damage]);
        }
        return null;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (UpgradeType upgradeType : UpgradeType.values()) {
            list.add(ItemUpgrade.getItemStack(upgradeType));
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer pl, List list, boolean par4) {
        if (is == null) {
            return;
        }
        int damage = is.func_77960_j();
        if (damage == UpgradeType.Energy.ordinal()) {
            list.add("Increases the max energy of the machine");
        } else if (damage == UpgradeType.Power.ordinal()) {
            list.add("Decreases the power usage of the machine");
        } else if (damage == UpgradeType.Speed.ordinal()) {
            list.add("Increases the speed of the machine");
        } else if (damage == UpgradeType.Range.ordinal()) {
            list.add("Increases the range of the machine");
        }
    }

    public void func_94581_a(IIconRegister ir) {
        for (UpgradeType val : UpgradeType.values()) {
            ItemUpgrade.iconBuffer[val.ordinal()] = ir.func_94245_a("warpdrive:upgrade" + (Object)((Object)val));
        }
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= 0 && damage < UpgradeType.values().length) {
            return iconBuffer[damage];
        }
        return iconBuffer[0];
    }
}

