/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.config.WarpDriveConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MessageVideoChannel
implements IMessage,
IMessageHandler<MessageVideoChannel, IMessage> {
    private int x;
    private int y;
    private int z;
    private int videoChannel;

    public MessageVideoChannel() {
    }

    public MessageVideoChannel(int x, int y, int z, int videoChannel) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.videoChannel = videoChannel;
    }

    public void fromBytes(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.videoChannel = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.videoChannel);
    }

    @SideOnly(value=Side.CLIENT)
    private void handle(World worldObj) {
        TileEntity tileEntity = worldObj.func_147438_o(this.x, this.y, this.z);
        if (tileEntity != null) {
            if (tileEntity instanceof IVideoChannel) {
                ((IVideoChannel)tileEntity).setVideoChannel(this.videoChannel);
            } else {
                WarpDrive.logger.error("Received video channel packet: (" + this.x + " " + this.y + " " + this.z + ") is not a valid tile entity");
            }
        } else {
            WarpDrive.logger.error("Received video channel packet: (" + this.x + " " + this.y + " " + this.z + ") has no tile entity");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageVideoChannel videoChannelMessage, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring video channel packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info("Received video channel packet: (" + videoChannelMessage.x + " " + videoChannelMessage.y + " " + videoChannelMessage.z + ") videoChannel '" + videoChannelMessage.videoChannel + "'");
        }
        videoChannelMessage.handle((World)Minecraft.func_71410_x().field_71441_e);
        return null;
    }
}

