require "behaviours/wander"
require "behaviours/doaction"
--require "behaviours/chaseandattack"
require "behaviours/standstill"
require "behaviours/follow"
require "behaviours/faceentity"
require "behaviours/panic"

local STOP_RUN_DIST = 10
local SEE_PLAYER_DIST = 5
local MAX_WANDER_DIST = 5
local SEE_TARGET_DIST = 6

local MAX_CHASE_DIST = 7
local MAX_CHASE_TIME = 8

local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end
local Frog_travelerBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function GoHomeAction(inst)
    if inst.components.homeseeker and 
       inst.components.homeseeker.home and 
       inst.components.homeseeker.home:IsValid() then
        return BufferedAction(inst, inst.components.homeseeker.home, ACTIONS.GOHOME)
    end
end

local function ShouldGoHome(inst)
    return (not TheWorld.state.isday ) and inst.ontravelling ~= 1 and inst.components.container:NumItems() <=0
end

function Frog_travelerBrain:OnStart()

    local root = PriorityNode(
    {
        WhileNode( function() return self.inst.components.hauntable and self.inst.components.hauntable.panic end, "PanicHaunted", Panic(self.inst)),
		WhileNode(function() return self.inst:HasTag("onopen") end, "onopen",StandStill(self.inst)),
		--[[WhileNode(function() return self.inst.ontravelling ~= 1 end, "ontravelling",
			Follow(self.inst, function() return self.inst.components.follower.leader end, 1, 4, 5, true)),--]]
		WhileNode(function() return ShouldGoHome(self.inst) end, "ShouldGoHome",
            DoAction(self.inst, function() return GoHomeAction(self.inst) end, "go home", true )),	
		FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn),
        Wander(self.inst, function() return self.inst.ontravelling ~= 1 and  self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST),
    }, .25)
    
    self.bt = BT(self.inst, root)
    
end

return Frog_travelerBrain
