require "prefabutil"
--require ("prefabs\critters")
local assets =
{
    Asset("ANIM", "anim/frogbaby.zip"),
    Asset("SOUND", "sound/frog.fsb"),
	Asset("ANIM", "anim/ui_cookpot_1x4.zip"),
}

local prefabs =
{
    "froglegs",
    "frogsplash",
}

local gift_list = 
{
[1] = {name = "winter_ornament_light1", price = 150},--圣诞灯红
[2] = {name = "winter_ornament_light2", price = 150},--圣诞灯绿
[3] = {name = "winter_ornament_light3", price = 150},--圣诞灯蓝
[4] = {name = "winter_ornament_light4", price = 150},--圣诞灯白
[5] = {name = "fireflies", price = 84},--萤火虫
[6] = {name = "redgem", price = 100},--红宝石
[7] = {name = "bluegem", price = 100},--蓝宝石
[8] = {name = "purplegem", price = 125},--紫宝石
[9] = {name = "greengem", price = 1400},--绿宝石
[10] = {name = "orangegem", price = 1100},--橙宝石
[11] = {name = "yellowgem", price = 1100},--黄宝石
[12] = {name = "trinket_15", price = 270},--白主教
[13] = {name = "trinket_16", price = 270},--黑主教
[14] = {name = "trinket_28", price = 270},--白战车
[15] = {name = "trinket_29", price = 270},--黑战车
[16] = {name = "trinket_30", price = 270},--白骑士
[17] = {name = "trinket_31", price = 270},--黑骑士
[18] = {name = "feather_crow", price = 16},--黑鸟毛
[19] = {name = "feather_robin", price = 18},--红鸟毛
[20] = {name = "feather_robin_winter", price = 22},--蓝鸟毛
[21] = {name = "feather_canary", price = 36},--金鸟毛
----------------------------------------------------------------下面是一些小玩意儿
[22] = {name = "trinket_1", price = 270},
[23] = {name = "trinket_2", price = 270},
[24] = {name = "trinket_3", price = 270},
[25] = {name = "trinket_4", price = 270},
[26] = {name = "trinket_5", price = 270},
[27] = {name = "trinket_6", price = 270},
[28] = {name = "trinket_7", price = 270},
[29] = {name = "trinket_8", price = 270},
[30] = {name = "trinket_9", price = 270},
[31] = {name = "trinket_10", price = 270},
[32] = {name = "trinket_11", price = 270},
[33] = {name = "trinket_12", price = 270},
}

local brain = require "brains/frog_travelerbrain"
local timea = (TUNING.LY_CODER and 5) or TUNING.TOTAL_DAY_TIME * 2
local timeb = (TUNING.LY_CODER and 10) or TUNING.TOTAL_DAY_TIME * 5

local function init(inst)
    if inst.icon == nil and not inst:HasTag("burnt") then
        inst.icon = SpawnPrefab("globalmapicon")
        inst.icon.MiniMapEntity:SetIsFogRevealer(true)
        inst.icon:TrackEntity(inst)
    end
end

local function ShouldSleep(inst) 
    return false -- frogs either go to their home, or just sit on the ground.
end

local function onopen(inst)
	inst:AddTag("onopen")
	inst.AnimState:PlayAnimation("idle")
    inst.Physics:Stop()
end 

local function onclose(inst)
	inst:RemoveTag("onopen")
	inst.AnimState:PlayAnimation("idle")
    inst.Physics:Stop()
end 

local function onfar(inst)
    if inst.components.container ~= nil then
        inst.components.container:Close()
    end
end

local function isfood(inst)
	if (inst.components and inst.components.edible) ----------------------------能吃
	and not inst:HasTag("badfood") ----------------------不是怪物类的食物
	and inst.prefab ~= "spoiled_food"  and inst.prefab ~= "wetgoop"  --------不是腐烂食物或者黏湿稀糊
	and not string.find(inst.prefab,'seed')----------------------------------不是种子
	and (inst.components.perishable and inst.components.perishable:GetPercent() >= 0.75) then ----------------新鲜度大于等于75%
		return true
	end
	return false
end 

local function hasfit(inst)
	return inst.components and inst.components.finiteuses
end 

local function isfueled(inst)
	return inst.components and inst.components.fueled
end 

local function isarmor(inst)
	return inst.components and inst.components.armor
end 

local function RemoveAll(inst)
	for k, v in pairs(inst.components.container.slots) do
		if isfood(v) then 
			v:Remove() 
		end
		if hasfit(v) then
			local uses = v.components.finiteuses:GetPercent() - math.random(1,50) / 100
			uses = math.max(0,uses)
			v.components.finiteuses:SetPercent(uses)
		end
		if isfueled(v) then
			local uses = v.components.fueled:GetPercent() - math.random(1,50) / 100
			uses = math.max(0,uses)
			v.components.fueled:SetPercent(uses)
		end
		if isarmor(v) then
			local uses = v.components.armor:GetPercent() - math.random(1,50) / 100
			uses = math.max(0,uses)
			v.components.armor:SetPercent(uses)
		end
		
    end
end 

local function checkvalue(inst)
	local foods = inst.components.container:FindItems(isfood)
	local works = inst.components.container:FindItems(hasfit)
	local fuel = inst.components.container:FindItems(isfueled)
	local armor = inst.components.container:FindItems(isarmor)
	local val = 0
	for k,v in pairs(foods) do 
		local nums = (v.components.stackable and v.components.stackable:StackSize()) or 1
		for i =1,nums do 
			val = val + v.components.edible:GetHunger()
		end 
		print("Food:",v.prefab,nums)
	end 
	for k,v in pairs(works) do 
		val = val + math.min(100,v.components.finiteuses:GetUses())
	end 
	for k,v in pairs(fuel) do 
		val = val + math.min(100,v.components.fueled.currentfuel)
	end 
	for k,v in pairs(armor) do 
		val = val + math.min(100,v.components.armor.condition / 2)
	end 
	print("Check Vals:",val)
	return val
end 

local function checkfood(inst)
	local foods = inst.components.container:FindItems(isfood)
	local i = 0
	for k,v in pairs(foods) do 
		i = i + 1
	end 
	if i > 0 then 
		return true
	end
	return false
end 

local function can_travel(inst)
	return inst.ontravelling ~= 1 and checkfood(inst) and checkvalue(inst) >= 80
end 

local function start_traveling(inst) 
	inst.components.container.canbeopened = false
	inst.val = checkvalue(inst)
	RemoveAll(inst)
	local a,b,c = inst:GetPosition():Get()
	--inst.beginpos = {a,b,c}
	local x,y,z = 0,0,0
	while not TheWorld.Map:IsAboveGroundAtPoint(x,y,z) or  ( x == 0 and y == 0 and z == 0)  do 
		local offset = math.random(2000,4500)
        x = a + math.random(2 * offset) - offset
		y = 0
		z = c + math.random(2 * offset) - offset
	end 
	inst.Physics:Teleport(x,y,z)
	inst.traveltime = math.random(timea, timeb)--------------------------------------设置旅行持续的总时间
	inst.ontravelling = 1
	TheNet:Announce("一只旅行青蛙出门啦!")
	if TUNING.LY_CODER then 
		TheNet:Announce("Travel Time: "..(inst.traveltime/TUNING.TOTAL_DAY_TIME).."Days")
	end 
end 

local function travelover(inst)
	inst.components.container.canbeopened = true
	inst.Physics:Teleport(inst.components.knownlocations:GetLocation("spawnpos"):Get())
	local maxtries = math.min(8,inst.val / 80)
	local mintries = math.max(0,maxtries-1)
	local tries = math.random(mintries,maxtries)
	for i = 1,tries do 
		local prefab = gift_list[math.random(1,#gift_list)].name
		if inst.components.container then 
			inst.components.container:GiveItem(SpawnPrefab(prefab)) 
		end 
	end 
	inst.ontravelling = 0
	inst.val = 0
	TheNet:Announce("一只旅行青蛙回家了!")
end 

local function ondeath(inst)
	TheNet:Announce("一只旅行青蛙死掉了!")
end 

local function OnEntitySleep(inst)
	if can_travel(inst) then 
		start_traveling(inst)
	end
end 



local function onsave(inst,data)
	data.ontravelling = inst.ontravelling or nil 
	data.traveltime = inst.traveltime or nil 
	data.beginpos = inst.beginpos or nil
	data.val = inst.val or nil 
end

local function onload(inst,data)
	if data ~= nil and data.ontravelling ~= nil then
		inst.ontravelling = data.ontravelling
		if inst.ontravelling == 1 then 
			inst.components.container.canbeopened = false
		else
			inst.components.container.canbeopened = true
		end
	end
	if data ~= nil and data.traveltime ~= nil then
		inst.traveltime = data.traveltime
	end
	if data ~= nil and data.beginpos ~= nil then
		inst.beginpos = data.beginpos
	end
	if data ~= nil and data.val ~= nil then
		inst.val = data.val
	end
end 

local frogslot =
{
    widget =
    {
        slotpos = {	Vector3(0,64+32+8+4,0), 
					Vector3(0,32+4,0),
					Vector3(0,-(32+4),0), 
					Vector3(0,-(64+32+8+4),0)
					},
        animbank = "ui_cookpot_1x4",
        animbuild = "ui_cookpot_1x4",
        pos = Vector3(200,0,0)
    },
    --issidewidget = true,
    type = "chest",
}

local containers = require("containers")
local widgetsetup_old = containers.widgetsetup
function containers.widgetsetup(container, prefab, data, ...)

 if container.inst.prefab == "frog_traveler" or prefab == "frog_traveler" then
  
      for k, v in pairs(frogslot) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
        return
  
  end
      return widgetsetup_old(container, prefab, data, ...)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddDynamicShadow()
    inst.entity:AddNetwork()

    MakeCharacterPhysics(inst, 1, .3)

    inst.DynamicShadow:SetSize(1.5, .75)
    inst.Transform:SetFourFaced()

	if TUNING.LY_CODER then 
		inst.entity:AddMiniMapEntity()
		--inst.MiniMapEntity:SetIcon("reticuleaoe_nucler_warnning.tex")
		inst.MiniMapEntity:SetCanUseCache(false)
		inst.MiniMapEntity:SetDrawOverFogOfWar(true)
	end 
	
    inst.AnimState:SetBank("frogbaby")
    inst.AnimState:SetBuild("frogbaby")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("animal")
    inst:AddTag("prey")
    inst:AddTag("hostile")
    inst:AddTag("smallcreature")
    --inst:AddTag("frog")
    --inst:AddTag("canbetrapped")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = 4
    inst.components.locomotor.runspeed = 8

    inst:SetStateGraph("SGfrog_traveler")

    inst:SetBrain(brain)

    inst:AddComponent("sleeper")
    inst.components.sleeper:SetSleepTest(ShouldSleep)

    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(300)
	inst.components.health:SetAbsorptionAmount(1.0)



    MakeTinyFreezableCharacter(inst, "frogsack")

    MakeHauntablePanic(inst)

    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetLoot({"froglegs"})

    inst:AddComponent("knownlocations")
	inst:DoTaskInTime(0.2,function()
	local spawnpos = inst:GetPosition()
	inst.components.knownlocations:RememberLocation("spawnpos", spawnpos,true)
	end)
	
    inst:AddComponent("inspectable")
	inst.components.inspectable:SetDescription("我的蛙蛙!")
	
	inst:AddComponent("follower")

	
	inst:AddComponent("container")
	inst.components.container:WidgetSetup("frog_traveler", frogslot)
	inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose
	
	inst:AddComponent("playerprox")
    inst.components.playerprox:SetDist(3,5)
    inst.components.playerprox:SetOnPlayerFar(onfar)
	
	if TUNING.LY_CODER then 
		inst:AddComponent("maprevealer")
		inst:DoTaskInTime(0, init)
	end 
	
	inst.ontravelling = 0
	inst.traveltime = 0
	inst.val = 0
	inst.beginpos = {0,0,0}
	
	inst:DoPeriodicTask(1,function()
	inst.traveltime = inst.traveltime - 1
	inst.traveltime = math.max(inst.traveltime,0)
		if inst.traveltime <= 0 and inst.ontravelling == 1 then 
			travelover(inst)
		end 
	end )
	
	inst.OnSave = onsave
	inst.OnLoad = onload
	
	inst:ListenForEvent("death", ondeath)
	inst:ListenForEvent("entitysleep", OnEntitySleep)
    return inst
end
STRINGS.NAMES.FROG_TRAVELER = "一只呱娃子"

return Prefab("frog_traveler", fn, assets, prefabs)
