local assets =
{
    Asset("ANIM", "anim/froghouse.zip"),--------建筑的贴图文件
}

local prefabs =
{
   -- "marble",
  
}


SetSharedLootTable( 'froghouse',     --------------建筑被破坏后掉落的东西列表
{
    --{'marble', 1.00},
})

local function testfn(inst,builder)----------------------------------------只能在地面建唯一的蛙蛙房子
	if TheWorld:HasTag("cave") then
		return false
	end 
	local x,y,z = inst:GetPosition():Get()
	local houses = TheSim:FindEntities(x,y,z, 10000, {"froghouse"})
	local num = 0
	for k,v in pairs(houses) do
		if v.prefab == "froghouse" and v.ownerid ~= 0 and v.ownerid == builder.userid then 
			num = num + 1
		end 
	end
	if num >= 2 then
		return false
	end
	return true
end


local function onworked(inst, worker, workleft)--------------建筑被砸的时候触发的函数

    if workleft <= 0 then ----------------如果在一次砸击中建筑被彻底破坏了
        local pos = inst:GetPosition()
		SpawnPrefab("collapse_small").Transform:SetPosition(pos:Get())-----------生成破坏样子的特效
        inst.components.lootdropper:DropLoot(pos)---------------原地掉落列表中的东西
		inst.components.childspawner:StopRegen()--------------------------------------停止生成蛙蛙
		for k, child in pairs(inst.components.childspawner.childrenoutside) do
			child.components.container:DropEverything()-------------------------------掉落所有物品
			child:Remove()------------------------------------------------------------被摧毁时移除所有它的蛙蛙
		end
        inst:Remove()--------移除建筑
    else

    --[[    inst.AnimState:PlayAnimation( ---------------建筑的样子随着耐久的变化而变化
            (workleft < TUNING.MARBLEPILLAR_MINE / 3 and "idle_low") or -------------被砸的差不多了
            (workleft < TUNING.MARBLEPILLAR_MINE * 2 / 3 and "idle_med") or --------------还没怎么被砸
            "idle_full"    --------------完全完好无损的样子
        )--]]
	end

end

local function ReturnChildren(inst)
    for k, child in pairs(inst.components.childspawner.childrenoutside) do
		if child.components.container:NumItems() <=0 and child.ontravelling ~= 1 then 
			if child.components.homeseeker ~= nil then
				child.components.homeseeker:GoHome()
			end
			child:PushEvent("gohome")
		end 
    end
end

local function OnChange(inst)
    local season = TheWorld.state.season
	local day = TheWorld.state.phase
	if day == "dusk" then
		day = "night"
	end
	if TheWorld.state.issnowcovered and season == "winter" then 
		season = "snow"
	end
	local anim = season.."_"..day
	inst.AnimState:PlayAnimation(anim,true)
	if day == "night" then
		inst.Light:Enable(true)
		ReturnChildren(inst)
		inst.components.childspawner:StopSpawning()
	else 
		inst.components.childspawner:StartSpawning()-------------白天才开始执行
		inst.Light:Enable(false)
	end
end

local function OnSave(inst,data)
	data.ownerid = inst.ownerid or nil 
end 

local function OnLoad(inst,data)
	if data ~= nil and data.ownerid ~= nil then 
		inst.ownerid = data.ownerid or 0
	end 
end 

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()
	inst.entity:AddLight()

    MakeObstaclePhysics(inst, 1.8) --------------建筑物理碰撞体积
	local minimap = inst.entity:AddMiniMapEntity() -------------设置小地图标志
	minimap:SetIcon("froghouse.tex")
	

    inst.AnimState:SetBank("froghouse")
    inst.AnimState:SetBuild("froghouse")
    inst.AnimState:PlayAnimation("idle") ----------喜闻乐见的动画设置
	inst.Transform:SetScale(2,2,2)-----------------在这里设置建筑的放大缩小
	inst:AddTag("froghouse") -------------------添加一个小标签QwQ
	
	inst.Light:SetIntensity(0.7)
	inst.Light:SetRadius(2)
	inst.Light:SetFalloff(0.5)
	inst.Light:SetColour(237/255,173/255,0/255)
	inst.Light:Enable(true)

	inst.ownerid = 0
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetChanceLootTable('froghouse') -------------设置掉落物组件，和开头的列表对应

    inst:AddComponent("inspectable")
	inst.components.inspectable:SetDescription("蛙蛙的家") ------------设置可检查组件
    inst:AddComponent("workable") -----------------------------设置可摧毁组件
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)------------------------摧毁这个建筑必须用稿子挖（挖：MINE）
    inst.components.workable:SetOnWorkCallback(onworked)------------------------设置摧毁过程中每砸一下就会触发的函数
	
    inst:AddComponent("childspawner") ------------------------拓展：设置生成组件，就像猪人火炬一样会定时生成猪人守卫那样
    inst.components.childspawner.childname = "frog_traveler" ------------------------------设置生成生物（以下称：孩子）的名字
    inst.components.childspawner:SetRegenPeriod(TUNING.TOTAL_DAY_TIME *4 )--------------设置孩子重生的速度是4天（孩子死了以后重生这个孩子需要4天）
    inst.components.childspawner:SetSpawnPeriod(1)---------------设置孩子的生成速度是1秒，好像不是？
    inst.components.childspawner:SetMaxChildren(1)---------拥有孩子的最大数量
    inst.components.childspawner:StopSpawning()---------------先不开始执行

   
    
	inst:WatchWorldState("season", OnChange)
	inst:WatchWorldState("startday", OnChange)
	inst:WatchWorldState("startdusk", OnChange)
	inst:WatchWorldState("startnight", OnChange)
	inst:ListenForEvent("onbuilt", function(inst,data)
		local builder = data.builder
		inst.ownerid = builder.userid
		if not testfn(inst,builder) then 
			inst.components.workable:Destroy(builder)
			if builder.components.talker then
				builder.components.talker:Say("我只能在地面建造一个唯一的旅行青蛙小窝")
			end
		end 
	end)
	OnChange(inst)
	
	inst.OnSave = OnSave
	inst.OnLoad = OnLoad
	
	MakeSnowCovered(inst)
	MakeHauntableWork(inst)
    return inst
end
STRINGS.NAMES.FROGHOUSE = "旅行小窝"

return Prefab("froghouse", fn, assets, prefabs),
MakePlacer("common/froghouse_placer", "froghouse", "froghouse", "build") 