local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

local start_inv = {
	"miamirick_portal_gun"
}

local function onbecamehuman(inst)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "miamirick_speed_mod", 1)
end

local function onbecameghost(inst)
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "miamirick_speed_mod")
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end


local common_postinit = function(inst) 
	inst.MiniMapEntity:SetIcon( "miamirick.tex" )
end




local function FindRandomPoint(inst, dist, atm)
	local attemp = atm or 0
    local dst = dist or 5
	local radius = dst
	local theta = math.random()*2*PI
	local offset = Vector3(radius * math.cos( theta ), 0, -radius * math.sin( theta ) )
	local pt = Vector3(inst.Transform:GetWorldPosition()) + offset  
	
	
	if pt and TheWorld.Map:GetTileAtPoint(pt:Get()) ~= GROUND.IMPASSABLE then
		return pt.x, pt.y, pt.z
    elseif attemp<10 then
		FindRandomPoint(inst, dst+1.5, attemp+1)
	else
		return 
	end
	
end

local function SetUpPortal(inst, chance)
	print("SetUpPortal(inst, chance)")
	if math.random()< chance then
		local portal_prefab = "miamirick_portal_enemy"
		
		local pt1 = Vector3(inst.Transform:GetWorldPosition())
		local x, y, z = pt1.x, 0, pt1.z
		local x1, y1, z1 = FindRandomPoint(inst)
		if x1 then
			x,y,z = x1, 0, z1 
		end
		
		local portal = SpawnPrefab(portal_prefab)
		
		portal.Transform:SetPosition(x, 0, z)
	end
	
end



local function OnUnlock(inst, recipe)
	print("OnUnlock")
	SetUpPortal(inst, TUNING.DES_MIAMIRICK_SCIENCE_HAUNT_CHANCE * TUNING.DES_MIAMIRICK_SCIENCE_HAUNT_UNLOCK_MULT)

end

local function OnBuild(inst, recipe)
	print("OnUnlock")
	SetUpPortal(inst, TUNING.DES_MIAMIRICK_SCIENCE_HAUNT_CHANCE)

end


local master_postinit = function(inst)
	inst.soundsname = "maxwell"

	inst:AddTag("miamirick")

	inst.components.health:SetMaxHealth(TUNING.DES_MIAMIRICK_HEALTH)
	
	inst.components.hunger:SetMax(TUNING.DES_MIAMIRICK_HUNGER)
	inst.components.hunger:SetRate(TUNING.DES_MIAMIRICK_HUNGERRATE * TUNING.WILSON_HUNGER_RATE)
	
	inst.components.sanity:SetMax(TUNING.DES_MIAMIRICK_SANITY)
	inst.components.sanity.night_drain_mult = TUNING.DES_MIAMIRICK_SANITYRESIST
    inst.components.sanity.neg_aura_mult = TUNING.DES_MIAMIRICK_SANITYRESIST


    inst.components.combat.damagemultiplier = 1 * TUNING.DES_MIAMIRICK_DAMAGEMULT
	
	inst.components.temperature.maxtemp = 60
	
	inst:ListenForEvent("unlockrecipe", OnUnlock)	
	inst:ListenForEvent("buildstructure", OnBuild)	
	inst:ListenForEvent("builditem", OnBuild)	
	
	--self.science_bonus = 0
   -- self.magic_bonus = 0
	
	if TUNING.DES_MIAMIRICK_ENABLE_RESEARCH_BONUSES == true then
		inst:DoPeriodicTask(10, function()
			local sanity = inst.components.sanity:GetPercent()
			--if TUNING.DES_MIAMIRICK_MAGIC_ON_INSANITY == true then
				if sanity < TUNING.DES_MIAMIRICK_MAGIC_ON_INSANITY_MINUMUM and TUNING.DES_MIAMIRICK_MAGIC_ON_INSANITY == true then
					inst.components.builder.magic_bonus = 2
					inst:AddTag("miamirick_no_science_recipes")
				else
					inst:RemoveTag("miamirick_no_science_recipes")
					inst.components.builder.magic_bonus = 0
				end
			--end
			if sanity > TUNING.DES_MIAMIRICK_SCIENCE_ON_SANITY_MINUMUM and TUNING.DES_MIAMIRICK_SCIENCE_ON_SANITY == true then
				inst.components.builder.science_bonus = 1
				inst:AddTag("miamirick_no_magic_recipes")
			else
				inst.components.builder.science_bonus = 0
				inst:RemoveTag("miamirick_no_magic_recipes")
			end
			
		end)
	end
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	inst.components.locomotor.walkspeed = 6 * TUNING.DES_MIAMIRICK_SPEEDMULT
	inst.components.locomotor.runspeed = 6 * TUNING.DES_MIAMIRICK_SPEEDMULT
	

	
	
	
	--if TUNING.DES_MIAMIRICK_EBABLE_SCIENCE_BONUS == true then
	--	inst.components.builder.science_bonus = 1
	--end
	
	inst.components.temperature.hurtrate = 3
	
end

return MakePlayerCharacter("miamirick", prefabs, assets, common_postinit, master_postinit, start_inv)
