local assets =
{
    Asset("ANIM", "anim/miamirick_portal.zip"),
}




---------inst.Transform:GetWorldPosition() 



local function SpawnEffect(inst)
    local x, y, z = inst.Transform:GetWorldPosition()
	print("local function SpawnEffect(inst)")
	
			local backfx = SpawnPrefab("collapse_big")-------inst.backfx)
		--collapse_big
        SpawnPrefab("collapse_big").Transform:SetPosition(x, y - .1, z)
		
		local frontfx = SpawnPrefab("collapse_big")-------SpawnPrefab(inst.frontfx)
        SpawnPrefab("collapse_big").Transform:SetPosition(x, y, z)		
		
    if inst.backfx ~= nil then
	print("local function    inst.backfx ~= nil SpawnEffect(inst)")
		local backfx = SpawnPrefab("collapse_big")-------inst.backfx)
		--collapse_big
        backfx.Transform:SetPosition(x, y - .1, z)
		--backfx.entity:AddAnimState()
		--backfx.AnimState:SetMultColour(inst.fxcolour[1], inst.fxcolour[2], inst.fxcolour[3], 0.5)
    end
    if inst.frontfx ~= nil then
		local frontfx = SpawnPrefab("collapse_big")-------SpawnPrefab(inst.frontfx)
        frontfx.Transform:SetPosition(x, y, z)
	   -- frontfx.entity:AddAnimState()

		--frontfx.AnimState:SetMultColour(inst.fxcolour[1], inst.fxcolour[2], inst.fxcolour[3], 0.5)
    end
end





local function SpawnMob(prefabname, portal, count)
	if count < 1 then return end
	local i = 1
	repeat
	i = i + 1
	
	local monster = SpawnPrefab(prefabname)
	monster.Transform:SetPosition(portal.Transform:GetWorldPosition())
	SpawnEffect(monster)
	
	
	until i > count
end


local function SpawnEnemies(portal)
	local group = TUNING.DES_MIAMIRICK_PORTAL_ENEMY_GROUPS[math.random(#TUNING.DES_MIAMIRICK_PORTAL_ENEMY_GROUPS)]
	local max_easy = group[1]
	local max_hard = group[2]
	
	local mob1 = group[3]
	local mob2 = group[4]

	local mob3 = group[5]
	local mob4 = group[6]	
	
	local mob1_ammount = math.floor(math.random(0, max_easy))
	local mob2_ammount = math.floor(math.random(0, max_easy))
	
	local mob3_ammount = math.floor(math.random(0, max_hard))
	local mob4_ammount = math.floor(math.random(0, max_hard))
	
	portal:DoTaskInTime(1+1*math.random(), function()
		SpawnMob(mob1, portal, mob1_ammount)
	end)
	portal:DoTaskInTime(4+2*math.random(), function()
		SpawnMob(mob2, portal, mob2_ammount)
	end)
	portal:DoTaskInTime(6+3*math.random(), function()
		SpawnMob(mob3, portal, mob3_ammount)
	end)
	portal:DoTaskInTime(10+6*math.random(), function()
		SpawnMob(mob4, portal, mob4_ammount)
	end)


end


local function OnActivate(inst, player)
	if inst.portal_link then
		local x, y, z = inst.portal_link.Transform:GetWorldPosition() 
		SpawnEffect(player)
        player.Transform:SetPosition(x, 0, z)
		inst.components.activatable.inactive = true
		SpawnEffect(inst)
	end
end

local function OnSave(inst, data)
	data.portal_link = inst.portal_link
	data.perish_time = inst.perish_time
end

local function OnLoad(inst, data)
	if data and data.portal_link then
		inst.portal_link = data.portal_link
		inst.perish_time = 16
	else
		--portal has no link delete portal
		inst:Remove()
	end
end

local function DestroyPortal(inst)
	inst.perish_time = 100
	inst.AnimState:PlayAnimation("death")
	------inst.AnimState:PushAnimation("death", true)
	local a = 1
	inst:DoPeriodicTask(2.7, function()
		a = 1-0.03
		inst.AnimState:SetMultColour(1,1,1,a)
	end)
	inst:DoTaskInTime(2.7, function()
		inst:Remove()
	end)		
end




local function buildgem(type)


    local function fn()
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddSoundEmitter()
        inst.entity:AddNetwork()

        MakeInventoryPhysics(inst)
		inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")

        inst.AnimState:SetBank("miamirick_portal")
        inst.AnimState:SetBuild("miamirick_portal")

        inst.entity:SetPristine()
		
		local s = 1.75	
		inst.Transform:SetScale(s,s,s )
		
        if not TheWorld.ismastersim then
            return inst
        end

		--""
		--inst.frontfx = "shadow_puff_large_front"
		--inst.backfx = "shadow_puff_large_back"
		
		inst.frontfx = "collapse_big"
		inst.backfx = "collapse_big"		
		
		if type == "_enemy" then
			inst.fxcolour = {200/255, 100/255, 50/255}
		else
			inst.fxcolour = {100/255, 255/255, 100/255}
		end
		--inst.plclr[1], inst.plclr[2], inst.plclr[3]
		
        inst:AddComponent("inspectable")

		inst:AddComponent("activatable")
		inst.components.activatable.OnActivate = OnActivate
		inst.components.activatable.inactive = true
		inst.components.activatable.quickaction = true
		
		
		inst.persists = false
		inst.perish_time = 16
		--	inst.OnSave = OnSave
		--inst.OnLoad = OnLoad	
	
		if type=="_enemy" then
			inst.perish_time = 22
			inst:DoTaskInTime(3, function()
				SpawnEnemies(inst)
			end)
		end

		
		inst:DoPeriodicTask(4, function()
			inst.perish_time = inst.perish_time - 4
			if inst.perish_time <= 0 then
				if inst.portal_link then
					DestroyPortal(inst.portal_link)
				end
				DestroyPortal(inst)
			end
		end)
	

		inst:DoTaskInTime(0, function()
			inst.AnimState:PlayAnimation("birth")
			inst.AnimState:PushAnimation("idle", true)
			
		end)	
	
        return inst
    end
    return Prefab("miamirick_portal"..type, fn, assets)
end

return buildgem(""),
buildgem("_enemy")
