


local waterballoon_prefabs =
{
    "waterballoon_splash",
}

local assets=
{
	Asset("ANIM", "anim/portalgun_ground.zip"),
	Asset("ANIM", "anim/swap_portalgun.zip"),
    Asset("IMAGE", "images/inventoryimages/miamirick_portal_gun.tex"),
	Asset("ATLAS", "images/inventoryimages/miamirick_portal_gun.xml")
}


local function removefire(inst) 
	if inst.fire then
		inst.fire:Remove()
		inst.fire = nil
	end
end




local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_portalgun", "swap_portalgun")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
	
	if inst.components.finiteuses.current >= 5 then
		if inst.fire == nil then
			inst.fire = SpawnPrefab("portal_gun_green")
			local c = 0.25
			inst.fire.Transform:SetScale(c,c,c)
			inst.fire.entity:AddFollower()
			inst.fire.Follower:FollowSymbol(owner.GUID, "swap_object", 40, -40, 0)
		end	
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", -43, -100, 1)
	end
end

local function onunequip(inst, owner) 
	removefire(inst)
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function ReticuleTargetFn()
    local player = ThePlayer
    local ground = TheWorld.Map
    local pos = Vector3()
    --Attack range is 8, leave room for error
    --Min range was chosen to not hit yourself (2 is the hit range)
    for r = 6.5, 3.5, -.25 do
        pos.x, pos.y, pos.z = player.entity:LocalToWorldSpace(r, 0, 0)
        if ground:IsPassableAtPoint(pos:Get()) and not ground:IsPointNearHole(pos) then
            return pos
        end
    end
    return pos
end

local easing = require("easing")
local function LaunchProjectile(inst, targetpos)
    local x, y, z = inst.Transform:GetWorldPosition()

   -- local projectile = SpawnPrefab("des_aqua_waterball")
	--
    local projectile = SpawnPrefab("miamirick_portal_gun_missle")
	
	
    projectile.Transform:SetPosition(x, 0, z)

    --V2C: scale the launch speed based on distance
    --     because 15 does not reach our max range.
    local dx = targetpos.x - x
    local dz = targetpos.z - z
    local rangesq = dx * dx + dz * dz
    local maxrange = TUNING.FIRE_DETECTOR_RANGE*1.6
    local speed = 45 ----------0.01*1.75*easing.linear(rangesq, 15, 3, maxrange * maxrange)
    projectile.components.complexprojectile:SetHorizontalSpeed(speed)
    projectile.components.complexprojectile:SetGravity(-15)
    projectile.components.complexprojectile:Launch(targetpos, inst, inst)
end


local function teleport_func(staff, tar, pos)
	local caster = staff.components.inventoryitem.owner
	if staff.components.finiteuses.current <= 0 then
		if caster.prefab == "miamirick" then
			caster.components.talker:Say("Oh, shit, it needs fuel!")
		else
			caster.components.talker:Say("It is discharged.")
		end
	else
		staff.components.finiteuses:Use(5)
		if staff.components.finiteuses.current < 5 then
			removefire(staff) 
		end
		LaunchProjectile(caster, pos)	
	end

end



local discription_variants =
 {	"I am the smartest thing on every conceivable universe.",
	"The Infinite Rick, a God.",
	"That's the three lines of math that separates my life as a man from my life as an unfeeling ghost.",
	"It produces sci-fi noises...",
	"A sort of breakthrough..."	
}

local function onperish(inst,owner)
	if inst.fire then
		inst.fire:Remove()
		inst.fire = nil
	end
end

local function des_aqua_staff_fn()
	
	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    -------inst.entity:AddLight()

   -- if isinventoryitem then
	MakeInventoryPhysics(inst)

	inst:AddTag("miamirick_portal_gun")
   -- if tag ~= nil then
   --     inst:AddTag("projectile")
    --end

	--inst.Light:SetIntensity(.75)
  --  inst.Light:SetColour(100 / 255, 200 / 255, 100 / 255)
  --  inst.Light:SetFalloff(.25)
  --  inst.Light:SetRadius(0.5)

    inst.AnimState:SetBank("portalgun_ground") 
    inst.AnimState:SetBuild("portalgun_ground")  
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()


    inst:AddComponent("reticule")
    inst.components.reticule.targetfn = ReticuleTargetFn
    inst.components.reticule.ease = true

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("locomotor")


   ----- inst:AddComponent("complexprojectile")

	
	inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(teleport_func)
    inst.components.spellcaster.quickcast = true
	inst.components.spellcaster.canuseonpoint = true
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.AXE_DAMAGE*0.75)

	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.DES_MIAMIRICK_PORTAL_GUN_MAXFUEL)
    inst.components.finiteuses:SetUses(TUNING.DES_MIAMIRICK_PORTAL_GUN_MAXFUEL)

    inst.components.finiteuses:SetOnFinished(onperish)
	
	inst:AddComponent("inspectable")


    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/miamirick_portal_gun.xml"
    

	inst:DoPeriodicTask(15, function()
		local word = discription_variants[math.random(#discription_variants)]
		if inst.components.inventoryitem:GetGrandOwner() and inst.components.inventoryitem:GetGrandOwner().prefab == "miamirick" then
			inst.components.inspectable:SetDescription(word)
		else
			inst.components.inspectable:SetDescription("Leads to the world unknown.")		
		end
	end)

	
	
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
  ---  inst.components.equippable.equipstack = true

  
   -- inst:AddComponent("fueled")
   -- inst.components.fueled:InitializeFuelLevel(20)
   -- inst.components.fueled.CanAcceptFuelItem = function (inst, item) return item:HasTag("miamirick_portal_gun_fuel") end
   -- inst.components.fueled.accepting = true
  
  
    MakeHauntableLaunch(inst)

    return inst
end

return Prefab("miamirick_portal_gun", des_aqua_staff_fn, assets, waterballoon_prefabs)

--[[
https://steamuserimages-a.akamaihd.net/ugc/401181903791118090/98F789A4FF4D882ACBD12FBFC22711B3D9CD657F/


ToDo:
Art:
1) Equipable portal gun
2) Portal

Code:
1) Portal prefabs
2) Portal gun shooting
3) Portals link
4) Portals teleport




I am the smartest thing on every conceivable universe.
The Infinite Rick, a God.
That's the three lines of math that separates my life as a man from my life as an unfeeling ghost.
--]]
