local snowball_assets =
{
    Asset("ANIM", "anim/des_portalgun_missle.zip"),
}

local snowball_prefabs =
{
    "splash_snow_fx",
}



local waterballoon_prefabs =
{
    "waterballoon_splash",
}

local function onthrown(inst)
    inst:AddTag("NOCLICK")
    inst.persists = false

    inst.AnimState:PlayAnimation("spin_loop", true)

    inst.Physics:SetMass(1)
    inst.Physics:SetCapsule(0.2, 0.2)
    inst.Physics:SetFriction(0)
    inst.Physics:SetDamping(0)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.ITEMS)
end





local function getrandomposition(caster)
    local ground = TheWorld
    local centers = {}
    for i, node in ipairs(ground.topology.nodes) do
        if ground.Map:IsPassableAtPoint(node.x, 0, node.y) then
            table.insert(centers, {x = node.x, z = node.y})
        end
    end
    if #centers > 0 then
        local pos = centers[math.random(#centers)]
        return pos.x, 0, pos.z
    else
        return caster:GetPosition()
    end
end


local function SetUpPortal(inst, x, z, ischild, isparent)
	local portal_prefab = "miamirick_portal"
	if not ischild and (math.random() < TUNING.DES_MIAMIRICK_ENABLE_EVILPORTALS) then
		portal_prefab = "miamirick_portal_enemy"
	end
	
	local portal = SpawnPrefab(portal_prefab)
	
	portal.Transform:SetPosition(x, 0, z)
	print(" DES_PORTAL PARENT IS SET")

	if portal_prefab == "miamirick_portal" then
		if isparent then
			local x1, y1, z1 = getrandomposition(inst)
			local child_portal = SetUpPortal(inst, x1, z1, true, nil)
			child_portal.portal_link = portal
			portal.portal_link = child_portal		
		end
		if ischild then
			print("SET UP DES_PORTAL CHILD")

			return portal
		end
	end
end
local function OnHitWater(inst, attacker, target)
    inst.SoundEmitter:PlaySound("dontstarve/creatures/pengull/splash")
	local x, y, z = inst.Transform:GetWorldPosition()
	print("SET UP DES_PORTAL PARENT")
    SetUpPortal(inst, x, z, nil, true)
	
    inst:Remove()
end

local function common_fn(bank, build, anim, tag, isinventoryitem)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

	
	local s = 0.2
	inst.Transform:SetScale(s,s,s,s)
	
	
    if isinventoryitem then
        MakeInventoryPhysics(inst)
    else
        inst.entity:AddPhysics()
        inst.Physics:SetMass(1)
        inst.Physics:SetCapsule(0.2, 0.2)
        inst.Physics:SetFriction(0)
        inst.Physics:SetDamping(0)
        inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
        inst.Physics:ClearCollisionMask()
        inst.Physics:CollidesWith(COLLISION.WORLD)
    end

    if tag ~= nil then
        inst:AddTag(tag)
    end

    inst.AnimState:SetBank("des_portalgun_missle")
    inst.AnimState:SetBuild("des_portalgun_missle")
    inst.AnimState:PlayAnimation("spin_loop", true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("locomotor")


    inst:AddComponent("complexprojectile")

    return inst
end

local function snowball_fn()
    local inst = common_fn("firefighter_projectile", "firefighter_projectile", "spin_loop", "NOCLICK")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false

    inst.components.complexprojectile:SetHorizontalSpeed(33)
    inst.components.complexprojectile:SetGravity(-35)
   -- inst.components.complexprojectile:SetLaunchOffset(Vector3(.25, 1, 0))
    inst.components.complexprojectile:SetOnLaunch(onthrown)
    inst.components.complexprojectile:SetOnHit(OnHitWater)

    inst.components.complexprojectile:SetLaunchOffset(Vector3(2, 1, 0))
    inst.components.complexprojectile.usehigharc = false
	
	
    return inst
end


local function onthrown(inst)
    inst:AddTag("NOCLICK")
    inst.persists = false

    inst.AnimState:PlayAnimation("spin_loop", true)

    inst.Physics:SetMass(1)
    inst.Physics:SetCapsule(0.2, 0.2)
    inst.Physics:SetFriction(0)
    inst.Physics:SetDamping(0)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.ITEMS)
end

local function ReticuleTargetFn()
    local player = ThePlayer
    local ground = TheWorld.Map
    local pos = Vector3()
    --Attack range is 8, leave room for error
    --Min range was chosen to not hit yourself (2 is the hit range)
    for r = 6.5, 3.5, -.25 do
        pos.x, pos.y, pos.z = player.entity:LocalToWorldSpace(r, 0, 0)
        if ground:IsPassableAtPoint(pos:Get()) and not ground:IsPointNearHole(pos) then
            return pos
        end
    end
    return pos
end



return Prefab("miamirick_portal_gun_missle", snowball_fn, snowball_assets, snowball_prefabs)