-- 
-- HorseHelper 
-- 
-- @Interface: 1.1.2.0 b3108
-- @Author: LS-Modcompany / kevink98
-- @Date: 25.11.2018
-- @Version: 1.0.0.0
-- 
-- @Support: LS-Modcompany
-- 
local version = "1.0.0.0 (25.11.2018)";

HorseHelper = {};
HorseHelper.dir = g_currentModDirectory;
addModEventListener(HorseHelper);

function HorseHelper:loadMap()
	g_currentMission.environment:addDayChangeListener(HorseHelper);
	g_currentMission.environment:addHourChangeListener(HorseHelper);
		
	self.alreadyRun = false;
end;

function HorseHelper:dayChanged() 
	self.alreadyRun = false;
	
	local moneyToOwner = {};	
	for _,husbandry in pairs(g_currentMission.husbandries) do
		
		for _,animal in pairs(husbandry:getAnimals()) do
			if animal.module.animalType == "HORSE" then
				local owner = animal.owner.ownerFarmId;
				if moneyToOwner[owner] == nil then
					moneyToOwner[owner] = 0;
				end;				
				moneyToOwner[owner] = moneyToOwner[owner] + 1;
			end;
		end;		
	end;
	
	for owner, counter in pairs(moneyToOwner) do
		if g_server ~= nil then
			g_currentMission:addMoney(-counter * 300, owner, "animalUpkeep");
		end;
	end;		
end;

function HorseHelper:hourChanged()
	if not self.alreadyRun and g_currentMission.environment.currentHour == 23 then
		for _,husbandry in pairs(g_currentMission.husbandries) do
			for _,animal in pairs(husbandry:getAnimals()) do
				if animal.module.animalType == "HORSE" then
					animal.ridingTimerSent  = animal.DAILY_TARGET_RIDING_TIME;
					animal.ridingTimer  = animal.DAILY_TARGET_RIDING_TIME;
				end;
			end;			
		end;
		self.alreadyRun = true;
	end;
end;

function HorseHelper:loadSavegame() end;
function HorseHelper:saveSavegame() end;
function HorseHelper:update(dt) end;
function HorseHelper:mouseEvent(posX, posY, isDown, isUp, button) end;
function HorseHelper:keyEvent(unicode, sym, modifier, isDown) end;
function HorseHelper:draw() end;
function HorseHelper:delete()end;
function HorseHelper:deleteMap() end;