package
{
   import flash.display.Bitmap;
   import flash.display.Loader;
   import flash.display.MovieClip;
   import flash.events.Event;
   import flash.media.Video;
   import flash.net.NetConnection;
   import flash.net.NetStream;
   import flash.net.URLRequest;
   import gs.TweenLite;
   
   public class LoaderClass extends MovieClip
   {
      
      public static const DATA_LOADED:String = "图片加载完成";
       
      
      private var loadType:String;
      
      public var loadWidth:Number;
      
      public var loadHeight:Number;
      
      private var FLVStream:NetStream;
      
      public var FLVVideo:Video;
      
      private var thisPICLoader:Bitmap;
      
      private var thisLoader:Loader;
      
      private var thisSwFMovieClip:MovieClip;
      
      private var _picwidth:Number;
      
      private var _picheight:Number;
      
      public function LoaderClass(param1:String, param2:String, param3:Number = 0, param4:Number = 0)
      {
         var thisConnection:NetConnection = null;
         var clientobj:Object = null;
         var filePath:String = param1;
         var fileType:String = param2;
         var picwidth:Number = param3;
         var picheight:Number = param4;
         super();
         this._picheight = picheight;
         this._picwidth = picwidth;
         this.loadType = fileType;
         if(filePath != null)
         {
            this.thisLoader = new Loader();
            this.thisLoader.contentLoaderInfo.addEventListener(Event.COMPLETE,this.onLoaded);
            this.thisLoader.load(new URLRequest(filePath));
         }
         if(fileType == "flv")
         {
            thisConnection = new NetConnection();
            thisConnection.connect(null);
            if(!this.FLVStream)
            {
               this.FLVStream = new NetStream(thisConnection);
               this.FLVVideo = new Video();
               this.FLVVideo.attachNetStream(this.FLVStream);
               this.FLVVideo.smoothing = true;
               clientobj = new Object();
               clientobj.onMetaData = function():void
               {
               };
               this.FLVStream.client = clientobj;
               this.addChild(this.FLVVideo);
               this.FLVStream.play(filePath);
            }
         }
      }
      
      private function onLoaded(param1:Event) : void
      {
         if(this.loadType == "jpg" || this.loadType == "png")
         {
            this.thisPICLoader = param1.currentTarget.content as Bitmap;
            if(this._picwidth != 0)
            {
               this.thisPICLoader.width = this._picwidth;
               this.thisPICLoader.height = this._picheight;
            }
            this.loadWidth = this.thisPICLoader.width;
            this.loadHeight = this.thisPICLoader.height;
            this.thisPICLoader.alpha = 0;
            TweenLite.to(this.thisPICLoader,1,{"alpha":1});
            this.addChild(this.thisPICLoader);
         }
         else if(this.loadType == "swf")
         {
            this.addChild(this.thisLoader.content);
         }
         dispatchEvent(new Event(Event.COMPLETE));
      }
      
      public function goframe(param1:Number) : void
      {
      }
      
      public function unLoaded(param1:Boolean) : void
      {
         if(param1)
         {
            if(this.loadType == "jpg" || this.loadType == "png")
            {
               TweenLite.to(this.thisPICLoader,0.5,{
                  "autoAlpha":0,
                  "onComplete":this.unLoadComplete
               });
            }
            else
            {
               TweenLite.to(this.thisLoader,0.5,{
                  "autoAlpha":0,
                  "onComplete":this.unLoadComplete
               });
            }
         }
         else
         {
            this.unLoadComplete();
         }
      }
      
      private function unLoadComplete() : void
      {
         if(this.loadType == "jpg" || this.loadType == "png")
         {
            this.unLoadPic();
         }
         else if(this.loadType == "swf")
         {
            this.unLoadSwf();
         }
      }
      
      private function unLoadSwf() : void
      {
         this.thisLoader.unloadAndStop(true);
      }
      
      private function unLoadPic() : void
      {
         if(this.thisPICLoader.bitmapData != null)
         {
            this.thisPICLoader.bitmapData.dispose();
            this.thisPICLoader.bitmapData = null;
            GC.ReleaseMemory();
         }
      }
      
      public function unSmallLoad() : void
      {
         this.thisLoader.unload();
      }
   }
}
