
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
	Asset( "ANIM", "anim/broccoliball.zip" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"gemma"
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8.5
	inst.Transform:SetScale(0.7, 0.7, 0.7)
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end

local function BroccoliAura(inst)
    SpawnPrefab("auraringfx").entity:AddFollower():FollowSymbol(inst.GUID, "swap_body", 0, 0, 0)
    inst:DoTaskInTime(math.random(25, 30), BroccoliAura)
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "broccoli.tex" )
	inst.transformed = false 
	inst:AddComponent("keyhandler")
    inst.components.keyhandler:AddActionListener("broccoli", TUNING.BROCCOLI.KEYFOUR, "BROCCOLIBALL")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "broccoli"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(250)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(150)
	
	inst.Transform:SetScale(0.7, 0.7, 0.7)
	
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8.5
		
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst:DoTaskInTime(math.random(25, 30), BroccoliAura)
	
	inst:ListenForEvent("equip", function(inst, data)
        print("I'm wearing something.")
        inst.AnimState:ClearOverrideSymbol("swap_body")
    end)
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("broccoli", prefabs, assets, common_postinit, master_postinit, start_inv)
