/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.client;

import com.darkona.adventurebackpack.client.Visuals;
import com.darkona.adventurebackpack.client.audio.BoilingBoilerSound;
import com.darkona.adventurebackpack.client.audio.CopterPackSound;
import com.darkona.adventurebackpack.client.audio.JetpackSoundOn;
import com.darkona.adventurebackpack.client.audio.LeakingBoilerSound;
import com.darkona.adventurebackpack.client.audio.NyanMovingSound;
import com.darkona.adventurebackpack.config.ConfigHandler;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class ClientActions {
    @SideOnly(value=Side.CLIENT)
    public static void showParticlesAtEntity(Entity entity, byte particleCode) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            switch (particleCode) {
                case 1: {
                    Visuals.CopterParticles(player, player.field_70170_p);
                    break;
                }
                case 0: {
                    Visuals.NyanParticles(player, player.field_70170_p);
                    break;
                }
                case 2: {
                    Visuals.SlimeParticles(player, player.field_70170_p);
                    break;
                }
                case 3: {
                    Visuals.JetpackParticles(player, player.field_70170_p);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playSoundAtEntity(Entity entity, byte soundCode) {
        SoundHandler snd = FMLClientHandler.instance().getClient().func_147118_V();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            switch (soundCode) {
                case 1: {
                    if (!ConfigHandler.ALLOW_COPTER_SOUND) break;
                    snd.func_147682_a((ISound)new CopterPackSound(player));
                    break;
                }
                case 0: {
                    snd.func_147682_a((ISound)new NyanMovingSound(player));
                    break;
                }
                case 2: {
                    snd.func_147682_a((ISound)new JetpackSoundOn(player));
                    break;
                }
                case 3: {
                    snd.func_147682_a((ISound)new BoilingBoilerSound(player));
                    break;
                }
                case 4: {
                    snd.func_147682_a((ISound)new LeakingBoilerSound(player));
                }
            }
        }
    }
}

