/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.client.gui;

import codechicken.lib.render.TextureUtils;
import com.darkona.adventurebackpack.client.gui.GuiTank;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.item.ItemHose;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class GuiOverlay
extends Gui {
    private Minecraft mc;
    private int screenWidth;
    private int screenHeight;
    protected static RenderItem itemRender = new RenderItem();
    protected FontRenderer fontRendererObj;
    ScaledResolution resolution;
    private static final int BUFF_ICON_SIZE = 18;
    private static final int BUFF_ICON_SPACING = 20;
    private static final int BUFF_ICON_BASE_U_OFFSET = 0;
    private static final int BUFF_ICON_BASE_V_OFFSET = 198;
    private static final int BUFF_ICONS_PER_ROW = 8;

    public GuiOverlay(Minecraft mc) {
        this.mc = mc;
        GuiOverlay.itemRender.field_77024_a = false;
        this.fontRendererObj = mc.field_71466_p;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        EntityClientPlayerMP player;
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        this.resolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        this.screenWidth = this.resolution.func_78326_a();
        this.screenHeight = this.resolution.func_78328_b();
        if (ConfigHandler.STATUS_OVERLAY) {
            int xPos = 2;
            int yPos = 2;
            Collection collection = this.mc.field_71439_g.func_70651_bq();
            if (!collection.isEmpty()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                this.mc.field_71446_o.func_110577_a(new ResourceLocation("textures/gui/container/inventory.png"));
                for (PotionEffect potioneffect : this.mc.field_71439_g.func_70651_bq()) {
                    Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                    if (potion.func_76400_d()) {
                        int iconIndex = potion.func_76392_e();
                        this.func_73729_b(xPos, yPos, 0 + iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
                    }
                    xPos += 20;
                }
            }
        }
        if (ConfigHandler.TANKS_OVERLAY && Wearing.isWearingWearable((EntityPlayer)(player = this.mc.field_71439_g))) {
            IInventoryTanks inv = Wearing.getWearableInv((EntityPlayer)player);
            assert (inv != null);
            inv.func_70295_k_();
            int textureHeight = 23;
            int textureWidth = 10;
            int xPos = this.screenWidth - textureWidth * 3 - 4;
            int yPos = this.screenHeight - textureHeight - 2;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            int tankX = xPos;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            for (FluidTank tank : inv.getTanksArray()) {
                this.mc.field_71446_o.func_110577_a(new ResourceLocation("adventurebackpack".toLowerCase(), "textures/gui/overlay.png"));
                this.func_73729_b(tankX, yPos, 10, 0, textureWidth, textureHeight);
                this.drawTank(tank, tankX + 1, yPos + 1, textureHeight - 2, textureWidth - 2);
                ++tankX;
                tankX += textureWidth;
            }
            if (Wearing.isWearingBackpack((EntityPlayer)player)) {
                int[] u = new int[]{10, 10};
                int[] v = new int[]{0, 0};
                int[] xStart = new int[]{xPos, xPos + textureWidth + 1};
                int[] yStart = new int[]{yPos, yPos};
                int tank = -1;
                if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemHose) {
                    tank = (short)ItemHose.getHoseTank(player.func_70694_bm());
                }
                if (tank > -1) {
                    u[0] = tank == 0 ? 0 : 10;
                    u[1] = tank == 1 ? 0 : 10;
                }
                this.mc.field_71446_o.func_110577_a(new ResourceLocation("adventurebackpack".toLowerCase(), "textures/gui/overlay.png"));
                this.func_73729_b(xStart[0], yStart[0], u[0], v[0], textureWidth, textureHeight);
                this.func_73729_b(xStart[1], yStart[0], u[1], v[1], textureWidth, textureHeight);
                RenderHelper.func_74519_b();
                RenderHelper.func_74520_c();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(xStart[1] + textureWidth + 2), (float)yStart[0], (float)0.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                this.drawItemStack(inv.func_70301_a(39), 0, 0);
                this.drawItemStack(inv.func_70301_a(40), 0, 16);
                GL11.glPopMatrix();
                RenderHelper.func_74518_a();
            }
            GL11.glDisable((int)32826);
            GL11.glDisable((int)3042);
        }
    }

    private void drawTank(FluidTank tank, int startX, int startY, int height, int width) {
        int liquidPerPixel = tank.getCapacity() / height;
        FluidStack fluid = tank.getFluid();
        if (fluid != null) {
            try {
                IIcon icon = fluid.getFluid().getStillIcon();
                TextureUtils.bindAtlas(fluid.getFluid().getSpriteNumber());
                int top = startY + height - fluid.amount / liquidPerPixel;
                for (int j = startY + height - 1; j >= top; --j) {
                    for (int i = startX; i <= startX + width - 1; ++i) {
                        GL11.glPushMatrix();
                        if (j >= top + 5) {
                            GL11.glColor4f((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        }
                        GuiTank.drawFluidPixelFromIcon(i, j, icon, 1, 1, 0, 0, 0, 0, 1.0f);
                        GL11.glPopMatrix();
                    }
                }
            }
            catch (Exception oops) {
                LogHelper.error("Exception while trying to render the fluid in the GUI");
            }
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        if (stack == null) {
            return;
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        GuiOverlay.itemRender.field_77023_b = 200.0f;
        FontRenderer font = null;
        font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.fontRendererObj;
        }
        itemRender.func_77015_a(font, this.mc.func_110434_K(), stack, x, y);
        this.field_73735_i = 0.0f;
        GuiOverlay.itemRender.field_77023_b = 0.0f;
    }
}

