/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.init.recipes;

import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.init.recipes.BackpackRecipes;
import com.darkona.adventurebackpack.reference.BackpackNames;
import com.darkona.adventurebackpack.util.LogHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class AbstractBackpackRecipe
implements IRecipe {
    final BackpackRecipes br = new BackpackRecipes();
    private ItemStack result;
    private ItemStack[] recipe;
    public HashMap<String, ItemStack[]> recipes = new HashMap();

    public boolean compareStacksForColor(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 != null && stack2 != null) {
            if (stack1.func_77973_b() != stack2.func_77973_b()) {
                return false;
            }
            return stack1.func_77960_j() == stack2.func_77960_j();
        }
        return false;
    }

    public AbstractBackpackRecipe() {
        int i = 0;
        for (Field field : BackpackRecipes.class.getFields()) {
            try {
                if (field.getType() != ItemStack[].class) continue;
                this.recipes.put(field.getName(), (ItemStack[])field.get(this.br));
                ++i;
            }
            catch (Exception oops) {
                LogHelper.error("Huge mistake during reflection. Some bad things might happen.");
            }
        }
        LogHelper.info("Loaded " + i + " recipes for backpack coloration.");
    }

    public ItemStack makeBackpack(ItemStack backpackIn, String colorName) {
        if (backpackIn == null) {
            return null;
        }
        ItemStack newBackpack = backpackIn.func_77946_l();
        if (backpackIn.field_77990_d == null) {
            backpackIn.func_77982_d(new NBTTagCompound());
            backpackIn.field_77990_d.func_74778_a("colorName", "Standard");
        }
        NBTTagCompound compound = (NBTTagCompound)backpackIn.func_77978_p().func_74737_b();
        newBackpack.func_77982_d(compound);
        newBackpack.field_77990_d.func_74778_a("colorName", colorName);
        return newBackpack;
    }

    public boolean match(ItemStack[] model, InventoryCrafting invC) {
        if (model == null || invC == null) {
            return false;
        }
        for (int i = 0; i < invC.func_70302_i_(); ++i) {
            ItemStack m = model[i];
            ItemStack c = invC.func_70301_a(i);
            if (!this.compareStacksForColor(m, c)) {
                return false;
            }
            if (i != 4 || BackpackNames.getBackpackColorName(c).equals("Standard")) continue;
            return false;
        }
        return true;
    }

    public boolean func_77569_a(InventoryCrafting invC, World world) {
        this.result = null;
        if (invC != null) {
            for (Map.Entry<String, ItemStack[]> recipe : this.recipes.entrySet()) {
                if (!this.match(recipe.getValue(), invC)) continue;
                this.result = this.makeBackpack(invC.func_70301_a(4), recipe.getKey());
                break;
            }
        }
        return this.result != null;
    }

    public ItemStack func_77572_b(InventoryCrafting invC) {
        if (invC != null) {
            for (Map.Entry<String, ItemStack[]> recipe : this.recipes.entrySet()) {
                if (!this.match(recipe.getValue(), invC)) continue;
                return this.makeBackpack(invC.func_70301_a(4), recipe.getKey());
            }
        }
        return this.result;
    }

    public int func_77570_a() {
        return 9;
    }

    public ItemStack func_77571_b() {
        ItemStack backpack = new ItemStack((Item)ModItems.adventureBackpack, 1);
        backpack.func_77982_d(new NBTTagCompound());
        backpack.field_77990_d.func_74778_a("colorName", "Standard");
        return backpack;
    }
}

