/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.item;

import com.darkona.adventurebackpack.client.models.ModelCopterPack;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.InventoryCopterPack;
import com.darkona.adventurebackpack.item.IBackWearableItem;
import com.darkona.adventurebackpack.item.ItemAB;
import com.darkona.adventurebackpack.network.GUIPacket;
import com.darkona.adventurebackpack.network.messages.EntityParticlePacket;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.proxy.ClientProxy;
import com.darkona.adventurebackpack.reference.GeneralReference;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemCopterPack
extends ItemAB
implements IBackWearableItem {
    public static byte OFF_MODE = 0;
    public static byte NORMAL_MODE = 1;
    public static byte HOVER_MODE = (byte)2;

    public ItemCopterPack() {
        this.func_77655_b("copterPack");
        this.func_77664_n();
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            ModNetwork.net.sendToServer((IMessage)new GUIPacket.GUImessage(2, 1));
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrent) {
    }

    public void pushEntities(World world, EntityPlayer player, float speed) {
        double posX = player.field_70165_t;
        double posY = player.field_70163_u;
        double posZ = player.field_70161_v;
        List groundItems = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)posX, (double)posY, (double)posZ, (double)(posX + 1.0), (double)(posY + 1.0), (double)(posZ + 1.0)).func_72314_b(4.0, 4.0, 4.0));
        for (EntityItem groundItem : groundItems) {
            if (groundItem.func_70090_H()) continue;
            if (groundItem.field_70165_t > posX) {
                groundItem.field_70159_w = speed;
            }
            if (groundItem.field_70165_t < posX) {
                groundItem.field_70159_w = -speed;
            }
            if (groundItem.field_70161_v > posZ) {
                groundItem.field_70179_y = speed;
            }
            if (groundItem.field_70161_v < posZ) {
                groundItem.field_70179_y = -speed;
            }
            if (!(groundItem.field_70163_u < posY)) continue;
            groundItem.field_70181_x -= (double)speed;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, int armorSlot) {
        return ModelCopterPack.instance.setWearable(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        String modelTexture = Resources.modelTextures("copterPack").toString();
        return modelTexture;
    }

    public static void elevate(EntityPlayer player, ItemStack copter) {
        if (player.field_70163_u < 100.0) {
            player.field_70181_x = Math.max(player.field_70181_x, 0.18);
        }
        if (player.field_70163_u > 100.0) {
            player.field_70181_x = 0.18 - player.field_70163_u % 100.0 / 100.0;
        }
    }

    @Override
    public void onEquippedUpdate(World world, EntityPlayer player, ItemStack stack) {
        InventoryCopterPack inv = new InventoryCopterPack(Wearing.getWearingCopter(player));
        inv.func_70295_k_();
        boolean canElevate = true;
        int fuelConsumption = 0;
        if (inv.getStatus() != OFF_MODE) {
            if (player.func_70090_H()) {
                inv.setStatus(OFF_MODE);
                inv.dirtyStatus();
                if (!world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.copterpack.cantwater", new Object[0]));
                }
                return;
            }
            if (inv.fuelTank.getFluidAmount() == 0) {
                canElevate = false;
                if (player.field_70122_E) {
                    inv.setStatus(OFF_MODE);
                    inv.dirtyStatus();
                    if (!world.field_72995_K) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.copterpack.off", new Object[0]));
                    }
                    return;
                }
                if (inv.getStatus() == HOVER_MODE) {
                    inv.setStatus(NORMAL_MODE);
                    inv.dirtyStatus();
                    if (!world.field_72995_K) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.copterpack.outoffuel", new Object[0]));
                    }
                    return;
                }
            }
        }
        if (inv.getStatus() != OFF_MODE) {
            ++fuelConsumption;
            if (inv.getStatus() == NORMAL_MODE) {
                if (!player.field_70122_E && !player.func_70093_af() && player.field_70181_x < 0.0) {
                    player.field_70181_x *= 0.6;
                }
                if (player.func_70093_af()) {
                    player.field_70181_x = -0.3;
                }
            }
            if (inv.getStatus() == HOVER_MODE) {
                if (player.func_70093_af()) {
                    player.field_70181_x = -0.3;
                } else {
                    fuelConsumption += 2;
                    player.field_70181_x = 0.0;
                }
            }
            player.field_70143_R = 0.0f;
            if (!world.field_72995_K) {
                ModNetwork.sendToNearby(new EntityParticlePacket.Message(1, (Entity)player), player);
            }
            float factor = 0.05f;
            if (!player.field_70122_E) {
                this.pushEntities(world, player, 0.2f);
                player.func_70060_a(player.field_70702_br, player.field_70701_bs, factor);
            } else {
                this.pushEntities(world, player, factor + 0.4f);
            }
            if (world.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && inv.canConsumeFuel(fuelConsumption + 2) && canElevate) {
                ItemCopterPack.elevate(player, stack);
            }
            if (!player.field_70122_E && player.field_70181_x > 0.0) {
                fuelConsumption += 2;
            }
            int ticks = inv.tickCounter - 1;
            if (inv.fuelTank.getFluid() != null && GeneralReference.isValidFuel(inv.getFuelTank().getFluid().getFluid())) {
                fuelConsumption = (int)Math.floor((float)fuelConsumption * GeneralReference.liquidFuels.get(inv.getFuelTank().getFluid().getFluid().getName()).floatValue());
            }
            if (ticks <= 0) {
                inv.tickCounter = 3;
                inv.consumeFuel(fuelConsumption);
                inv.dirtyTanks();
            } else {
                inv.tickCounter = ticks;
            }
        }
        inv.func_70305_f();
    }

    @Override
    public void onPlayerDeath(World world, EntityPlayer player, ItemStack stack) {
        this.onUnequipped(world, player, stack);
        player.func_71019_a(stack.func_77946_l(), false);
        BackpackProperty.get(player).setWearable(null);
    }

    @Override
    public void onEquipped(World world, EntityPlayer player, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74774_a("status", OFF_MODE);
    }

    @Override
    public void onUnequipped(World world, EntityPlayer player, ItemStack stack) {
        stack.field_77990_d.func_74774_a("status", OFF_MODE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getWearableModel(ItemStack wearable) {
        return ClientProxy.modelCopterPack.setWearable(wearable);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getWearableTexture(ItemStack wearable) {
        return Resources.modelTextures("copterPack");
    }
}

