/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.proxy;

import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.block.TileCampfire;
import com.darkona.adventurebackpack.client.gui.GuiOverlay;
import com.darkona.adventurebackpack.client.models.ModelBackpackArmor;
import com.darkona.adventurebackpack.client.models.ModelCopterPack;
import com.darkona.adventurebackpack.client.models.ModelSteamJetpack;
import com.darkona.adventurebackpack.client.render.RenderRideableSpider;
import com.darkona.adventurebackpack.client.render.RendererAdventureBackpackBlock;
import com.darkona.adventurebackpack.client.render.RendererCampFire;
import com.darkona.adventurebackpack.client.render.RendererHose;
import com.darkona.adventurebackpack.client.render.RendererInflatableBoat;
import com.darkona.adventurebackpack.client.render.RendererItemAdventureBackpack;
import com.darkona.adventurebackpack.client.render.RendererItemAdventureHat;
import com.darkona.adventurebackpack.client.render.RendererItemClockworkCrossbow;
import com.darkona.adventurebackpack.client.render.RendererWearableEquipped;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.config.Keybindings;
import com.darkona.adventurebackpack.entity.EntityFriendlySpider;
import com.darkona.adventurebackpack.entity.EntityInflatableBoat;
import com.darkona.adventurebackpack.handlers.KeybindHandler;
import com.darkona.adventurebackpack.handlers.RenderHandler;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.proxy.IProxy;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.Utils;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
implements IProxy {
    public static RendererItemAdventureBackpack rendererItemAdventureBackpack;
    public static RendererItemAdventureHat rendererItemAdventureHat;
    public static RendererHose rendererHose;
    public static RendererWearableEquipped rendererWearableEquipped;
    public static RenderHandler renderHandler;
    public static RendererInflatableBoat renderInflatableBoat;
    public static RenderRideableSpider renderRideableSpider;
    public static RendererItemClockworkCrossbow renderCrossbow;
    public static ModelSteamJetpack modelSteamJetpack;
    public static ModelBackpackArmor modelAdventureBackpack;
    public static ModelCopterPack modelCopterPack;

    @Override
    public void init() {
        this.initRenderers();
        this.registerKeybindings();
        MinecraftForge.EVENT_BUS.register((Object)new GuiOverlay(Minecraft.func_71410_x()));
    }

    @Override
    public void initNetwork() {
    }

    @Override
    public void joinPlayer(EntityPlayer player) {
        LogHelper.info("Joined Player in client");
    }

    @Override
    public void synchronizePlayer(int id, NBTTagCompound properties) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
        if (Utils.notNullAndInstanceOf(entity, EntityPlayer.class) && properties != null) {
            EntityPlayer player = (EntityPlayer)entity;
            if (BackpackProperty.get(player) == null) {
                BackpackProperty.register(player);
            }
            BackpackProperty.get(player).loadNBTData(properties);
        }
    }

    public void initRenderers() {
        renderHandler = new RenderHandler();
        MinecraftForge.EVENT_BUS.register((Object)renderHandler);
        rendererWearableEquipped = new RendererWearableEquipped();
        rendererItemAdventureBackpack = new RendererItemAdventureBackpack();
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.adventureBackpack, (IItemRenderer)rendererItemAdventureBackpack);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.blockBackpack), (IItemRenderer)rendererItemAdventureBackpack);
        ClientRegistry.bindTileEntitySpecialRenderer(TileAdventureBackpack.class, (TileEntitySpecialRenderer)new RendererAdventureBackpackBlock());
        rendererItemAdventureHat = new RendererItemAdventureHat();
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.adventureHat, (IItemRenderer)rendererItemAdventureHat);
        if (!ConfigHandler.TANKS_OVERLAY) {
            rendererHose = new RendererHose();
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.hose, (IItemRenderer)rendererHose);
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileCampfire.class, (TileEntitySpecialRenderer)new RendererCampFire());
        renderInflatableBoat = new RendererInflatableBoat();
        RenderingRegistry.registerEntityRenderingHandler(EntityInflatableBoat.class, (Render)renderInflatableBoat);
        renderRideableSpider = new RenderRideableSpider();
        RenderingRegistry.registerEntityRenderingHandler(EntityFriendlySpider.class, (Render)renderRideableSpider);
        renderCrossbow = new RendererItemClockworkCrossbow();
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.cwxbow, (IItemRenderer)renderCrossbow);
    }

    @Override
    public void registerKeybindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.openBackpack);
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.toggleHose);
        FMLCommonHandler.instance().bus().register((Object)new KeybindHandler());
    }

    static {
        modelSteamJetpack = new ModelSteamJetpack();
        modelAdventureBackpack = new ModelBackpackArmor();
        modelCopterPack = new ModelCopterPack();
    }
}

