/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.proxy;

import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.proxy.IProxy;
import com.darkona.adventurebackpack.util.LogHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ServerProxy
implements IProxy {
    private static final Map<UUID, NBTTagCompound> extendedEntityData = new HashMap<UUID, NBTTagCompound>();

    @Override
    public void init() {
    }

    @Override
    public void registerKeybindings() {
    }

    @Override
    public void initNetwork() {
    }

    @Override
    public void joinPlayer(EntityPlayer player) {
        NBTTagCompound playerData = ServerProxy.extractPlayerProps(player.func_110124_au());
        if (playerData != null) {
            LogHelper.info("Stored properties retrieved");
            BackpackProperty.get(player).loadNBTData(playerData);
            BackpackProperty.syncToNear(player);
        } else {
            LogHelper.info("Data is null! WTF!");
        }
    }

    @Override
    public void synchronizePlayer(int id, NBTTagCompound compound) {
    }

    public static void storePlayerProps(EntityPlayer player) {
        try {
            NBTTagCompound data = BackpackProperty.get(player).getData();
            if (data.func_74764_b("wearable")) {
                LogHelper.info("Storing wearable: " + ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("wearable")).func_82833_r());
            }
            extendedEntityData.put(player.func_110124_au(), data);
            LogHelper.info("Stored player properties for dead player");
        }
        catch (Exception ex) {
            LogHelper.error("Something went wrong while saving player properties: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static NBTTagCompound extractPlayerProps(UUID playerID) {
        return extendedEntityData.remove(playerID);
    }
}

