/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util.calendar;

public class ChineseCalendar {
    private int gregorianYear;
    private int gregorianMonth;
    private int gregorianDate;
    private boolean isGregorianLeap;
    private int dayOfYear;
    private int dayOfWeek;
    private int chineseYear;
    private int chineseMonth;
    private int chineseDate;
    private int sectionalTerm;
    private int principleTerm;
    private static char[] daysInGregorianMonth = new char[]{'\u001f', '\u001c', '\u001f', '\u001e', '\u001f', '\u001e', '\u001f', '\u001f', '\u001e', '\u001f', '\u001e', '\u001f'};
    private static String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static String[] stemNames = new String[]{"Wood", "Wood", "Fire", "Fire", "Earth", "Earth", "Metal", "Metal", "Water", "Water"};
    private static String[] branchNames = new String[]{"Rat", "Ox", "Tiger", "Rabbit", "Dragon", "Snake", "Horse", "Sheep", "Monkey", "Rooster", "Dog", "Boar"};
    private static char[] chineseMonths = new char[]{'\u0000', '\u0004', '\u00ad', '\b', 'Z', '\u0001', '\u00d5', 'T', '\u00b4', '\t', 'd', '\u0005', 'Y', 'E', '\u0095', '\n', '\u00a6', '\u0004', 'U', '$', '\u00ad', '\b', 'Z', 'b', '\u00da', '\u0004', '\u00b4', '\u0005', '\u00b4', 'U', 'R', '\r', '\u0094', '\n', 'J', '*', 'V', '\u0002', 'm', 'q', 'm', '\u0001', '\u00da', '\u0002', '\u00d2', 'R', '\u00a9', '\u0005', 'I', '\r', '*', 'E', '+', '\t', 'V', '\u0001', '\u00b5', ' ', 'm', '\u0001', 'Y', 'i', '\u00d4', '\n', '\u00a8', '\u0005', '\u00a9', 'V', '\u00a5', '\u0004', '+', '\t', '\u009e', '8', '\u00b6', '\b', '\u00ec', 't', 'l', '\u0005', '\u00d4', '\n', '\u00e4', 'j', 'R', '\u0005', '\u0095', '\n', 'Z', 'B', '[', '\u0004', '\u00b6', '\u0004', '\u00b4', '\"', 'j', '\u0005', 'R', 'u', '\u00c9', '\n', 'R', '\u0005', '5', 'U', 'M', '\n', 'Z', '\u0002', ']', '1', '\u00b5', '\u0002', 'j', '\u008a', 'h', '\u0005', '\u00a9', '\n', '\u008a', 'j', '*', '\u0005', '-', '\t', '\u00aa', 'H', 'Z', '\u0001', '\u00b5', '\t', '\u00b0', '9', 'd', '\u0005', '%', 'u', '\u0095', '\n', '\u0096', '\u0004', 'M', 'T', '\u00ad', '\u0004', '\u00da', '\u0004', '\u00d4', 'D', '\u00b4', '\u0005', 'T', '\u0085', 'R', '\r', '\u0092', '\n', 'V', 'j', 'V', '\u0002', 'm', '\u0002', 'j', 'A', '\u00da', '\u0002', '\u00b2', '\u00a1', '\u00a9', '\u0005', 'I', '\r', '\n', 'm', '*', '\t', 'V', '\u0001', '\u00ad', 'P', 'm', '\u0001', '\u00d9', '\u0002', '\u00d1', ':', '\u00a8', '\u0005', ')', '\u0085', '\u00a5', '\f', '*', '\t', '\u0096', 'T', '\u00b6', '\b', 'l', '\t', 'd', 'E', '\u00d4', '\n', '\u00a4', '\u0005', 'Q', '%', '\u0095', '\n', '*', 'r', '[', '\u0004', '\u00b6', '\u0004', '\u00ac', 'R', 'j', '\u0005', '\u00d2', '\n', '\u00a2', 'J', 'J', '\u0005', 'U', '\u0094', '-', '\n', 'Z', '\u0002', 'u', 'a', '\u00b5', '\u0002', 'j', '\u0003', 'a', 'E', '\u00a9', '\n', 'J', '\u0005', '%', '%', '-', '\t', '\u009a', 'h', '\u00da', '\b', '\u00b4', '\t', '\u00a8', 'Y', 'T', '\u0003', '\u00a5', '\n', '\u0091', ':', '\u0096', '\u0004', '\u00ad', '\u00b0', '\u00ad', '\u0004', '\u00da', '\u0004', '\u00f4', 'b', '\u00b4', '\u0005', 'T', '\u000b', 'D', ']', 'R', '\n', '\u0095', '\u0004', 'U', '\"', 'm', '\u0002', 'Z', 'q', '\u00da', '\u0002', '\u00aa', '\u0005', '\u00b2', 'U', 'I', '\u000b', 'J', '\n', '-', '9', '6', '\u0001', 'm', '\u0080', 'm', '\u0001', '\u00d9', '\u0002', '\u00e9', 'j', '\u00a8', '\u0005', ')', '\u000b', '\u009a', 'L', '\u00aa', '\b', '\u00b6', '\b', '\u00b4', '8', 'l', '\t', 'T', 'u', '\u00d4', '\n', '\u00a4', '\u0005', 'E', 'U', '\u0095', '\n', '\u009a', '\u0004', 'U', 'D', '\u00b5', '\u0004', 'j', '\u0082', 'j', '\u0005', '\u00d2', '\n', '\u0092', 'j', 'J', '\u0005', 'U', '\n', '*', 'J', 'Z', '\u0002', '\u00b5', '\u0002', '\u00b2', '1', 'i', '\u0003', '1', 's', '\u00a9', '\n', 'J', '\u0005', '-', 'U', '-', '\t', 'Z', '\u0001', '\u00d5', 'H', '\u00b4', '\t', 'h', '\u0089', 'T', '\u000b', '\u00a4', '\n', '\u00a5', 'j', '\u0095', '\u0004', '\u00ad', '\b', 'j', 'D', '\u00da', '\u0004', 't', '\u0005', '\u00b0', '%', 'T', '\u0003'};
    private static int baseYear = 1901;
    private static int baseIndex = 0;
    private static int baseChineseYear = 4597;
    private static int[] bigLeapMonthYears = new int[]{6, 14, 19, 25, 33, 36, 38, 41, 44, 52, 55, 79, 117, 136, 147, 150, 155, 158, 185, 193};
    private static char[][] sectionalTermMap = new char[][]{{'\u0007', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0005', '\u0006', '\u0006', '\u0006', '\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005'}, {'\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0004', '\u0004', '\u0005', '\u0005', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0003', '\u0004', '\u0004', '\u0004', '\u0003', '\u0003', '\u0004', '\u0004', '\u0003', '\u0003', '\u0003'}, {'\u0006', '\u0006', '\u0006', '\u0007', '\u0006', '\u0006', '\u0006', '\u0006', '\u0005', '\u0006', '\u0006', '\u0006', '\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0005'}, {'\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0004', '\u0004', '\u0005', '\u0005', '\u0004', '\u0004', '\u0004', '\u0005', '\u0004', '\u0004', '\u0004', '\u0004', '\u0005'}, {'\u0006', '\u0006', '\u0006', '\u0007', '\u0006', '\u0006', '\u0006', '\u0006', '\u0005', '\u0006', '\u0006', '\u0006', '\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0005'}, {'\u0006', '\u0006', '\u0007', '\u0007', '\u0006', '\u0006', '\u0006', '\u0007', '\u0006', '\u0006', '\u0006', '\u0006', '\u0005', '\u0006', '\u0006', '\u0006', '\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0005'}, {'\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0006', '\u0006', '\u0007', '\u0007', '\u0006', '\u0006', '\u0006', '\u0007', '\u0007'}, {'\b', '\b', '\b', '\t', '\b', '\b', '\b', '\b', '\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0006', '\u0006', '\u0007', '\u0007', '\u0007'}, {'\b', '\b', '\b', '\t', '\b', '\b', '\b', '\b', '\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0007'}, {'\t', '\t', '\t', '\t', '\b', '\t', '\t', '\t', '\b', '\b', '\t', '\t', '\b', '\b', '\b', '\t', '\b', '\b', '\b', '\b', '\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\b'}, {'\b', '\b', '\b', '\b', '\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0006', '\u0006', '\u0007', '\u0007', '\u0007'}, {'\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0006', '\u0006', '\u0007', '\u0007', '\u0006', '\u0006', '\u0006', '\u0007', '\u0007'}};
    private static char[][] sectionalTermYear = new char[][]{{'\r', '1', 'U', 'u', '\u0095', '\u00b9', '\u00c9', '\u00fa', '\u00fa'}, {'\r', '-', 'Q', 'u', '\u0095', '\u00b9', '\u00c9', '\u00fa', '\u00fa'}, {'\r', '0', 'T', 'p', '\u0094', '\u00b8', '\u00c8', '\u00c9', '\u00fa'}, {'\r', '-', 'L', 'l', '\u008c', '\u00ac', '\u00c8', '\u00c9', '\u00fa'}, {'\r', ',', 'H', 'h', '\u0084', '\u00a8', '\u00c8', '\u00c9', '\u00fa'}, {'\u0005', '!', 'D', '`', '|', '\u0098', '\u00bc', '\u00c8', '\u00c9'}, {'\u001d', '9', 'U', 'x', '\u0094', '\u00b0', '\u00c8', '\u00c9', '\u00fa'}, {'\r', '0', 'L', 'h', '\u0084', '\u00a8', '\u00c4', '\u00c8', '\u00c9'}, {'\u0019', '<', 'X', 'x', '\u0094', '\u00b8', '\u00c8', '\u00c9', '\u00fa'}, {'\u0010', ',', 'L', 'l', '\u0090', '\u00ac', '\u00c8', '\u00c9', '\u00fa'}, {'\u001c', '<', '\\', '|', '\u00a0', '\u00c0', '\u00c8', '\u00c9', '\u00fa'}, {'\u0011', '5', 'U', '|', '\u009c', '\u00bc', '\u00c8', '\u00c9', '\u00fa'}};
    private static char[][] principleTermMap = new char[][]{{'\u0015', '\u0015', '\u0015', '\u0015', '\u0015', '\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0014', '\u0014', '\u0014', '\u0014', '\u0014', '\u0014', '\u0014', '\u0014', '\u0013', '\u0014', '\u0014', '\u0014', '\u0013', '\u0013', '\u0014'}, {'\u0014', '\u0013', '\u0013', '\u0014', '\u0014', '\u0013', '\u0013', '\u0013', '\u0013', '\u0013', '\u0013', '\u0013', '\u0013', '\u0012', '\u0013', '\u0013', '\u0013', '\u0012', '\u0012', '\u0013', '\u0013', '\u0012', '\u0012', '\u0012', '\u0012', '\u0012', '\u0012', '\u0012'}, {'\u0015', '\u0015', '\u0015', '\u0016', '\u0015', '\u0015', '\u0015', '\u0015', '\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0014', '\u0014', '\u0014', '\u0015', '\u0014', '\u0014', '\u0014', '\u0014', '\u0013', '\u0014', '\u0014', '\u0014', '\u0014'}, {'\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0014', '\u0014', '\u0014', '\u0015', '\u0014', '\u0014', '\u0014', '\u0014', '\u0013', '\u0014', '\u0014', '\u0014', '\u0013', '\u0013', '\u0014', '\u0014', '\u0013', '\u0013', '\u0013', '\u0014', '\u0014'}, {'\u0015', '\u0016', '\u0016', '\u0016', '\u0015', '\u0015', '\u0016', '\u0016', '\u0015', '\u0015', '\u0015', '\u0016', '\u0015', '\u0015', '\u0015', '\u0015', '\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0014', '\u0014', '\u0014', '\u0015', '\u0015'}, {'\u0016', '\u0016', '\u0016', '\u0016', '\u0015', '\u0016', '\u0016', '\u0016', '\u0015', '\u0015', '\u0016', '\u0016', '\u0015', '\u0015', '\u0015', '\u0016', '\u0015', '\u0015', '\u0015', '\u0015', '\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0015'}, {'\u0017', '\u0017', '\u0018', '\u0018', '\u0017', '\u0017', '\u0017', '\u0018', '\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0016', '\u0016', '\u0016', '\u0016', '\u0017'}, {'\u0017', '\u0018', '\u0018', '\u0018', '\u0017', '\u0017', '\u0018', '\u0018', '\u0017', '\u0017', '\u0017', '\u0018', '\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0017'}, {'\u0017', '\u0018', '\u0018', '\u0018', '\u0017', '\u0017', '\u0018', '\u0018', '\u0017', '\u0017', '\u0017', '\u0018', '\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0017'}, {'\u0018', '\u0018', '\u0018', '\u0018', '\u0017', '\u0018', '\u0018', '\u0018', '\u0017', '\u0017', '\u0018', '\u0018', '\u0017', '\u0017', '\u0017', '\u0018', '\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0017'}, {'\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0016', '\u0016', '\u0016', '\u0016', '\u0015', '\u0016', '\u0016', '\u0016', '\u0015', '\u0015', '\u0016', '\u0016', '\u0016'}, {'\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0016', '\u0016', '\u0016', '\u0016', '\u0015', '\u0016', '\u0016', '\u0016', '\u0015', '\u0015', '\u0016', '\u0016', '\u0015', '\u0015', '\u0015', '\u0016', '\u0015', '\u0015', '\u0015', '\u0015', '\u0016'}};
    private static char[][] principleTermYear = new char[][]{{'\r', '-', 'Q', 'q', '\u0095', '\u00b9', '\u00c9'}, {'\u0015', '9', ']', '}', '\u00a1', '\u00c1', '\u00c9'}, {'\u0015', '8', 'X', 'x', '\u0098', '\u00bc', '\u00c8', '\u00c9'}, {'\u0015', '1', 'Q', 't', '\u0090', '\u00b0', '\u00c8', '\u00c9'}, {'\u0011', '1', 'M', 'p', '\u008c', '\u00a8', '\u00c8', '\u00c9'}, {'\u001c', '<', 'X', 't', '\u0094', '\u00b4', '\u00c8', '\u00c9'}, {'\u0019', '5', 'T', 'p', '\u0090', '\u00ac', '\u00c8', '\u00c9'}, {'\u001d', '9', 'Y', 'x', '\u0094', '\u00b4', '\u00c8', '\u00c9'}, {'\u0011', '-', 'I', 'l', '\u008c', '\u00a8', '\u00c8', '\u00c9'}, {'\u001c', '<', '\\', '|', '\u00a0', '\u00c0', '\u00c8', '\u00c9'}, {'\u0010', ',', 'P', 'p', '\u0094', '\u00b4', '\u00c8', '\u00c9'}, {'\u0011', '5', 'X', 'x', '\u009c', '\u00bc', '\u00c8', '\u00c9'}};

    public static void generateChineseCalendar(String[] arg) {
        ChineseCalendar c = new ChineseCalendar();
        String cmd = "day";
        int y = 1901;
        int m = 1;
        int d = 1;
        if (arg.length > 0) {
            cmd = arg[0];
        }
        if (arg.length > 1) {
            y = Integer.parseInt(arg[1]);
        }
        if (arg.length > 2) {
            m = Integer.parseInt(arg[2]);
        }
        if (arg.length > 3) {
            d = Integer.parseInt(arg[3]);
        }
        c.setGregorian(y, m, d);
        c.computeChineseFields();
        c.computeSolarTerms();
        if (cmd.equalsIgnoreCase("year")) {
            String[] t = c.getYearTable();
            for (int i = 0; i < t.length; ++i) {
                System.out.println(t[i]);
            }
        } else if (cmd.equalsIgnoreCase("month")) {
            String[] t = c.getMonthTable();
            for (int i = 0; i < t.length; ++i) {
                System.out.println(t[i]);
            }
        } else {
            System.out.println(c.toString());
        }
    }

    public static boolean isChineseNewYear(int year, int month, int day) {
        ChineseCalendar c = new ChineseCalendar();
        c.setGregorian(year, month, day);
        c.computeChineseFields();
        c.computeSolarTerms();
        return c.chineseMonth == 1 && c.chineseDate == 1;
    }

    public ChineseCalendar() {
        this.setGregorian(1901, 1, 1);
    }

    public void setGregorian(int y, int m, int d) {
        this.gregorianYear = y;
        this.gregorianMonth = m;
        this.gregorianDate = d;
        this.isGregorianLeap = ChineseCalendar.isGregorianLeapYear(y);
        this.dayOfYear = ChineseCalendar.dayOfYear(y, m, d);
        this.dayOfWeek = ChineseCalendar.dayOfWeek(y, m, d);
        this.chineseYear = 0;
        this.chineseMonth = 0;
        this.chineseDate = 0;
        this.sectionalTerm = 0;
        this.principleTerm = 0;
    }

    public static boolean isGregorianLeapYear(int year) {
        boolean isLeap = false;
        if (year % 4 == 0) {
            isLeap = true;
        }
        if (year % 100 == 0) {
            isLeap = false;
        }
        if (year % 400 == 0) {
            isLeap = true;
        }
        return isLeap;
    }

    public static int daysInGregorianMonth(int y, int m) {
        int d = daysInGregorianMonth[m - 1];
        if (m == 2 && ChineseCalendar.isGregorianLeapYear(y)) {
            ++d;
        }
        return d;
    }

    public static int dayOfYear(int y, int m, int d) {
        int c = 0;
        for (int i = 1; i < m; ++i) {
            c += ChineseCalendar.daysInGregorianMonth(y, i);
        }
        return c += d;
    }

    public static int dayOfWeek(int y, int m, int d) {
        int w = 1;
        y = (y - 1) % 400 + 1;
        int ly = (y - 1) / 4;
        ly -= (y - 1) / 100;
        int ry = y - 1 - (ly += (y - 1) / 400);
        w += ry;
        w += 2 * ly;
        w += ChineseCalendar.dayOfYear(y, m, d);
        w = (w - 1) % 7 + 1;
        return w;
    }

    public int computeChineseFields() {
        int i;
        int baseChineseDate;
        int baseChineseMonth;
        int baseDate;
        int baseMonth;
        if (this.gregorianYear < 1901 || this.gregorianYear > 2100) {
            return 1;
        }
        int startYear = baseYear;
        int startMonth = baseMonth = 1;
        int startDate = baseDate = 1;
        this.chineseYear = baseChineseYear;
        this.chineseMonth = baseChineseMonth = 11;
        this.chineseDate = baseChineseDate = 11;
        if (this.gregorianYear >= 2000) {
            startYear = baseYear + 99;
            startMonth = 1;
            startDate = 1;
            this.chineseYear = baseChineseYear + 99;
            this.chineseMonth = 11;
            this.chineseDate = 25;
        }
        int daysDiff = 0;
        for (i = startYear; i < this.gregorianYear; ++i) {
            daysDiff += 365;
            if (!ChineseCalendar.isGregorianLeapYear(i)) continue;
            ++daysDiff;
        }
        for (i = startMonth; i < this.gregorianMonth; ++i) {
            daysDiff += ChineseCalendar.daysInGregorianMonth(this.gregorianYear, i);
        }
        this.chineseDate += (daysDiff += this.gregorianDate - startDate);
        int lastDate = ChineseCalendar.daysInChineseMonth(this.chineseYear, this.chineseMonth);
        int nextMonth = ChineseCalendar.nextChineseMonth(this.chineseYear, this.chineseMonth);
        while (this.chineseDate > lastDate) {
            if (Math.abs(nextMonth) < Math.abs(this.chineseMonth)) {
                ++this.chineseYear;
            }
            this.chineseMonth = nextMonth;
            this.chineseDate -= lastDate;
            lastDate = ChineseCalendar.daysInChineseMonth(this.chineseYear, this.chineseMonth);
            nextMonth = ChineseCalendar.nextChineseMonth(this.chineseYear, this.chineseMonth);
        }
        return 0;
    }

    public static int daysInChineseMonth(int y, int m) {
        int d;
        block4: {
            int v;
            int index;
            block5: {
                int l;
                block3: {
                    index = y - baseChineseYear + baseIndex;
                    v = 0;
                    l = 0;
                    d = 30;
                    if (1 > m || m > 8) break block3;
                    v = chineseMonths[2 * index];
                    l = m - 1;
                    if ((v >> l & 1) != 1) break block4;
                    d = 29;
                    break block4;
                }
                if (9 > m || m > 12) break block5;
                v = chineseMonths[2 * index + 1];
                l = m - 9;
                if ((v >> l & 1) != 1) break block4;
                d = 29;
                break block4;
            }
            v = chineseMonths[2 * index + 1];
            if ((v = v >> 4 & 0xF) != Math.abs(m)) {
                d = 0;
            } else {
                d = 29;
                for (int i = 0; i < bigLeapMonthYears.length; ++i) {
                    if (bigLeapMonthYears[i] != index) continue;
                    d = 30;
                    break;
                }
            }
        }
        return d;
    }

    public static int nextChineseMonth(int y, int m) {
        int n = Math.abs(m) + 1;
        if (m > 0) {
            int index = y - baseChineseYear + baseIndex;
            int v = chineseMonths[2 * index + 1];
            if ((v = v >> 4 & 0xF) == m) {
                n = -m;
            }
        }
        if (n == 13) {
            n = 1;
        }
        return n;
    }

    public int computeSolarTerms() {
        if (this.gregorianYear < 1901 || this.gregorianYear > 2100) {
            return 1;
        }
        this.sectionalTerm = ChineseCalendar.sectionalTerm(this.gregorianYear, this.gregorianMonth);
        this.principleTerm = ChineseCalendar.principleTerm(this.gregorianYear, this.gregorianMonth);
        return 0;
    }

    public static int sectionalTerm(int y, int m) {
        if (y < 1901 || y > 2100) {
            return 0;
        }
        int index = 0;
        int ry = y - baseYear + 1;
        while (ry >= sectionalTermYear[m - 1][index]) {
            ++index;
        }
        int term = sectionalTermMap[m - 1][4 * index + ry % 4];
        if (ry == 121 && m == 4) {
            term = 5;
        }
        if (ry == 132 && m == 4) {
            term = 5;
        }
        if (ry == 194 && m == 6) {
            term = 6;
        }
        return term;
    }

    public static int principleTerm(int y, int m) {
        if (y < 1901 || y > 2100) {
            return 0;
        }
        int index = 0;
        int ry = y - baseYear + 1;
        while (ry >= principleTermYear[m - 1][index]) {
            ++index;
        }
        int term = principleTermMap[m - 1][4 * index + ry % 4];
        if (ry == 171 && m == 3) {
            term = 21;
        }
        if (ry == 181 && m == 5) {
            term = 21;
        }
        return term;
    }

    public String toString() {
        return "Gregorian Year: " + this.gregorianYear + "\n" + "Gregorian Month: " + this.gregorianMonth + "\n" + "Gregorian Date: " + this.gregorianDate + "\n" + "Is Leap Year: " + this.isGregorianLeap + "\n" + "Day of Year: " + this.dayOfYear + "\n" + "Day of Week: " + this.dayOfWeek + "\n" + "Chinese Year: " + this.chineseYear + "\n" + "Heavenly Stem: " + (this.chineseYear - 1) % 10 + "\n" + "Earthly Branch: " + (this.chineseYear - 1) % 12 + "\n" + "Chinese Month: " + this.chineseMonth + "\n" + "Chinese Date: " + this.chineseDate + "\n" + "Sectional Term: " + this.sectionalTerm + "\n" + "Principle Term: " + this.principleTerm + "\n";
    }

    public String[] getYearTable() {
        this.setGregorian(this.gregorianYear, 1, 1);
        this.computeChineseFields();
        this.computeSolarTerms();
        String[] table = new String[59];
        table[0] = ChineseCalendar.getTextLine(27, "Gregorian Calendar Year: " + this.gregorianYear);
        table[1] = ChineseCalendar.getTextLine(27, "Chinese Calendar Year: " + (this.chineseYear + 1) + " (" + stemNames[(this.chineseYear + 1 - 1) % 10] + "-" + branchNames[(this.chineseYear + 1 - 1) % 12] + ")");
        int ln = 2;
        String[] mLeft = null;
        String[] mRight = null;
        for (int i = 1; i <= 6; ++i) {
            table[ln] = ChineseCalendar.getTextLine(0, null);
            ++ln;
            mLeft = this.getMonthTable();
            mRight = this.getMonthTable();
            for (int j = 0; j < mLeft.length; ++j) {
                String line;
                table[ln] = line = mLeft[j] + "  " + mRight[j];
                ++ln;
            }
        }
        table[ln] = ChineseCalendar.getTextLine(0, null);
        table[++ln] = ChineseCalendar.getTextLine(0, "##/## - Gregorian date/Chinese date, (*)CM## - (Leap) Chinese month first day");
        table[++ln] = ChineseCalendar.getTextLine(0, "ST## - Sectional term, PT## - Principle term");
        ++ln;
        return table;
    }

    public static String getTextLine(int s, String t) {
        String str = "                                                                                    ";
        if (t != null && s < str.length() && s + t.length() < str.length()) {
            str = str.substring(0, s) + t + str.substring(s + t.length());
        }
        return str;
    }

    public String[] getMonthTable() {
        int i;
        this.setGregorian(this.gregorianYear, this.gregorianMonth, 1);
        this.computeChineseFields();
        this.computeSolarTerms();
        String[] table = new String[8];
        String title = "                    " + monthNames[this.gregorianMonth - 1] + "                   ";
        String header = "  Sun   Mon   Tue   Wed   Thu   Fri   Sat ";
        String blank = "                                          ";
        table[0] = title;
        table[1] = header;
        int wk = 2;
        String line = "";
        for (int i2 = 1; i2 < this.dayOfWeek; ++i2) {
            line = line + "      ";
        }
        int days = ChineseCalendar.daysInGregorianMonth(this.gregorianYear, this.gregorianMonth);
        for (i = this.gregorianDate; i <= days; ++i) {
            line = line + this.getDateString() + ' ';
            this.rollUpOneDay();
            if (this.dayOfWeek != 1) continue;
            table[wk] = line;
            line = "";
            ++wk;
        }
        for (i = this.dayOfWeek; i <= 7; ++i) {
            line = line + "      ";
        }
        table[wk] = line;
        for (i = wk + 1; i < table.length; ++i) {
            table[i] = blank;
        }
        for (i = 0; i < table.length; ++i) {
            table[i] = table[i].substring(0, table[i].length() - 1);
        }
        return table;
    }

    public String getDateString() {
        String cd;
        String gd;
        String cm;
        String str = "*  /  ";
        String gm = String.valueOf((this.gregorianMonth - 1 + 11) % 12 + 1);
        if (gm.length() == 1) {
            gm = ' ' + gm;
        }
        if ((cm = String.valueOf(Math.abs(this.chineseMonth))).length() == 1) {
            cm = ' ' + cm;
        }
        if ((gd = String.valueOf(this.gregorianDate)).length() == 1) {
            gd = ' ' + gd;
        }
        if ((cd = String.valueOf(this.chineseDate)).length() == 1) {
            cd = ' ' + cd;
        }
        str = this.gregorianDate == this.sectionalTerm ? " ST" + gm : (this.gregorianDate == this.principleTerm ? " PT" + gm : (this.chineseDate == 1 && this.chineseMonth > 0 ? " CM" + cm : (this.chineseDate == 1 && this.chineseMonth < 0 ? "*CM" + cm : gd + '/' + cd)));
        return str;
    }

    public int rollUpOneDay() {
        this.dayOfWeek = this.dayOfWeek % 7 + 1;
        ++this.dayOfYear;
        ++this.gregorianDate;
        int days = ChineseCalendar.daysInGregorianMonth(this.gregorianYear, this.gregorianMonth);
        if (this.gregorianDate > days) {
            this.gregorianDate = 1;
            ++this.gregorianMonth;
            if (this.gregorianMonth > 12) {
                this.gregorianMonth = 1;
                ++this.gregorianYear;
                this.dayOfYear = 1;
                this.isGregorianLeap = ChineseCalendar.isGregorianLeapYear(this.gregorianYear);
            }
            this.sectionalTerm = ChineseCalendar.sectionalTerm(this.gregorianYear, this.gregorianMonth);
            this.principleTerm = ChineseCalendar.principleTerm(this.gregorianYear, this.gregorianMonth);
        }
        ++this.chineseDate;
        days = ChineseCalendar.daysInChineseMonth(this.chineseYear, this.chineseMonth);
        if (this.chineseDate > days) {
            this.chineseDate = 1;
            this.chineseMonth = ChineseCalendar.nextChineseMonth(this.chineseYear, this.chineseMonth);
            if (this.chineseMonth == 1) {
                ++this.chineseYear;
            }
        }
        return 0;
    }
}

