#ifdef ENEEC_DLL_EXPORTS
#define ENEEC_API __declspec(dllexport)
#else
#define ENEEC_API __declspec(dllimport)
#pragma comment(lib, "EneEc.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif

// Micro seconds delay.
ENEEC_API
VOID DelayUs(DWORD us);

// Called to get error message if one of Ec_Xxx() or FtI2c_Xxx() or FtSpi_Xxx() fails.
ENEEC_API
CONST CHAR *Ec_ErrorString();

typedef enum ECBUS
{
    ECBUS_EDI_OVER_FTSPI    = 1,  // Host <--> FTDI <-SPI-> EDI_of_EC (EDI_OVER_FTSPI)
    ECBUS_EDI_OVER_FTI2C    = 2,  // Host <--> FTDI <-I2C-> EDI_of_EC (EDI_OVER_FTI2C)
    ECBUS_FTSMBD            = 3,  // Host <--> FTDI <-I2C-> SMBD_of_EC
    ECBUS_WINUSB            = 4,  // Host <--> USB_of_IO374X
    ECBUS_FAKE              = 100 // Test purpose
} ECBUS;

typedef struct EcInitParam
{
    INT size;
    enum ECBUS bus;
    DWORD slaveAdr;
    DWORD ftClkKhz;
    BOOL noLoadTrim0; // Set TRUE if not to load trim0. Normally tools released to customers load trim0, internal chip-test tools don't.
                      //   default=0=load trim0.
    WORD forceChipId; // Don't detect chip ID, instead force using this chip ID and rev ID.
    BYTE forceRevId;  //   default=0=don't force.
} EcInitParam;

enum Sel_ModeName {
    EFFECT_STOP = 0,
    EFFECT_STATIC_MODE = 1,		//Effect 06
    EFFECT_BREATH_MODE = 2,		//Effect 07
    EFFECT_RAINBOW = 5,		//Effect 01
    EFFECT_BREATH_RAINBOW = 6,		//Effect 03
    EFFECT_MOMENT_RAINBOWH = 24,	//Effect 02
    EFFECT_GRADIENT_RAINBOW = 25,	//Effect 04
    EFFECT_RAND_FLASH = 26,	//Effect 05
    EFFECT_WHITE = 27,	//Effect 08
    EFFECT_Control_VCCctrl = 28,
    EFFECT_LAST,
};

enum group_Name {
		GROUP_1		=0,
		GROUP_2		=1,
		GROUP_3		=2,
		GROUP_4		=3,
        GROUP_5     =4,
		GROUP_ALL	=10,
};

enum fan_Name {
		FAN_0		=0,
		FAN_1		=1,
		FAN_2		=2,
		FAN_3		=3,
		FAN_4	    =4,
        FAN_5		=5,
		FAN_6		=6,
		FAN_7		=7,
		FAN_8		=8,
		FAN_9	    =9,
        FAN_10		=10,
		FAN_11	    =11,
};

ENEEC_API
HANDLE Ec_Init(EcInitParam *param);

ENEEC_API
VOID Ec_Exit(HANDLE hEc);

ENEEC_API
WORD Ec_GetChipId(HANDLE hEc);

ENEEC_API
BYTE Ec_GetRevId(HANDLE hEc);

ENEEC_API
BOOL Ec_ReadRegs(HANDLE hEc, DWORD reg, BYTE *buf, INT len);

ENEEC_API
BOOL Ec_WriteRegs(HANDLE hEc, DWORD reg, CONST BYTE *buf, INT len);

ENEEC_API
BOOL Ec_ResetAndStop(HANDLE hEc);

ENEEC_API
BOOL Ec_Run(HANDLE hEc);

ENEEC_API
BOOL Ec_ReadSrow(HANDLE hEc, BYTE row, BYTE col, BYTE *buf, INT len);

// Special row write is automatically enabled before erasing, then disabled when done.
ENEEC_API
BOOL Ec_EraseSrow(HANDLE hEc, BYTE row);

// Special row write is automatically enabled before writing, then disabled when done.
ENEEC_API
BOOL Ec_WriteSrow(HANDLE hEc, BYTE row, BYTE col, CONST BYTE *buf, INT len);

// Get a handle to FTDI SPI or I2C used by EC.
// The handle can be used in FtSpi_Xxx(), FtI2c_Xxx() or Ft_Xxx() except FtSpi_Close() and
// FtI2c_Close(), i.e., no need to close the handle.
ENEEC_API
HANDLE Ec_GetFt(HANDLE hEc);

// ---- FTDI SPI APIs ---------------------------------------------------------

ENEEC_API
HANDLE FtSpi_Open();

ENEEC_API
VOID FtSpi_Close(HANDLE hSpi);

ENEEC_API
BOOL FtSpi_SetSerialClock(HANDLE hSpi, DWORD ftClkKhz);

ENEEC_API
BOOL FtSpi_WriteRead(
        HANDLE hSpi,
        CONST BYTE *writeData, // data to write to slave.
        INT writeLen,          // length of writeData.
        BYTE *readBuf,         // buffer to hold data read from slave.
        INT readLen            // length of readBuf.
        );

// "Queue" multiple SPI WriteReads to a "sequence", then send the sequence to SPI adapter
//   to complete at one time, to reduce number of handshakings.

// Begin the W/R sequence.
ENEEC_API
VOID FtSpi_BeginWriteReadSeq(HANDLE hSpi);

// Add one W/R to the sequence.
ENEEC_API
VOID FtSpi_WriteReadSeq(
        HANDLE hSpi,
        CONST BYTE *writeData, // data to write to slave.
        INT writeLen,          // length of writeData.
        INT readLen            // length of read data.
        );

// Perform/complete the W/R sequence.
ENEEC_API
BOOL FtSpi_EndWriteReadSeq(
        HANDLE hSpi, 
        BYTE *readBuf, // buffer to hold data read from slave.
        INT readLen    // length of readBuf, must >= sum of all readLen of FtSpi_WriteReadSeq() calls.
        );

// ---- FTDI I2C APIs ---------------------------------------------------------

ENEEC_API
HANDLE FtI2c_Open();

ENEEC_API
VOID FtI2c_Close(HANDLE hI2c);

ENEEC_API
BOOL FtI2c_SetSerialClock(HANDLE hI2c, DWORD ftClkKhz);

ENEEC_API
BOOL FtI2c_WriteRead(
        HANDLE hI2c,
        BYTE i2cAdr,           // slave address (8 bits).
        CONST BYTE *writeData, // data to write to slave.
        INT writeLen,          // length of writeData.
        BYTE *readBuf,         // buffer to hold data read from slave.
        INT readLen            // length of readBuf.
        );

// "Queue" multiple I2C WriteReads to a "sequence", then send the sequence to I2C adapter
//   to complete at one time, to reduce number of handshakings.

// Begin the W/R sequence.
ENEEC_API
VOID FtI2c_BeginWriteReadSeq(HANDLE hI2c);

// Add one W/R to the sequence.
ENEEC_API
VOID FtI2c_WriteReadSeq(
        HANDLE hI2c,
        BYTE i2cAdr,           // slave address (8 bits).
        CONST BYTE *writeData, // data to write to slave.
        INT writeLen,          // length of writeData.
        INT readLen            // length of read data.
        );

// Perform/complete the W/R sequence.
ENEEC_API
BOOL FtI2c_EndWriteReadSeq(
        HANDLE hI2c, 
        BYTE *readBuf, // buffer to hold data read from slave.
        INT readLen    // length of readBuf, must >= sum of all readLen of FtI2c_WriteReadSeq() calls.
        );

// ---- FTDI APIs -------------------------------------------------------------

// Configure ADBUS0~7 pins:
//   ADBUS:    0  1  2  3  4      5      6      7
//   Function: SK DO DI CS GPIOL0 GPIOL1 GPIOL2 GPIOL3
ENEEC_API
BOOL Ft_SetADBUS(
        HANDLE hFt,   // hSpi from FtSpi_Open(), or hI2c from FtI2c_Open().
        BYTE pinMask, // pins to set. e.g., 0x03 means pin0 and pin1.
        BYTE outMask, // pins to set as output. e.g., 0x03 means pin0 and pin1 are output direction.
        BYTE hiMask   // pins to set their value high. e.g., 0x03 means pin0 and pin1 are set to high.
        );

ENEEC_API
BOOL Ft_GetADBUS(
        HANDLE hFt,    // hSpi from FtSpi_Open(), or hI2c from FtI2c_Open().
        BYTE *outMask, // get direction of each pin; 1=output, 0=input. e.g., 0x03 means pin0 and pin1 are output direction.
        BYTE *hiMask   // get state of each pin; e.g., 0x03 means pin0 and pin1 are currently high.
        );

//+ 20200609 Rody: SK
ENEEC_API
BOOL EneSDKVccCtrl(HANDLE m_hEc, int ctrlval);
//- 20200609 Rody: SK

ENEEC_API
BOOL EneSDKSetEffect(HANDLE m_hEc,int index,ULONG effectId, COLORREF  color[],ULONG numberOfColors, ULONG speed, ULONG direction,ULONG brightness);

ENEEC_API
BOOL EneSDKSetColor(HANDLE m_hEc,int index,COLORREF  color[],ULONG numberOfColors);

ENEEC_API
BOOL EneSDKSynchronize(HANDLE hEc,ULONGLONG effectId,ULONGLONG tickcount,UCHAR now_direction);

ENEEC_API
BOOL EneSDKSetLedNumber(	
		HANDLE m_hEc,		
		int group_idx,		//Group idx: 0, 1, 2, 3
		ULONG numberOfLed	//Led Number Only Support 16, 32, 48, 64 
		);					//Other value will be set as default value: 16


ENEEC_API
BOOL Ec_GetFanDuty(HANDLE hEc,ULONG fan_idx, BYTE* duty);

ENEEC_API
BOOL Ec_SetFanDuty(HANDLE hEc,ULONG fan_idx, BYTE duty);

ENEEC_API
BOOL Ec_GetFanRPM(HANDLE hEc,ULONG fan_idx, WORD* rpm);

ENEEC_API
BOOL Ec_CheckConnected(HANDLE hEc);

ENEEC_API
BOOL Ec_GetTotalGroupNum(HANDLE hEc,BYTE *total_gp_num);

ENEEC_API
BOOL Ec_GetGroupLedNum(HANDLE hEc,BYTE gp_idx, WORD* led_num);

ENEEC_API
BOOL Ec_SwitchARGB(HANDLE hEc,BYTE switch_to_MB);
enum bits_ctrl_fan_num
{
	bit0_ctrl_fan0 = 0x01,
	bit1_ctrl_fan1 = 0x02,
	bit2_ctrl_fan2 = 0x04,
	bit3_ctrl_fan3 = 0x08,
	bit0to3_ctrl_fanAll = 0x0F,
};
enum bits_ctrl_fan_num_switch_to_MB
{
	bit0_ctrl_fan0_switch_to_MB = 0x01,
	bit1_ctrl_fan1_switch_to_MB = 0x02,
	bit2_ctrl_fan2_switch_to_MB = 0x04,
	bit3_ctrl_fan3_switch_to_MB = 0x08,
	bit0to3_ctrl_fanAll_switch_to_MB = 0x0F,
};
ENEEC_API
BOOL Ec_SwitchFan(HANDLE hEc,BYTE bit0to3_ctrl_fan_num,BYTE bit0to3_switch_to_MB);


#ifdef __cplusplus
}
#endif
