/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.core.registry;

import com.github.worldsender.mcanm.client.renderer.entity.RenderAnimatedModel;
import cpw.mods.fml.client.registry.RenderingRegistry;
import mhfc.net.client.render.projectile.RenderRathalosFireball;
import mhfc.net.client.render.projectile.RenderTigrexBlock;
import mhfc.net.common.entity.monster.EntityBarroth;
import mhfc.net.common.entity.monster.EntityDeviljho;
import mhfc.net.common.entity.monster.EntityGreatJaggi;
import mhfc.net.common.entity.monster.EntityNargacuga;
import mhfc.net.common.entity.monster.EntityRathalos;
import mhfc.net.common.entity.monster.EntityTigrex;
import mhfc.net.common.entity.projectile.EntityRathalosFireball;
import mhfc.net.common.entity.projectile.EntityTigrexBlock;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class MHFCEntityRenderRegistry {
    public static void init() {
        MHFCEntityRenderRegistry.renderMonster();
        MHFCEntityRenderRegistry.renderBlockEntities();
    }

    private static void renderMonster() {
        MHFCEntityRenderRegistry.registerAnimatedRenderer(EntityTigrex.class, "mhfc:models/Tigrex/Tigrex.mcmd", 1.0f);
        MHFCEntityRenderRegistry.registerAnimatedRenderer(EntityRathalos.class, "mhfc:models/Rathalos/Rathalos.mcmd", 1.0f);
        MHFCEntityRenderRegistry.registerAnimatedRenderer(EntityGreatJaggi.class, "mhfc:models/GreatJaggi/GreatJaggi.mcmd", 1.0f);
        MHFCEntityRenderRegistry.registerAnimatedRenderer(EntityDeviljho.class, "mhfc:models/Deviljho/Deviljho.mcmd", 1.0f);
        MHFCEntityRenderRegistry.registerAnimatedRenderer(EntityBarroth.class, "mhfc:models/Barroth/Barroth.mcmd", 1.0f);
        MHFCEntityRenderRegistry.registerAnimatedRenderer(EntityNargacuga.class, "mhfc:models/Nargacuga/Nargacuga.mcmd", 1.0f);
    }

    private static void renderBlockEntities() {
        RenderingRegistry.registerEntityRenderingHandler(EntityTigrexBlock.class, (Render)new RenderTigrexBlock());
        RenderingRegistry.registerEntityRenderingHandler(EntityRathalosFireball.class, (Render)new RenderRathalosFireball());
    }

    private static <T extends Entity> void registerAnimatedRenderer(Class<T> entityClass, String resource, float shadow) {
        MHFCEntityRenderRegistry.registerAnimatedRenderer(entityClass, new ResourceLocation(resource), shadow);
    }

    private static <T extends Entity> void registerAnimatedRenderer(Class<T> entityClass, ResourceLocation resLoc, float shadow) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, (Render)RenderAnimatedModel.fromResLocation((ResourceLocation)resLoc, (float)shadow));
    }
}

