/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.gui;

import java.util.ArrayList;
import mhfc.net.client.gui.GuiListItem;
import mhfc.net.client.gui.IMouseInteractable;
import mhfc.net.client.quests.MHFCRegQuestVisual;
import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class ClickableGuiList<Item extends GuiListItem>
extends ArrayList<Item>
implements IMouseInteractable {
    private static final float SLIDER_WIDTH = 8.0f;
    private static final float BORDER_WIDTH = 2.0f;
    protected int posX;
    protected int posY;
    protected int width;
    protected int height;
    protected float itemHeight;
    protected float scrollAmount = 0.0f;
    protected int selected = -1;
    protected float sliderWidth = 8.0f;
    protected boolean recalculateItemHeightOnDraw = false;
    protected boolean visible = true;
    private boolean drawSmallestBounds = false;
    private GuiListItem.Alignment alignment = GuiListItem.Alignment.LEFT;
    protected boolean isSliderDragged = false;
    protected int mouseClickX;
    protected int mouseClickY;
    protected int mouseClickMoveX;
    protected int mouseClickMoveY;
    private static final long serialVersionUID = -7451553351083938970L;

    public ClickableGuiList(int posX, int posY, int width, int height, float itemHeight) {
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
        this.itemHeight = itemHeight;
    }

    public ClickableGuiList(int width, int height, float itemHeight) {
        this(0, 0, width, height, itemHeight);
    }

    public ClickableGuiList(int posX, int posY, int width, int height) {
        this(posX, posY, width, height, 0.0f);
        this.recalculateItemHeightOnDraw = true;
    }

    public ClickableGuiList(int width, int height) {
        this(0, 0, width, height);
    }

    public float getItemWidth() {
        return this.itemHeight;
    }

    public void setItemWidth(int itemWidth) {
        this.itemHeight = itemWidth;
        this.recalculateItemHeightOnDraw = false;
    }

    public float getSliderWidth() {
        return this.sliderWidth;
    }

    public void setSliderWidth(float sliderWidth) {
        this.sliderWidth = sliderWidth;
    }

    public void draw(int baseX, int baseY, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        int posX = this.posX + baseX;
        int posY = this.posY + baseY;
        if (this.recalculateItemHeightOnDraw) {
            this.recalculateItemHeight();
        }
        int width = Math.max(this.width, 15);
        Minecraft m = Minecraft.func_71410_x();
        int scale = MHFCGuiUtil.guiScaleFactor(m);
        int openGLy = m.field_71440_d;
        GL11.glScissor((int)(posX * scale), (int)(openGLy - (posY + this.height) * scale), (int)(width * scale), (int)(this.height * scale + 1));
        GL11.glEnable((int)3089);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        this.drawBackground(posX, posY, mouseX, mouseY);
        this.drawListItems(posX, posY, mouseX, mouseY);
        this.drawListSlider(posX, posY, mouseX, mouseY);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3089);
    }

    protected void drawListSlider(int posX, int posY, int mouseX, int mouseY) {
        float alpha = this.getSliderAlpha(mouseX, mouseY);
        if (alpha > 0.0f && !this.isEmpty()) {
            float extendedHeight = this.itemHeight * (float)this.size();
            float sliderHeight = (float)(this.height * this.height) / extendedHeight;
            float sliderPosY = this.scrollAmount * (float)this.height / extendedHeight;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(MHFCRegQuestVisual.CLICKABLE_LIST);
            MHFCGuiUtil.drawTexturedRectangle((float)(posX + this.width) - this.sliderWidth, (float)posY + sliderPosY, this.sliderWidth, sliderHeight, 0.5f, 0.5f, 0.0625f, 0.5f);
        }
    }

    public final float getFullHeight() {
        return this.itemHeight * (float)this.size();
    }

    public final float getSliderHeight() {
        return (float)(this.height * this.height) / this.getFullHeight();
    }

    public final float getSliderVerticalDisplacement() {
        return this.scrollAmount * (float)this.height / this.getFullHeight();
    }

    protected float getSliderAlpha(int mouseX, int mouseY) {
        if (this.isMouseOnSlider(mouseX, mouseY) || this.isSliderDragged) {
            return 1.0f;
        }
        return 0.0f;
    }

    protected boolean isSliderRequired() {
        return this.itemHeight * (float)this.size() > (float)this.height;
    }

    protected boolean isMouseOnSlider(int mouseX, int mouseY) {
        return this.hoversMouseOverSlider(mouseX, mouseY) && this.isSliderRequired();
    }

    protected boolean hoversMouseOverSlider(int mouseX, int mouseY) {
        return mouseY >= 0 && mouseY <= this.height && (float)mouseX > (float)this.width - this.sliderWidth && mouseX <= this.width;
    }

    protected void drawBackground(int posX, int posY, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(MHFCRegQuestVisual.CLICKABLE_LIST);
        float texheight = this.height;
        if (this.drawSmallestBounds) {
            texheight = Math.min((float)this.size() * this.itemHeight, texheight);
        }
        MHFCGuiUtil.drawTexturedRectangle(posX, posY, this.width, texheight, 0.0f, 0.0f, 0.5f, 1.0f);
        if (this.selected >= 0) {
            float sm;
            float selectionYMin = (float)this.selected * this.itemHeight - this.scrollAmount;
            float selectionYHeight = this.itemHeight;
            if (selectionYMin < 2.0f) {
                sm = 2.0f - selectionYMin;
                selectionYMin += sm;
                selectionYHeight -= sm;
            }
            if (selectionYMin + selectionYHeight > (float)this.height) {
                sm = selectionYMin + selectionYHeight - (float)this.height;
                selectionYHeight -= sm;
            }
            MHFCGuiUtil.drawTexturedRectangle((float)(posX + this.width) - 2.0f, (float)posY + selectionYMin, 2.0, selectionYHeight, 0.625f, 0.5f, 0.125f, 0.25f);
        }
    }

    protected void drawListItems(int posX, int posY, int mouseX, int mouseY) {
        Minecraft m = Minecraft.func_71410_x();
        for (int i = (int)(this.scrollAmount / this.itemHeight); i < this.size(); ++i) {
            GuiListItem item = (GuiListItem)this.get(i);
            item.draw(posX, posY - (int)(this.scrollAmount - (float)i * this.itemHeight), this.width, (int)this.itemHeight, m, i == this.selected, this.alignment);
        }
    }

    protected void recalculateItemHeight() {
        this.itemHeight = (float)this.height / (float)this.size();
    }

    @Override
    public boolean handleClick(int relativeX, int relativeY, int button) {
        if (!this.visible || relativeX < 0 || relativeX >= this.width || relativeY < 0 || relativeY >= this.height) {
            return false;
        }
        if (this.isMouseOnSlider(relativeX, relativeY)) {
            this.mouseClickX = relativeX;
            this.mouseClickY = relativeY;
            this.mouseClickMoveX = this.mouseClickX;
            this.mouseClickMoveY = this.mouseClickY;
        } else {
            int selec = (int)(((float)relativeY + this.scrollAmount) / this.itemHeight);
            if (selec >= this.size()) {
                return false;
            }
            this.setSelected(selec);
        }
        return true;
    }

    @Override
    public void handleMovementMouseDown(int mouseX, int mouseY, int button, long timeDiff) {
        if (this.isMouseOnSlider(this.mouseClickX, this.mouseClickY)) {
            this.scrollAmount += (float)(mouseY - this.mouseClickMoveY) / (float)this.height * this.getFullHeight();
            this.scrollAmount = Math.min(this.scrollAmount, this.getFullHeight() - (float)this.height);
            this.scrollAmount = Math.max(this.scrollAmount, 0.0f);
            this.isSliderDragged = true;
            this.mouseClickMoveX = mouseX;
            this.mouseClickMoveY = mouseY;
        }
    }

    @Override
    public void handleMouseUp(int mouseX, int mouseY, int id) {
        this.isSliderDragged = false;
    }

    @Override
    public void handleMovement(int mouseX, int mouseY) {
    }

    public int getSelected() {
        return this.selected;
    }

    @Override
    public void add(int index, Item element) {
        if (index <= this.selected) {
            ++this.selected;
        }
        super.add(index, element);
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < this.selected) {
            --this.selected;
        }
        if (index == this.selected) {
            this.selected = -1;
        }
        return super.remove(o);
    }

    @Override
    public Item remove(int index) {
        if (index < this.selected) {
            --this.selected;
        }
        if (index == this.selected) {
            this.selected = -1;
        }
        return (Item)((GuiListItem)super.remove(index));
    }

    @Override
    public void clear() {
        this.selected = -1;
        super.clear();
    }

    public Item getSelectedItem() {
        if (this.selected >= 0 && this.selected < this.size()) {
            return (Item)((GuiListItem)this.get(this.selected));
        }
        return null;
    }

    protected void setSelected(int newSelected) {
        this.selected = newSelected;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidthAndHeight(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public GuiListItem.Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(GuiListItem.Alignment alignment) {
        this.alignment = alignment;
    }

    public void setRecalculateItemHeightOnDraw(boolean recalculate) {
        this.recalculateItemHeightOnDraw = recalculate;
    }

    public boolean isDrawSmallestBounds() {
        return this.drawSmallestBounds;
    }

    public void setDrawSmallestBounds(boolean drawSmallestBounds) {
        this.drawSmallestBounds = drawSmallestBounds;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
    }

    public static class GuiListStringItem
    extends GuiListItem {
        private String string;

        public GuiListStringItem(String itemString) {
            this.string = itemString;
        }

        @Override
        public String getRepresentationString() {
            return this.string;
        }

        public String getInitializationString() {
            return this.string;
        }
    }
}

